/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.pool.ConnectionPoolStatics;
import cn.beecp.pool.PooledConnection;
import cn.beecp.pool.ProxyBaseWrapper;
import cn.beecp.pool.ProxyConnectionBase;
import cn.beecp.pool.ProxyResultSetBase;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

abstract class ProxyStatementBase
extends ProxyBaseWrapper
implements Statement {
    private final ProxyConnectionBase owner;
    protected Statement raw;
    boolean registered = true;
    private ProxyResultSetBase curRe;
    private ArrayList<ProxyResultSetBase> results;
    private int resultOpenCode = 1;

    public ProxyStatementBase(Statement raw, ProxyConnectionBase o, PooledConnection p) {
        super(p);
        this.raw = raw;
        this.owner = o;
        this.owner.registerStatement(this);
    }

    void removeOpenResultSet(ProxyResultSetBase r) {
        if (r == this.curRe) {
            this.curRe = null;
        } else if (this.results != null) {
            this.results.remove(r);
        }
    }

    void setOpenResultSet(ProxyResultSetBase r) {
        switch (this.resultOpenCode) {
            case 1: {
                if (this.curRe == null || this.curRe.isClosed) break;
                ConnectionPoolStatics.oclose(this.curRe);
                break;
            }
            case 2: {
                if (this.curRe == null || this.curRe.isClosed) break;
                if (this.results == null) {
                    this.results = new ArrayList(1);
                }
                this.results.add(this.curRe);
                break;
            }
            case 3: {
                if (this.curRe != null && !this.curRe.isClosed) {
                    ConnectionPoolStatics.oclose(this.curRe);
                }
                if (this.results == null) break;
                for (ProxyResultSetBase openRe : this.results) {
                    if (openRe.isClosed) continue;
                    ConnectionPoolStatics.oclose(openRe);
                }
                this.results.clear();
                break;
            }
        }
        this.curRe = r;
    }

    public Connection getConnection() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("No operations allowed after statement closed");
        }
        return this.owner;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public final void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.curRe != null) {
            ConnectionPoolStatics.oclose(this.curRe);
        }
        if (this.results != null) {
            for (ProxyResultSetBase resultSetBase : this.results) {
                ConnectionPoolStatics.oclose(resultSetBase);
            }
            this.results.clear();
        }
        try {
            this.raw.close();
        }
        finally {
            this.raw = ConnectionPoolStatics.CLOSED_CSTM;
            if (this.registered) {
                this.owner.unregisterStatement(this);
            }
        }
    }

    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    public boolean getMoreResults(int current) throws SQLException {
        this.resultOpenCode = current;
        return this.raw.getMoreResults(current);
    }

    public ResultSet getResultSet() throws SQLException {
        ResultSet re = this.raw.getResultSet();
        if (re == null) {
            return null;
        }
        if (this.curRe != null && this.curRe.containsRaw(re)) {
            return this.curRe;
        }
        if (this.results != null) {
            for (ProxyResultSetBase resultSetBase : this.results) {
                if (!resultSetBase.containsRaw(re)) continue;
                return resultSetBase;
            }
        }
        return ConnectionPoolStatics.createProxyResultSet(re, this, this.p);
    }

    public void setPoolable(boolean var1) {
    }

    public void closeOnCompletion() {
    }

    public boolean isCloseOnCompletion() {
        return false;
    }
}

