/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.pool.ConnectionPoolStatics;
import cn.beecp.pool.PooledConnection;
import cn.beecp.pool.ProxyBaseWrapper;
import cn.beecp.pool.ProxyStatementBase;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Executor;

abstract class ProxyConnectionBase
extends ProxyBaseWrapper
implements Connection {
    protected Connection raw;

    public ProxyConnectionBase(PooledConnection p) {
        super(p);
        this.raw = p.rawConn;
        p.proxyInUsing = this;
    }

    final void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("No operations allowed after connection closed");
        }
    }

    final synchronized void registerStatement(ProxyStatementBase s) {
        this.p.registerStatement(s);
    }

    final synchronized void unregisterStatement(ProxyStatementBase s) {
        this.p.unregisterStatement(s);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws SQLException {
        ProxyConnectionBase proxyConnectionBase = this;
        synchronized (proxyConnectionBase) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.raw = ConnectionPoolStatics.CLOSED_CON;
            if (this.p.openStmSize > 0) {
                this.p.clearStatement();
            }
        }
        this.p.recycleSelf();
    }

    public final void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.p.commitDirtyInd) {
            throw new SQLException("Change forbidden during dirty transaction");
        }
        this.raw.setAutoCommit(autoCommit);
        this.p.curAutoCommit = autoCommit;
        this.p.setResetInd(0, autoCommit != this.p.defaultAutoCommit);
    }

    public final void commit() throws SQLException {
        this.raw.commit();
        this.p.commitDirtyInd = false;
        this.p.lastAccessTime = System.currentTimeMillis();
    }

    public final void rollback() throws SQLException {
        this.raw.rollback();
        this.p.commitDirtyInd = false;
        this.p.lastAccessTime = System.currentTimeMillis();
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.raw.setTransactionIsolation(level);
        this.p.setResetInd(1, level != this.p.defaultTransactionIsolation);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.raw.setReadOnly(readOnly);
        this.p.setResetInd(2, readOnly != this.p.defaultReadOnly);
    }

    public void setCatalog(String catalog) throws SQLException {
        this.raw.setCatalog(catalog);
        this.p.setResetInd(3, !ConnectionPoolStatics.stringEquals(catalog, this.p.defaultCatalog));
    }

    public void setSchema(String schema) throws SQLException {
        this.raw.setSchema(schema);
        this.p.setResetInd(4, !ConnectionPoolStatics.stringEquals(schema, this.p.defaultSchema));
    }

    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        if (!this.p.supportNetworkTimeoutSet()) {
            throw new SQLException("Driver not support 'networkTimeout'");
        }
        this.raw.setNetworkTimeout(executor, milliseconds);
        this.p.setResetInd(5, milliseconds != this.p.defaultNetworkTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(Executor executor) {
        ProxyConnectionBase proxyConnectionBase = this;
        synchronized (proxyConnectionBase) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.raw = ConnectionPoolStatics.CLOSED_CON;
            if (this.p.openStmSize > 0) {
                this.p.clearStatement();
            }
        }
        this.p.removeSelf();
    }
}

