/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.pool.ConnectionPoolStatics;
import cn.beecp.pool.FastConnectionPool;
import cn.beecp.pool.ProxyConnectionBase;
import cn.beecp.pool.ProxyStatementBase;
import cn.beecp.pool.exception.ConnectionRecycleException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import javax.transaction.xa.XAResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PooledConnection
implements Cloneable {
    private static final boolean[] FALSE = new boolean[6];
    final boolean defaultAutoCommit;
    final int defaultTransactionIsolation;
    final boolean defaultReadOnly;
    final String defaultCatalog;
    final String defaultSchema;
    final int defaultNetworkTimeout;
    private final boolean defaultCatalogIsNotBlank;
    private final boolean defaultSchemaIsNotBlank;
    private final boolean supportNetworkTimeoutInd;
    private final ThreadPoolExecutor networkTimeoutExecutor;
    private final FastConnectionPool pool;
    private final boolean enableDefaultOnCatalog;
    private final boolean enableDefaultOnSchema;
    private final boolean enableDefaultOnReadOnly;
    private final boolean enableDefaultOnAutoCommit;
    private final boolean enableDefaultOnTransactionIsolation;
    private final List<Integer> sqlExceptionCodeList;
    private final List<String> sqlExceptionStateList;
    Connection rawConn;
    XAResource rawXaRes;
    volatile int state;
    volatile long lastAccessTime;
    int openStmSize;
    boolean curAutoCommit;
    boolean commitDirtyInd;
    ProxyConnectionBase proxyInUsing;
    private int resetCnt;
    private boolean[] resetFlags;
    private ProxyStatementBase[] openStatements;

    PooledConnection(FastConnectionPool pool, boolean enableDefaultOnAutoCommit, boolean defaultAutoCommit, boolean enableDefaultOnTransactionIsolation, int defaultTransactionIsolation, boolean enableDefaultOnReadOnly, boolean defaultReadOnly, boolean enableDefaultOnCatalog, String defaultCatalog, boolean enableDefaultOnSchema, String defaultSchema, boolean supportNetworkTimeoutInd, int defaultNetworkTimeout, ThreadPoolExecutor networkTimeoutExecutor, List<Integer> sqlExceptionCodeList, List<String> sqlExceptionStateList) {
        this.enableDefaultOnAutoCommit = enableDefaultOnAutoCommit;
        this.defaultAutoCommit = defaultAutoCommit;
        this.enableDefaultOnTransactionIsolation = enableDefaultOnTransactionIsolation;
        this.defaultTransactionIsolation = defaultTransactionIsolation;
        this.enableDefaultOnReadOnly = enableDefaultOnReadOnly;
        this.defaultReadOnly = defaultReadOnly;
        this.enableDefaultOnCatalog = enableDefaultOnCatalog;
        this.defaultCatalog = defaultCatalog;
        this.defaultCatalogIsNotBlank = !ConnectionPoolStatics.isBlank(defaultCatalog);
        this.enableDefaultOnSchema = enableDefaultOnSchema;
        this.defaultSchema = defaultSchema;
        this.defaultSchemaIsNotBlank = !ConnectionPoolStatics.isBlank(defaultSchema);
        this.supportNetworkTimeoutInd = supportNetworkTimeoutInd;
        this.defaultNetworkTimeout = defaultNetworkTimeout;
        this.networkTimeoutExecutor = networkTimeoutExecutor;
        this.sqlExceptionCodeList = sqlExceptionCodeList;
        this.sqlExceptionStateList = sqlExceptionStateList;
        this.pool = pool;
        this.curAutoCommit = defaultAutoCommit;
    }

    PooledConnection setDefaultAndCopy(Connection rawConn, int state, XAResource rawXaRes) throws SQLException, CloneNotSupportedException {
        if (this.enableDefaultOnAutoCommit && this.defaultAutoCommit != rawConn.getAutoCommit()) {
            rawConn.setAutoCommit(this.defaultAutoCommit);
        }
        if (this.enableDefaultOnTransactionIsolation && this.defaultTransactionIsolation != rawConn.getTransactionIsolation()) {
            rawConn.setTransactionIsolation(this.defaultTransactionIsolation);
        }
        if (this.enableDefaultOnReadOnly && this.defaultReadOnly != rawConn.isReadOnly()) {
            rawConn.setReadOnly(this.defaultReadOnly);
        }
        if (this.enableDefaultOnCatalog && this.defaultCatalogIsNotBlank && !this.defaultCatalog.equals(rawConn.getCatalog())) {
            rawConn.setCatalog(this.defaultCatalog);
        }
        if (this.enableDefaultOnSchema && this.defaultSchemaIsNotBlank && !this.defaultSchema.equals(rawConn.getSchema())) {
            rawConn.setSchema(this.defaultSchema);
        }
        PooledConnection p = (PooledConnection)this.clone();
        p.state = state;
        p.rawConn = rawConn;
        p.rawXaRes = rawXaRes;
        p.resetFlags = (boolean[])FALSE.clone();
        p.openStatements = new ProxyStatementBase[10];
        p.lastAccessTime = System.currentTimeMillis();
        return p;
    }

    final boolean supportNetworkTimeoutSet() {
        return this.supportNetworkTimeoutInd;
    }

    final void updateAccessTime() {
        this.commitDirtyInd = !this.curAutoCommit;
        this.lastAccessTime = System.currentTimeMillis();
    }

    final void setResetInd(int i, boolean changed) {
        if (this.resetFlags[i] != changed) {
            this.resetFlags[i] = changed;
            this.resetCnt += changed ? 1 : -1;
        }
    }

    final void removeSelf() {
        this.pool.abandonOnReturn(this, "abort");
    }

    final void onBeforeRemove() {
        try {
            this.state = 2;
            this.resetRawConn();
        }
        catch (Throwable e) {
            ConnectionPoolStatics.CommonLog.error("Connection close error", e);
        }
        finally {
            ConnectionPoolStatics.oclose(this.rawConn);
            this.rawXaRes = null;
        }
    }

    final void recycleSelf() throws SQLException {
        try {
            this.proxyInUsing = null;
            this.resetRawConn();
            this.pool.recycle(this);
        }
        catch (Throwable e) {
            this.pool.abandonOnReturn(this, "bad");
            throw e instanceof SQLException ? (SQLException)e : new ConnectionRecycleException(e);
        }
    }

    private void resetRawConn() throws SQLException {
        if (this.commitDirtyInd) {
            this.rawConn.rollback();
            this.commitDirtyInd = false;
        }
        if (this.resetCnt > 0) {
            if (this.resetFlags[0]) {
                this.rawConn.setAutoCommit(this.defaultAutoCommit);
                this.curAutoCommit = this.defaultAutoCommit;
            }
            if (this.resetFlags[1]) {
                this.rawConn.setTransactionIsolation(this.defaultTransactionIsolation);
            }
            if (this.resetFlags[2]) {
                this.rawConn.setReadOnly(this.defaultReadOnly);
            }
            if (this.defaultCatalogIsNotBlank && this.resetFlags[3]) {
                this.rawConn.setCatalog(this.defaultCatalog);
            }
            if (this.defaultSchemaIsNotBlank && this.resetFlags[4]) {
                this.rawConn.setSchema(this.defaultSchema);
            }
            if (this.resetFlags[5]) {
                this.rawConn.setNetworkTimeout(this.networkTimeoutExecutor, this.defaultNetworkTimeout);
            }
            this.resetCnt = 0;
            System.arraycopy(FALSE, 0, this.resetFlags, 0, 6);
        }
        this.rawConn.clearWarnings();
    }

    final void registerStatement(ProxyStatementBase s) {
        if (this.openStmSize == this.openStatements.length) {
            ProxyStatementBase[] array = new ProxyStatementBase[this.openStmSize << 1];
            System.arraycopy(this.openStatements, 0, array, 0, this.openStmSize);
            this.openStatements = array;
        }
        this.openStatements[this.openStmSize++] = s;
    }

    final void unregisterStatement(ProxyStatementBase s) {
        for (int i = this.openStmSize - 1; i >= 0; --i) {
            if (s != this.openStatements[i]) continue;
            int m = this.openStmSize - i - 1;
            if (m > 0) {
                System.arraycopy(this.openStatements, i + 1, this.openStatements, i, m);
            }
            this.openStatements[--this.openStmSize] = null;
            return;
        }
    }

    final void clearStatement() {
        for (int i = 0; i < this.openStmSize; ++i) {
            ProxyStatementBase s = this.openStatements[i];
            if (s == null) continue;
            s.registered = false;
            this.openStatements[i] = null;
            ConnectionPoolStatics.oclose(s);
        }
        this.openStmSize = 0;
    }

    void checkSQLException(SQLException e) {
        int code = e.getErrorCode();
        if (code != 0 && this.proxyInUsing != null && this.sqlExceptionCodeList != null && this.sqlExceptionCodeList.contains(code)) {
            this.proxyInUsing.abort(null);
            this.proxyInUsing = null;
            return;
        }
        String state = e.getSQLState();
        if (state != null && this.proxyInUsing != null && this.sqlExceptionStateList != null && this.sqlExceptionStateList.contains(state)) {
            this.proxyInUsing.abort(null);
            this.proxyInUsing = null;
        }
    }
}

