/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.BeeConnectionPool;
import cn.beecp.BeeConnectionPoolJmxBean;
import cn.beecp.BeeConnectionPoolMonitorVo;
import cn.beecp.BeeDataSourceConfig;
import cn.beecp.RawConnectionFactory;
import cn.beecp.RawXaConnectionFactory;
import cn.beecp.pool.Borrower;
import cn.beecp.pool.ConnectionPoolStatics;
import cn.beecp.pool.FastConnectionPoolMonitorVo;
import cn.beecp.pool.PooledConnection;
import cn.beecp.pool.PooledConnectionTransferPolicy;
import cn.beecp.pool.PooledConnectionValidTest;
import cn.beecp.pool.ProxyConnectionBase;
import cn.beecp.pool.XaProxyConnection;
import cn.beecp.pool.XaProxyResource;
import cn.beecp.pool.XaResourceLocalImpl;
import cn.beecp.pool.atomic.AtomicIntegerFieldUpdaterImpl;
import cn.beecp.pool.exception.ConnectionCreateException;
import cn.beecp.pool.exception.ConnectionGetException;
import cn.beecp.pool.exception.ConnectionGetForbiddenException;
import cn.beecp.pool.exception.ConnectionGetInterruptedException;
import cn.beecp.pool.exception.ConnectionGetTimeoutException;
import cn.beecp.pool.exception.PoolCreateFailedException;
import cn.beecp.pool.exception.PoolInClearingException;
import cn.beecp.pool.exception.PoolInitializedException;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FastConnectionPool
extends Thread
implements BeeConnectionPool,
BeeConnectionPoolJmxBean,
PooledConnectionValidTest,
PooledConnectionTransferPolicy {
    private static final AtomicIntegerFieldUpdater<PooledConnection> ConStUpd = AtomicIntegerFieldUpdaterImpl.newUpdater(PooledConnection.class, "state");
    private static final AtomicReferenceFieldUpdater<Borrower, Object> BorrowStUpd = AtomicReferenceFieldUpdater.newUpdater(Borrower.class, Object.class, "state");
    private static final AtomicIntegerFieldUpdater<FastConnectionPool> PoolStateUpd = AtomicIntegerFieldUpdaterImpl.newUpdater(FastConnectionPool.class, "poolState");
    private static final Logger Log = LoggerFactory.getLogger(FastConnectionPool.class);
    private static final long spinForTimeoutThreshold = 1023L;
    private String poolName;
    private String poolMode;
    private String poolHostIP;
    private long poolThreadId;
    private String poolThreadName;
    private int poolMaxSize;
    private volatile int poolState;
    private boolean isFairMode;
    private boolean isCompeteMode;
    private int semaphoreSize;
    private PoolSemaphore semaphore;
    private long maxWaitNs;
    private long idleTimeoutMs;
    private long holdTimeoutMs;
    private boolean supportHoldTimeout;
    private long validAssumeTimeMs;
    private int validTestTimeout;
    private long delayTimeForNextClearNs;
    private int stateCodeOnRelease;
    private PooledConnectionTransferPolicy transferPolicy;
    private boolean templatePooledConnNotCreated = true;
    private PooledConnection templatePooledConn;
    private ReentrantLock pooledArrayLock;
    private volatile PooledConnection[] pooledArray;
    private boolean isRawXaConnFactory;
    private RawConnectionFactory rawConnFactory;
    private RawXaConnectionFactory rawXaConnFactory;
    private PooledConnectionValidTest conValidTest;
    private ThreadPoolExecutor networkTimeoutExecutor;
    private AtomicInteger servantState;
    private AtomicInteger servantTryCount;
    private AtomicInteger idleScanState;
    private IdleTimeoutScanThread idleScanThread;
    private ConcurrentLinkedQueue<Borrower> waitQueue;
    private ThreadLocal<WeakReference<Borrower>> threadLocal;
    private BeeDataSourceConfig poolConfig;
    private FastConnectionPoolMonitorVo monitorVo;
    private ConnectionPoolHook exitHook;
    private boolean printRuntimeLog;

    public void init(BeeDataSourceConfig config) throws SQLException {
        if (PoolStateUpd.compareAndSet(this, 0, 1)) {
            try {
                ConnectionPoolStatics.checkJdbcProxyClass();
                if (config == null) {
                    throw new PoolCreateFailedException("Configuration of pool initialization can't be null");
                }
                this.poolConfig = config.check();
                this.startup();
                this.poolState = 2;
            }
            catch (Throwable e) {
                Log.info("BeeCP({})Initialized failed", e);
                this.poolState = 0;
                throw e instanceof SQLException ? (SQLException)e : new PoolInitializedException(e);
            }
        } else {
            throw new PoolCreateFailedException("Pool has already been initialized or in initializing");
        }
    }

    private void startup() throws SQLException {
        this.poolName = this.poolConfig.getPoolName();
        Log.info("BeeCP({})starting up....", (Object)this.poolName);
        Object rawFactory = this.poolConfig.getConnectionFactory();
        if (rawFactory instanceof RawXaConnectionFactory) {
            this.isRawXaConnFactory = true;
            this.rawXaConnFactory = (RawXaConnectionFactory)rawFactory;
        } else if (rawFactory instanceof RawConnectionFactory) {
            this.rawConnFactory = (RawConnectionFactory)rawFactory;
        } else {
            throw new PoolCreateFailedException("Connection factory must implement one of interfaces[RawConnectionFactory,RawXaConnectionFactory]");
        }
        this.templatePooledConn = null;
        this.templatePooledConnNotCreated = true;
        this.poolMaxSize = this.poolConfig.getMaxActive();
        if (1 == this.poolState) {
            this.pooledArrayLock = new ReentrantLock();
            this.pooledArray = new PooledConnection[0];
        }
        this.maxWaitNs = TimeUnit.MILLISECONDS.toNanos(this.poolConfig.getMaxWait());
        if (this.poolConfig.getInitialSize() > 0 && !this.poolConfig.isAsyncCreateInitConnection()) {
            this.createInitConnections(this.poolConfig.getInitialSize(), true);
        }
        if (this.poolConfig.isFairMode()) {
            this.poolMode = "fair";
            this.isFairMode = true;
            this.transferPolicy = new FairTransferPolicy();
        } else {
            this.poolMode = "compete";
            this.isCompeteMode = true;
            this.transferPolicy = this;
        }
        this.stateCodeOnRelease = this.transferPolicy.getStateCodeOnRelease();
        this.idleTimeoutMs = this.poolConfig.getIdleTimeout();
        this.holdTimeoutMs = this.poolConfig.getHoldTimeout();
        this.supportHoldTimeout = this.holdTimeoutMs > 0L;
        this.validAssumeTimeMs = this.poolConfig.getValidAssumeTime();
        this.validTestTimeout = this.poolConfig.getValidTestTimeout();
        this.delayTimeForNextClearNs = TimeUnit.MILLISECONDS.toNanos(this.poolConfig.getDelayTimeForNextClear());
        this.printRuntimeLog = this.poolConfig.isPrintRuntimeLog();
        this.semaphoreSize = this.poolConfig.getBorrowSemaphoreSize();
        this.semaphore = new PoolSemaphore(this.semaphoreSize, this.isFairMode);
        this.threadLocal = new BorrowerThreadLocal();
        if (1 == this.poolState) {
            this.waitQueue = new ConcurrentLinkedQueue();
            this.servantTryCount = new AtomicInteger(0);
            this.servantState = new AtomicInteger(0);
            this.idleScanState = new AtomicInteger(0);
            this.idleScanThread = new IdleTimeoutScanThread(this);
            this.monitorVo = this.createPoolMonitorVo();
            this.exitHook = new ConnectionPoolHook(this);
            Runtime.getRuntime().addShutdownHook(this.exitHook);
            this.registerJmx();
            this.setDaemon(true);
            this.setName("BeeCP(" + this.poolName + ")" + "-asyncAdd");
            this.start();
            this.idleScanThread.setDaemon(true);
            this.idleScanThread.setPriority(3);
            this.idleScanThread.setName("BeeCP(" + this.poolName + ")" + "-idleCheck");
            this.idleScanThread.start();
        }
        if (this.poolConfig.getInitialSize() > 0 && this.poolConfig.isAsyncCreateInitConnection()) {
            new PoolInitAsyncCreateThread(this).start();
        }
        Log.info("BeeCP({})has startup{mode:{},init size:{},max size:{},semaphore size:{},max wait:{}ms,driver:{}}", new Object[]{this.poolName, this.poolMode, this.pooledArray.length, this.poolMaxSize, this.semaphoreSize, this.poolConfig.getMaxWait(), this.poolConfig.getDriverClassName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInitConnections(int initSize, boolean syn) throws SQLException {
        this.pooledArrayLock.lock();
        try {
            for (int i = 0; i < initSize; ++i) {
                this.createPooledConn(0);
            }
        }
        catch (Throwable e) {
            for (PooledConnection p : this.pooledArray) {
                this.removePooledConn(p, "init");
            }
            if (syn) {
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw new PoolInitializedException(e);
            }
            Log.warn("Failed to create initial connections" + e);
        }
        finally {
            this.pooledArrayLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledConnection createPooledConn(int state) throws SQLException {
        try {
            if (!this.pooledArrayLock.tryLock(this.maxWaitNs, TimeUnit.NANOSECONDS)) {
                throw new ConnectionCreateException("Timeout at acquiring lock to create a pooled connection");
            }
        }
        catch (InterruptedException e) {
            throw new ConnectionCreateException("Interrupted at acquiring lock to create a pooled connection");
        }
        try {
            int l = this.pooledArray.length;
            if (l < this.poolMaxSize) {
                if (this.printRuntimeLog) {
                    Log.info("BeeCP({}))Begin to create a new pooled connection with state:{}", (Object)this.poolName, (Object)state);
                }
                Connection rawConn = null;
                XAConnection rawXaConn = null;
                XAResource rawXaRes = null;
                try {
                    if (this.isRawXaConnFactory) {
                        rawXaConn = this.rawXaConnFactory.create();
                        rawConn = rawXaConn.getConnection();
                        rawXaRes = rawXaConn.getXAResource();
                    } else {
                        rawConn = this.rawConnFactory.create();
                    }
                    if (this.templatePooledConnNotCreated) {
                        this.templatePooledConn = this.createTemplatePooledConn(rawConn);
                        this.templatePooledConnNotCreated = false;
                    }
                    PooledConnection p = this.templatePooledConn.setDefaultAndCopy(rawConn, state, rawXaRes);
                    if (this.printRuntimeLog) {
                        Log.info("BeeCP({}))Created a new pooled connection:{} with state:{}", new Object[]{this.poolName, p, state});
                    }
                    PooledConnection[] arrayNew = new PooledConnection[l + 1];
                    System.arraycopy(this.pooledArray, 0, arrayNew, 0, l);
                    arrayNew[l] = p;
                    this.pooledArray = arrayNew;
                    PooledConnection pooledConnection = p;
                    return pooledConnection;
                }
                catch (Throwable e) {
                    if (rawConn != null) {
                        ConnectionPoolStatics.oclose(rawConn);
                    } else if (rawXaConn != null) {
                        ConnectionPoolStatics.oclose(rawXaConn);
                    }
                    throw e instanceof SQLException ? (SQLException)e : new ConnectionCreateException(e);
                }
            }
            PooledConnection pooledConnection = null;
            return pooledConnection;
        }
        finally {
            this.pooledArrayLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePooledConn(PooledConnection p, String removeType) {
        if (this.printRuntimeLog) {
            Log.info("BeeCP({}))Begin to remove a pooled connection:{} for reason:{}", new Object[]{this.poolName, p, removeType});
        }
        p.onBeforeRemove();
        this.pooledArrayLock.lock();
        try {
            int l = this.pooledArray.length;
            for (int i = l - 1; i >= 0; --i) {
                if (this.pooledArray[i] != p) continue;
                PooledConnection[] arrayNew = new PooledConnection[l - 1];
                System.arraycopy(this.pooledArray, 0, arrayNew, 0, i);
                int m = l - i - 1;
                if (m > 0) {
                    System.arraycopy(this.pooledArray, i + 1, arrayNew, i, m);
                }
                this.pooledArray = arrayNew;
                if (this.printRuntimeLog) {
                    Log.info("BeeCP({}))Removed a pooled connection:{} for reason:{}", new Object[]{this.poolName, p, removeType});
                }
                break;
            }
        }
        finally {
            this.pooledArrayLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledConnection createTemplatePooledConn(Connection rawCon) throws SQLException {
        boolean supportIsValid;
        String defaultSchema;
        String defaultCatalog;
        Boolean defaultReadOnly;
        Integer defaultTransactionIsolation;
        Boolean defaultAutoCommit;
        block31: {
            block30: {
                block29: {
                    defaultAutoCommit = this.poolConfig.isDefaultAutoCommit();
                    if (defaultAutoCommit == null && this.poolConfig.isEnableDefaultOnAutoCommit()) {
                        defaultAutoCommit = rawCon.getAutoCommit();
                    }
                    if (defaultAutoCommit == null) {
                        defaultAutoCommit = Boolean.TRUE;
                    }
                    if ((defaultTransactionIsolation = this.poolConfig.getDefaultTransactionIsolationCode()) == null && this.poolConfig.isEnableDefaultOnTransactionIsolation()) {
                        defaultTransactionIsolation = rawCon.getTransactionIsolation();
                    }
                    if (defaultTransactionIsolation == null) {
                        defaultTransactionIsolation = 2;
                    }
                    if ((defaultReadOnly = this.poolConfig.isDefaultReadOnly()) == null && this.poolConfig.isEnableDefaultOnReadOnly()) {
                        defaultReadOnly = rawCon.isReadOnly();
                    }
                    if (defaultReadOnly == null) {
                        defaultReadOnly = Boolean.FALSE;
                    }
                    if (ConnectionPoolStatics.isBlank(defaultCatalog = this.poolConfig.getDefaultCatalog()) && this.poolConfig.isEnableDefaultOnCatalog()) {
                        try {
                            defaultCatalog = rawCon.getCatalog();
                        }
                        catch (Throwable e) {
                            if (!this.printRuntimeLog) break block29;
                            Log.warn("BeeCP({})'catalog' property of connection not supported by driver", (Object)this.poolName);
                        }
                    }
                }
                if (ConnectionPoolStatics.isBlank(defaultSchema = this.poolConfig.getDefaultSchema()) && this.poolConfig.isEnableDefaultOnSchema()) {
                    try {
                        defaultSchema = rawCon.getSchema();
                    }
                    catch (Throwable e) {
                        if (!this.printRuntimeLog) break block30;
                        Log.warn("BeeCP({})'schema' property of connection not supported by driver", (Object)this.poolName);
                    }
                }
            }
            supportIsValid = true;
            try {
                if (rawCon.isValid(this.validTestTimeout)) {
                    this.conValidTest = this;
                } else {
                    supportIsValid = false;
                    if (this.printRuntimeLog) {
                        Log.warn("BeeCP({})'isValid' method of connection not supported by driver", (Object)this.poolName);
                    }
                }
            }
            catch (Throwable e) {
                supportIsValid = false;
                if (!this.printRuntimeLog) break block31;
                Log.warn("BeeCP({}) 'isValid' method check failed for driver", (Object)this.poolName, (Object)e);
            }
        }
        if (!supportIsValid) {
            String conTestSql = this.poolConfig.getValidTestSql();
            boolean supportQueryTimeout = ConnectionPoolStatics.validateTestSql(this.poolName, rawCon, conTestSql, this.validTestTimeout, defaultAutoCommit);
            this.conValidTest = new PooledConnectionValidTestBySql(this.poolName, conTestSql, this.validTestTimeout, defaultAutoCommit, supportQueryTimeout, this.printRuntimeLog);
        }
        int defaultNetworkTimeout = 0;
        boolean supportNetworkTimeoutInd = true;
        try {
            defaultNetworkTimeout = rawCon.getNetworkTimeout();
            if (defaultNetworkTimeout < 0) {
                supportNetworkTimeoutInd = false;
                if (this.printRuntimeLog) {
                    Log.warn("BeeCP({})'networkTimeout' property of connection not supported by driver", (Object)this.poolName);
                }
            } else {
                if (this.networkTimeoutExecutor == null) {
                    this.networkTimeoutExecutor = new ThreadPoolExecutor(this.poolMaxSize, this.poolMaxSize, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.poolMaxSize), new PoolThreadThreadFactory("BeeCP(" + this.poolName + ")"));
                    this.networkTimeoutExecutor.allowCoreThreadTimeOut(true);
                }
                rawCon.setNetworkTimeout(this.networkTimeoutExecutor, defaultNetworkTimeout);
            }
        }
        catch (Throwable e) {
            supportNetworkTimeoutInd = false;
            if (this.printRuntimeLog) {
                Log.warn("BeeCP({}) 'networkTimeout' property check failed for driver", (Object)this.poolName, (Object)e);
            }
        }
        finally {
            if (!supportNetworkTimeoutInd && this.networkTimeoutExecutor != null) {
                this.networkTimeoutExecutor.shutdown();
                this.networkTimeoutExecutor = null;
            }
        }
        return new PooledConnection(this, this.poolConfig.isEnableDefaultOnAutoCommit(), defaultAutoCommit, this.poolConfig.isEnableDefaultOnTransactionIsolation(), defaultTransactionIsolation, this.poolConfig.isEnableDefaultOnReadOnly(), defaultReadOnly, this.poolConfig.isEnableDefaultOnCatalog(), defaultCatalog, this.poolConfig.isEnableDefaultOnSchema(), defaultSchema, supportNetworkTimeoutInd, defaultNetworkTimeout, this.networkTimeoutExecutor, this.poolConfig.getSqlExceptionCodeList(), this.poolConfig.getSqlExceptionStateList());
    }

    public final Connection getConnection() throws SQLException {
        return ConnectionPoolStatics.createProxyConnection(this.getPooledConnection());
    }

    public final XAConnection getXAConnection() throws SQLException {
        PooledConnection p = this.getPooledConnection();
        ProxyConnectionBase proxyConn = ConnectionPoolStatics.createProxyConnection(p);
        return new XaProxyConnection(proxyConn, this.isRawXaConnFactory ? new XaProxyResource(p.rawXaRes, proxyConn) : new XaResourceLocalImpl(proxyConn, p.defaultAutoCommit));
    }

    private PooledConnection getPooledConnection() throws SQLException {
        PooledConnection p;
        if (this.poolState != 2) {
            throw new ConnectionGetForbiddenException("Access rejected,cause:pool was closed or in clearing");
        }
        Borrower b = (Borrower)this.threadLocal.get().get();
        if (b != null) {
            PooledConnection p2 = b.lastUsed;
            if (p2 != null && p2.state == 0 && ConStUpd.compareAndSet(p2, 0, 1)) {
                if (this.testOnBorrow(p2)) {
                    b.lastUsed = p2;
                    return b.lastUsed;
                }
                b.lastUsed = null;
            }
        } else {
            b = new Borrower();
            this.threadLocal.set(new WeakReference<Borrower>(b));
        }
        long deadline = System.nanoTime();
        try {
            if (!this.semaphore.tryAcquire(this.maxWaitNs, TimeUnit.NANOSECONDS)) {
                throw new ConnectionGetTimeoutException("Timeout at acquiring semaphore to get a idle connection");
            }
        }
        catch (InterruptedException e) {
            throw new ConnectionGetInterruptedException("Interrupted at acquiring semaphore to get a idle connection");
        }
        try {
            p = this.searchOrCreate();
            if (p != null) {
                this.semaphore.release();
                b.lastUsed = p;
                return b.lastUsed;
            }
        }
        catch (SQLException e) {
            this.semaphore.release();
            throw e;
        }
        b.state = null;
        this.waitQueue.offer(b);
        ConnectionGetException cause = null;
        deadline += this.maxWaitNs;
        while (true) {
            Object s;
            if ((s = b.state) instanceof PooledConnection) {
                p = (PooledConnection)s;
                if (this.transferPolicy.tryCatch(p) && this.testOnBorrow(p)) {
                    this.waitQueue.remove(b);
                    this.semaphore.release();
                    b.lastUsed = p;
                    return b.lastUsed;
                }
            } else if (s instanceof Throwable) {
                this.waitQueue.remove(b);
                this.semaphore.release();
                throw s instanceof SQLException ? (SQLException)s : new ConnectionGetException((Throwable)s);
            }
            if (cause != null) {
                BorrowStUpd.compareAndSet(b, s, cause);
                continue;
            }
            if (s != null) {
                b.state = null;
                continue;
            }
            long t = deadline - System.nanoTime();
            if (t > 1023L) {
                if (this.servantTryCount.get() > 0 && this.servantState.get() == 1 && this.servantState.compareAndSet(1, 0)) {
                    LockSupport.unpark(this);
                }
                LockSupport.parkNanos(t);
                if (!Thread.interrupted()) continue;
                cause = new ConnectionGetInterruptedException("Interrupted while waiting in queue");
                continue;
            }
            if (t > 0L) continue;
            cause = new ConnectionGetTimeoutException("Timeout in wait queue");
        }
    }

    private PooledConnection searchOrCreate() throws SQLException {
        PooledConnection[] array;
        for (PooledConnection p : array = this.pooledArray) {
            if (p.state != 0 || !ConStUpd.compareAndSet(p, 0, 1) || !this.testOnBorrow(p)) continue;
            return p;
        }
        if (this.pooledArray.length < this.poolMaxSize) {
            return this.createPooledConn(1);
        }
        return null;
    }

    private void tryWakeupServantThread() {
        int c;
        do {
            if ((c = this.servantTryCount.get()) < this.poolMaxSize) continue;
            return;
        } while (!this.servantTryCount.compareAndSet(c, c + 1));
        if (!this.waitQueue.isEmpty() && this.servantState.get() == 1 && this.servantState.compareAndSet(1, 0)) {
            LockSupport.unpark(this);
        }
    }

    public final void recycle(PooledConnection p) {
        if (this.isCompeteMode) {
            p.state = 0;
        }
        for (Borrower b : this.waitQueue) {
            if (p.state != this.stateCodeOnRelease) {
                return;
            }
            if (b.state != null || !BorrowStUpd.compareAndSet(b, null, p)) continue;
            LockSupport.unpark(b.thread);
            return;
        }
        if (this.isFairMode) {
            p.state = 0;
        }
        this.tryWakeupServantThread();
    }

    private void transferException(Throwable e) {
        for (Borrower b : this.waitQueue) {
            if (b.state != null || !BorrowStUpd.compareAndSet(b, null, e)) continue;
            LockSupport.unpark(b.thread);
            return;
        }
    }

    final void abandonOnReturn(PooledConnection p, String reason) {
        this.removePooledConn(p, reason);
        this.tryWakeupServantThread();
    }

    private boolean testOnBorrow(PooledConnection p) {
        if (System.currentTimeMillis() - p.lastAccessTime > this.validAssumeTimeMs && !this.conValidTest.isValid(p)) {
            this.removePooledConn(p, "bad");
            this.tryWakeupServantThread();
            return false;
        }
        return true;
    }

    public final int getStateCodeOnRelease() {
        return 0;
    }

    public final boolean tryCatch(PooledConnection p) {
        return p.state == 0 && ConStUpd.compareAndSet(p, 0, 1);
    }

    private void shutdownPoolThread() {
        int curState = this.servantState.get();
        this.servantState.set(2);
        if (curState == 1) {
            LockSupport.unpark(this);
        }
        curState = this.idleScanState.get();
        this.idleScanState.set(2);
        if (curState == 1) {
            LockSupport.unpark(this.idleScanThread);
        }
    }

    public void run() {
        while (this.poolState != 3) {
            int c;
            while (!(this.servantState.get() != 0 || (c = this.servantTryCount.get()) <= 0 || this.waitQueue.isEmpty() && this.servantTryCount.compareAndSet(c, 0))) {
                this.servantTryCount.decrementAndGet();
                try {
                    PooledConnection p = this.searchOrCreate();
                    if (p == null) continue;
                    this.recycle(p);
                }
                catch (Throwable e) {
                    this.transferException(e);
                }
            }
            if (this.servantState.get() == 2) break;
            if (this.servantTryCount.get() != 0 || !this.servantState.compareAndSet(0, 1)) continue;
            LockSupport.park();
        }
    }

    private void closeIdleTimeoutConnection() {
        PooledConnection[] array;
        if (this.printRuntimeLog) {
            BeeConnectionPoolMonitorVo vo = this.getPoolMonitorVo();
            Log.info("BeeCP({})-before idle clear,{idle:{},using:{},semaphore-waiting:{},transfer-waiting:{}}", new Object[]{this.poolName, vo.getIdleSize(), vo.getUsingSize(), vo.getSemaphoreWaitingSize(), vo.getTransferWaitingSize()});
        }
        for (PooledConnection p : array = this.pooledArray) {
            int state = p.state;
            if (state == 0 && this.semaphore.availablePermits() == this.semaphoreSize) {
                boolean isTimeoutInIdle;
                boolean bl = isTimeoutInIdle = System.currentTimeMillis() - p.lastAccessTime >= this.idleTimeoutMs;
                if (!isTimeoutInIdle || !ConStUpd.compareAndSet(p, state, 2)) continue;
                this.removePooledConn(p, "idle");
                this.tryWakeupServantThread();
                continue;
            }
            if (state == 1 && this.supportHoldTimeout) {
                if (System.currentTimeMillis() - p.lastAccessTime < this.holdTimeoutMs) continue;
                ProxyConnectionBase proxyInUsing = p.proxyInUsing;
                if (proxyInUsing != null) {
                    ConnectionPoolStatics.oclose(proxyInUsing);
                    continue;
                }
                this.removePooledConn(p, "bad");
                this.tryWakeupServantThread();
                continue;
            }
            if (state != 2) continue;
            this.removePooledConn(p, "closed");
            this.tryWakeupServantThread();
        }
        if (this.printRuntimeLog) {
            BeeConnectionPoolMonitorVo vo = this.getPoolMonitorVo();
            Log.info("BeeCP({})-after idle clear,{idle:{},using:{},semaphore-waiting:{},transfer-waiting:{}}", new Object[]{this.poolName, vo.getIdleSize(), vo.getUsingSize(), vo.getSemaphoreWaitingSize(), vo.getTransferWaitingSize()});
        }
    }

    public void clear(boolean forceCloseUsing) {
        try {
            this.clear(forceCloseUsing, null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void clear(boolean forceCloseUsing, BeeDataSourceConfig config) throws SQLException {
        if (PoolStateUpd.compareAndSet(this, 2, 4)) {
            Log.info("BeeCP({})begin to remove all connections", (Object)this.poolName);
            this.removeAllConnections(forceCloseUsing, "clear");
            Log.info("BeeCP({})removed all connections", (Object)this.poolName);
            try {
                if (config != null) {
                    Log.info("BeeCP({})begin to restart with new configuration", (Object)this.poolName);
                    this.poolConfig = config.check();
                    this.startup();
                }
            }
            catch (Throwable e) {
                Log.error("BeeCP({})Restarted failed", e);
                throw e instanceof SQLException ? (SQLException)e : new PoolInitializedException(e);
            }
            finally {
                this.poolState = 2;
                Log.info("BeeCP({})reset pool state to ready after clearing", (Object)this.poolName);
            }
        }
    }

    private void removeAllConnections(boolean force, String source) {
        this.semaphore.interruptWaitingThreads();
        PoolInClearingException exception = new PoolInClearingException("Access rejected,pool in clearing");
        while (!this.waitQueue.isEmpty()) {
            this.transferException(exception);
        }
        while (true) {
            PooledConnection[] array;
            for (PooledConnection p : array = this.pooledArray) {
                int state = p.state;
                if (state == 0) {
                    if (!ConStUpd.compareAndSet(p, 0, 2)) continue;
                    this.removePooledConn(p, source);
                    continue;
                }
                if (state == 1) {
                    ProxyConnectionBase proxyInUsing = p.proxyInUsing;
                    if (proxyInUsing != null) {
                        if (!force && (!this.supportHoldTimeout || System.currentTimeMillis() - p.lastAccessTime < this.holdTimeoutMs)) continue;
                        ConnectionPoolStatics.oclose(proxyInUsing);
                        if (!ConStUpd.compareAndSet(p, 0, 2)) continue;
                        this.removePooledConn(p, source);
                        continue;
                    }
                    this.removePooledConn(p, source);
                    continue;
                }
                if (state != 2) continue;
                this.removePooledConn(p, source);
            }
            if (this.pooledArray.length == 0) break;
            LockSupport.parkNanos(this.delayTimeForNextClearNs);
        }
        if (this.printRuntimeLog) {
            BeeConnectionPoolMonitorVo vo = this.getPoolMonitorVo();
            Log.info("BeeCP({})-{idle:{},using:{},semaphore-waiting:{},transfer-waiting:{}}", new Object[]{this.poolName, vo.getIdleSize(), vo.getUsingSize(), vo.getSemaphoreWaitingSize(), vo.getTransferWaitingSize()});
        }
    }

    public boolean isClosed() {
        return this.poolState == 3;
    }

    public void close() {
        while (true) {
            int poolStateCode;
            if (((poolStateCode = this.poolState) == 0 || poolStateCode == 2) && PoolStateUpd.compareAndSet(this, poolStateCode, 3)) {
                Log.info("BeeCP({})Begin to shutdown", (Object)this.poolName);
                this.shutdownPoolThread();
                this.unregisterJmx();
                this.removeAllConnections(this.poolConfig.isForceCloseUsingOnClear(), "destroy");
                if (this.networkTimeoutExecutor != null) {
                    this.networkTimeoutExecutor.shutdownNow();
                }
                try {
                    Runtime.getRuntime().removeShutdownHook(this.exitHook);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Log.info("BeeCP({})Has shutdown", (Object)this.poolName);
                break;
            }
            if (poolStateCode == 3) break;
            LockSupport.parkNanos(this.delayTimeForNextClearNs);
        }
    }

    public void setPrintRuntimeLog(boolean indicator) {
        this.printRuntimeLog = indicator;
    }

    public int getTotalSize() {
        return this.pooledArray.length;
    }

    public int getIdleSize() {
        PooledConnection[] array;
        int idleSize = 0;
        for (PooledConnection p : array = this.pooledArray) {
            if (p.state != 0) continue;
            ++idleSize;
        }
        return idleSize;
    }

    public int getUsingSize() {
        int active = this.pooledArray.length - this.getIdleSize();
        return active > 0 ? active : 0;
    }

    public int getSemaphoreWaitingSize() {
        return this.semaphore.getQueueLength();
    }

    public int getSemaphoreAcquiredSize() {
        return this.semaphoreSize - this.semaphore.availablePermits();
    }

    public int getTransferWaitingSize() {
        int size = 0;
        for (Borrower borrower : this.waitQueue) {
            if (borrower.state != null) continue;
            ++size;
        }
        return size;
    }

    private void registerJmx() {
        if (this.poolConfig.isEnableJmx()) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.registerJmxBean(mBeanServer, String.format("FastConnectionPool:type=BeeCP(%s)", this.poolName), this);
            this.registerJmxBean(mBeanServer, String.format("BeeDataSourceConfig:type=BeeCP(%s)-config", this.poolName), this.poolConfig);
        }
    }

    private void registerJmxBean(MBeanServer mBeanServer, String regName, Object bean) {
        try {
            ObjectName jmxRegName = new ObjectName(regName);
            if (!mBeanServer.isRegistered(jmxRegName)) {
                mBeanServer.registerMBean(bean, jmxRegName);
            }
        }
        catch (Exception e) {
            Log.warn("BeeCP({})Failed to assembly jmx-bean:{}", new Object[]{this.poolName, regName, e});
        }
    }

    private void unregisterJmx() {
        if (this.poolConfig.isEnableJmx()) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.unregisterJmxBean(mBeanServer, String.format("FastConnectionPool:type=BeeCP(%s)", this.poolName));
            this.unregisterJmxBean(mBeanServer, String.format("BeeDataSourceConfig:type=BeeCP(%s)-config", this.poolName));
        }
    }

    private void unregisterJmxBean(MBeanServer mBeanServer, String regName) {
        try {
            ObjectName jmxRegName = new ObjectName(regName);
            if (mBeanServer.isRegistered(jmxRegName)) {
                mBeanServer.unregisterMBean(jmxRegName);
            }
        }
        catch (Exception e) {
            Log.warn("BeeCP({})Failed to unregister jmx-bean:{}", new Object[]{this.poolName, regName, e});
        }
    }

    public final boolean isValid(PooledConnection p) {
        block3: {
            try {
                if (p.rawConn.isValid(this.validTestTimeout)) {
                    p.lastAccessTime = System.currentTimeMillis();
                    return true;
                }
            }
            catch (Throwable e) {
                if (!this.printRuntimeLog) break block3;
                Log.warn("BeeCP({})Failed to test connection with 'isValid' method", (Object)this.poolName, (Object)e);
            }
        }
        return false;
    }

    private FastConnectionPoolMonitorVo createPoolMonitorVo() {
        Thread currentThread = Thread.currentThread();
        this.poolThreadId = currentThread.getId();
        this.poolThreadName = currentThread.getName();
        try {
            this.poolHostIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            Log.info("BeeCP({})Failed to resolve host IP", (Object)this.poolName);
        }
        return new FastConnectionPoolMonitorVo();
    }

    public BeeConnectionPoolMonitorVo getPoolMonitorVo() {
        this.monitorVo.setPoolName(this.poolName);
        this.monitorVo.setPoolMode(this.poolMode);
        this.monitorVo.setPoolMaxSize(this.poolMaxSize);
        this.monitorVo.setThreadId(this.poolThreadId);
        this.monitorVo.setThreadName(this.poolThreadName);
        this.monitorVo.setHostIP(this.poolHostIP);
        int totSize = this.getTotalSize();
        int idleSize = this.getIdleSize();
        this.monitorVo.setPoolState(this.poolState);
        this.monitorVo.setIdleSize(idleSize);
        this.monitorVo.setUsingSize(totSize - idleSize);
        this.monitorVo.setSemaphoreWaitingSize(this.getSemaphoreWaitingSize());
        this.monitorVo.setTransferWaitingSize(this.getTransferWaitingSize());
        return this.monitorVo;
    }

    private static final class PooledConnectionValidTestBySql
    implements PooledConnectionValidTest {
        private final String testSql;
        private final String poolName;
        private final boolean printRuntimeLog;
        private final int validTestTimeout;
        private final boolean isDefaultAutoCommit;
        private final boolean supportQueryTimeout;

        private PooledConnectionValidTestBySql(String poolName, String testSql, int validTestTimeout, boolean isDefaultAutoCommit, boolean supportQueryTimeout, boolean printRuntimeLog) {
            this.poolName = poolName;
            this.testSql = testSql;
            this.printRuntimeLog = printRuntimeLog;
            this.validTestTimeout = validTestTimeout;
            this.isDefaultAutoCommit = isDefaultAutoCommit;
            this.supportQueryTimeout = supportQueryTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isValid(PooledConnection p) {
            Statement st = null;
            boolean changed = false;
            Connection rawConn = p.rawConn;
            boolean checkPassed = true;
            try {
                block21: {
                    if (this.isDefaultAutoCommit) {
                        rawConn.setAutoCommit(false);
                        changed = true;
                    }
                    st = rawConn.createStatement();
                    if (this.supportQueryTimeout) {
                        try {
                            st.setQueryTimeout(this.validTestTimeout);
                        }
                        catch (Throwable e) {
                            if (!this.printRuntimeLog) break block21;
                            Log.warn("BeeCP({})Called failed on method 'setQueryTimeout' in sql tester", (Object)this.poolName, (Object)e);
                        }
                    }
                }
                try {
                    st.execute(this.testSql);
                    p.lastAccessTime = System.currentTimeMillis();
                }
                finally {
                    rawConn.rollback();
                }
            }
            catch (Throwable e) {
                checkPassed = false;
                if (this.printRuntimeLog) {
                    Log.warn("BeeCP({})SQL tested failed on borrowed connection", (Object)this.poolName, (Object)e);
                }
            }
            finally {
                if (st != null) {
                    ConnectionPoolStatics.oclose(st);
                }
                if (changed) {
                    try {
                        rawConn.setAutoCommit(true);
                    }
                    catch (Throwable e) {
                        Log.warn("BeeCP({})Default value(true) reset failed on borrowed connection after sql test", (Object)this.poolName, (Object)e);
                        checkPassed = false;
                    }
                }
            }
            return checkPassed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BorrowerThreadLocal
    extends ThreadLocal<WeakReference<Borrower>> {
        private BorrowerThreadLocal() {
        }

        @Override
        protected WeakReference<Borrower> initialValue() {
            return new WeakReference<Borrower>(new Borrower());
        }
    }

    private static final class FairTransferPolicy
    implements PooledConnectionTransferPolicy {
        private FairTransferPolicy() {
        }

        public int getStateCodeOnRelease() {
            return 1;
        }

        public final boolean tryCatch(PooledConnection p) {
            return p.state == 1;
        }
    }

    private static class ConnectionPoolHook
    extends Thread {
        private final FastConnectionPool pool;

        ConnectionPoolHook(FastConnectionPool pool) {
            this.pool = pool;
        }

        public void run() {
            Log.info("BeeCP({})Hook is running", (Object)this.pool.poolName);
            try {
                this.pool.close();
            }
            catch (Throwable e) {
                Log.error("BeeCP({})Error at closing connection pool", (Object)this.pool.poolName, (Object)e);
            }
        }
    }

    private static final class IdleTimeoutScanThread
    extends Thread {
        private final FastConnectionPool pool;

        IdleTimeoutScanThread(FastConnectionPool pool) {
            this.pool = pool;
        }

        public void run() {
            AtomicInteger idleScanState = this.pool.idleScanState;
            long checkTimeIntervalNanos = TimeUnit.MILLISECONDS.toNanos(this.pool.poolConfig.getTimerCheckInterval());
            while (idleScanState.get() == 0) {
                LockSupport.parkNanos(checkTimeIntervalNanos);
                try {
                    if (this.pool.poolState != 2) continue;
                    this.pool.closeIdleTimeoutConnection();
                }
                catch (Throwable e) {
                    Log.warn("BeeCP({})Error at closing idle timeout connections", (Object)this.pool.poolName, (Object)e);
                }
            }
        }
    }

    private static final class PoolInitAsyncCreateThread
    extends Thread {
        private final FastConnectionPool pool;

        PoolInitAsyncCreateThread(FastConnectionPool pool) {
            this.pool = pool;
        }

        public void run() {
            try {
                this.pool.createInitConnections(this.pool.poolConfig.getInitialSize(), false);
                this.pool.servantState.getAndSet(this.pool.pooledArray.length);
                if (!this.pool.waitQueue.isEmpty() && this.pool.servantState.get() == 1 && this.pool.servantState.compareAndSet(1, 0)) {
                    LockSupport.unpark(this.pool);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static final class PoolSemaphore
    extends Semaphore {
        PoolSemaphore(int permits, boolean fair) {
            super(permits, fair);
        }

        void interruptWaitingThreads() {
            for (Thread thread : this.getQueuedThreads()) {
                thread.interrupt();
            }
        }
    }

    private static final class PoolThreadThreadFactory
    implements ThreadFactory {
        private final String poolName;

        PoolThreadThreadFactory(String poolName) {
            this.poolName = poolName;
        }

        public Thread newThread(Runnable r) {
            Thread th = new Thread(r, this.poolName + "-networkTimeoutRestThread");
            th.setDaemon(true);
            return th;
        }
    }
}

