/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp;

import cn.beecp.BeeDataSourceConfigException;
import cn.beecp.BeeDataSourceConfigJmxBean;
import cn.beecp.BeeJdbcLinkInfoDecoder;
import cn.beecp.RawConnectionFactory;
import cn.beecp.RawXaConnectionFactory;
import cn.beecp.TransactionIsolation;
import cn.beecp.pool.ConnectionFactoryByDriver;
import cn.beecp.pool.ConnectionFactoryByDriverDs;
import cn.beecp.pool.ConnectionPoolStatics;
import cn.beecp.pool.FastConnectionPool;
import cn.beecp.pool.XaConnectionFactoryByDriverDs;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import javax.sql.XADataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeeDataSourceConfig
implements BeeDataSourceConfigJmxBean {
    private static final AtomicInteger PoolNameIndex = new AtomicInteger(1);
    private final Map<String, Object> connectProperties = new HashMap<String, Object>(2);
    private String username;
    private String password;
    private String jdbcUrl;
    private String driverClassName;
    private String poolName;
    private boolean fairMode;
    private int initialSize;
    private boolean asyncCreateInitConnection;
    private int maxActive = Math.min(Math.max(10, ConnectionPoolStatics.NCPU), 50);
    private int borrowSemaphoreSize = Math.min(this.maxActive / 2, ConnectionPoolStatics.NCPU);
    private long maxWait = TimeUnit.SECONDS.toMillis(8L);
    private long idleTimeout = TimeUnit.MINUTES.toMillis(3L);
    private long holdTimeout;
    private String validTestSql = "SELECT 1";
    private int validTestTimeout = 3;
    private long validAssumeTime = 500L;
    private long timerCheckInterval = TimeUnit.MINUTES.toMillis(3L);
    private boolean forceCloseUsingOnClear;
    private long delayTimeForNextClear = 3000L;
    private List<Integer> sqlExceptionCodeList;
    private List<String> sqlExceptionStateList;
    private String defaultCatalog;
    private String defaultSchema;
    private Boolean defaultReadOnly;
    private Boolean defaultAutoCommit;
    private Integer defaultTransactionIsolationCode;
    private String defaultTransactionIsolationName;
    private boolean enableDefaultOnCatalog = true;
    private boolean enableDefaultOnSchema = true;
    private boolean enableDefaultOnReadOnly = true;
    private boolean enableDefaultOnAutoCommit = true;
    private boolean enableDefaultOnTransactionIsolation = true;
    private Class connectionFactoryClass;
    private String connectionFactoryClassName;
    private Object connectionFactory;
    private Class jdbcLinkInfoDecoderClass;
    private String jdbcLinkInfDecoderClassName;
    private String poolImplementClassName = FastConnectionPool.class.getName();
    private boolean enableJmx;
    private boolean printConfigInfo;
    private boolean printRuntimeLog;

    public BeeDataSourceConfig() {
    }

    public BeeDataSourceConfig(File propertiesFile) {
        this.loadFromPropertiesFile(propertiesFile);
    }

    public BeeDataSourceConfig(String propertiesFileName) {
        this.loadFromPropertiesFile(propertiesFileName);
    }

    public BeeDataSourceConfig(Properties configProperties) {
        this.loadFromProperties(configProperties);
    }

    public BeeDataSourceConfig(String driver, String url, String user, String password) {
        this.jdbcUrl = ConnectionPoolStatics.trimString(url);
        this.username = ConnectionPoolStatics.trimString(user);
        this.password = ConnectionPoolStatics.trimString(password);
        this.driverClassName = ConnectionPoolStatics.trimString(driver);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = ConnectionPoolStatics.trimString(username);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = ConnectionPoolStatics.trimString(password);
    }

    @Override
    public String getUrl() {
        return this.jdbcUrl;
    }

    public void setUrl(String jdbcUrl) {
        this.jdbcUrl = ConnectionPoolStatics.trimString(jdbcUrl);
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = ConnectionPoolStatics.trimString(jdbcUrl);
    }

    @Override
    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = ConnectionPoolStatics.trimString(driverClassName);
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = ConnectionPoolStatics.trimString(poolName);
    }

    @Override
    public boolean isFairMode() {
        return this.fairMode;
    }

    public void setFairMode(boolean fairMode) {
        this.fairMode = fairMode;
    }

    @Override
    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int initialSize) {
        if (initialSize >= 0) {
            this.initialSize = initialSize;
        }
    }

    public boolean isAsyncCreateInitConnection() {
        return this.asyncCreateInitConnection;
    }

    public void setAsyncCreateInitConnection(boolean asyncCreateInitConnection) {
        this.asyncCreateInitConnection = asyncCreateInitConnection;
    }

    @Override
    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        if (maxActive > 0) {
            this.maxActive = maxActive;
            this.borrowSemaphoreSize = maxActive > 1 ? Math.min(maxActive / 2, ConnectionPoolStatics.NCPU) : 1;
        }
    }

    @Override
    public int getBorrowSemaphoreSize() {
        return this.borrowSemaphoreSize;
    }

    public void setBorrowSemaphoreSize(int borrowSemaphoreSize) {
        if (borrowSemaphoreSize > 0) {
            this.borrowSemaphoreSize = borrowSemaphoreSize;
        }
    }

    @Override
    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        if (maxWait > 0L) {
            this.maxWait = maxWait;
        }
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        if (idleTimeout > 0L) {
            this.idleTimeout = idleTimeout;
        }
    }

    @Override
    public long getHoldTimeout() {
        return this.holdTimeout;
    }

    public void setHoldTimeout(long holdTimeout) {
        this.holdTimeout = holdTimeout;
    }

    @Override
    public String getValidTestSql() {
        return this.validTestSql;
    }

    public void setValidTestSql(String validTestSql) {
        if (!ConnectionPoolStatics.isBlank(validTestSql)) {
            this.validTestSql = ConnectionPoolStatics.trimString(validTestSql);
        }
    }

    @Override
    public int getValidTestTimeout() {
        return this.validTestTimeout;
    }

    public void setValidTestTimeout(int validTestTimeout) {
        if (validTestTimeout >= 0) {
            this.validTestTimeout = validTestTimeout;
        }
    }

    @Override
    public long getValidAssumeTime() {
        return this.validAssumeTime;
    }

    public void setValidAssumeTime(long validAssumeTime) {
        if (validAssumeTime >= 0L) {
            this.validAssumeTime = validAssumeTime;
        }
    }

    @Override
    public long getTimerCheckInterval() {
        return this.timerCheckInterval;
    }

    public void setTimerCheckInterval(long timerCheckInterval) {
        if (timerCheckInterval > 0L) {
            this.timerCheckInterval = timerCheckInterval;
        }
    }

    @Override
    public boolean isForceCloseUsingOnClear() {
        return this.forceCloseUsingOnClear;
    }

    public void setForceCloseUsingOnClear(boolean forceCloseUsingOnClear) {
        this.forceCloseUsingOnClear = forceCloseUsingOnClear;
    }

    @Override
    public long getDelayTimeForNextClear() {
        return this.delayTimeForNextClear;
    }

    public void setDelayTimeForNextClear(long delayTimeForNextClear) {
        if (delayTimeForNextClear >= 0L) {
            this.delayTimeForNextClear = delayTimeForNextClear;
        }
    }

    public List<Integer> getSqlExceptionCodeList() {
        return this.sqlExceptionCodeList;
    }

    public void addSqlExceptionCode(int code) {
        if (this.sqlExceptionCodeList == null) {
            this.sqlExceptionCodeList = new ArrayList<Integer>(1);
        }
        this.sqlExceptionCodeList.add(code);
    }

    public void removeSqlExceptionCode(int code) {
        if (this.sqlExceptionCodeList != null) {
            this.sqlExceptionCodeList.remove(code);
        }
    }

    public List<String> getSqlExceptionStateList() {
        return this.sqlExceptionStateList;
    }

    public void addSqlExceptionState(String state) {
        if (this.sqlExceptionStateList == null) {
            this.sqlExceptionStateList = new ArrayList<String>(1);
        }
        this.sqlExceptionStateList.add(state);
    }

    public void removeSqlExceptionState(String state) {
        if (this.sqlExceptionStateList != null) {
            this.sqlExceptionStateList.remove(state);
        }
    }

    @Override
    public String getPoolImplementClassName() {
        return this.poolImplementClassName;
    }

    public void setPoolImplementClassName(String poolImplementClassName) {
        if (!ConnectionPoolStatics.isBlank(poolImplementClassName)) {
            this.poolImplementClassName = ConnectionPoolStatics.trimString(poolImplementClassName);
        }
    }

    @Override
    public boolean isEnableJmx() {
        return this.enableJmx;
    }

    public void setEnableJmx(boolean enableJmx) {
        this.enableJmx = enableJmx;
    }

    public boolean isPrintConfigInfo() {
        return this.printConfigInfo;
    }

    public void setPrintConfigInfo(boolean printConfigInfo) {
        this.printConfigInfo = printConfigInfo;
    }

    public boolean isPrintRuntimeLog() {
        return this.printRuntimeLog;
    }

    public void setPrintRuntimeLog(boolean printRuntimeLog) {
        this.printRuntimeLog = printRuntimeLog;
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = ConnectionPoolStatics.trimString(defaultCatalog);
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = ConnectionPoolStatics.trimString(defaultSchema);
    }

    @Override
    public Boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(Boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    @Override
    public Boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(Boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    @Override
    public Integer getDefaultTransactionIsolationCode() {
        return this.defaultTransactionIsolationCode;
    }

    public void setDefaultTransactionIsolationCode(Integer transactionIsolationCode) {
        this.defaultTransactionIsolationCode = transactionIsolationCode;
    }

    @Override
    public String getDefaultTransactionIsolationName() {
        return this.defaultTransactionIsolationName;
    }

    public void setDefaultTransactionIsolationName(String transactionIsolationName) {
        String transactionIsolationNameTemp = ConnectionPoolStatics.trimString(transactionIsolationName);
        this.defaultTransactionIsolationCode = TransactionIsolation.getTransactionIsolationCode(transactionIsolationNameTemp);
        if (this.defaultTransactionIsolationCode == null) {
            throw new BeeDataSourceConfigException("Invalid transaction isolation name:" + transactionIsolationNameTemp + ", value is one of[" + "0,2,1,4,8" + "]");
        }
        this.defaultTransactionIsolationName = transactionIsolationNameTemp;
    }

    public boolean isEnableDefaultOnCatalog() {
        return this.enableDefaultOnCatalog;
    }

    public void setEnableDefaultOnCatalog(boolean enableDefaultOnCatalog) {
        this.enableDefaultOnCatalog = enableDefaultOnCatalog;
    }

    public boolean isEnableDefaultOnSchema() {
        return this.enableDefaultOnSchema;
    }

    public void setEnableDefaultOnSchema(boolean enableDefaultOnSchema) {
        this.enableDefaultOnSchema = enableDefaultOnSchema;
    }

    public boolean isEnableDefaultOnReadOnly() {
        return this.enableDefaultOnReadOnly;
    }

    public void setEnableDefaultOnReadOnly(boolean enableDefaultOnReadOnly) {
        this.enableDefaultOnReadOnly = enableDefaultOnReadOnly;
    }

    public boolean isEnableDefaultOnAutoCommit() {
        return this.enableDefaultOnAutoCommit;
    }

    public void setEnableDefaultOnAutoCommit(boolean enableDefaultOnAutoCommit) {
        this.enableDefaultOnAutoCommit = enableDefaultOnAutoCommit;
    }

    public boolean isEnableDefaultOnTransactionIsolation() {
        return this.enableDefaultOnTransactionIsolation;
    }

    public void setEnableDefaultOnTransactionIsolation(boolean enableDefaultOnTransactionIsolation) {
        this.enableDefaultOnTransactionIsolation = enableDefaultOnTransactionIsolation;
    }

    public Object getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setRawConnectionFactory(RawConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public void setRawXaConnectionFactory(RawXaConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public Class getConnectionFactoryClass() {
        return this.connectionFactoryClass;
    }

    public void setConnectionFactoryClass(Class connectionFactoryClass) {
        this.connectionFactoryClass = connectionFactoryClass;
    }

    @Override
    public String getConnectionFactoryClassName() {
        return this.connectionFactoryClassName;
    }

    public void setConnectionFactoryClassName(String connectionFactoryClassName) {
        this.connectionFactoryClassName = ConnectionPoolStatics.trimString(connectionFactoryClassName);
    }

    public Class getJdbcLinkInfoDecoderClass() {
        return this.jdbcLinkInfoDecoderClass;
    }

    public void setJdbcLinkInfoDecoderClass(Class jdbcLinkInfoDecoderClass) {
        this.jdbcLinkInfoDecoderClass = jdbcLinkInfoDecoderClass;
    }

    public String getJdbcLinkInfDecoderClassName() {
        return this.jdbcLinkInfDecoderClassName;
    }

    public void setJdbcLinkInfDecoderClassName(String jdbcLinkInfDecoderClassName) {
        this.jdbcLinkInfDecoderClassName = jdbcLinkInfDecoderClassName;
    }

    public void removeConnectProperty(String key) {
        if (!ConnectionPoolStatics.isBlank(key)) {
            this.connectProperties.remove(key);
        }
    }

    public void addConnectProperty(String key, Object value) {
        if (!ConnectionPoolStatics.isBlank(key) && value != null) {
            this.connectProperties.put(key, value);
        }
    }

    public void addConnectProperty(String connectPropertyText) {
        if (!ConnectionPoolStatics.isBlank(connectPropertyText)) {
            for (String attribute : connectPropertyText.split("&")) {
                String[] pair = attribute.split("=");
                if (pair.length == 2) {
                    this.addConnectProperty(pair[0].trim(), pair[1].trim());
                    continue;
                }
                pair = attribute.split(":");
                if (pair.length != 2) continue;
                this.addConnectProperty(pair[0].trim(), pair[1].trim());
            }
        }
    }

    public void loadFromPropertiesFile(String filename) {
        if (ConnectionPoolStatics.isBlank(filename)) {
            throw new IllegalArgumentException("Configuration properties file name can't be null or empty");
        }
        this.loadFromPropertiesFile(new File(filename));
    }

    public void loadFromPropertiesFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Configuration properties file can't be null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("Configuration properties file not found:" + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Target object is not a valid file");
        }
        if (!file.getAbsolutePath().toLowerCase(Locale.US).endsWith(".properties")) {
            throw new IllegalArgumentException("Target file is not a properties file");
        }
        InputStream stream = null;
        try {
            stream = Files.newInputStream(Paths.get(file.toURI()), new OpenOption[0]);
            Properties configProperties = new Properties();
            configProperties.load(stream);
            this.loadFromProperties(configProperties);
        }
        catch (BeeDataSourceConfigException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BeeDataSourceConfigException("Failed to load configuration properties file", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable e) {
                    ConnectionPoolStatics.CommonLog.warn("Failed to close inputStream of configuration properties file", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromProperties(Properties configProperties) {
        if (configProperties == null || configProperties.isEmpty()) {
            throw new BeeDataSourceConfigException("Configuration properties can't be null or empty");
        }
        Properties properties = configProperties;
        synchronized (properties) {
            HashMap<String, Object> setValueMap = new HashMap<String, Object>(configProperties.size());
            for (String propertyName : configProperties.stringPropertyNames()) {
                setValueMap.put(propertyName, configProperties.getProperty(propertyName));
            }
            ConnectionPoolStatics.setPropertiesValue(this, setValueMap);
            this.addConnectProperty(ConnectionPoolStatics.getPropertyValue(configProperties, "connectProperties"));
            String connectPropertiesSize = ConnectionPoolStatics.getPropertyValue(configProperties, "connectProperties.size");
            if (!ConnectionPoolStatics.isBlank(connectPropertiesSize)) {
                int size = Integer.parseInt(connectPropertiesSize.trim());
                for (int i = 1; i <= size; ++i) {
                    this.addConnectProperty(ConnectionPoolStatics.getPropertyValue(configProperties, "connectProperties." + i));
                }
            }
        }
    }

    public BeeDataSourceConfig check() throws SQLException {
        if (this.maxActive <= 0) {
            throw new BeeDataSourceConfigException("maxActive must be greater than zero");
        }
        if (this.initialSize < 0) {
            throw new BeeDataSourceConfigException("initialSize must not be less than zero");
        }
        if (this.initialSize > this.maxActive) {
            throw new BeeDataSourceConfigException("initialSize must not be greater than maxActive");
        }
        if (this.borrowSemaphoreSize <= 0) {
            throw new BeeDataSourceConfigException("borrowSemaphoreSize must be greater than zero");
        }
        if (this.idleTimeout <= 0L) {
            throw new BeeDataSourceConfigException("idleTimeout must be greater than zero");
        }
        if (this.holdTimeout < 0L) {
            throw new BeeDataSourceConfigException("holdTimeout must be greater than zero");
        }
        if (this.maxWait <= 0L) {
            throw new BeeDataSourceConfigException("maxWait must be greater than zero");
        }
        if (ConnectionPoolStatics.isBlank(this.validTestSql)) {
            throw new BeeDataSourceConfigException("validTestSql can't be null or empty");
        }
        if (!this.validTestSql.toUpperCase(Locale.US).startsWith("SELECT ")) {
            throw new BeeDataSourceConfigException("validTestSql must be start with 'select '");
        }
        Object connectionFactory = this.createConnectionFactory();
        BeeDataSourceConfig checkedConfig = new BeeDataSourceConfig();
        this.copyTo(checkedConfig);
        checkedConfig.connectionFactory = connectionFactory;
        if (ConnectionPoolStatics.isBlank(checkedConfig.poolName)) {
            checkedConfig.poolName = "FastPool-" + PoolNameIndex.getAndIncrement();
        }
        return checkedConfig;
    }

    void copyTo(BeeDataSourceConfig config) {
        String fieldName = "";
        try {
            for (Field field : BeeDataSourceConfig.class.getDeclaredFields()) {
                fieldName = field.getName();
                if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || "connectProperties".equals(fieldName) || "sqlExceptionCodeList".equals(fieldName) || "sqlExceptionStateList".equals(fieldName)) continue;
                Object fieldValue = field.get(this);
                if (this.printConfigInfo) {
                    ConnectionPoolStatics.CommonLog.info("{}.{}={}", new Object[]{this.poolName, fieldName, fieldValue});
                }
                field.set(config, fieldValue);
            }
        }
        catch (Throwable e) {
            throw new BeeDataSourceConfigException("Failed to copy field[" + fieldName + "]", e);
        }
        for (Map.Entry entry : this.connectProperties.entrySet()) {
            if (this.printConfigInfo) {
                ConnectionPoolStatics.CommonLog.info("{}.connectProperties.{}={}", new Object[]{this.poolName, entry.getKey(), entry.getValue()});
            }
            config.addConnectProperty((String)entry.getKey(), entry.getValue());
        }
        if (this.sqlExceptionCodeList != null && !this.sqlExceptionCodeList.isEmpty()) {
            config.sqlExceptionCodeList = new ArrayList<Integer>(this.sqlExceptionCodeList);
        }
        if (this.sqlExceptionStateList != null && !this.sqlExceptionStateList.isEmpty()) {
            config.sqlExceptionStateList = new ArrayList<String>(this.sqlExceptionStateList);
        }
    }

    private BeeJdbcLinkInfoDecoder createJdbcLinkInfoDecoder() {
        BeeJdbcLinkInfoDecoder jdbcLinkInfoDecoder = null;
        Class<?> jdbcLinkInfoDecoderClass = this.jdbcLinkInfoDecoderClass;
        if (jdbcLinkInfoDecoderClass == null && !ConnectionPoolStatics.isBlank(this.jdbcLinkInfDecoderClassName)) {
            try {
                jdbcLinkInfoDecoderClass = Class.forName(this.jdbcLinkInfDecoderClassName);
            }
            catch (Throwable e) {
                throw new BeeDataSourceConfigException("Failed to create jdbc link info decoder by class:" + this.jdbcLinkInfDecoderClassName, e);
            }
        }
        if (jdbcLinkInfoDecoderClass != null) {
            try {
                jdbcLinkInfoDecoder = (BeeJdbcLinkInfoDecoder)ConnectionPoolStatics.createClassInstance((Class)jdbcLinkInfoDecoderClass, BeeJdbcLinkInfoDecoder.class, "jdbc link info decoder");
            }
            catch (Throwable e) {
                throw new BeeDataSourceConfigException("Failed to instantiate jdbc link info decoder class:" + jdbcLinkInfoDecoderClass.getName(), e);
            }
        }
        return jdbcLinkInfoDecoder;
    }

    private Object createConnectionFactory() throws SQLException {
        if (this.connectionFactory != null) {
            return this.connectionFactory;
        }
        BeeJdbcLinkInfoDecoder jdbcLinkInfoDecoder = this.createJdbcLinkInfoDecoder();
        if (this.connectionFactoryClass == null && ConnectionPoolStatics.isBlank(this.connectionFactoryClassName)) {
            String url = this.jdbcUrl;
            if (ConnectionPoolStatics.isBlank(url)) {
                url = System.getProperty("beecp.url", null);
            }
            if (ConnectionPoolStatics.isBlank(url)) {
                url = System.getProperty("beecp.jdbcUrl", null);
            }
            if (ConnectionPoolStatics.isBlank(url)) {
                throw new BeeDataSourceConfigException("jdbcUrl can't be null");
            }
            if (jdbcLinkInfoDecoder != null) {
                url = jdbcLinkInfoDecoder.decodeUrl(url);
            }
            Driver connectDriver = null;
            if (!ConnectionPoolStatics.isBlank(this.driverClassName)) {
                connectDriver = ConnectionPoolStatics.loadDriver(this.driverClassName);
            }
            if (connectDriver == null) {
                connectDriver = DriverManager.getDriver(url);
            }
            if (connectDriver == null) {
                throw new BeeDataSourceConfigException("Not found driver by url:" + url);
            }
            if (!connectDriver.acceptsURL(url)) {
                throw new BeeDataSourceConfigException("jdbcUrl(" + url + ")can not match driver:" + connectDriver.getClass().getName());
            }
            Properties configProperties = new Properties();
            configProperties.putAll(this.connectProperties);
            String userName = configProperties.getProperty("user");
            String password = configProperties.getProperty("password");
            if (ConnectionPoolStatics.isBlank(userName)) {
                userName = this.username;
                if (ConnectionPoolStatics.isBlank(userName)) {
                    userName = System.getProperty("beecp.user", null);
                }
                if (!ConnectionPoolStatics.isBlank(userName)) {
                    configProperties.setProperty("user", userName);
                }
            }
            if (ConnectionPoolStatics.isBlank(password)) {
                password = this.password;
                if (ConnectionPoolStatics.isBlank(password)) {
                    password = System.getProperty("beecp.password", null);
                }
                if (!ConnectionPoolStatics.isBlank(password)) {
                    configProperties.setProperty("password", password);
                }
            }
            if (jdbcLinkInfoDecoder != null) {
                if (!ConnectionPoolStatics.isBlank(userName)) {
                    configProperties.setProperty("user", jdbcLinkInfoDecoder.decodeUsername(userName));
                }
                if (!ConnectionPoolStatics.isBlank(password)) {
                    configProperties.setProperty("password", jdbcLinkInfoDecoder.decodePassword(password));
                }
            }
            return new ConnectionFactoryByDriver(url, connectDriver, configProperties);
        }
        try {
            String password;
            String userName;
            Class<?> conFactClass = this.connectionFactoryClass != null ? this.connectionFactoryClass : Class.forName(this.connectionFactoryClassName);
            Class[] parentClasses = new Class[]{RawConnectionFactory.class, RawXaConnectionFactory.class, DataSource.class, XADataSource.class};
            Object factory = ConnectionPoolStatics.createClassInstance(conFactClass, parentClasses, "connection factory");
            HashMap<String, Object> propertyValueMap = new HashMap<String, Object>(this.connectProperties);
            String url = (String)propertyValueMap.get("url");
            if (ConnectionPoolStatics.isBlank(url)) {
                url = (String)propertyValueMap.get("URL");
            }
            if (ConnectionPoolStatics.isBlank(url)) {
                url = (String)propertyValueMap.get("jdbcUrl");
            }
            if (ConnectionPoolStatics.isBlank(url)) {
                url = this.jdbcUrl;
            }
            if (ConnectionPoolStatics.isBlank(url)) {
                url = System.getProperty("beecp.url", null);
            }
            if (ConnectionPoolStatics.isBlank(url)) {
                url = System.getProperty("beecp.URL", null);
            }
            if (ConnectionPoolStatics.isBlank(url)) {
                url = System.getProperty("beecp.jdbcUrl", null);
            }
            if (ConnectionPoolStatics.isBlank(userName = (String)propertyValueMap.get("user"))) {
                userName = this.username;
                if (ConnectionPoolStatics.isBlank(userName)) {
                    userName = System.getProperty("beecp.user", null);
                }
                propertyValueMap.put("user", userName);
            }
            if (ConnectionPoolStatics.isBlank(password = (String)propertyValueMap.get("password"))) {
                password = this.password;
                if (ConnectionPoolStatics.isBlank(password)) {
                    password = System.getProperty("beecp.password", null);
                }
                propertyValueMap.put("password", password);
            }
            if (jdbcLinkInfoDecoder != null) {
                if (!ConnectionPoolStatics.isBlank(url)) {
                    url = jdbcLinkInfoDecoder.decodeUrl(url);
                }
                if (!ConnectionPoolStatics.isBlank(userName)) {
                    propertyValueMap.put("user", jdbcLinkInfoDecoder.decodeUsername(userName));
                }
                if (!ConnectionPoolStatics.isBlank(password)) {
                    propertyValueMap.put("password", jdbcLinkInfoDecoder.decodePassword(password));
                }
            }
            if (!ConnectionPoolStatics.isBlank(url)) {
                propertyValueMap.put("url", url);
                propertyValueMap.put("URL", url);
                propertyValueMap.put("jdbcUrl", url);
            }
            ConnectionPoolStatics.setPropertiesValue(factory, propertyValueMap);
            if (factory instanceof RawConnectionFactory || factory instanceof RawXaConnectionFactory) {
                return factory;
            }
            if (factory instanceof XADataSource) {
                return new XaConnectionFactoryByDriverDs((XADataSource)factory, userName, password);
            }
            if (factory instanceof DataSource) {
                return new ConnectionFactoryByDriverDs((DataSource)factory, userName, password);
            }
            throw new BeeDataSourceConfigException("Error connection factory type:" + this.connectionFactoryClassName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeeDataSourceConfigException("Failed to create connection factory by class:" + this.connectionFactoryClassName, e);
        }
    }
}

