/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.config;

import com.github.binarywang.wxpay.config.WxPayHttpProxy;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.v3.auth.AutoUpdateCertificatesVerifier;
import com.github.binarywang.wxpay.v3.auth.PrivateKeySigner;
import com.github.binarywang.wxpay.v3.auth.PublicCertificateVerifier;
import com.github.binarywang.wxpay.v3.auth.Verifier;
import com.github.binarywang.wxpay.v3.auth.WxPayCredentials;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.commons.lang3.StringUtils;

class VerifierBuilder {
    static Verifier build(String certSerialNo, String mchId, String apiV3Key, PrivateKey merchantPrivateKey, WxPayHttpProxy wxPayHttpProxy, int certAutoUpdateTime, String payBaseUrl, String publicKeyId, PublicKey publicKey) throws WxPayException {
        Verifier certificatesVerifier = null;
        Exception ex = null;
        if (merchantPrivateKey != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{certSerialNo, apiV3Key})) {
            try {
                certificatesVerifier = VerifierBuilder.getCertificatesVerifier(certSerialNo, mchId, apiV3Key, merchantPrivateKey, wxPayHttpProxy, certAutoUpdateTime, payBaseUrl);
            }
            catch (Exception e) {
                ex = e;
            }
        }
        if (publicKey != null && StringUtils.isNotBlank((CharSequence)publicKeyId)) {
            try {
                certificatesVerifier = VerifierBuilder.getPublicCertVerifier(publicKeyId, publicKey, certificatesVerifier);
            }
            catch (Exception e) {
                ex = e;
            }
        }
        if (certificatesVerifier != null) {
            return certificatesVerifier;
        }
        if (ex != null) {
            throw new WxPayException(ex.getMessage(), ex);
        }
        return null;
    }

    private static AutoUpdateCertificatesVerifier getCertificatesVerifier(String certSerialNo, String mchId, String apiV3Key, PrivateKey merchantPrivateKey, WxPayHttpProxy wxPayHttpProxy, int certAutoUpdateTime, String payBaseUrl) {
        return new AutoUpdateCertificatesVerifier(new WxPayCredentials(mchId, new PrivateKeySigner(certSerialNo, merchantPrivateKey)), apiV3Key.getBytes(StandardCharsets.UTF_8), certAutoUpdateTime, payBaseUrl, wxPayHttpProxy);
    }

    private static Verifier getPublicCertVerifier(String publicKeyId, PublicKey publicKey, Verifier certificatesVerifier) {
        PublicCertificateVerifier publicCertificatesVerifier = new PublicCertificateVerifier(publicKey, publicKeyId);
        publicCertificatesVerifier.setOtherVerifier(certificatesVerifier);
        certificatesVerifier = publicCertificatesVerifier;
        return certificatesVerifier;
    }

    private VerifierBuilder() {
    }
}

