/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.bank.BankAccountResult;
import com.github.binarywang.wxpay.bean.bank.BankBranchesResult;
import com.github.binarywang.wxpay.bean.bank.BankingResult;
import com.github.binarywang.wxpay.bean.bank.CitiesResult;
import com.github.binarywang.wxpay.bean.bank.ProvincesResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.BankService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

public class BankServiceImpl
implements BankService {
    private final WxPayService payService;
    private static final Gson GSON = new GsonBuilder().create();

    @Override
    public BankAccountResult searchBanksByBankAccount(String accountNumber) throws WxPayException {
        String url = String.format("%s/v3/capital/capitallhh/banks/search-banks-by-bank-account?account_number=%s", this.payService.getPayBaseUrl(), accountNumber);
        String response = this.payService.getV3WithWechatPaySerial(url);
        return (BankAccountResult)GSON.fromJson(response, BankAccountResult.class);
    }

    @Override
    public BankingResult personalBanking(Integer offset, Integer limit) throws WxPayException {
        offset = offset == null ? 0 : offset;
        limit = limit == null ? 200 : limit;
        String url = String.format("%s/v3/capital/capitallhh/banks/personal-banking?offset=%s&limit=%s", this.payService.getPayBaseUrl(), offset, limit);
        String response = this.payService.getV3(url);
        return (BankingResult)GSON.fromJson(response, BankingResult.class);
    }

    @Override
    public BankingResult corporateBanking(Integer offset, Integer limit) throws WxPayException {
        offset = offset == null ? 0 : offset;
        limit = limit == null ? 200 : limit;
        String url = String.format("%s/v3/capital/capitallhh/banks/corporate-banking?offset=%s&limit=%s", this.payService.getPayBaseUrl(), offset, limit);
        String response = this.payService.getV3(url);
        return (BankingResult)GSON.fromJson(response, BankingResult.class);
    }

    @Override
    public ProvincesResult areasProvinces() throws WxPayException {
        String url = String.format("%s/v3/capital/capitallhh/areas/provinces", this.payService.getPayBaseUrl());
        String response = this.payService.getV3WithWechatPaySerial(url);
        return (ProvincesResult)GSON.fromJson(response, ProvincesResult.class);
    }

    @Override
    public CitiesResult areasCities(Integer provinceCode) throws WxPayException {
        String url = String.format("%s/v3/capital/capitallhh/areas/provinces/%s/cities", this.payService.getPayBaseUrl(), provinceCode);
        String response = this.payService.getV3WithWechatPaySerial(url);
        return (CitiesResult)GSON.fromJson(response, CitiesResult.class);
    }

    @Override
    public BankBranchesResult bankBranches(String bankAliasCode, Integer cityCode, Integer offset, Integer limit) throws WxPayException {
        offset = offset == null ? 0 : offset;
        limit = limit == null ? 200 : limit;
        String url = String.format("%s/v3/capital/capitallhh/banks/%s/branches?city_code=%s&offset=%s&limit=%s", this.payService.getPayBaseUrl(), bankAliasCode, cityCode, offset, limit);
        String response = this.payService.getV3(url);
        return (BankBranchesResult)GSON.fromJson(response, BankBranchesResult.class);
    }

    public BankServiceImpl(WxPayService payService) {
        this.payService = payService;
    }
}

