/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.request;

import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@XStreamAlias(value="xml")
public class WxPayRefundQueryRequest
extends BaseWxPayRequest {
    @XStreamAlias(value="device_info")
    private String deviceInfo;
    @XStreamAlias(value="transaction_id")
    private String transactionId;
    @XStreamAlias(value="out_trade_no")
    private String outTradeNo;
    @XStreamAlias(value="out_refund_no")
    private String outRefundNo;
    @XStreamAlias(value="refund_id")
    private String refundId;

    @Override
    protected void checkConstraints() throws WxPayException {
        if (StringUtils.isBlank((CharSequence)this.transactionId) && StringUtils.isBlank((CharSequence)this.outTradeNo) && StringUtils.isBlank((CharSequence)this.outRefundNo) && StringUtils.isBlank((CharSequence)this.refundId) || StringUtils.isNotBlank((CharSequence)this.transactionId) && StringUtils.isNotBlank((CharSequence)this.outTradeNo) && StringUtils.isNotBlank((CharSequence)this.outRefundNo) && StringUtils.isNotBlank((CharSequence)this.refundId)) {
            throw new WxPayException("transactionId\uff0coutRefundNo\uff0ctransactionId\uff0crefundId \u5fc5\u987b\u56db\u9009\u4e00");
        }
    }

    @Override
    protected void storeMap(Map<String, String> map) {
        map.put("device_info", this.deviceInfo);
        map.put("transaction_id", this.transactionId);
        map.put("out_trade_no", this.outTradeNo);
        map.put("out_refund_no", this.outRefundNo);
        map.put("refund_id", this.refundId);
    }

    public static WxPayRefundQueryRequestBuilder newBuilder() {
        return new WxPayRefundQueryRequestBuilder();
    }

    public String getDeviceInfo() {
        return this.deviceInfo;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public String getOutRefundNo() {
        return this.outRefundNo;
    }

    public String getRefundId() {
        return this.refundId;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public void setOutRefundNo(String outRefundNo) {
        this.outRefundNo = outRefundNo;
    }

    public void setRefundId(String refundId) {
        this.refundId = refundId;
    }

    @Override
    public String toString() {
        return "WxPayRefundQueryRequest(deviceInfo=" + this.getDeviceInfo() + ", transactionId=" + this.getTransactionId() + ", outTradeNo=" + this.getOutTradeNo() + ", outRefundNo=" + this.getOutRefundNo() + ", refundId=" + this.getRefundId() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxPayRefundQueryRequest)) {
            return false;
        }
        WxPayRefundQueryRequest other = (WxPayRefundQueryRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$deviceInfo = this.getDeviceInfo();
        String other$deviceInfo = other.getDeviceInfo();
        if (this$deviceInfo == null ? other$deviceInfo != null : !this$deviceInfo.equals(other$deviceInfo)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        String this$outTradeNo = this.getOutTradeNo();
        String other$outTradeNo = other.getOutTradeNo();
        if (this$outTradeNo == null ? other$outTradeNo != null : !this$outTradeNo.equals(other$outTradeNo)) {
            return false;
        }
        String this$outRefundNo = this.getOutRefundNo();
        String other$outRefundNo = other.getOutRefundNo();
        if (this$outRefundNo == null ? other$outRefundNo != null : !this$outRefundNo.equals(other$outRefundNo)) {
            return false;
        }
        String this$refundId = this.getRefundId();
        String other$refundId = other.getRefundId();
        return !(this$refundId == null ? other$refundId != null : !this$refundId.equals(other$refundId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WxPayRefundQueryRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $deviceInfo = this.getDeviceInfo();
        result = result * 59 + ($deviceInfo == null ? 43 : $deviceInfo.hashCode());
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        String $outTradeNo = this.getOutTradeNo();
        result = result * 59 + ($outTradeNo == null ? 43 : $outTradeNo.hashCode());
        String $outRefundNo = this.getOutRefundNo();
        result = result * 59 + ($outRefundNo == null ? 43 : $outRefundNo.hashCode());
        String $refundId = this.getRefundId();
        result = result * 59 + ($refundId == null ? 43 : $refundId.hashCode());
        return result;
    }

    public WxPayRefundQueryRequest() {
    }

    public WxPayRefundQueryRequest(String deviceInfo, String transactionId, String outTradeNo, String outRefundNo, String refundId) {
        this.deviceInfo = deviceInfo;
        this.transactionId = transactionId;
        this.outTradeNo = outTradeNo;
        this.outRefundNo = outRefundNo;
        this.refundId = refundId;
    }

    public static class WxPayRefundQueryRequestBuilder {
        private String deviceInfo;
        private String transactionId;
        private String outTradeNo;
        private String outRefundNo;
        private String refundId;

        WxPayRefundQueryRequestBuilder() {
        }

        public WxPayRefundQueryRequestBuilder deviceInfo(String deviceInfo) {
            this.deviceInfo = deviceInfo;
            return this;
        }

        public WxPayRefundQueryRequestBuilder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public WxPayRefundQueryRequestBuilder outTradeNo(String outTradeNo) {
            this.outTradeNo = outTradeNo;
            return this;
        }

        public WxPayRefundQueryRequestBuilder outRefundNo(String outRefundNo) {
            this.outRefundNo = outRefundNo;
            return this;
        }

        public WxPayRefundQueryRequestBuilder refundId(String refundId) {
            this.refundId = refundId;
            return this;
        }

        public WxPayRefundQueryRequest build() {
            return new WxPayRefundQueryRequest(this.deviceInfo, this.transactionId, this.outTradeNo, this.outRefundNo, this.refundId);
        }

        public String toString() {
            return "WxPayRefundQueryRequest.WxPayRefundQueryRequestBuilder(deviceInfo=" + this.deviceInfo + ", transactionId=" + this.transactionId + ", outTradeNo=" + this.outTradeNo + ", outRefundNo=" + this.outRefundNo + ", refundId=" + this.refundId + ")";
        }
    }
}

