/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.result;

import com.github.binarywang.wxpay.bean.result.enums.TradeTypeEnum;
import com.github.binarywang.wxpay.v3.util.SignUtils;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.security.PrivateKey;

public class CombineTransactionsResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    @SerializedName(value="prepay_id")
    private String prepayId;
    @SerializedName(value="h5_url")
    private String h5Url;
    @SerializedName(value="code_url")
    private String codeUrl;

    public <T> T getPayInfo(TradeTypeEnum tradeType, String appId, String mchId, PrivateKey privateKey) {
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String nonceStr = SignUtils.genRandomStr();
        switch (tradeType) {
            case JSAPI: {
                JsapiResult jsapiResult = new JsapiResult();
                jsapiResult.setAppId(appId).setTimeStamp(timestamp).setPackageValue("prepay_id=" + this.prepayId).setNonceStr(nonceStr).setSignType("RSA").setPaySign(SignUtils.sign(jsapiResult.getSignStr(), privateKey));
                return (T)jsapiResult;
            }
            case H5: {
                return (T)this.h5Url;
            }
            case APP: {
                AppResult appResult = new AppResult();
                appResult.setAppid(appId).setPrepayid(this.prepayId).setPartnerid(mchId).setNoncestr(nonceStr).setTimestamp(timestamp).setPackageValue("Sign=WXPay");
                return (T)appResult;
            }
            case NATIVE: {
                return (T)this.codeUrl;
            }
        }
        return null;
    }

    public String getPrepayId() {
        return this.prepayId;
    }

    public String getH5Url() {
        return this.h5Url;
    }

    public String getCodeUrl() {
        return this.codeUrl;
    }

    public void setPrepayId(String prepayId) {
        this.prepayId = prepayId;
    }

    public void setH5Url(String h5Url) {
        this.h5Url = h5Url;
    }

    public void setCodeUrl(String codeUrl) {
        this.codeUrl = codeUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CombineTransactionsResult)) {
            return false;
        }
        CombineTransactionsResult other = (CombineTransactionsResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$prepayId = this.getPrepayId();
        String other$prepayId = other.getPrepayId();
        if (this$prepayId == null ? other$prepayId != null : !this$prepayId.equals(other$prepayId)) {
            return false;
        }
        String this$h5Url = this.getH5Url();
        String other$h5Url = other.getH5Url();
        if (this$h5Url == null ? other$h5Url != null : !this$h5Url.equals(other$h5Url)) {
            return false;
        }
        String this$codeUrl = this.getCodeUrl();
        String other$codeUrl = other.getCodeUrl();
        return !(this$codeUrl == null ? other$codeUrl != null : !this$codeUrl.equals(other$codeUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CombineTransactionsResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $prepayId = this.getPrepayId();
        result = result * 59 + ($prepayId == null ? 43 : $prepayId.hashCode());
        String $h5Url = this.getH5Url();
        result = result * 59 + ($h5Url == null ? 43 : $h5Url.hashCode());
        String $codeUrl = this.getCodeUrl();
        result = result * 59 + ($codeUrl == null ? 43 : $codeUrl.hashCode());
        return result;
    }

    public String toString() {
        return "CombineTransactionsResult(prepayId=" + this.getPrepayId() + ", h5Url=" + this.getH5Url() + ", codeUrl=" + this.getCodeUrl() + ")";
    }

    public static class AppResult
    implements Serializable {
        private String appid;
        private String partnerid;
        private String prepayid;
        private String packageValue;
        private String noncestr;
        private String timestamp;

        public String getAppid() {
            return this.appid;
        }

        public String getPartnerid() {
            return this.partnerid;
        }

        public String getPrepayid() {
            return this.prepayid;
        }

        public String getPackageValue() {
            return this.packageValue;
        }

        public String getNoncestr() {
            return this.noncestr;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public AppResult setAppid(String appid) {
            this.appid = appid;
            return this;
        }

        public AppResult setPartnerid(String partnerid) {
            this.partnerid = partnerid;
            return this;
        }

        public AppResult setPrepayid(String prepayid) {
            this.prepayid = prepayid;
            return this;
        }

        public AppResult setPackageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public AppResult setNoncestr(String noncestr) {
            this.noncestr = noncestr;
            return this;
        }

        public AppResult setTimestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppResult)) {
                return false;
            }
            AppResult other = (AppResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$appid = this.getAppid();
            String other$appid = other.getAppid();
            if (this$appid == null ? other$appid != null : !this$appid.equals(other$appid)) {
                return false;
            }
            String this$partnerid = this.getPartnerid();
            String other$partnerid = other.getPartnerid();
            if (this$partnerid == null ? other$partnerid != null : !this$partnerid.equals(other$partnerid)) {
                return false;
            }
            String this$prepayid = this.getPrepayid();
            String other$prepayid = other.getPrepayid();
            if (this$prepayid == null ? other$prepayid != null : !this$prepayid.equals(other$prepayid)) {
                return false;
            }
            String this$packageValue = this.getPackageValue();
            String other$packageValue = other.getPackageValue();
            if (this$packageValue == null ? other$packageValue != null : !this$packageValue.equals(other$packageValue)) {
                return false;
            }
            String this$noncestr = this.getNoncestr();
            String other$noncestr = other.getNoncestr();
            if (this$noncestr == null ? other$noncestr != null : !this$noncestr.equals(other$noncestr)) {
                return false;
            }
            String this$timestamp = this.getTimestamp();
            String other$timestamp = other.getTimestamp();
            return !(this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AppResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $appid = this.getAppid();
            result = result * 59 + ($appid == null ? 43 : $appid.hashCode());
            String $partnerid = this.getPartnerid();
            result = result * 59 + ($partnerid == null ? 43 : $partnerid.hashCode());
            String $prepayid = this.getPrepayid();
            result = result * 59 + ($prepayid == null ? 43 : $prepayid.hashCode());
            String $packageValue = this.getPackageValue();
            result = result * 59 + ($packageValue == null ? 43 : $packageValue.hashCode());
            String $noncestr = this.getNoncestr();
            result = result * 59 + ($noncestr == null ? 43 : $noncestr.hashCode());
            String $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
            return result;
        }

        public String toString() {
            return "CombineTransactionsResult.AppResult(appid=" + this.getAppid() + ", partnerid=" + this.getPartnerid() + ", prepayid=" + this.getPrepayid() + ", packageValue=" + this.getPackageValue() + ", noncestr=" + this.getNoncestr() + ", timestamp=" + this.getTimestamp() + ")";
        }
    }

    public static class JsapiResult
    implements Serializable {
        private String appId;
        private String timeStamp;
        private String nonceStr;
        private String packageValue;
        private String signType;
        private String paySign;

        private String getSignStr() {
            return String.format("%s\n%s\n%s\n%s\n", this.appId, this.timeStamp, this.nonceStr, this.packageValue);
        }

        public String getAppId() {
            return this.appId;
        }

        public String getTimeStamp() {
            return this.timeStamp;
        }

        public String getNonceStr() {
            return this.nonceStr;
        }

        public String getPackageValue() {
            return this.packageValue;
        }

        public String getSignType() {
            return this.signType;
        }

        public String getPaySign() {
            return this.paySign;
        }

        public JsapiResult setAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public JsapiResult setTimeStamp(String timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        public JsapiResult setNonceStr(String nonceStr) {
            this.nonceStr = nonceStr;
            return this;
        }

        public JsapiResult setPackageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public JsapiResult setSignType(String signType) {
            this.signType = signType;
            return this;
        }

        public JsapiResult setPaySign(String paySign) {
            this.paySign = paySign;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JsapiResult)) {
                return false;
            }
            JsapiResult other = (JsapiResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$appId = this.getAppId();
            String other$appId = other.getAppId();
            if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
                return false;
            }
            String this$timeStamp = this.getTimeStamp();
            String other$timeStamp = other.getTimeStamp();
            if (this$timeStamp == null ? other$timeStamp != null : !this$timeStamp.equals(other$timeStamp)) {
                return false;
            }
            String this$nonceStr = this.getNonceStr();
            String other$nonceStr = other.getNonceStr();
            if (this$nonceStr == null ? other$nonceStr != null : !this$nonceStr.equals(other$nonceStr)) {
                return false;
            }
            String this$packageValue = this.getPackageValue();
            String other$packageValue = other.getPackageValue();
            if (this$packageValue == null ? other$packageValue != null : !this$packageValue.equals(other$packageValue)) {
                return false;
            }
            String this$signType = this.getSignType();
            String other$signType = other.getSignType();
            if (this$signType == null ? other$signType != null : !this$signType.equals(other$signType)) {
                return false;
            }
            String this$paySign = this.getPaySign();
            String other$paySign = other.getPaySign();
            return !(this$paySign == null ? other$paySign != null : !this$paySign.equals(other$paySign));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JsapiResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $appId = this.getAppId();
            result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
            String $timeStamp = this.getTimeStamp();
            result = result * 59 + ($timeStamp == null ? 43 : $timeStamp.hashCode());
            String $nonceStr = this.getNonceStr();
            result = result * 59 + ($nonceStr == null ? 43 : $nonceStr.hashCode());
            String $packageValue = this.getPackageValue();
            result = result * 59 + ($packageValue == null ? 43 : $packageValue.hashCode());
            String $signType = this.getSignType();
            result = result * 59 + ($signType == null ? 43 : $signType.hashCode());
            String $paySign = this.getPaySign();
            result = result * 59 + ($paySign == null ? 43 : $paySign.hashCode());
            return result;
        }

        public String toString() {
            return "CombineTransactionsResult.JsapiResult(appId=" + this.getAppId() + ", timeStamp=" + this.getTimeStamp() + ", nonceStr=" + this.getNonceStr() + ", packageValue=" + this.getPackageValue() + ", signType=" + this.getSignType() + ", paySign=" + this.getPaySign() + ")";
        }
    }
}

