/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.WxMaShopRegisterService;
import cn.binarywang.wx.miniapp.bean.shop.request.WxMaShopRegisterApplySceneRequest;
import cn.binarywang.wx.miniapp.bean.shop.request.WxMaShopRegisterFinishAccessInfoRequest;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopBaseResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopRegisterCheckResponse;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import com.google.gson.JsonObject;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMaShopRegisterServiceImpl
implements WxMaShopRegisterService {
    private static final Logger log = LoggerFactory.getLogger(WxMaShopRegisterServiceImpl.class);
    private static final String ERR_CODE = "errcode";
    private final WxMaService wxMaService;

    @Override
    public WxMaShopBaseResponse registerApply() throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/register/apply", new JsonObject());
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopBaseResponse.class);
    }

    @Override
    public WxMaShopRegisterCheckResponse registerCheck() throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/register/check", new JsonObject());
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopRegisterCheckResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopRegisterCheckResponse.class);
    }

    @Override
    public WxMaShopBaseResponse registerFinishAccessInfo(WxMaShopRegisterFinishAccessInfoRequest request) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/register/finish_access_info", request);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopBaseResponse.class);
    }

    @Override
    public WxMaShopBaseResponse registerApplyScene(WxMaShopRegisterApplySceneRequest request) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/register/apply_scene", request);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopBaseResponse.class);
    }

    public WxMaShopRegisterServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

