/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http;

import java.io.File;
import java.io.IOException;
import jodd.http.HttpConnectionProvider;
import jodd.http.ProxyInfo;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.ResponseHandler;
import me.chanjar.weixin.common.util.http.apache.ApacheMediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.hc.HttpComponentsMediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.jodd.JoddHttpMediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpMediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import okhttp3.OkHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.HttpHost;

public abstract class BaseMediaDownloadRequestExecutor<H, P>
implements RequestExecutor<File, String> {
    protected RequestHttp<H, P> requestHttp;
    protected File tmpDirFile;

    public BaseMediaDownloadRequestExecutor(RequestHttp<H, P> requestHttp, File tmpDirFile) {
        this.requestHttp = requestHttp;
        this.tmpDirFile = tmpDirFile;
    }

    @Override
    public void execute(String uri, String data, ResponseHandler<File> handler, WxType wxType) throws WxErrorException, IOException {
        handler.handle((File)this.execute(uri, data, wxType));
    }

    public static RequestExecutor<File, String> create(RequestHttp<?, ?> requestHttp, File tmpDirFile) {
        switch (requestHttp.getRequestType()) {
            case APACHE_HTTP: {
                return new ApacheMediaDownloadRequestExecutor(requestHttp, tmpDirFile);
            }
            case JODD_HTTP: {
                return new JoddHttpMediaDownloadRequestExecutor((RequestHttp<HttpConnectionProvider, ProxyInfo>)requestHttp, tmpDirFile);
            }
            case OK_HTTP: {
                return new OkHttpMediaDownloadRequestExecutor((RequestHttp<OkHttpClient, OkHttpProxyInfo>)requestHttp, tmpDirFile);
            }
            case HTTP_COMPONENTS: {
                return new HttpComponentsMediaDownloadRequestExecutor((RequestHttp<CloseableHttpClient, HttpHost>)requestHttp, tmpDirFile);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684http\u6267\u884c\u5668\u7c7b\u578b\uff1a" + (Object)((Object)requestHttp.getRequestType()));
    }
}

