/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.crypto;

import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.util.crypto.ByteGroup;
import me.chanjar.weixin.common.util.crypto.PKCS7Encoder;
import me.chanjar.weixin.common.util.crypto.SHA1;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class WxCryptUtil {
    private static final Base64 BASE64 = new Base64();
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final ThreadLocal<DocumentBuilder> BUILDER_LOCAL = ThreadLocal.withInitial(() -> {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setExpandEntityReferences(false);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException exc) {
            throw new IllegalArgumentException(exc);
        }
    });
    protected byte[] aesKey;
    protected String token;
    protected String appidOrCorpid;

    public WxCryptUtil() {
    }

    public WxCryptUtil(String token, String encodingAesKey, String appidOrCorpid) {
        this.token = token;
        this.appidOrCorpid = appidOrCorpid;
        this.aesKey = Base64.decodeBase64((String)StringUtils.remove((String)encodingAesKey, (String)" "));
    }

    private static String extractEncryptPart(String xml) {
        try {
            DocumentBuilder db = BUILDER_LOCAL.get();
            Document document = db.parse(new InputSource(new StringReader(xml)));
            Element root = document.getDocumentElement();
            return root.getElementsByTagName("Encrypt").item(0).getTextContent();
        }
        catch (Exception e) {
            throw new WxRuntimeException(e);
        }
    }

    private static byte[] number2BytesInNetworkOrder(int number) {
        byte[] orderBytes = new byte[4];
        orderBytes[3] = (byte)(number & 0xFF);
        orderBytes[2] = (byte)(number >> 8 & 0xFF);
        orderBytes[1] = (byte)(number >> 16 & 0xFF);
        orderBytes[0] = (byte)(number >> 24 & 0xFF);
        return orderBytes;
    }

    private static int bytesNetworkOrder2Number(byte[] bytesInNetworkOrder) {
        int sourceNumber = 0;
        for (int i = 0; i < 4; ++i) {
            sourceNumber <<= 8;
            sourceNumber |= bytesInNetworkOrder[i] & 0xFF;
        }
        return sourceNumber;
    }

    private static String genRandomStr() {
        String base = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    private static String generateXml(String encrypt, String signature, String timestamp, String nonce) {
        String format = "<xml>\n<Encrypt><![CDATA[%1$s]]></Encrypt>\n<MsgSignature><![CDATA[%2$s]]></MsgSignature>\n<TimeStamp>%3$s</TimeStamp>\n<Nonce><![CDATA[%4$s]]></Nonce>\n</xml>";
        return String.format(format, encrypt, signature, timestamp, nonce);
    }

    public String encrypt(String plainText) {
        String encryptedXml = this.encrypt(WxCryptUtil.genRandomStr(), plainText);
        String timeStamp = Long.toString(System.currentTimeMillis() / 1000L);
        String nonce = WxCryptUtil.genRandomStr();
        String signature = SHA1.gen(this.token, timeStamp, nonce, encryptedXml);
        return WxCryptUtil.generateXml(encryptedXml, signature, timeStamp, nonce);
    }

    public EncryptContext encryptContext(String plainText) {
        String encryptedXml = this.encrypt(WxCryptUtil.genRandomStr(), plainText);
        String timeStamp = Long.toString(System.currentTimeMillis() / 1000L);
        String nonce = WxCryptUtil.genRandomStr();
        String signature = SHA1.gen(this.token, timeStamp, nonce, encryptedXml);
        return new EncryptContext(encryptedXml, signature, timeStamp, nonce);
    }

    public String encrypt(String randomStr, String plainText) {
        ByteGroup byteCollector = new ByteGroup();
        byte[] randomStringBytes = randomStr.getBytes(CHARSET);
        byte[] plainTextBytes = plainText.getBytes(CHARSET);
        byte[] bytesOfSizeInNetworkOrder = WxCryptUtil.number2BytesInNetworkOrder(plainTextBytes.length);
        byte[] appIdBytes = this.appidOrCorpid.getBytes(CHARSET);
        byteCollector.addBytes(randomStringBytes);
        byteCollector.addBytes(bytesOfSizeInNetworkOrder);
        byteCollector.addBytes(plainTextBytes);
        byteCollector.addBytes(appIdBytes);
        byte[] padBytes = PKCS7Encoder.encode(byteCollector.size());
        byteCollector.addBytes(padBytes);
        byte[] unencrypted = byteCollector.toBytes();
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.aesKey, 0, 16);
            cipher.init(1, (Key)keySpec, iv);
            byte[] encrypted = cipher.doFinal(unencrypted);
            return BASE64.encodeToString(encrypted);
        }
        catch (Exception e) {
            throw new WxRuntimeException(e);
        }
    }

    public String decryptXml(String msgSignature, String timeStamp, String nonce, String encryptedXml) {
        String cipherText = WxCryptUtil.extractEncryptPart(encryptedXml);
        return this.decryptContent(msgSignature, timeStamp, nonce, cipherText);
    }

    @Deprecated
    public String decrypt(String msgSignature, String timeStamp, String nonce, String encryptedXml) {
        return this.decryptXml(msgSignature, timeStamp, nonce, encryptedXml);
    }

    public String decryptContent(String msgSignature, String timeStamp, String nonce, String encryptedContent) {
        String signature = SHA1.gen(this.token, timeStamp, nonce, encryptedContent);
        if (!signature.equals(msgSignature)) {
            throw new WxRuntimeException("\u52a0\u5bc6\u6d88\u606f\u7b7e\u540d\u6821\u9a8c\u5931\u8d25");
        }
        return this.decrypt(encryptedContent);
    }

    public String decrypt(String cipherText) {
        String xmlContent;
        byte[] original;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(this.aesKey, 0, 16));
            cipher.init(2, (Key)keySpec, iv);
            byte[] encrypted = Base64.decodeBase64((String)cipherText);
            original = cipher.doFinal(encrypted);
        }
        catch (Exception e) {
            throw new WxRuntimeException(e);
        }
        try {
            byte[] bytes = PKCS7Encoder.decode(original);
            byte[] networkOrder = Arrays.copyOfRange(bytes, 16, 20);
            int xmlLength = WxCryptUtil.bytesNetworkOrder2Number(networkOrder);
            xmlContent = new String(Arrays.copyOfRange(bytes, 20, 20 + xmlLength), CHARSET);
            String fromAppid = new String(Arrays.copyOfRange(bytes, 20 + xmlLength, bytes.length), CHARSET);
        }
        catch (Exception e) {
            throw new WxRuntimeException(e);
        }
        return xmlContent;
    }

    public static class EncryptContext {
        private String encrypt;
        private String signature;
        private String timeStamp;
        private String nonce;

        public String getEncrypt() {
            return this.encrypt;
        }

        public String getSignature() {
            return this.signature;
        }

        public String getTimeStamp() {
            return this.timeStamp;
        }

        public String getNonce() {
            return this.nonce;
        }

        public void setEncrypt(String encrypt) {
            this.encrypt = encrypt;
        }

        public void setSignature(String signature) {
            this.signature = signature;
        }

        public void setTimeStamp(String timeStamp) {
            this.timeStamp = timeStamp;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EncryptContext)) {
                return false;
            }
            EncryptContext other = (EncryptContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$encrypt = this.getEncrypt();
            String other$encrypt = other.getEncrypt();
            if (this$encrypt == null ? other$encrypt != null : !this$encrypt.equals(other$encrypt)) {
                return false;
            }
            String this$signature = this.getSignature();
            String other$signature = other.getSignature();
            if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
                return false;
            }
            String this$timeStamp = this.getTimeStamp();
            String other$timeStamp = other.getTimeStamp();
            if (this$timeStamp == null ? other$timeStamp != null : !this$timeStamp.equals(other$timeStamp)) {
                return false;
            }
            String this$nonce = this.getNonce();
            String other$nonce = other.getNonce();
            return !(this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EncryptContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $encrypt = this.getEncrypt();
            result = result * 59 + ($encrypt == null ? 43 : $encrypt.hashCode());
            String $signature = this.getSignature();
            result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
            String $timeStamp = this.getTimeStamp();
            result = result * 59 + ($timeStamp == null ? 43 : $timeStamp.hashCode());
            String $nonce = this.getNonce();
            result = result * 59 + ($nonce == null ? 43 : $nonce.hashCode());
            return result;
        }

        public String toString() {
            return "WxCryptUtil.EncryptContext(encrypt=" + this.getEncrypt() + ", signature=" + this.getSignature() + ", timeStamp=" + this.getTimeStamp() + ", nonce=" + this.getNonce() + ")";
        }

        public EncryptContext(String encrypt, String signature, String timeStamp, String nonce) {
            this.encrypt = encrypt;
            this.signature = signature;
            this.timeStamp = timeStamp;
            this.nonce = nonce;
        }
    }
}

