/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.api;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import me.chanjar.weixin.common.api.WxMessageDuplicateChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMessageInMemoryDuplicateCheckerSingleton
implements WxMessageDuplicateChecker {
    private static final Logger log = LoggerFactory.getLogger(WxMessageInMemoryDuplicateCheckerSingleton.class);
    private static final Long TIME_TO_LIVE = 15L;
    private static final Long CLEAR_PERIOD = 5L;
    private static final ScheduledThreadPoolExecutor SCHEDULED_THREAD_POOL_EXECUTOR = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("wxMessage-memory-pool-%d").build(), new ThreadPoolExecutor.AbortPolicy());
    private static final ConcurrentHashMap<String, Long> MSG_ID_2_TIMESTAMP = new ConcurrentHashMap();

    private WxMessageInMemoryDuplicateCheckerSingleton() {
    }

    public static WxMessageInMemoryDuplicateCheckerSingleton getInstance() {
        return WxMessageInnerClass.CHECKER_SINGLETON;
    }

    @Override
    public boolean isDuplicate(String messageId) {
        if (messageId == null) {
            return false;
        }
        Long timestamp = MSG_ID_2_TIMESTAMP.putIfAbsent(messageId, System.currentTimeMillis());
        return timestamp != null;
    }

    static {
        SCHEDULED_THREAD_POOL_EXECUTOR.scheduleAtFixedRate(() -> {
            try {
                Long now = System.currentTimeMillis();
                MSG_ID_2_TIMESTAMP.entrySet().removeIf(entry -> now - (Long)entry.getValue() > TIME_TO_LIVE * 1000L);
            }
            catch (Exception ex) {
                log.error("\u91cd\u590d\u6d88\u606f\u53bb\u91cd\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38", (Throwable)ex);
            }
        }, 1L, CLEAR_PERIOD, TimeUnit.SECONDS);
    }

    private static class WxMessageInnerClass {
        static final WxMessageInMemoryDuplicateCheckerSingleton CHECKER_SINGLETON = new WxMessageInMemoryDuplicateCheckerSingleton();

        private WxMessageInnerClass() {
        }
    }
}

