/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http;

import java.io.File;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.apache.ApacheMediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.jodd.JoddHttpMediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpMediaDownloadRequestExecutor;

public abstract class BaseMediaDownloadRequestExecutor<H, P>
implements RequestExecutor<File, String> {
    protected RequestHttp<H, P> requestHttp;
    protected File tmpDirFile;

    public BaseMediaDownloadRequestExecutor(RequestHttp<H, P> requestHttp, File tmpDirFile) {
        this.requestHttp = requestHttp;
        this.tmpDirFile = tmpDirFile;
    }

    public static RequestExecutor<File, String> create(RequestHttp requestHttp, File tmpDirFile) {
        switch (requestHttp.getRequestType()) {
            case APACHE_HTTP: {
                return new ApacheMediaDownloadRequestExecutor(requestHttp, tmpDirFile);
            }
            case JODD_HTTP: {
                return new JoddHttpMediaDownloadRequestExecutor(requestHttp, tmpDirFile);
            }
            case OK_HTTP: {
                return new OkHttpMediaDownloadRequestExecutor(requestHttp, tmpDirFile);
            }
        }
        return null;
    }
}

