/*
 * Decompiled with CFR 0.152.
 */
package com.github.missthee.tool.excel.template;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class CellFomatter {
    private static final int FONT_WIDTH = 256;

    public static void setRegionStyle(Sheet sheet, CellRangeAddress region, CellStyle cs) {
        for (int rowIndex = region.getFirstRow(); rowIndex <= region.getLastRow(); ++rowIndex) {
            Row row = sheet.getRow(rowIndex);
            if (row == null) {
                row = sheet.createRow(rowIndex);
            }
            for (int columnIndex = region.getFirstColumn(); columnIndex <= region.getLastColumn(); ++columnIndex) {
                Cell cell = row.getCell(columnIndex);
                if (cell == null) {
                    cell = row.createCell(columnIndex);
                }
                cell.setCellStyle(cs);
            }
        }
    }

    public static void setColumnAdaptiveWidth(Sheet sheet, Cell cell, boolean useMaxWidth) {
        int columnIndex = cell.getAddress().getColumn();
        int rowIndex = cell.getAddress().getRow();
        int regionWidth = 1;
        for (CellRangeAddress cellRangeAddress : sheet.getMergedRegions()) {
            if (!cellRangeAddress.containsColumn(columnIndex) || !cellRangeAddress.containsRow(rowIndex)) continue;
            regionWidth += cellRangeAddress.getLastColumn() - cellRangeAddress.getFirstColumn();
        }
        String value = CellFomatter.getCellValueToString(cell);
        if (value != null) {
            int codeCount = 0;
            for (int i = 0; i < value.length(); ++i) {
                String tempStr = value.substring(i, i + 1);
                char litter = tempStr.toCharArray()[0];
                if (litter > 'A' && litter <= 'Z') {
                    codeCount += 2;
                    continue;
                }
                codeCount += Math.min(tempStr.getBytes().length, 2);
            }
            int fontWidth = 266;
            int sheetWidth = useMaxWidth ? Math.max(sheet.getColumnWidth(columnIndex), codeCount * fontWidth) : codeCount * fontWidth;
            for (int i = 0; i < regionWidth; ++i) {
                int avgWidth = Math.max(sheetWidth, 1024) / regionWidth;
                int finalWidth = Math.max(sheet.getColumnWidth(columnIndex + i), avgWidth);
                sheet.setColumnWidth(columnIndex + i, finalWidth);
            }
        }
    }

    private static String getCellValueToString(Cell cell) {
        String value = null;
        CellType cellTypeEnumTemp = cell.getCellTypeEnum();
        switch (cellTypeEnumTemp) {
            case STRING: {
                value = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                value = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case NUMERIC: {
                value = String.valueOf(cell.getNumericCellValue());
                break;
            }
        }
        if (value == null || "null".equals(value)) {
            value = null;
        }
        return value;
    }
}

