/*
 * Decompiled with CFR 0.152.
 */
package com.github.missthee.tool.excel.imports;

import com.github.missthee.tool.excel.template.SimpleCell;
import com.github.missthee.tool.excel.template.TemplateTool;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Scanner;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelReadTool {
    public static void main(String[] args) {
        ExcelReadTool.readExcel();
    }

    public static void readExcel() {
        try {
            Scanner scanner = new Scanner(System.in);
            System.out.println("\u8f93\u5165excel\u6587\u4ef6\u5730\u5740\uff08.xls\uff09:");
            String filePath = scanner.next();
            System.out.println("\u751f\u6210\u7ed3\u679c\u662f\u5426\u9700\u8981\u4f4d\u79fb\uff1f\uff08y/n\uff09:");
            String isNeedMove = scanner.next();
            int fixX = 0;
            int fixY = 0;
            if ("y".equals(isNeedMove.toLowerCase())) {
                System.out.println("X\u504f\u79fb\u6570:");
                fixX = scanner.nextInt();
                System.out.println("Y\u504f\u79fb\u6570:");
                fixY = scanner.nextInt();
            }
            ExcelReadTool.excelToDataColumn(WorkbookFactory.create((File)new File(filePath)), fixX, fixY, true, true);
        }
        catch (IOException | InvalidFormatException e) {
            e.printStackTrace();
        }
    }

    public static String excelToDataColumn(Workbook wb, int fixX, int fixY, boolean needPrintToConsole, boolean needPasteToClipBoard) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("//generate code start\r\n");
        Iterator sheetIterator = wb.sheetIterator();
        int sheetIndex = 0;
        for (Sheet sheet : wb) {
            stringBuilder.append("//Sheet" + sheetIndex++ + "\r\n");
            Iterator rowIterator = sheet.rowIterator();
            int rowIndex = 0;
            for (Row row : sheet) {
                stringBuilder.append("//Sheet" + sheetIndex + ", Row" + rowIndex++ + "\r\n");
                for (Cell cell : row) {
                    SimpleCell cellInfo = TemplateTool.getSimpleCellInfo(sheet, cell);
                    if (cellInfo.getValue() == null || cellInfo.getX() + fixX < 0 || cellInfo.getY() + fixY < 0) continue;
                    stringBuilder.append("add(new " + SimpleCell.class.getSimpleName() + "(\"" + cellInfo.getValue() + "\"," + (cellInfo.getX() + fixX) + "," + (cellInfo.getY() + fixY) + "," + cellInfo.getW() + "," + cellInfo.getH() + "));\r\n");
                }
            }
        }
        stringBuilder.append("//generate code end\r\n");
        String str = stringBuilder.toString();
        if (needPrintToConsole) {
            System.out.println(str);
        }
        if (needPasteToClipBoard) {
            ExcelReadTool.pasteToClipBoard(str);
        }
        return stringBuilder.toString();
    }

    private static void pasteToClipBoard(String str) {
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        clip.setContents(new StringSelection(str), null);
        System.out.println("\u3010\u5df2\u590d\u5236\u5230\u526a\u8d34\u677f\u3011");
    }
}

