/*
 * Decompiled with CFR 0.152.
 */
package com.github.missthee.tool.excel.exports.direct;

import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class DefaultStyle {
    public static CellStyle titleStyle(Workbook wb) {
        CellStyle style = DefaultStyle.commonStyleBuilder(wb, false);
        Font font = wb.createFont();
        font.setFontHeightInPoints((short)12);
        font.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        font.setBold(true);
        style.setFont(font);
        return style;
    }

    public static CellStyle headerStyle(Workbook wb) {
        CellStyle style = DefaultStyle.commonStyleBuilder(wb, true);
        Font font = wb.createFont();
        font.setFontHeightInPoints((short)10);
        font.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        font.setBold(true);
        style.setFont(font);
        return style;
    }

    public static CellStyle dataStyle(Workbook wb) {
        CellStyle style = DefaultStyle.commonStyleBuilder(wb, true);
        Font font = wb.createFont();
        font.setFontHeightInPoints((short)10);
        font.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        style.setFont(font);
        return style;
    }

    private static CellStyle commonStyleBuilder(Workbook wb, boolean hasBorder) {
        CellStyle style = wb.createCellStyle();
        if (hasBorder) {
            style.setBorderTop(BorderStyle.THIN);
            style.setBorderBottom(BorderStyle.THIN);
            style.setBorderLeft(BorderStyle.THIN);
            style.setBorderRight(BorderStyle.THIN);
        }
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return style;
    }
}

