/*
 * Decompiled with CFR 0.152.
 */
package com.reger.dubbo.rpc.filter;

import com.alibaba.dubbo.common.utils.ConcurrentHashSet;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcResult;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static final String TRANSFORM_EXCEPTION_MESSAGE = "REGER.DUBBO.RPC.TRANSFORM_EXCEPTION_MESSAGE";
    private static final Set<Class<? extends Throwable>> exceptions = new ConcurrentHashSet();

    public static final void register(Class<? extends Throwable> claz) {
        exceptions.add(claz);
    }

    protected static final Result decodeException(Result relust) {
        Throwable throwable;
        if (relust != null && relust.hasException() && (throwable = relust.getException()).getClass().equals(Exception.class) && TRANSFORM_EXCEPTION_MESSAGE.equals(throwable.getMessage()) && (throwable = throwable.getCause()) != null) {
            log.debug("\u88ab\u5305\u88c5\u7684\u5f02\u5e38{}\uff0c\u89e3\u5f00\u5305\u88c5...", throwable.getClass());
            return new RpcResult(throwable);
        }
        return relust;
    }

    protected static final Result encoderException(Result relust) {
        Throwable throwable;
        if (relust != null && relust.hasException() && exceptions.contains((throwable = relust.getException()).getClass())) {
            log.debug("{}\u5f02\u5e38\u88ab\u8f6c\u5316\u4e3aException\u8f93\u51fa\uff0c\u7528\u6765\u901a\u7528\u5f02\u5e38\u5904\u7406....", throwable.getClass());
            return new RpcResult((Throwable)new Exception(TRANSFORM_EXCEPTION_MESSAGE, throwable));
        }
        return relust;
    }
}

