/*
 * Decompiled with CFR 0.152.
 */
package com.reger.dubbo.config;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ConsumerConfig;
import com.alibaba.dubbo.config.ModuleConfig;
import com.alibaba.dubbo.config.MonitorConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.ProviderConfig;
import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.config.ServiceConfig;
import com.alibaba.dubbo.config.spring.ServiceBean;
import com.reger.dubbo.config.AnnotationBean;
import com.reger.dubbo.properties.DubboProperties;
import com.reger.dubbo.rpc.filter.ConsumerFilter;
import com.reger.dubbo.rpc.filter.ConsumerFilterBean;
import com.reger.dubbo.rpc.filter.ProviderFilter;
import com.reger.dubbo.rpc.filter.ProviderFilterBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.SocketUtils;
import org.springframework.util.StringUtils;

@Configuration
public class DubboAutoConfiguration
extends AnnotationBean
implements EnvironmentAware,
ApplicationContextAware,
InitializingBean,
BeanPostProcessor,
CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(DubboAutoConfiguration.class);
    private static final long serialVersionUID = 1L;
    private Environment environment;
    private ApplicationContext applicationContext;

    private DubboProperties getDubboProperties() {
        DubboProperties existingValue = (DubboProperties)Binder.get((Environment)this.environment).bind("spring.dubbo", DubboProperties.class).get();
        return existingValue;
    }

    @Override
    public void setEnvironment(Environment environment) {
        super.setEnvironment(environment);
        this.environment = environment;
    }

    private List<ProtocolConfig> getProtocols(DubboProperties dubboProperties) {
        List<ProtocolConfig> protocols = dubboProperties.getProtocols();
        if (protocols == null) {
            protocols = new ArrayList<ProtocolConfig>();
        }
        if (dubboProperties.getProtocol() != null) {
            protocols.add(dubboProperties.getProtocol());
        }
        return protocols;
    }

    private List<RegistryConfig> getRegistrys(DubboProperties dubboProperties) {
        List<RegistryConfig> registryConfigs = dubboProperties.getRegistrys();
        if (registryConfigs == null) {
            registryConfigs = new ArrayList<RegistryConfig>();
        }
        if (dubboProperties.getRegistry() != null) {
            registryConfigs.add(dubboProperties.getRegistry());
        }
        return registryConfigs;
    }

    private List<RegistryConfig> getRegistry(List<RegistryConfig> registrys, String environmentName) {
        String value = this.environment.getProperty(environmentName);
        if (StringUtils.isEmpty((Object)value)) {
            return null;
        }
        String[] vals = value.split(",");
        ArrayList<RegistryConfig> ret = new ArrayList<RegistryConfig>();
        for (String val : vals) {
            for (RegistryConfig registryConfig : registrys) {
                if (!val.trim().equals(registryConfig.getId())) continue;
                ret.add(registryConfig);
            }
        }
        return ret;
    }

    private List<ProtocolConfig> getProtocol(List<ProtocolConfig> protocols, String environmentName) {
        String value = this.environment.getProperty(environmentName);
        if (StringUtils.isEmpty((Object)value)) {
            return protocols;
        }
        String[] vals = value.split(",");
        ArrayList<ProtocolConfig> ret = new ArrayList<ProtocolConfig>();
        for (String val : vals) {
            for (ProtocolConfig protocolConfig : protocols) {
                if (!val.trim().equals(protocolConfig.getId())) continue;
                ret.add(protocolConfig);
            }
        }
        return ret;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        super.exportServiceBean(bean, beanName);
        return bean;
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        DubboProperties dubboProperties = this.getDubboProperties();
        ApplicationConfig application = dubboProperties.getApplication();
        MonitorConfig monitor = dubboProperties.getMonitor();
        ModuleConfig module = dubboProperties.getModule();
        ProviderConfig provider = dubboProperties.getProvider();
        ConsumerConfig consumer = dubboProperties.getConsumer();
        List<ProtocolConfig> protocols = this.getProtocols(dubboProperties);
        List<RegistryConfig> registryConfigs = this.getRegistrys(dubboProperties);
        List<ReferenceConfig<?>> references = dubboProperties.getReferences();
        List<ServiceConfig<?>> services = dubboProperties.getServices();
        this.registerRegistry(registryConfigs, beanFactory);
        String basePackage = dubboProperties.getBasePackage();
        if (provider != null) {
            provider.setProtocols(this.getProtocol(protocols, "spring.dubbo.provider.protocol"));
            provider.setRegistries(this.getRegistry(registryConfigs, "spring.dubbo.provider.registry"));
        }
        if (consumer != null) {
            consumer.setRegistries(this.getRegistry(registryConfigs, "spring.dubbo.consumer.registry"));
        }
        this.registerThis(basePackage, beanFactory);
        this.registerApplication(application, beanFactory);
        this.registerProtocols(protocols, beanFactory);
        this.registerMonitor(monitor, beanFactory);
        this.registerModule(module, beanFactory);
        this.registerProvider(provider, beanFactory);
        this.registerConsumer(consumer, beanFactory);
        this.registerReferences(references, beanFactory);
        this.registerServices(services, beanFactory);
        super.postProcessBeanFactory(beanFactory);
        super.postProcessAnnotationPackageService();
    }

    private void registerConsumer(ConsumerConfig consumer, ConfigurableListableBeanFactory beanFactory) {
        if (consumer != null) {
            String filter;
            String beanName = consumer.getId();
            if (StringUtils.isEmpty((Object)beanName)) {
                beanName = "consumerConfig";
            }
            filter = StringUtils.isEmpty((Object)(filter = consumer.getFilter())) ? "regerConsumerFilter" : filter.trim() + ",regerConsumerFilter";
            logger.debug("\u6dfb\u52a0consumerFilter\u540e\u7684Filter, {}", (Object)filter);
            consumer.setFilter(filter);
            beanFactory.registerSingleton(beanName, (Object)consumer);
        } else {
            logger.debug("dubbo \u6ca1\u6709\u914d\u7f6e\u9ed8\u8ba4\u7684\u6d88\u8d39\u8005\u53c2\u6570");
        }
    }

    private void registerProvider(ProviderConfig provider, ConfigurableListableBeanFactory beanFactory) {
        if (provider != null) {
            String filter;
            String beanName = provider.getId();
            if (StringUtils.isEmpty((Object)beanName)) {
                beanName = "providerConfig";
            }
            filter = StringUtils.isEmpty((Object)(filter = provider.getFilter())) ? "regerProviderFilter" : filter.trim() + ",regerProviderFilter";
            logger.debug("\u6dfb\u52a0consumerFilter\u540e\u7684Filter, {}", (Object)filter);
            provider.setFilter(filter);
            beanFactory.registerSingleton(beanName, (Object)provider);
        } else {
            logger.debug("dubbo \u6ca1\u6709\u914d\u7f6e\u9ed8\u8ba4\u7684\u751f\u6210\u8005\u53c2\u6570");
        }
    }

    private void registerModule(ModuleConfig module, ConfigurableListableBeanFactory beanFactory) {
        if (module != null) {
            String beanName = module.getId();
            if (StringUtils.isEmpty((Object)beanName)) {
                beanName = "moduleConfig";
            }
            beanFactory.registerSingleton(beanName, (Object)module);
        } else {
            logger.debug("dubbo \u6ca1\u6709\u914d\u7f6e\u6a21\u5757\u4fe1\u606f");
        }
    }

    private void registerReferences(List<ReferenceConfig<?>> references, ConfigurableListableBeanFactory beanFactory) {
        if (references == null || references.isEmpty()) {
            return;
        }
        for (int index = 0; index < references.size(); ++index) {
            ReferenceConfig<?> referenceConfig = references.get(index);
            String beanName = referenceConfig.getId();
            if (StringUtils.isEmpty((Object)beanName)) {
                beanName = "referenceConfig" + index;
            }
            beanFactory.registerSingleton(beanName, referenceConfig);
            beanFactory.registerSingleton(beanName, referenceConfig.get());
            logger.debug("\u6ce8\u518c\u670d\u52a1\u8c03\u7528\u4fe1\u606f{} \u5b8c\u6bd5", (Object)beanName);
        }
    }

    private void registerServices(List<ServiceConfig<?>> services, ConfigurableListableBeanFactory beanFactory) {
        if (services == null || services.isEmpty()) {
            return;
        }
        for (int index = 0; index < services.size(); ++index) {
            ServiceConfig<?> serviceConfig = services.get(index);
            String beanName = serviceConfig.getId();
            if (StringUtils.isEmpty((Object)beanName)) {
                beanName = "serviceConfig" + index;
            }
            beanFactory.registerSingleton(beanName, serviceConfig);
            serviceConfig.export();
            logger.debug("\u6ce8\u518c\u53d1\u5e03\u670d\u52a1{} \u5b8c\u6bd5", (Object)beanName);
        }
    }

    private void registerMonitor(MonitorConfig monitorConfig, ConfigurableListableBeanFactory beanFactory) {
        if (monitorConfig != null) {
            String beanName = monitorConfig.getId();
            if (StringUtils.isEmpty((Object)beanName)) {
                beanName = "monitorConfig";
            }
            beanFactory.registerSingleton(beanName, (Object)monitorConfig);
        } else {
            logger.debug("dubbo \u6ca1\u6709\u914d\u7f6e\u670d\u52a1\u76d1\u63a7\u4e2d\u5fc3");
        }
    }

    private void registerRegistry(List<RegistryConfig> registryConfigs, ConfigurableListableBeanFactory beanFactory) {
        if (registryConfigs == null || registryConfigs.isEmpty()) {
            logger.warn("dubbo \u6ca1\u6709\u914d\u7f6e\u670d\u52a1\u6ce8\u518c\u4e2d\u5fc3");
        } else {
            for (int index = 0; index < registryConfigs.size(); ++index) {
                RegistryConfig registryConfig = registryConfigs.get(index);
                String beanName = registryConfig.getId();
                if (StringUtils.isEmpty((Object)beanName)) {
                    beanName = "registryConfig-" + index;
                }
                beanFactory.registerSingleton(beanName, (Object)registryConfig);
            }
        }
    }

    private void registerThis(String basePackages, ConfigurableListableBeanFactory beanFactory) {
        super.setId("dubboBasePackages");
        if (!StringUtils.isEmpty((Object)basePackages)) {
            logger.info("dubbo\u5f00\u59cb\u626b\u63cf: {}", (Object)basePackages);
        }
        this.setPackage(basePackages);
    }

    private void registerApplication(ApplicationConfig applicationConfig, ConfigurableListableBeanFactory beanFactory) {
        if (applicationConfig != null) {
            String name = applicationConfig.getId();
            if (StringUtils.isEmpty((Object)name)) {
                name = "application";
            }
            beanFactory.registerSingleton(name, (Object)applicationConfig);
        } else {
            logger.warn("dubbo \u6ca1\u6709\u914d\u7f6e\u670d\u52a1\u540d\u4fe1\u606f");
        }
    }

    private void registerProtocols(List<ProtocolConfig> protocols, ConfigurableListableBeanFactory beanFactory) {
        if (protocols == null || protocols.isEmpty()) {
            logger.info("dubbo \u6ca1\u6709\u914d\u7f6e\u534f\u8bae,\u5c06\u4f7f\u7528\u9ed8\u8ba4\u534f\u8bae");
            return;
        }
        for (int index = 0; index < protocols.size(); ++index) {
            ProtocolConfig protocol = protocols.get(index);
            String beanName = protocol.getId();
            if (StringUtils.hasText((String)protocol.getId())) {
                beanName = protocol.getId();
            } else if (StringUtils.hasText((String)protocol.getName())) {
                beanName = protocol.getName();
                protocol.setId(beanName);
            } else {
                beanName = "dubbo";
                protocol.setName(beanName);
                protocol.setId(beanName);
            }
            if (protocol.getPort() == null || protocol.getPort() == 0) {
                protocol.setPort(Integer.valueOf(SocketUtils.findAvailableTcpPort((int)53600, (int)53688)));
            }
            beanFactory.registerSingleton(beanName, (Object)protocol);
            logger.debug("\u6ce8\u518c\u534f\u8bae\u4fe1\u606f{}\u5b8c\u6bd5", (Object)beanName);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            Map consumerFilters = this.applicationContext.getBeansOfType(ConsumerFilter.class);
            ConsumerFilterBean.setConsumerFilter(consumerFilters);
        }
        catch (NoSuchBeanDefinitionException e) {
            logger.debug("\u6ca1\u6709ConsumerFilter");
        }
        try {
            Map providerFilters = this.applicationContext.getBeansOfType(ProviderFilter.class);
            ProviderFilterBean.setProviderFilter(providerFilters);
        }
        catch (NoSuchBeanDefinitionException e) {
            logger.debug("\u6ca1\u6709ProviderFilter");
        }
    }

    public void run(String ... args) throws Exception {
        try {
            Map sbs = this.applicationContext.getBeansOfType(ServiceBean.class);
            if (!sbs.isEmpty()) {
                logger.info("\u670d\u52a1\u63d0\u4f9b\u8005\u5bfc\u51fa\u5b8c\u6bd5,\u5171\u5bfc\u51fa{}\u4e2a\u7c7b\u5b9e\u4f8b\uff01", (Object)sbs.size());
            }
        }
        catch (Exception e) {
            logger.warn("\u670d\u52a1\u63d0\u4f9b\u8005\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
        }
    }
}

