/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.util.sceneInspection;

import cn.smarthse.core.framework.enums.BusinessStage;
import cn.smarthse.core.framework.enums.OccupationHealthInspectionType;
import java.text.SimpleDateFormat;
import java.util.Date;

public class OccupationHealthInspectionUtil {
    public final boolean IS_OPEN_WORK_FLOW = true;

    private OccupationHealthInspectionUtil() {
    }

    public static final OccupationHealthInspectionUtil getInstance() {
        return LazyHolder.INSTANCE;
    }

    public String getInspectionSn() {
        String inspectionSnPrefix = "JCWS";
        StringBuilder inspectionSn = new StringBuilder(inspectionSnPrefix);
        inspectionSn.append(this.getNum());
        return inspectionSn.toString();
    }

    private String getNum() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return sdf.format(new Date());
    }

    public String getInformSn() {
        String informSnPrefix = "JCWSTZ";
        StringBuilder informSn = new StringBuilder(informSnPrefix);
        informSn.append(this.getNum());
        return informSn.toString();
    }

    public String getReformInformSn() {
        String informSnPrefix = "ZGTZ";
        StringBuilder informSn = new StringBuilder(informSnPrefix);
        informSn.append(this.getNum());
        return informSn.toString();
    }

    public String getInformSnDailyScene() {
        String informSnPrefix = "RCJCTZ";
        StringBuilder informSn = new StringBuilder(informSnPrefix);
        informSn.append(this.getNum());
        return informSn.toString();
    }

    public String getSummarySnManager(Byte inspectionType) {
        String summarySnPrefix = null;
        summarySnPrefix = inspectionType != null && inspectionType.equals(OccupationHealthInspectionType.dailyScene.getValue()) ? "RCJCHZ" : "JCWSHZ";
        StringBuilder summarySn = new StringBuilder(summarySnPrefix);
        summarySn.append(this.getNum());
        return summarySn.toString();
    }

    public String getSummarySnCollaborator(Byte inspectionType) {
        String summarySnPrefix = null;
        summarySnPrefix = inspectionType != null && inspectionType.equals(OccupationHealthInspectionType.dailyScene.getValue()) ? "RCJCJL" : "JCWSJL";
        StringBuilder summarySn = new StringBuilder(summarySnPrefix);
        summarySn.append(this.getNum());
        return summarySn.toString();
    }

    public String getDailySceneSn() {
        String snPrefix = "RCJC";
        StringBuilder sn = new StringBuilder(snPrefix);
        sn.append(this.getNum());
        return sn.toString();
    }

    public String occupationHealthInspectionBuisnessPath(Integer businessId, Byte businessPhrase, String taskName, Byte inspectionType) {
        if (businessPhrase == null) {
            return "forward:/occupationHealthInspection/" + businessId + "/view?menuid=521";
        }
        if (OccupationHealthInspectionUtil.getInstance().isDailyScene(inspectionType)) {
            if (BusinessStage.initiate.getValue().equals(businessPhrase)) {
                if ("read".equals(taskName)) {
                    return "forward:/occupationHealthInspection/dailyScene/" + businessId + "/dailySceneInitiateFeedback";
                }
                if ("approve".equals(taskName)) {
                    return "forward:/occupationHealthInspection/dailyScene/" + businessId + "/dailySceneInitiateApprove";
                }
            } else if (BusinessStage.summary.getValue().equals(businessPhrase) && "approve".equals(taskName)) {
                return "forward:/occupationHealthInspection/dailyScene/" + businessId + "/dailySceneSummaryApprove";
            }
        } else if (BusinessStage.plan.getValue().equals(businessPhrase)) {
            if ("approve".equals(taskName)) {
                return "forward:/occupationHealthInspection/occupationHealthInspectionPlanApprove?id=" + businessId;
            }
            if ("apply".equals(taskName)) {
                return "forward:/occupationHealthInspection/" + businessId + "/editInspection??menuid=521";
            }
        } else if (BusinessStage.initiate.getValue().equals(businessPhrase)) {
            if ("read".equals(taskName)) {
                return "forward:/occupationHealthInspection/occupationHealthInspectionInitiateFeedback?id=" + businessId;
            }
            if ("approve".equals(taskName)) {
                return "forward:/occupationHealthInspection/occupationHealthInspectionInitiateApprove?id=" + businessId;
            }
        } else if (BusinessStage.summary.getValue().equals(businessPhrase)) {
            if ("approve".equals(taskName)) {
                return "forward:/occupationHealthInspection/occupationHealthInspectionSummaryApprove?id=" + businessId;
            }
        } else if (BusinessStage.file.getValue().equals(businessPhrase) && "approve".equals(taskName)) {
            return "forward:/occupationHealthInspection/makeup/" + businessId + "/makeupApprove";
        }
        return "forward:/occupationHealthInspection/" + businessId + "/view?menuid=521";
    }

    public boolean isDailyScene(Byte inspectionType) {
        return OccupationHealthInspectionType.dailyScene.getValue().equals(inspectionType);
    }

    /* synthetic */ OccupationHealthInspectionUtil(OccupationHealthInspectionUtil occupationHealthInspectionUtil) {
        this();
    }

    private static class LazyHolder {
        private static final OccupationHealthInspectionUtil INSTANCE = new OccupationHealthInspectionUtil(null);

        private LazyHolder() {
        }
    }
}

