/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.util;

import cn.smarthse.core.util.UserAgentSO;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgentUtil {
    static Logger logger = LoggerFactory.getLogger(UserAgentUtil.class);
    static String[] mobileAgents = new String[]{"iphone", "android", "phone", "mobile", "wap", "netfront", "java", "opera mobi", "opera mini", "ucweb", "windows ce", "symbian", "series", "webos", "sony", "blackberry", "dopod", "nokia", "samsung", "palmsource", "xda", "pieplus", "meizu", "midp", "cldc", "motorola", "foma", "docomo", "up.browser", "up.link", "blazer", "helio", "hosin", "huawei", "novarra", "coolpad", "webos", "techfaith", "palmsource", "alcatel", "amoi", "ktouch", "nexian", "ericsson", "philips", "sagem", "wellcom", "bunjalloo", "maui", "smartphone", "iemobile", "spice", "bird", "zte-", "longcos", "pantech", "gionee", "portalmmm", "jig browser", "hiptop", "benq", "haier", "^lct", "320x320", "240x320", "176x220", "w3c ", "acs-", "alav", "alca", "amoi", "audi", "avan", "benq", "bird", "blac", "blaz", "brew", "cell", "cldc", "cmd-", "dang", "doco", "eric", "hipt", "inno", "ipaq", "java", "jigs", "kddi", "keji", "leno", "lg-c", "lg-d", "lg-g", "lge-", "maui", "maxo", "midp", "mits", "mmef", "mobi", "mot-", "moto", "mwbp", "nec-", "newt", "noki", "oper", "palm", "pana", "pant", "phil", "play", "port", "prox", "qwap", "sage", "sams", "sany", "sch-", "sec-", "send", "seri", "sgh-", "shar", "sie-", "siem", "smal", "smar", "sony", "sph-", "symb", "t-mo", "teli", "tim-", "tsm-", "upg1", "upsi", "vk-v", "voda", "wap-", "wapa", "wapi", "wapp", "wapr", "webc", "winw", "winw", "xda", "xda-", "Googlebot-Mobile"};

    public static UserAgentSO getUserAgent(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String ua = request.getHeader("user-agent");
        logger.info(ua);
        ua = ua.toLowerCase();
        UserAgentSO agent = UserAgentUtil.getUserAgent(ua);
        agent.setUa(ua);
        agent.setQueryString(request.getQueryString());
        agent.setTrident(ua.indexOf("Trident") > -1);
        agent.setPresto(ua.indexOf("Presto") > -1);
        agent.setWebKit(ua.indexOf("AppleWebKit") > -1);
        agent.setGecko(ua.indexOf("Gecko") > -1 && ua.indexOf("KHTML") == -1);
        agent.setIsweixin(ua.indexOf("micromessenger") > -1);
        String[] stringArray = mobileAgents;
        int n = mobileAgents.length;
        int n2 = 0;
        while (n2 < n) {
            String ma = stringArray[n2];
            if (ua.indexOf(ma) >= 0) {
                agent.setIsmobile(true);
                break;
            }
            ++n2;
        }
        return agent;
    }

    public static UserAgentSO getUserAgent(String userAgent) {
        if (userAgent != null && !"".equals(userAgent)) {
            userAgent = userAgent.toLowerCase();
        }
        if (userAgent.contains("windows")) {
            if (userAgent.contains("windows nt 6.2")) {
                return UserAgentUtil.judgeBrowser(userAgent, "windows", "8", null);
            }
            if (userAgent.contains("windows nt 6.1")) {
                return UserAgentUtil.judgeBrowser(userAgent, "windows", "7", null);
            }
            if (userAgent.contains("windows nt 6.0")) {
                return UserAgentUtil.judgeBrowser(userAgent, "windows", "Vista", null);
            }
            if (userAgent.contains("windows nt 5.2")) {
                return UserAgentUtil.judgeBrowser(userAgent, "windows", "XP", "x64 Edition");
            }
            if (userAgent.contains("windows nt 5.1")) {
                return UserAgentUtil.judgeBrowser(userAgent, "windows", "XP", null);
            }
            if (userAgent.contains("windows nt 5.01")) {
                return UserAgentUtil.judgeBrowser(userAgent, "windows", "2000", "SP1");
            }
            if (userAgent.contains("windows nt 5.0")) {
                return UserAgentUtil.judgeBrowser(userAgent, "windows", "2000", null);
            }
            if (userAgent.contains("windows nt 4.0")) {
                return UserAgentUtil.judgeBrowser(userAgent, "windows", "NT 4.0", null);
            }
            if (userAgent.contains("windows 98; Win 9x 4.90")) {
                return UserAgentUtil.judgeBrowser(userAgent, "windows", "ME", null);
            }
            if (userAgent.contains("windows 98")) {
                return UserAgentUtil.judgeBrowser(userAgent, "windows", "98", null);
            }
            if (userAgent.contains("windows 95")) {
                return UserAgentUtil.judgeBrowser(userAgent, "windows", "95", null);
            }
            if (userAgent.contains("windows CE")) {
                return UserAgentUtil.judgeBrowser(userAgent, "windows", "CE", null);
            }
        } else if (userAgent.contains("mac os x") && userAgent.contains("ipod")) {
            return UserAgentUtil.judgeBrowser(userAgent, "ipod", null, null);
        }
        return new UserAgentSO();
    }

    private static UserAgentSO judgeBrowser(String userAgent, String platformType, String platformSeries, String platformVersion) {
        if (userAgent != null && !"".equals(userAgent)) {
            userAgent = userAgent.toLowerCase();
        }
        if (userAgent.contains("chrome")) {
            String temp = userAgent.substring(userAgent.indexOf("chrome/") + 7);
            String chromeVersion = null;
            chromeVersion = temp.indexOf(" ") < 0 ? temp : temp.substring(0, temp.indexOf(" "));
            return new UserAgentSO("chrome", chromeVersion, platformType, platformSeries, platformVersion);
        }
        if (userAgent.contains("firefox")) {
            String temp = userAgent.substring(userAgent.indexOf("firefox/") + 8);
            String ffVersion = null;
            ffVersion = temp.indexOf(" ") < 0 ? temp : temp.substring(0, temp.indexOf(" "));
            return new UserAgentSO("firefox", ffVersion, platformType, platformSeries, platformVersion);
        }
        if (userAgent.contains("msie")) {
            if (userAgent.contains("msie 10.0")) {
                return new UserAgentSO("Internet Explorer", "10", platformType, platformSeries, platformVersion);
            }
            if (userAgent.contains("msie 9.0")) {
                return new UserAgentSO("Internet Explorer", "9", platformType, platformSeries, platformVersion);
            }
            if (userAgent.contains("msie 8.0")) {
                return new UserAgentSO("Internet Explorer", "8", platformType, platformSeries, platformVersion);
            }
            if (userAgent.contains("msie 7.0")) {
                return new UserAgentSO("Internet Explorer", "7", platformType, platformSeries, platformVersion);
            }
            if (userAgent.contains("msie 6.0")) {
                return new UserAgentSO("Internet Explorer", "6", platformType, platformSeries, platformVersion);
            }
        } else {
            return new UserAgentSO(null, null, platformType, platformSeries, platformVersion);
        }
        return null;
    }
}

