/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.util;

import cn.smarthse.core.framework.security.shiro.ShiroPrincipal;
import cn.smarthse.core.model.basic.Staff;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class LoginUtil {
    private LoginUtil() {
    }

    public static final LoginUtil getInstance() {
        return LazyHolder.INSTANCE;
    }

    public Staff getLoginStaffInfo() {
        Subject subject = SecurityUtils.getSubject();
        Object principal = subject.getPrincipal();
        Staff staff = null;
        if (principal instanceof ShiroPrincipal) {
            staff = ((ShiroPrincipal)principal).getStaff();
        }
        return staff;
    }

    public Integer getLoginStaffId() {
        Staff staff = this.getLoginStaffInfo();
        return staff == null ? null : staff.getId();
    }

    public Integer getLoginStaffCompanyId() {
        Staff staff = this.getLoginStaffInfo();
        if (staff == null) {
            return null;
        }
        return staff.getCid();
    }

    /* synthetic */ LoginUtil(LoginUtil loginUtil) {
        this();
    }

    private static class LazyHolder {
        private static final LoginUtil INSTANCE = new LoginUtil(null);

        private LazyHolder() {
        }
    }
}

