/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.util;

import cn.smarthse.core.util.DateUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public final class HttpUtil {
    public static String getURL(HttpServletRequest request) {
        StringBuffer sb = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString != null) {
            return sb.toString() + "?" + queryString;
        }
        return sb.toString();
    }

    public static int getInt(HttpServletRequest request, String paramName, int defaultValue) {
        String s = request.getParameter(paramName);
        if (s == null || s.equals("")) {
            return defaultValue;
        }
        return Integer.parseInt(s);
    }

    public static int getInt(HttpServletRequest request, String paramName) {
        String s = request.getParameter(paramName);
        return Integer.parseInt(s);
    }

    public static Long getLong(HttpServletRequest request, String paramName) {
        String s = request.getParameter(paramName);
        return Long.parseLong(s);
    }

    public static Long getLong(HttpServletRequest request, String paramName, Long defaultValue) {
        String s = request.getParameter(paramName);
        if (s == null || s.equals("")) {
            return defaultValue;
        }
        return Long.parseLong(s);
    }

    public static String getString(HttpServletRequest request, String paramName, String defaultValue) {
        String s = request.getParameter(paramName);
        if (s == null || s.equals("")) {
            return defaultValue;
        }
        return s;
    }

    public static String getString(HttpServletRequest request, String paramName) {
        String s = request.getParameter(paramName);
        if (s == null || s.equals("")) {
            throw new NullPointerException("Null parameter: " + paramName);
        }
        return s;
    }

    public static boolean getBoolean(HttpServletRequest request, String paramName) {
        String s = request.getParameter(paramName);
        return Boolean.parseBoolean(s);
    }

    public static boolean getBoolean(HttpServletRequest request, String paramName, boolean defaultValue) {
        String s = request.getParameter(paramName);
        if (s == null || s.equals("")) {
            return defaultValue;
        }
        return Boolean.parseBoolean(s);
    }

    public static float getFloat(HttpServletRequest request, String paramName) {
        String s = request.getParameter(paramName);
        return Float.parseFloat(s);
    }

    public static Object createFormBean(HttpServletRequest request, Class c) {
        Object bean;
        try {
            bean = c.newInstance();
        }
        catch (Exception e) {
            return new Object();
        }
        Method[] ms = c.getMethods();
        int i = 0;
        while (i < ms.length) {
            Class<?>[] cc;
            String name = ms[i].getName();
            if (name.startsWith("set") && (cc = ms[i].getParameterTypes()).length == 1) {
                String type = cc[0].getName();
                try {
                    String prop = Character.toLowerCase(name.charAt(3)) + name.substring(4);
                    String param = HttpUtil.getString(request, prop);
                    if (param != null && !param.equals("")) {
                        if (type.equals("java.lang.String")) {
                            ms[i].invoke(bean, HttpUtil.htmlEncode(param));
                        } else if (type.equals("int") || type.equals("java.lang.Integer")) {
                            ms[i].invoke(bean, new Integer(param));
                        } else if (type.equals("long") || type.equals("java.lang.Long")) {
                            ms[i].invoke(bean, new Long(param));
                        } else if (type.equals("boolean") || type.equals("java.lang.Boolean")) {
                            ms[i].invoke(bean, Boolean.valueOf(param));
                        } else if (type.equals("float") || type.equals("java.lang.Float")) {
                            ms[i].invoke(bean, new Float(param));
                        } else if (type.equals("java.util.Date")) {
                            Date date = null;
                            date = param.indexOf(58) != -1 ? DateUtil.parseDateTime(param) : DateUtil.parseDate(param);
                            if (date != null) {
                                ms[i].invoke(bean, date);
                            } else {
                                System.err.println("WARNING: date is null: " + param);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println("WARNING: Invoke method " + ms[i].getName() + " failed: " + e.getMessage());
                }
            }
            ++i;
        }
        return bean;
    }

    public static String htmlEncode(String text) {
        if (text == null || "".equals(text)) {
            return "";
        }
        text = text.replace("<", "&lt;");
        text = text.replace(">", "&gt;");
        text = text.replace(" ", "&nbsp;");
        text = text.replace("\"", "&quot;");
        text = text.replace("'", "&apos;");
        return text.replace("\n", "<br/>");
    }

    public static String htmlEncodeNotBlank(String text) {
        if (text == null || "".equals(text)) {
            return "";
        }
        text = text.replace("<", "&lt;");
        text = text.replace(">", "&gt;");
        text = text.replace("\"", "&quot;");
        text = text.replace("'", "&apos;");
        return text.replace("\n", "<br/>");
    }

    public static String encode(String text) {
        if (text == null || "".equals(text)) {
            return "";
        }
        text = text.replace("<", "&lt;");
        text = text.replace(">", "&gt;");
        text = text.replace("\"", "&quot;");
        text = text.replace("'", "&apos;");
        text = text.replace("&", "&amp;");
        return text.replace("\n", "<br/>");
    }

    public static String encodeHtml(String text) {
        if (text == null || "".equals(text)) {
            return "";
        }
        text = text.replace("&lt;", "<");
        text = text.replace("&gt;", ">");
        text = text.replace("&nbsp;", " ");
        text = text.replace("&quot;", "\"");
        text = text.replace("&apos;", "'");
        return text.replace("<br/>", "\n");
    }

    public static String encodeHtml2(String text) {
        if (text == null || "".equals(text)) {
            return "";
        }
        text = text.replace("&lt;", "<");
        text = text.replace("&gt;", ">");
        text = text.replace("&nbsp;", " ");
        text = text.replace("&quot;", "");
        text = text.replace("&apos;", "");
        return text.replace("<br/>", "\n");
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String subStringHTML(String param, int length, String end) {
        StringBuffer result = new StringBuffer();
        int n = 0;
        boolean isCode = false;
        boolean isHTML = false;
        for (int i = 0; i < param.length(); ++i) {
            char temp = param.charAt(i);
            if (temp == '<') {
                isCode = true;
            } else if (temp == '&') {
                isHTML = true;
            } else if (temp == '>' && isCode) {
                --n;
                isCode = false;
            } else if (temp == ';' && isHTML) {
                isHTML = false;
            }
            if (!isCode && !isHTML) {
                ++n;
                if ((temp + "").getBytes().length > 1) {
                    ++n;
                }
            }
            result.append(temp);
            if (n >= length) break;
        }
        result.append(end);
        String temp_result = result.toString().replaceAll("(>)[^<>]*(<?)", "$1$2");
        temp_result = temp_result.replaceAll("</?(AREA|BASE|BASEFONT|BODY|BR|COL|COLGROUP|DD|DT|FRAME|HEAD|HR|HTML|IMG|INPUT|ISINDEX|LI|LINK|META|OPTION|P|PARAM|TBODY|TD|TFOOT|TH|THEAD|TR|area|base|basefont|body|br|col|colgroup|dd|dt|frame|head|hr|html|img|input|isindex|li|link|meta|option|p|param|tbody|td|tfoot|th|thead|tr)[^<>]*/?>", "");
        temp_result = temp_result.replaceAll("<([a-zA-Z]+)[^<>]*>(.*?)</\\1>", "$2");
        Pattern p = Pattern.compile("<([a-zA-Z]+)[^<>]*>");
        Matcher m = p.matcher(temp_result);
        ArrayList<String> endHTML = new ArrayList<String>();
        while (m.find()) {
            endHTML.add(m.group(1));
        }
        int j = endHTML.size() - 1;
        while (j >= 0) {
            result.append("</");
            result.append(endHTML.get(j));
            result.append(">");
            --j;
        }
        return result.toString();
    }

    public static void main(String[] args) {
        String test = "&lt;FONT&nbsp;color=#1a6be6&gt;\u50cf\u827a\u672f\u5bb6\u4e00\u6837\u6d6a\u6f2b\uff0c\u50cf\u5de5\u7a0b\u5e08\u4e00\u6837\u4e25\u8c28;\u5b89\u5206\u7aed\u529b\uff0c\u6cca\u7136\u5982\u4e00\u65e0\u6240\u6c42\u8005\uff0c\u4e0d\u8fc7\u4e24\u5e74\uff0c\u5219\u5fc5\u4e3a\u4e0a\u5b98\u50da\u53cb\u6240\u94a6\u5c5e\u4e5f;\u865a\u5984\u7684\u4e16\u754c\u5bfb\u6c42\u4e00\u65b9\u51c0\u571f:\u4eba\u751f\u54f2\u5b66-\u667a\u8005\u7684\u5929\u7a7a;\u56db\u4e66\u4e94\u7ecf-\u5112\u3001\u9053\u3001\u4f5b\u5bb6\u7684\u7ecf\u5178;\u65e5\u97e9\u6f6e\u6d41-\u6d6a\u6f2b\u552f\u7f8e\u7684\u4e00\u9685\uff1b\u7ecf\u5178\u6d41\u884c-\u6e05\u65b0\u96c5\u4e50\u7684\u7eaf\u51c0&lt;/FONT&gt;";
        System.out.println(test);
        System.out.println("=============================================================================");
        System.out.println(HttpUtil.encodeHtml(test));
        System.out.println(HttpUtil.subStringHTML(HttpUtil.encodeHtml(test), 20, "..."));
    }
}

