/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.util;

import java.util.BitSet;
import java.util.HashMap;

public class GeohashUtil {
    private static int numbits = 30;
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final HashMap<Character, Integer> lookup = new HashMap();
    private static final double EARTH_RADIUS = 6378.137;

    static {
        int i = 0;
        char[] cArray = digits;
        int n = digits.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            lookup.put(Character.valueOf(c), i++);
            ++n2;
        }
    }

    public double[] decode(String geohash) {
        boolean isSet;
        StringBuilder buffer = new StringBuilder();
        char[] cArray = geohash.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            int i = lookup.get(Character.valueOf(c)) + 32;
            buffer.append(Integer.toString(i, 2).substring(1));
            ++n2;
        }
        BitSet lonset = new BitSet();
        BitSet latset = new BitSet();
        int j = 0;
        int i = 0;
        while (i < numbits * 2) {
            isSet = false;
            if (i < buffer.length()) {
                isSet = buffer.charAt(i) == '1';
            }
            lonset.set(j++, isSet);
            i += 2;
        }
        j = 0;
        i = 1;
        while (i < numbits * 2) {
            isSet = false;
            if (i < buffer.length()) {
                isSet = buffer.charAt(i) == '1';
            }
            latset.set(j++, isSet);
            i += 2;
        }
        double lon = this.decode(lonset, -180.0, 180.0);
        double lat = this.decode(latset, -90.0, 90.0);
        return new double[]{lat, lon};
    }

    private double decode(BitSet bs, double floor, double ceiling) {
        double mid = 0.0;
        int i = 0;
        while (i < bs.length()) {
            mid = (floor + ceiling) / 2.0;
            if (bs.get(i)) {
                floor = mid;
            } else {
                ceiling = mid;
            }
            ++i;
        }
        return mid;
    }

    public String encode(double lat, double lon) {
        BitSet latbits = this.getBits(lat, -90.0, 90.0);
        BitSet lonbits = this.getBits(lon, -180.0, 180.0);
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < numbits) {
            buffer.append(lonbits.get(i) ? (char)'1' : '0');
            buffer.append(latbits.get(i) ? (char)'1' : '0');
            ++i;
        }
        return GeohashUtil.base32(Long.parseLong(buffer.toString(), 2));
    }

    public String encode(double lat, double lon, int len) {
        String geocode = this.encode(lat, lon);
        return geocode.substring(0, len);
    }

    private BitSet getBits(double lat, double floor, double ceiling) {
        BitSet buffer = new BitSet(numbits);
        int i = 0;
        while (i < numbits) {
            double mid = (floor + ceiling) / 2.0;
            if (lat >= mid) {
                buffer.set(i);
                floor = mid;
            } else {
                ceiling = mid;
            }
            ++i;
        }
        return buffer;
    }

    public static String base32(long i) {
        boolean negative;
        char[] buf = new char[65];
        int charPos = 64;
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= -32L) {
            buf[charPos--] = digits[(int)(-(i % 32L))];
            i /= 32L;
        }
        buf[charPos] = digits[(int)(-i)];
        if (negative) {
            buf[--charPos] = 45;
        }
        return new String(buf, charPos, 65 - charPos);
    }

    public static double getPointDistance(double lat1, double lng1, double lat2, double lng2) {
        double result = 0.0;
        double radLat1 = GeohashUtil.radian(lat1);
        double ratlat2 = GeohashUtil.radian(lat2);
        double a = GeohashUtil.radian(lat1) - GeohashUtil.radian(lat2);
        double b = GeohashUtil.radian(lng1) - GeohashUtil.radian(lng2);
        result = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(ratlat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        result *= 6378.137;
        result = Math.round(result * 1000.0);
        return result;
    }

    private static double radian(double d) {
        return d * Math.PI / 180.0;
    }

    public static void main(String[] args) {
        double[] latlon = new GeohashUtil().decode("dj248j248j24");
        System.out.println(String.valueOf(latlon[0]) + " " + latlon[1]);
        GeohashUtil e = new GeohashUtil();
        String s = e.encode(30.0, -90.0);
        System.out.println(s);
        latlon = e.decode(s);
        System.out.println(String.valueOf(latlon[0]) + ", " + latlon[1]);
    }
}

