/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;

public class DateUtil
extends DateUtils {
    private static String DATETIME_FORMAT = "yyyy-MM-dd HH:mm";
    private static String DATE_FORMAT = "yyyy-MM-dd";
    public static final String[] zodiacArr = new String[]{"\u7334", "\u9e21", "\u72d7", "\u732a", "\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a"};
    public static final String[] constellationArr = new String[]{"\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u7261\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u9b54\u7faf\u5ea7"};
    public static final int[] constellationEdgeDay = new int[]{20, 19, 21, 21, 21, 22, 23, 23, 23, 23, 22, 22};

    public static Date previous(int days) {
        return new Date(System.currentTimeMillis() - (long)days * 3600000L * 24L);
    }

    public static String formatDateTime(Date d) {
        return new SimpleDateFormat(DATETIME_FORMAT).format(d);
    }

    public static String formatDateTime(long d) {
        return new SimpleDateFormat(DATETIME_FORMAT).format(d);
    }

    public static String formatDate(Date d) {
        return new SimpleDateFormat(DATE_FORMAT).format(d);
    }

    public static Date parseDate(String d) {
        try {
            return new SimpleDateFormat(DATE_FORMAT).parse(d);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Date parseDateTime(String dt) {
        try {
            return new SimpleDateFormat(DATETIME_FORMAT).parse(dt);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String parseDate(String d, String format) {
        return new SimpleDateFormat(format).format(DateUtil.parseDateTime(d));
    }

    public static int getYearOfDate(Date p_date) {
        if (p_date != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(p_date);
            return c.get(1);
        }
        return -1;
    }

    public static int getMonthOfDate(Date p_date) {
        if (p_date != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(p_date);
            return c.get(2) + 1;
        }
        return -1;
    }

    public static int getDayOfDate(Date p_date) {
        if (p_date != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(p_date);
            return c.get(5);
        }
        return -1;
    }

    public static int getHourOfDate(Date p_date) {
        if (p_date != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(p_date);
            return c.get(11);
        }
        return -1;
    }

    public static int getMinuteOfDate(Date p_date) {
        if (p_date != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(p_date);
            return c.get(12);
        }
        return -1;
    }

    public static int getSecondOfDate(Date p_date) {
        if (p_date != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(p_date);
            return c.get(13);
        }
        return -1;
    }

    public static long getMillisOfDate(Date p_date) {
        if (p_date != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(p_date);
            return c.getTimeInMillis();
        }
        return -1L;
    }

    public static int getAge(Date birthDay) throws Exception {
        Calendar cal = Calendar.getInstance();
        if (cal.before(birthDay)) {
            throw new IllegalArgumentException("The birthDay is before Now.It's unbelievable!");
        }
        int yearNow = cal.get(1);
        int monthNow = cal.get(2);
        int dayOfMonthNow = cal.get(5);
        cal.setTime(birthDay);
        int yearBirth = cal.get(1);
        int monthBirth = cal.get(2);
        int dayOfMonthBirth = cal.get(5);
        int age = yearNow - yearBirth;
        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) {
                    --age;
                }
            } else {
                --age;
            }
        }
        return age;
    }

    public static String formatDayHour(long ms, int validDay) {
        int temp = (int)(ms / 3600000L);
        int day = 0;
        int hour = 0;
        if (temp % 24 == 0) {
            day = (validDay * 24 - temp) / 24;
            hour = 0;
        } else {
            day = (validDay * 24 - temp) / 24;
            hour = temp < 24 ? 24 - temp : 24 - temp % 24;
        }
        return String.valueOf(day) + "\u5929" + hour + "\u5c0f\u65f6";
    }

    public static String date2Zodica(Calendar time) {
        return zodiacArr[time.get(1) % 12];
    }

    public static String date2Constellation(Calendar time) {
        int month = time.get(2);
        int day = time.get(5);
        if (day < constellationEdgeDay[month]) {
            --month;
        }
        if (month >= 0) {
            return constellationArr[month];
        }
        return constellationArr[11];
    }

    public static String date2Str(Date date) {
        StringBuffer buffer = new StringBuffer();
        long millTime = System.currentTimeMillis() - date.getTime();
        long second = millTime / 1000L;
        long minutes = second / 60L;
        long hours = minutes / 60L;
        if (second < 60L) {
            buffer.append(second).append("\u79d2\u524d");
        } else if (minutes < 60L) {
            buffer.append(minutes).append("\u5206\u949f\u524d");
        } else if (hours < 24L) {
            buffer.append(hours).append("\u5c0f\u65f6\u524d");
        } else {
            buffer.append(new SimpleDateFormat(DATETIME_FORMAT).format(date));
        }
        return buffer.toString();
    }

    public static float date2diff(Date sd, Date ed) {
        Long s = sd.getTime();
        Long e = ed.getTime();
        if (s > e) {
            Long tmp = s;
            s = e;
            e = tmp;
        }
        Long diff = e - s;
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long ns = 1000L;
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        long sec = diff % nd % nh % nm / ns;
        System.out.println("\u65f6\u95f4\u76f8\u5dee\uff1a" + day + "\u5929" + hour + "\u5c0f\u65f6" + min + "\u5206\u949f" + sec + "\u79d2\u3002");
        return Float.valueOf(String.format("%s.%s", day, hour)).floatValue();
    }

    public static Long date2diffTime(Date sd, Date ed) {
        Long s = sd.getTime();
        Long e = ed.getTime();
        if (s > e) {
            Long tmp = s;
            s = e;
            e = tmp;
        }
        return e - s;
    }

    public static long date2diffMinutes(Date sd, Date ed) {
        Long s = sd.getTime();
        Long e = ed.getTime();
        if (s > e) {
            Long tmp = s;
            s = e;
            e = tmp;
        }
        Long diff = e - s;
        return diff / 60000L;
    }

    public static Date str2date(String date, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        try {
            return df.parse(date);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Date str2date(String date) {
        return DateUtil.str2date(date, "yyyy-MM-dd HH:mm");
    }

    public static Date getMonthLastDate() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat datef = new SimpleDateFormat("yyyy-MM-dd");
        cal.set(5, 1);
        cal.roll(5, -1);
        Date endTime = cal.getTime();
        String endTime1 = String.valueOf(datef.format(endTime)) + " 23:59:59";
        return DateUtil.str2date(endTime1);
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.parseDate("2016-07-01 16:39:42", "yyyyMMdd"));
    }
}

