/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.util;

import com.google.gson.Gson;
import java.math.BigDecimal;
import java.text.Collator;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class CommonUtil {
    private static Gson gson = new Gson();
    private static String[] units = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341"};
    private static String[] weeks = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u65e5"};
    private static final int[] dayArr = new int[]{20, 19, 21, 20, 21, 22, 23, 23, 23, 24, 23, 22};
    private static final String[] constellationArr = new String[]{"\u6469\u7faf\u5ea7", "\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u767d\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u6469\u7faf\u5ea7"};

    public static String object2json(Object object) {
        return gson.toJson(object);
    }

    public static String codemessage2json(String code, String message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", code);
        map.put("msg", message);
        return CommonUtil.getJsonResult(map);
    }

    public static String getJsonResult(Map<String, Object> map) {
        return gson.toJson(map);
    }

    public static String code2json(String code, Map<String, Object> jsondata) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", code);
        map.putAll(jsondata);
        return gson.toJson(map);
    }

    public static String code2jlist(String code, List list) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", code);
        map.put("list", gson.toJson((Object)list));
        return gson.toJson(map);
    }

    public static String code2json(String code, String message) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", code);
        map.put("msg", message);
        return gson.toJson(map);
    }

    public static String code2data(String code, String objctName, Object objct) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", code);
        if (objctName == null || !"".equals(objctName)) {
            objctName = "data";
        }
        map.put(objctName, gson.toJson(objct));
        return gson.toJson(map);
    }

    public static String clickNum2Text(long clickNum) {
        DecimalFormat formater = new DecimalFormat("###,###");
        return formater.format(clickNum);
    }

    public static String int2ChineseNum(int num) {
        if (num > 11) {
            return String.valueOf(num);
        }
        return units[num];
    }

    public static long str2long(String strlong) {
        block3: {
            try {
                if (!"".equals(strlong.replaceAll(" ", ""))) break block3;
                return 0L;
            }
            catch (Exception e) {
                return 0L;
            }
        }
        return Long.valueOf(strlong);
    }

    public static long getVideoMesh(String video, int idx, Long dv) throws Exception {
        Long _value;
        if (StringUtils.isEmpty((String)video)) {
            return dv;
        }
        String[] arr = video.split("x");
        if (arr.length > idx && (_value = Long.valueOf(CommonUtil.str2long(arr[idx]))) > 0L) {
            return _value;
        }
        return dv;
    }

    public static long Duration2long(String duration) throws Exception {
        long result = 0L;
        String[] arr = duration.split(":");
        result += CommonUtil.str2long(arr[0]) * 3600L;
        result += CommonUtil.str2long(arr[1]) * 60L;
        result = (long)((float)result + Float.valueOf(arr[arr.length - 1]).floatValue());
        return result *= 1000L;
    }

    public static String percent(Long p, Long all) {
        if (all <= 0L) {
            return "0%";
        }
        double x_double = (double)p.longValue() * 1.0;
        double tempresult = x_double / (double)all.longValue();
        DecimalFormat df1 = new DecimalFormat("0%");
        return df1.format(tempresult);
    }

    public static String Duration2bit(Long duration) {
        try {
            long ld = duration / 1000L;
            ld %= 31536000L;
            ld %= 2592000L;
            long hour = (ld %= 86400L) / 3600L;
            long min = (ld %= 3600L) / 60L;
            long sec = ld %= 60L;
            String result = "";
            result = String.valueOf(result) + (sec >= 10L ? "" : "0") + sec;
            result = String.valueOf(min > 0L ? String.valueOf(min >= 10L ? "" : "0") + min + ":" : "00:") + result;
            result = String.valueOf(hour > 0L ? String.valueOf(hour >= 10L ? "" : "0") + hour + ":" : "") + result;
            return result;
        }
        catch (Exception e) {
            return "00:00";
        }
    }

    public static String filesize2mb(long filesize) {
        if (filesize > 1024L && filesize < 0x100000L) {
            return String.format("%s KB", filesize / 1024L);
        }
        if (filesize >= 0x100000L && filesize < 0x100000L) {
            return String.format("%s MB", filesize / 1024L / 1024L);
        }
        return String.format("%s B", filesize);
    }

    public static Long long2mb(long filesize) {
        return filesize / 1024L / 1024L;
    }

    public static String b2mb(long filesize) {
        double r = 0.0;
        String sbyte = "";
        if (filesize > 0x10000000000L) {
            sbyte = "T";
            r = Math.round(filesize / 1024L / 1024L / 1024L / 1024L * 10L) / 10;
        } else if (filesize > 0x4B400000L) {
            sbyte = "G";
            r = Math.round(filesize / 1024L / 1024L / 1024L * 10L) / 10;
        } else if (filesize > 0x100000L) {
            sbyte = "M";
            r = Math.round(filesize / 1024L / 1024L * 10L) / 10;
        } else if (filesize > 1024L) {
            sbyte = "K";
            r = Math.round(filesize / 1024L * 10L) / 10;
        } else {
            sbyte = "";
            r = filesize;
        }
        return String.valueOf(r) + sbyte;
    }

    public static String dateformat(Date date, String format) {
        SimpleDateFormat _format = new SimpleDateFormat(format);
        return _format.format(date);
    }

    public static String formatDateWithWeekNoYear(Date date) {
        if (date == null) {
            return "";
        }
        String d = CommonUtil.dateformat(date, "MM/dd");
        String week = weeks[Math.abs(CommonUtil.getWeek(date))];
        String hm = CommonUtil.dateformat(date, "HH:mm");
        return String.valueOf(d) + " \u5468" + week + " " + hm;
    }

    public static String getMondayDate() {
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.add(5, CommonUtil.getStartWeekNumber());
        Date monday = currentDate.getTime();
        return CommonUtil.dateformat(monday, "yyyy-MM-dd");
    }

    public static String getWeekDateStr(int week) {
        Date end = CommonUtil.getWeekDate(week);
        return CommonUtil.dateformat(end, "yyyy-MM-dd");
    }

    public static Date getWeekDate(int week) {
        Calendar calendar = Calendar.getInstance();
        int min = CommonUtil.getStartWeekNumber();
        calendar.add(7, min);
        calendar.add(7, week);
        return calendar.getTime();
    }

    public static int getWeek(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        int dayOfWeek = cd.get(7) - 1;
        if (dayOfWeek == 0) {
            dayOfWeek = 7;
        }
        if (dayOfWeek == 1) {
            return 0;
        }
        return 1 - dayOfWeek;
    }

    public static String getWeekStr(String date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date dt1 = df.parse(date);
            return weeks[Math.abs(CommonUtil.getWeek(dt1))];
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public static int getStartWeekNumber() {
        return CommonUtil.getWeek(new Date());
    }

    public static int getWeek() {
        Calendar c = Calendar.getInstance();
        return c.get(3);
    }

    public static Long getMonthLastDay() {
        return CommonUtil.getMonthLastDate().getTime();
    }

    public static Date getMonthLastDate() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat datef = new SimpleDateFormat("yyyy-MM-dd");
        cal.set(5, 1);
        cal.roll(5, -1);
        Date endTime = cal.getTime();
        String endTime1 = String.valueOf(datef.format(endTime)) + " 23:59:59";
        return CommonUtil.str2date(endTime1);
    }

    public static int compare_date(String DATE1, String DATE2) {
        Date dt2;
        Date dt1;
        block4: {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                dt1 = df.parse(DATE1);
                dt2 = df.parse(DATE2);
                if (dt1.getTime() <= dt2.getTime()) break block4;
                return 1;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return 0;
            }
        }
        if (dt1.getTime() < dt2.getTime()) {
            return -1;
        }
        return 0;
    }

    public static Date str2date(String date) {
        return CommonUtil.str2date(date, "yyyy-MM-dd HH:mm");
    }

    public static Date str2date(String date, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        try {
            return df.parse(date);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static int str2int(String strlong, int def) {
        try {
            if (StringUtils.isNotEmpty((String)strlong)) {
                return Integer.parseInt(strlong);
            }
            return def;
        }
        catch (Exception e) {
            return def;
        }
    }

    public static double str2double(String value, double def) {
        return CommonUtil.str2double(value, 2, def);
    }

    public static double str2double(String value, int format, double def) {
        try {
            if (StringUtils.isNotEmpty((String)value)) {
                return CommonUtil.roundForNumber(Double.valueOf(value), format);
            }
            return def;
        }
        catch (Exception e) {
            e.printStackTrace();
            return def;
        }
    }

    public static String double2str(double value, String format, String def) {
        try {
            DecimalFormat decimalFormat = new DecimalFormat(format);
            if (value < 1.0) {
                return "0" + decimalFormat.format(value);
            }
            return decimalFormat.format(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return def;
        }
    }

    public static String str2float(String strlong, String def) {
        try {
            if (StringUtils.isNotEmpty((String)strlong)) {
                DecimalFormat decimalFormat = new DecimalFormat("######.00");
                double vals = CommonUtil.roundForNumber(Double.valueOf(strlong), 2);
                System.out.println(decimalFormat.format(vals));
                return String.valueOf(decimalFormat.format(vals));
            }
            return def;
        }
        catch (Exception e) {
            e.printStackTrace();
            return def;
        }
    }

    public static double roundForNumber(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, 4).doubleValue();
    }

    public static Long date2diff(Date sd, Date ed) {
        Long s = sd.getTime();
        Long e = ed.getTime();
        if (s > e) {
            Long tmp = s;
            s = e;
            e = tmp;
        }
        return e - s;
    }

    public static int getYear() {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        String endTime = null;
        endTime = String.valueOf(String.valueOf(year)) + "-09-01";
        int c = CommonUtil.compare_date(endTime);
        if (c < 0) {
            --year;
        }
        return year;
    }

    public static int compare_date(String date) {
        return CommonUtil.compare_date(date, CommonUtil.dateformat(new Date(), "yyyy-MM-dd"));
    }

    public static int compare_date(Date d1, Date d2) {
        block4: {
            try {
                if (d1.getTime() <= d2.getTime()) break block4;
                System.out.println("dt1 \u5728dt2\u524d");
                return 1;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return 0;
            }
        }
        if (d1.getTime() < d2.getTime()) {
            System.out.println("dt1\u5728dt2\u540e");
            return -1;
        }
        return 0;
    }

    public static String Date2String(Date date) {
        if (date == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        long millTime = System.currentTimeMillis() - date.getTime();
        long second = millTime / 1000L;
        long minutes = second / 60L;
        long hours = minutes / 60L;
        if (second < 60L) {
            buffer.append(second).append("\u79d2\u524d");
        } else if (minutes < 60L) {
            buffer.append(minutes).append("\u5206\u949f\u524d");
        } else if (hours < 24L) {
            buffer.append(hours).append("\u5c0f\u65f6\u524d");
        } else {
            buffer.append(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(date));
        }
        return buffer.toString();
    }

    public static int compare_date(Date d1) {
        return CommonUtil.compare_date(d1, new Date());
    }

    public static long getInt1tomaxRandom(long max) {
        return Math.round(Math.random() * (double)(max - 10L) + 8.0);
    }

    public static List<String> getHtmlImages(String html) {
        String img = "";
        ArrayList<String> pics = new ArrayList<String>();
        String regEx_img = "<img.*src=(.*?)[^>]*?>";
        Pattern p_image = Pattern.compile(regEx_img, 2);
        Matcher m_image = p_image.matcher(html);
        while (m_image.find()) {
            img = String.valueOf(img) + "," + m_image.group();
            Matcher m = Pattern.compile("src=\"?(.*?)(\"|>|\\s+)").matcher(img);
            while (m.find()) {
                String url = m.group(1);
                url = url.replace("'", "");
                pics.add(url);
            }
        }
        return pics;
    }

    public static String getTextLen(String text, int len) {
        if (text == null || "".equals(text)) {
            return "";
        }
        text = text.replaceAll("\\&[a-zA-Z]{1,10};", "").replaceAll("<[^>]*>", "");
        if ((text = text.replaceAll("[(/>)<]", "")).length() >= len) {
            return String.valueOf(text.substring(0, len - 1)) + "...";
        }
        return text;
    }

    public static String delHTMLTag(String htmlStr) {
        String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>";
        String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>";
        String regEx_html = "<[^>]+>";
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll("");
        Pattern p_style = Pattern.compile(regEx_style, 2);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll("");
        Pattern p_html = Pattern.compile(regEx_html, 2);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll("");
        return htmlStr.trim();
    }

    public static String local2url(String filePath, String firstIndex) {
        String webfilepath = "/" + filePath.substring(filePath.indexOf(firstIndex), filePath.length());
        try {
            webfilepath = webfilepath.replaceAll("\\\\", "/");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return webfilepath;
    }

    public static String str2Sort(String sort) {
        if (sort == null || "".equals(sort.trim())) {
            return sort;
        }
        Object[] ary = sort.split(",");
        Arrays.sort(ary);
        return StringUtils.join((Object[])ary, (String)",");
    }

    public static String str2Sort2(String sort) {
        if (sort == null || "".equals(sort.trim())) {
            return sort;
        }
        sort = sort.replaceAll(" ", ",").replaceAll("\\[", "").replaceAll("\\]", ",");
        Object[] ary = sort.split(",");
        Collator comp = Collator.getInstance(Locale.CHINESE);
        Arrays.sort(ary, comp);
        return StringUtils.join((Object[])ary, (String)",");
    }

    public static List<String> str2list(String str) {
        ArrayList<String> list = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)str)) {
            String[] words;
            String[] stringArray = words = str.split("\\s+|[\uff0c,]");
            int n = words.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                if (!StringUtils.isEmpty((String)word)) {
                    list.add(word);
                }
                ++n2;
            }
        }
        return list;
    }

    public static String ary2str(String sort, String replacement) {
        if (sort == null || "".equals(sort.trim())) {
            return sort;
        }
        Object[] ary = sort.split(",");
        Arrays.sort(ary);
        StringBuffer result = new StringBuffer();
        Object[] objectArray = ary;
        int n = ary.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if ("[]".equals(replacement)) {
                result.append("[").append((String)item).append("]");
            } else if ("{}".equals(replacement)) {
                result.append("{").append((String)item).append("}");
            } else if ("()".equals(replacement)) {
                result.append("(").append((String)item).append(")");
            } else if ("<>".equals(replacement)) {
                result.append("<").append((String)item).append(">");
            } else {
                result.append((String)item).append(replacement);
            }
            ++n2;
        }
        return result.toString();
    }

    public static String getWeiboTime(Date date) {
        if (date == null) {
            return "";
        }
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int dateYear = Integer.parseInt(new SimpleDateFormat("yyyy").format(date));
        StringBuffer buffer = new StringBuffer();
        long millTime = System.currentTimeMillis() - date.getTime();
        long second = millTime / 1000L;
        long minutes = second / 60L;
        long hours = minutes / 60L;
        if (second < 60L) {
            buffer.append("\u521a\u521a");
        } else if (minutes < 60L) {
            buffer.append(minutes).append("\u5206\u949f\u524d");
        } else if (hours < 24L) {
            buffer.append(hours).append("\u5c0f\u65f6\u524d");
        } else if (dateYear != year) {
            buffer.append(new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm").format(date));
        } else {
            buffer.append(new SimpleDateFormat("MM\u6708dd\u65e5 HH:mm").format(date));
        }
        return buffer.toString();
    }

    public static String formatDateWithWeek(Date date) {
        if (date == null) {
            return "";
        }
        String d = CommonUtil.dateformat(date, "yyyy/MM/dd HH:mm");
        String week = weeks[Math.abs(CommonUtil.getWeek(date))];
        return String.valueOf(d) + " \u5468" + week;
    }

    public static String getConstellation(int month, int day) {
        return day < dayArr[month - 1] ? constellationArr[month - 1] : constellationArr[month];
    }

    public static String[] removeRepeat(String[] arry) {
        List<String> strList = Arrays.asList(arry);
        HashSet<String> strSet = new HashSet<String>(strList);
        String[] newArray = new String[strSet.size()];
        Iterator ite = strSet.iterator();
        int i = 0;
        while (ite.hasNext()) {
            newArray[i] = (String)ite.next();
            ++i;
        }
        return newArray;
    }

    public static boolean checkEmail(String value) {
        return value != null && !"".equals(value) && value.matches("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*");
    }

    public static boolean checkTel(String value) {
        return value != null && !"".equals(value) && value.matches("\\d{4}-\\d{8}|\\d{4}-\\d{7}|\\d(3)-\\d(8)");
    }

    public static boolean checkMobile(String value) {
        return value != null && !"".equals(value) && value.matches("^[1][0-9]+\\d{9}");
    }

    public static boolean checkChineseName(String value, int length) {
        return value != null && !"".equals(value) && value.matches("^[\u4e00-\u9fa5]+{1}") && value.length() <= length;
    }

    public static boolean checkBlank(String value) {
        return value != null && !"".equals(value) && value.matches("^\\s*|\\s*{1}");
    }

    public static boolean checkHtmlTag(String value) {
        return value != null && !"".equals(value) && value.matches("<(\\S*?)[^>]*>.*?</\\1>|<.*? />");
    }

    public static boolean checkURL(String value) {
        return value != null && !"".equals(value) && value.matches("[a-zA-z]+://[^\\s]*");
    }

    public static boolean checkIP(String value) {
        return value != null && !"".equals(value) && value.matches("\\d{1,3}+\\.\\d{1,3}+\\.\\d{1,3}+\\.\\d{1,3}");
    }

    public static boolean checkID(String value) {
        return value != null && !"".equals(value) && value.matches("[a-zA-Z][a-zA-Z0-9_]{4,15}{1}");
    }

    public static boolean checkQQ(String value) {
        return value != null && !"".equals(value) && value.matches("[1-9][0-9]{4,13}");
    }

    public static boolean checkPostCode(String value) {
        return value != null && !"".equals(value) && value.matches("[1-9]\\d{5}(?!\\d)");
    }

    public static boolean checkIDCard(String value) {
        return value != null && !"".equals(value) && value.matches("\\d{15}|\\d{18}");
    }

    public static boolean checkLength(String value, int length) {
        return (value == null || "".equals(value.trim()) ? 0 : value.length()) <= length;
    }

    public static boolean checkNull(String value) {
        return value == null || "".equals(value.trim());
    }

    public static void main(String[] args) {
        System.out.println("\u672c\u671f\u53f7:" + CommonUtil.getWeek());
    }
}

