/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.workflow;

import cn.smarthse.core.dao.flow.WfTaskMapper;
import cn.smarthse.core.model.flow.WfTask;
import cn.smarthse.core.model.flow.vo.DayWorkitemVO;
import cn.smarthse.core.model.flow.vo.WorkTaskItem;
import cn.smarthse.core.util.DateUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WfTaskService {
    @Autowired
    WfTaskMapper wfTaskMapper;

    public List<DayWorkitemVO> getDayworkItem(Integer staffId) {
        if (staffId == null || staffId == 0) {
            return Collections.emptyList();
        }
        ArrayList<DayWorkitemVO> result = new ArrayList<DayWorkitemVO>();
        List<WorkTaskItem> list = this.wfTaskMapper.selectWorkItemByStaffId(staffId);
        HashMap<String, ArrayList<WorkTaskItem>> map = new HashMap<String, ArrayList<WorkTaskItem>>();
        for (WorkTaskItem item : list) {
            if (StringUtils.isEmpty((String)item.getTaskCreateTime())) continue;
            String day = DateUtil.parseDate(item.getTaskCreateTime(), "yyyy-M-dd");
            ArrayList<WorkTaskItem> items = (ArrayList<WorkTaskItem>)map.get(day);
            if (items == null) {
                items = new ArrayList<WorkTaskItem>();
            }
            item.initTaskMap();
            items.add(item);
            map.put(day, items);
        }
        for (Map.Entry entry : map.entrySet()) {
            result.add(new DayWorkitemVO((String)entry.getKey(), (List)entry.getValue()));
        }
        Collections.sort(result, new Comparator<DayWorkitemVO>(){

            @Override
            public int compare(DayWorkitemVO s1, DayWorkitemVO s2) {
                try {
                    int compareTo = s1.getDay().compareTo(s2.getDay());
                    System.out.println(String.valueOf(s1.getDay()) + " \u5728  " + s2.getDay() + "\u524d=" + compareTo);
                    if (compareTo > 0) {
                        return 0 - compareTo;
                    }
                    return 1;
                }
                catch (Exception exception) {
                    return 0;
                }
            }
        });
        return result;
    }

    public List<WfTask> getTaskListByOrderId(Integer orderId, Integer staffId) {
        return this.wfTaskMapper.selectTaskListByOrderStaff(orderId, staffId);
    }
}

