/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.workflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.snaker.engine.SnakerEngine;
import org.snaker.engine.access.Page;
import org.snaker.engine.access.QueryFilter;
import org.snaker.engine.entity.HistoryTask;
import org.snaker.engine.entity.Order;
import org.snaker.engine.entity.Process;
import org.snaker.engine.entity.Surrogate;
import org.snaker.engine.entity.Task;
import org.snaker.engine.entity.WorkItem;
import org.snaker.engine.helper.StreamHelper;
import org.snaker.engine.model.TaskModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SnakerEngineFacets {
    @Autowired(required=false)
    private SnakerEngine engine;

    public void initFlows() {
        this.engine.process().deploy(StreamHelper.getStreamFromClasspath((String)"flows/borrow.snaker"));
        this.engine.process().deploy(StreamHelper.getStreamFromClasspath((String)"flows/businessFlow.snaker"));
    }

    public SnakerEngine getEngine() {
        return this.engine;
    }

    public List<String> getAllProcessNames() {
        List list = this.engine.process().getProcesss(new QueryFilter());
        ArrayList<String> names = new ArrayList<String>();
        for (Process entity : list) {
            if (names.contains(entity.getName())) continue;
            names.add(entity.getName());
        }
        return names;
    }

    public Order startInstanceById(Integer processId, String operator, Map<String, Object> args) {
        return this.engine.startInstanceById(processId, operator, args);
    }

    public Order startInstanceByName(String name, Integer version, String operator, Map<String, Object> args) {
        return this.engine.startInstanceByName(name, version, operator, args);
    }

    public Order startAndExecute(String name, Integer version, String operator, Map<String, Object> args) {
        Order order = this.engine.startInstanceByName(name, version, operator, args);
        List tasks = this.engine.query().getActiveTasks(new QueryFilter().setOrderId(order.getId()));
        ArrayList newTasks = new ArrayList();
        if (tasks != null && tasks.size() > 0) {
            Task task = (Task)tasks.get(0);
            newTasks.addAll(this.engine.executeTask(task.getId(), operator, args));
        }
        return order;
    }

    public Order startAndExecute(Integer processId, String operator, Map<String, Object> args) {
        Order order = this.engine.startInstanceById(processId, operator, args);
        List tasks = this.engine.query().getActiveTasks(new QueryFilter().setOrderId(order.getId()));
        ArrayList newTasks = new ArrayList();
        if (tasks != null && tasks.size() > 0) {
            Task task = (Task)tasks.get(0);
            newTasks.addAll(this.engine.executeTask(task.getId(), operator, args));
        }
        return order;
    }

    public List<Task> execute(Integer taskId, String operator, Map<String, Object> args) {
        return this.engine.executeTask(taskId, operator, args);
    }

    public List<Task> executeAndJump(Integer taskId, String operator, Map<String, Object> args, String nodeName) {
        return this.engine.executeAndJumpTask(taskId, operator, args, nodeName);
    }

    public List<Task> transferMajor(Integer taskId, String operator, String ... actors) {
        List tasks = this.engine.task().createNewTask(taskId, TaskModel.TaskType.Major.ordinal(), actors);
        this.engine.task().complete(taskId, operator);
        return tasks;
    }

    public List<Task> transferAidant(Integer taskId, String operator, String ... actors) {
        List tasks = this.engine.task().createNewTask(taskId, TaskModel.TaskType.Aidant.ordinal(), actors);
        this.engine.task().complete(taskId, operator);
        return tasks;
    }

    public Map<String, Object> flowData(Integer orderId, String taskName) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (orderId != null && StringUtils.isNotEmpty((String)taskName)) {
            List histTasks = this.engine.query().getHistoryTasks(new QueryFilter().setOrderId(orderId).setName(taskName));
            ArrayList<Map> vars = new ArrayList<Map>();
            for (HistoryTask hist : histTasks) {
                vars.add(hist.getVariableMap());
            }
            data.put("vars", vars);
            data.put("histTasks", histTasks);
        }
        return data;
    }

    public List<HistoryTask> getOrderData(Integer orderId) {
        if (orderId == null) {
            return null;
        }
        List histTasks = this.engine.query().getHistoryTasks(new QueryFilter().setOrderId(orderId));
        for (HistoryTask hist : histTasks) {
            hist.setvMap(hist.getVariableMap());
        }
        return histTasks;
    }

    public void addSurrogate(Surrogate entity) {
        if (entity.getState() == null) {
            entity.setState(Integer.valueOf(1));
        }
        this.engine.manager().saveOrUpdate(entity);
    }

    public void deleteSurrogate(Integer id) {
        this.engine.manager().deleteSurrogate(id);
    }

    public Surrogate getSurrogate(Integer id) {
        return this.engine.manager().getSurrogate(id);
    }

    public List<Surrogate> searchSurrogate(Page<Surrogate> page, QueryFilter filter) {
        return this.engine.manager().getSurrogate(page, filter);
    }

    public void processMapData(List<WorkItem> list) {
        for (WorkItem item : list) {
            item.setTaskMap(item.getTaskVariableMap());
            item.setOrderMap(item.getOrderVariableMap());
        }
    }

    public void processMapData(Order order) {
        order.setOrderMap(order.getVariableMap());
    }
}

