/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.workflow;

import cn.smarthse.core.dao.flow.WfModularsWorkflowActorMapper;
import cn.smarthse.core.dao.flow.WfModularsWorkflowMapper;
import cn.smarthse.core.framework.common.util.StringUtils;
import cn.smarthse.core.framework.enums.Modulars;
import cn.smarthse.core.framework.utils.DateUtils;
import cn.smarthse.core.model.flow.WfModularsWorkflow;
import cn.smarthse.core.model.flow.WfModularsWorkflowActor;
import cn.smarthse.core.model.flow.WfModularsWorkflowActorExample;
import cn.smarthse.core.model.flow.WfModularsWorkflowExample;
import cn.smarthse.core.model.flow.so.QueryWorkflowParam;
import cn.smarthse.core.model.flow.vo.DayModularWorkItemVO;
import cn.smarthse.core.model.vo.WorkFlowParam;
import cn.smarthse.core.util.DateUtil;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class ModularsWorkflowService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    WfModularsWorkflowMapper wfModularsWorkflowMapper;
    @Autowired
    WfModularsWorkflowActorMapper actorMapper;
    @Autowired
    WfModularsWorkflowActorMapper wfModularsWorkflowActorMapper;

    public WfModularsWorkflow addWfModularsWorkflow(WfModularsWorkflow record) {
        this.wfModularsWorkflowMapper.insertSelective(record);
        return record;
    }

    public WfModularsWorkflow getWfModularsWorkflowById(int id) {
        return this.wfModularsWorkflowMapper.selectByPrimaryKey(id);
    }

    public WfModularsWorkflow getByIdResultMapWithActor(int id) {
        return this.wfModularsWorkflowMapper.selectByIdResultMapWithActor(id);
    }

    public int updateWfModularsWorkflow(WfModularsWorkflow record) {
        return this.wfModularsWorkflowMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteWfModularsWorkflowByID(int id) {
        return this.wfModularsWorkflowMapper.deleteByPrimaryKey(id);
    }

    public List<WfModularsWorkflow> getWfModularsWorkflowListByExample(WfModularsWorkflowExample example) {
        return this.wfModularsWorkflowMapper.selectByExample(example);
    }

    public List<WfModularsWorkflow> getworkflowList(int cid, String businesstype, Integer businessid) {
        return this.wfModularsWorkflowMapper.selectworkflowByHistory(cid, businesstype, businessid);
    }

    public WfModularsWorkflow getLastWorkflow(int cid, String businesstype, Integer businessid) {
        WfModularsWorkflowExample example = new WfModularsWorkflowExample();
        example.createCriteria().andCidEqualTo(cid).andBusinessidEqualTo(businessid).andBusinesstypeEqualTo(businesstype);
        example.setOrderByClause(" id desc");
        PageHelper.startPage((int)1, (int)1);
        List<WfModularsWorkflow> list = this.getWfModularsWorkflowListByExample(example);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public WfModularsWorkflow getworkflowByapprover(Integer approverStaffId, String businessType, Integer businessid) {
        return this.wfModularsWorkflowMapper.selectLastworkflowByapprover(approverStaffId, businessType, businessid);
    }

    public int countWorkflowUNprocess(int cid, String businessType, Integer businessid, Byte stageId) {
        WfModularsWorkflowExample example = new WfModularsWorkflowExample();
        example.createCriteria().andCidEqualTo(cid).andBusinessidEqualTo(businessid).andBusinesstypeEqualTo(businessType).andStageIdEqualTo((byte)0);
        return this.wfModularsWorkflowMapper.countByExample(example);
    }

    public void completeWorkflow(int cid, WorkFlowParam wfparam) {
        Modulars m = Modulars.getModularsByCode(wfparam.getBusinessType());
        String applyer = wfparam.getApplyer();
        Integer applyerId = null;
        if (!StringUtils.isEmpty((String)applyer)) {
            applyerId = Integer.valueOf(applyer);
        }
        WfModularsWorkflow wf = new WfModularsWorkflow();
        wf.setCid(cid);
        wf.setApplyer(applyerId);
        wf.setApplyerDatetime(new Date());
        wf.setOrderId(wfparam.getOrderId());
        wf.setStage(wfparam.getStage());
        if (wfparam.getBusinessPhase() != null) {
            wf.setStageId(Byte.valueOf(wfparam.getBusinessPhase()));
        }
        wf.setProcessid(wfparam.getProcessId());
        wf.setBusinessname(wfparam.getBusinessName());
        wf.setBusinesstype(wfparam.getBusinessType());
        wf.setBusinessid(wfparam.getBusinessId());
        wf.setBusinessno(wfparam.getMessageno());
        wf.setBusinessmangerid(wfparam.getStaffId());
        if (!StringUtils.isEmpty((String)wfparam.getBusinessplantime())) {
            wf.setBusinessactualtime(DateUtils.StringToDate(wfparam.getBusinessplantime()));
        }
        if (!StringUtils.isEmpty((String)wfparam.getBusinessactualtime())) {
            wf.setBusinessactualtime(DateUtils.StringToDate(wfparam.getBusinessactualtime()));
        }
        wf.setProcessid(15);
        wf.setProcessstate((byte)0);
        wf.setBusinessstate((byte)1);
        this.wfModularsWorkflowMapper.insert(wf);
    }

    public WfModularsWorkflow terminateWorkflow(int cid, WorkFlowParam wfparam) {
        WfModularsWorkflow last;
        String applyer = wfparam.getApplyer();
        Integer applyerId = null;
        if (!StringUtils.isEmpty((String)applyer)) {
            applyerId = Integer.valueOf(applyer);
        }
        if ((last = this.getLastWorkflow(cid, wfparam.getBusinessType(), wfparam.getBusinessId())) != null) {
            if (last.getBusinessstate() != 0) {
                return null;
            }
            if (last.getProcessstate() == 1) {
                return null;
            }
            last.setId(null);
            last.setBusinessstate((byte)2);
            last.setBusinessstatetext(wfparam.getRemark());
            this.wfModularsWorkflowMapper.insert(last);
            return last;
        }
        WfModularsWorkflow wf = new WfModularsWorkflow();
        wf.setCid(cid);
        wf.setApplyer(applyerId);
        wf.setApplyerDatetime(new Date());
        wf.setOrderId(wfparam.getOrderId());
        wf.setStage(wfparam.getStage());
        if (wfparam.getBusinessPhase() != null) {
            wf.setStageId(Byte.valueOf(wfparam.getBusinessPhase()));
        }
        wf.setProcessid(wfparam.getProcessId());
        wf.setBusinessname(wfparam.getBusinessName());
        wf.setBusinesstype(wfparam.getBusinessType());
        wf.setBusinessid(wfparam.getBusinessId());
        wf.setBusinessno(wfparam.getMessageno());
        wf.setBusinessmangerid(wfparam.getStaffId());
        if (!StringUtils.isEmpty((String)wfparam.getBusinessplantime())) {
            wf.setBusinessactualtime(DateUtil.str2date(wfparam.getBusinessplantime()));
        }
        if (!StringUtils.isEmpty((String)wfparam.getBusinessactualtime())) {
            wf.setBusinessactualtime(DateUtil.str2date(wfparam.getBusinessactualtime()));
        }
        wf.setBusinessstate((byte)2);
        if (!StringUtils.isEmpty((String)wfparam.getRemark())) {
            wf.setBusinessstatetext(wfparam.getRemark());
        }
        this.wfModularsWorkflowMapper.insert(wf);
        return wf;
    }

    @Transactional
    public WfModularsWorkflow executeProcessWfModular(int cid, WorkFlowParam wfparam) {
        Modulars m = Modulars.getModularsByCode(wfparam.getBusinessType());
        String applyer = wfparam.getApplyer();
        Integer applyerId = null;
        if (!StringUtils.isEmpty((String)applyer)) {
            applyerId = Integer.valueOf(applyer);
        }
        String approver = wfparam.getApprover();
        Integer approverId = null;
        if (!StringUtils.isEmpty((String)approver)) {
            approverId = Integer.valueOf(approver);
        }
        String nextapprover = wfparam.getNextApprover();
        Integer nextapproverId = null;
        if (!StringUtils.isEmpty((String)nextapprover)) {
            nextapproverId = Integer.valueOf(nextapprover);
        }
        WfModularsWorkflow wf = null;
        if (wfparam.getWfid() != null && wfparam.getWfid() > 0) {
            wf = this.wfModularsWorkflowMapper.selectByPrimaryKey(wfparam.getWfid());
            if (wfparam.getNeedapprove() != null && wfparam.getNeedapprove().booleanValue()) {
                wf.setProcessstate((byte)1);
                if (wfparam.getBusinesscomplete() == 1) {
                    wf.setBusinessstate((byte)-1);
                } else if (wfparam.getBusinesscomplete() == 2) {
                    wf.setBusinessstate((byte)-2);
                } else {
                    wf.setBusinessstate((byte)0);
                }
            } else if (wfparam.getNeedapprove() != null && !wfparam.getNeedapprove().booleanValue()) {
                wf.setProcessstate((byte)0);
                if (wfparam.getBusinesscomplete() > 0) {
                    wf.setBusinessstate(wfparam.getBusinesscomplete());
                }
            } else if (wfparam.getApproved() != null && wfparam.getApproved().booleanValue()) {
                WfModularsWorkflowActor actor;
                wf.setProcessstate((byte)2);
                if (approverId != null && approverId > 0 && (actor = this.getworkflowActor(approverId, wf.getId())) != null) {
                    actor.setActorDatetime(new Date());
                    actor.setActorStatus((byte)2);
                    this.actorMapper.updateByPrimaryKey(actor);
                }
                if (wfparam.getEnd().booleanValue() && wfparam.getBusinesscomplete() == -1 && wf.getBusinessstate() < 0) {
                    wf.setBusinessstate((byte)1);
                } else if (wfparam.getEnd().booleanValue() && wfparam.getBusinesscomplete() == -2 && wf.getBusinessstate() < 0) {
                    wf.setBusinessstate((byte)2);
                } else {
                    wf.setBusinessstate((byte)0);
                }
            } else if (wfparam.getApproved() != null && !wfparam.getApproved().booleanValue()) {
                WfModularsWorkflowActor actor;
                wf.setProcessstate((byte)3);
                if (approverId != null && approverId > 0 && (actor = this.getworkflowActor(approverId, wf.getId())) != null) {
                    actor.setActorDatetime(new Date());
                    actor.setActorStatus((byte)3);
                    actor.setActorResult(wfparam.getRemark());
                    this.actorMapper.updateByPrimaryKey(actor);
                }
                wf.setBusinessstate((byte)0);
            }
            this.wfModularsWorkflowMapper.updateByPrimaryKey(wf);
            if (!wfparam.getEnd().booleanValue() && nextapproverId > 0) {
                wf.setId(null);
                wf.setApplyer(applyerId);
                wf.setApplyerDatetime(new Date());
                wf.setBusinessstate(wfparam.getBusinesscomplete());
                wf.setProcessstate((byte)1);
                this.wfModularsWorkflowMapper.insertSelective(wf);
                wfparam.setWfid(wf.getId());
            }
            this.executeAddApproveActor(wf, wfparam);
            return wf;
        }
        if (StringUtils.isNotEmpty(wfparam.getBusinessIdList())) {
            String[] idList;
            String[] stringArray = idList = wfparam.getBusinessIdList().split(",");
            int n = idList.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                wfparam.setBusinessId(Integer.valueOf(id));
                wf = this.addModuleWork(cid, wfparam);
                ++n2;
            }
        } else {
            wf = this.addModuleWork(cid, wfparam);
        }
        wfparam.setWfid(wf.getId());
        return wf;
    }

    @Transactional
    public WfModularsWorkflow executeInformWfModular(int cid, WorkFlowParam wfparam) {
        String applyer = wfparam.getApplyer();
        Integer applyerId = null;
        if (!StringUtils.isEmpty((String)applyer)) {
            applyerId = Integer.valueOf(applyer);
        }
        WfModularsWorkflow wf = null;
        if (wfparam.getWfid() != null && wfparam.getWfid() > 0) {
            WfModularsWorkflowActor actor;
            wf = this.wfModularsWorkflowMapper.selectByPrimaryKey(wfparam.getWfid());
            if (wfparam.getApproved() != null && wfparam.getApproved().booleanValue()) {
                WfModularsWorkflowActor actor2;
                if (applyerId != null && applyerId > 0 && (actor2 = this.getworkflowActor(applyerId, wf.getId())) != null) {
                    actor2.setActorDatetime(new Date());
                    actor2.setActorStatus((byte)2);
                    this.actorMapper.updateByPrimaryKey(actor2);
                }
            } else if (wfparam.getApproved() != null && !wfparam.getApproved().booleanValue() && applyerId != null && applyerId > 0 && (actor = this.getworkflowActor(applyerId, wf.getId())) != null) {
                actor.setActorDatetime(new Date());
                actor.setActorStatus((byte)3);
                actor.setActorResult(wfparam.getRemark());
                this.actorMapper.updateByPrimaryKey(actor);
            }
            if ((wf = this.wfModularsWorkflowMapper.selectByIdResultMapWithActor(wfparam.getWfid())) != null && wf.getAllcount() == wf.getFreebackcount()) {
                wf.setProcessstate((byte)2);
            }
            this.wfModularsWorkflowMapper.updateByPrimaryKey(wf);
            return wf;
        }
        if (StringUtils.isNotEmpty(wfparam.getBusinessIdList())) {
            String[] idList;
            String[] stringArray = idList = wfparam.getBusinessIdList().split(",");
            int n = idList.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                wfparam.setBusinessId(Integer.valueOf(id));
                wf = this.addModuleWork(cid, wfparam);
                ++n2;
            }
        } else {
            wf = this.addModuleWork(cid, wfparam);
        }
        wfparam.setWfid(wf.getId());
        return wf;
    }

    private WfModularsWorkflow addModuleWork(int cid, WorkFlowParam wfparam) {
        WfModularsWorkflow wf = new WfModularsWorkflow();
        wf.setCid(cid);
        String applyer = wfparam.getApplyer();
        Integer applyerId = null;
        if (!StringUtils.isEmpty((String)applyer)) {
            applyerId = Integer.valueOf(applyer);
        }
        wf.setApplyer(applyerId);
        wf.setApplyerDatetime(new Date());
        wf.setOrderId(wfparam.getOrderId());
        wf.setStage(wfparam.getStage());
        if (wfparam.getBusinessPhase() != null && wfparam.getBusinessPhase() != "") {
            wf.setStageId(Byte.valueOf(wfparam.getBusinessPhase()));
        }
        String approver = wfparam.getApprover();
        Integer approverId = null;
        if (!StringUtils.isEmpty((String)approver)) {
            approverId = Integer.valueOf(approver);
        }
        wf.setProcessid(wfparam.getProcessId());
        wf.setBusinessid(wfparam.getBusinessId());
        wf.setBusinessname(wfparam.getBusinessName());
        wf.setBusinesstype(wfparam.getBusinessType());
        wf.setBusinessno(wfparam.getMessageno());
        wf.setBusinessmangerid(wfparam.getStaffId());
        if (!StringUtils.isEmpty((String)wfparam.getBusinessplantime())) {
            wf.setBusinessactualtime(DateUtil.str2date(wfparam.getBusinessplantime()));
        }
        if (!StringUtils.isEmpty((String)wfparam.getBusinessactualtime())) {
            wf.setBusinessactualtime(DateUtil.str2date(wfparam.getBusinessactualtime()));
        }
        Modulars m = Modulars.getModularsByCode(wfparam.getBusinessType());
        if (wfparam.getProcessId() == 15) {
            if (wfparam.getNeedapprove() != null && wfparam.getNeedapprove().booleanValue()) {
                wf.setProcessstate((byte)1);
                if (wfparam.getBusinesscomplete() == 1) {
                    wf.setBusinessstate((byte)-1);
                } else if (wfparam.getBusinesscomplete() == 2) {
                    wf.setBusinessstate((byte)-2);
                } else {
                    wf.setBusinessstate((byte)0);
                }
            } else if (wfparam.getNeedapprove() != null && !wfparam.getNeedapprove().booleanValue()) {
                wf.setProcessstate((byte)0);
                if (wfparam.getBusinesscomplete() > 0) {
                    wf.setBusinessstate(wfparam.getBusinesscomplete());
                }
            } else if (wfparam.getApproved() != null && wfparam.getApproved().booleanValue()) {
                if (wfparam.getBusinesscomplete() > 0 && wf.getBusinessstate() < 0) {
                    wf.setBusinessstate(wfparam.getBusinesscomplete());
                }
            } else if (wfparam.getApproved() != null && !wfparam.getApproved().booleanValue() && wfparam.getBusinesscomplete() > 0 && wf.getBusinessstate() < 0) {
                wf.setBusinessstate((byte)0);
            }
        } else if (wfparam.getProcessId() == 22) {
            if (wfparam.getNeedInform() != null && wfparam.getNeedInform().booleanValue()) {
                wf.setProcessstate((byte)1);
            } else if (wfparam.getNeedInform() != null && !wfparam.getNeedInform().booleanValue()) {
                wf.setProcessstate((byte)0);
            }
        }
        this.wfModularsWorkflowMapper.insertSelective(wf);
        this.executeAddApproveActor(wf, wfparam);
        return wf;
    }

    public List<WfModularsWorkflow> getworkflowByQuery(QueryWorkflowParam qparam) {
        if (qparam == null) {
            return Collections.emptyList();
        }
        if (qparam.getCid() == null || qparam.getCid() == 0) {
            return Collections.emptyList();
        }
        if (StringUtils.isEmpty((String)qparam.getKeyword())) {
            qparam.setKeyword(null);
        }
        if (qparam.getApprover() != null && qparam.getApprover() > 0) {
            return this.wfModularsWorkflowMapper.selectworkflowApproverByQuery(qparam);
        }
        return this.wfModularsWorkflowMapper.selectworkflowByQuery(qparam);
    }

    public List<DayModularWorkItemVO> transformList2VO(List<WfModularsWorkflow> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<DayModularWorkItemVO> result = new ArrayList<DayModularWorkItemVO>();
        HashMap<String, ArrayList<WfModularsWorkflow>> map = new HashMap<String, ArrayList<WfModularsWorkflow>>();
        for (WfModularsWorkflow item : list) {
            if (item.getApplyerDatetime() == null) continue;
            String day = DateUtil.formatDate(item.getApplyerDatetime());
            ArrayList<WfModularsWorkflow> items = (ArrayList<WfModularsWorkflow>)map.get(day);
            if (items == null) {
                items = new ArrayList<WfModularsWorkflow>();
            }
            items.add(item);
            map.put(day, items);
        }
        for (Map.Entry entry : map.entrySet()) {
            result.add(new DayModularWorkItemVO((String)entry.getKey(), (List)entry.getValue()));
        }
        Collections.sort(result, new Comparator<DayModularWorkItemVO>(){

            @Override
            public int compare(DayModularWorkItemVO s1, DayModularWorkItemVO s2) {
                try {
                    int compareTo = s1.getDay().compareTo(s2.getDay());
                    System.out.println(String.valueOf(s1.getDay()) + " \u5728  " + s2.getDay() + "\u524d=" + compareTo);
                    if (compareTo > 0) {
                        return 0 - compareTo;
                    }
                    return 1;
                }
                catch (Exception exception) {
                    return 0;
                }
            }
        });
        return result;
    }

    public WfModularsWorkflowActor addWfModularsWorkflowActor(WfModularsWorkflowActor record) {
        this.wfModularsWorkflowActorMapper.insertSelective(record);
        return record;
    }

    public WfModularsWorkflowActor getWfModularsWorkflowActorById(int id) {
        return this.wfModularsWorkflowActorMapper.selectByPrimaryKey(id);
    }

    public int updateWfModularsWorkflowActor(WfModularsWorkflowActor record) {
        return this.wfModularsWorkflowActorMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteWfModularsWorkflowActorByID(int id) {
        return this.wfModularsWorkflowActorMapper.deleteByPrimaryKey(id);
    }

    public List<WfModularsWorkflowActor> getWfModularsWorkflowActorListByExample(WfModularsWorkflowActorExample example) {
        return this.wfModularsWorkflowActorMapper.selectByExample(example);
    }

    @Transactional
    public void executeAddApproveActor(WfModularsWorkflow workflow, WorkFlowParam wfparam) {
        String ccOperator;
        if (workflow == null || wfparam == null) {
            return;
        }
        if (wfparam.getNeedapprove() != null && wfparam.getNeedapprove().booleanValue()) {
            String approver = wfparam.getApprover();
            Integer approverId = null;
            if (!StringUtils.isEmpty((String)approver)) {
                approverId = Integer.valueOf(approver);
            }
            if (approverId != null && approverId > 0) {
                WfModularsWorkflowActor approve = new WfModularsWorkflowActor();
                approve.setActorDatetime(new Date());
                approve.setActorStaff(approverId);
                approve.setActorStatus((byte)1);
                approve.setActorType((byte)2);
                approve.setCid(workflow.getCid());
                approve.setIsvalid((byte)1);
                approve.setWfid(workflow.getId());
                this.actorMapper.insert(approve);
            }
        }
        if (wfparam.getApproved() != null && wfparam.getApproved().booleanValue() && !wfparam.getEnd().booleanValue()) {
            String nextapproverStr = wfparam.getNextApprover();
            Integer nextapproverId = null;
            if (!StringUtils.isEmpty((String)nextapproverStr)) {
                nextapproverId = Integer.valueOf(nextapproverStr);
            }
            WfModularsWorkflowActor nextapprover = new WfModularsWorkflowActor();
            nextapprover.setActorStaff(nextapproverId);
            nextapprover.setActorStatus((byte)1);
            nextapprover.setActorType((byte)6);
            nextapprover.setCid(workflow.getCid());
            nextapprover.setIsvalid((byte)1);
            nextapprover.setWfid(workflow.getId());
            this.actorMapper.insert(nextapprover);
        }
        if (StringUtils.isNotEmpty(ccOperator = wfparam.getCcOperator()) && ccOperator.split(",").length > 0) {
            String[] stringArray = ccOperator.split(",");
            int n = stringArray.length;
            int nextapprover = 0;
            while (nextapprover < n) {
                String actorId = stringArray[nextapprover];
                if (StringUtils.isNotEmpty(actorId) && !"0".equals(actorId)) {
                    Integer cc_staffId = Integer.valueOf(actorId);
                    WfModularsWorkflowActor nextapprover2 = new WfModularsWorkflowActor();
                    nextapprover2.setActorDatetime(new Date());
                    nextapprover2.setActorStaff(cc_staffId);
                    nextapprover2.setActorStatus((byte)2);
                    nextapprover2.setActorType((byte)5);
                    nextapprover2.setCid(workflow.getCid());
                    nextapprover2.setIsvalid((byte)1);
                    nextapprover2.setWfid(workflow.getId());
                    this.actorMapper.insert(nextapprover2);
                    cc_staffId = null;
                }
                ++nextapprover;
            }
        }
        if (!StringUtils.isEmpty((String)wfparam.getReceiver())) {
            String[] receiverIdlist;
            String[] stringArray = receiverIdlist = wfparam.getReceiver().split(",");
            int n = receiverIdlist.length;
            int n2 = 0;
            while (n2 < n) {
                String receiverId = stringArray[n2];
                if (StringUtils.isNumber(receiverId)) {
                    Integer receiver_staffId = Integer.valueOf(receiverId);
                    WfModularsWorkflowActor receiver = new WfModularsWorkflowActor();
                    receiver.setActorDatetime(new Date());
                    receiver.setActorStaff(receiver_staffId);
                    if (wfparam.getNeedfeedback() != null && wfparam.getNeedfeedback().booleanValue()) {
                        receiver.setActorStatus((byte)1);
                    } else {
                        receiver.setActorStatus((byte)3);
                    }
                    receiver.setActorType((byte)3);
                    receiver.setCid(workflow.getCid());
                    receiver.setIsvalid((byte)1);
                    receiver.setWfid(workflow.getId());
                    this.actorMapper.insert(receiver);
                    receiver_staffId = null;
                }
                ++n2;
            }
        }
    }

    public WfModularsWorkflowActor getworkflowActor(int cid, int staffid, String businessType, Integer businessId) {
        return this.actorMapper.selectworkflowActorBybis(cid, staffid, businessType, businessId);
    }

    public WfModularsWorkflowActor getworkflowActor(int staffid, int wfid) {
        return this.actorMapper.selectworkflowActorBywfid(staffid, wfid);
    }
}

