/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.workflow;

import cn.smarthse.core.dao.flow.WfModularMapper;
import cn.smarthse.core.framework.enums.ApproveResult;
import cn.smarthse.core.model.flow.WfModular;
import cn.smarthse.core.model.flow.WfModularExample;
import cn.smarthse.core.model.vo.WorkFlowParam;
import cn.smarthse.core.service.basic.pdmonitor.PdMonitorService;
import cn.smarthse.core.service.emergency.EmeDrillService;
import cn.smarthse.core.service.emergency.accident.EmeAccidentInfoService;
import cn.smarthse.core.service.emergency.material.EmeMaterialrentService;
import cn.smarthse.core.service.matter.hazardousCensus.HazardousCensusService;
import cn.smarthse.core.service.physicalcheck.PhysicalCheckService;
import cn.smarthse.core.service.physicalcheck.diseasers.PhcSuspectedOccupationalDiseasersService;
import cn.smarthse.core.service.reform.ReformPhaseService;
import cn.smarthse.core.service.sheild.ShieldRequirementService;
import cn.smarthse.core.service.train.TrainEvaluationService;
import cn.smarthse.core.service.train.TrainPlanService;
import cn.smarthse.core.service.train.TrainsummarizeService;
import cn.smarthse.core.service.workflow.SnakerEngineFacets;
import cn.smarthse.core.util.EntityUtil;
import java.util.List;
import org.snaker.engine.entity.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GeneralWorkFlowService {
    @Autowired
    private SnakerEngineFacets facets;
    @Autowired
    private ShieldRequirementService shieldRequirementService;
    @Autowired
    private PhysicalCheckService PhysicalCheckService;
    @Autowired
    private WfModularMapper wfModularMapper;
    @Autowired
    private PdMonitorService pdMonitorService;
    @Autowired
    private ReformPhaseService ReformPhaseService;
    @Autowired
    private HazardousCensusService hazardousCensusService;
    @Autowired
    private TrainPlanService trainplanService;
    @Autowired
    private TrainsummarizeService trainsummarizeService;
    @Autowired
    private TrainEvaluationService trainEvaluationService;
    @Autowired
    private EmeDrillService emeDrillService;
    @Autowired
    private EmeMaterialrentService emeMaterialrentService;
    @Autowired
    private EmeAccidentInfoService emeAccidentInfoService;
    @Autowired
    private PhcSuspectedOccupationalDiseasersService phcSuspectedOccupationalDiseasersService;

    public void initParam(WorkFlowParam param) {
        if (param.getProcessId() != null) {
            param.setProcess(this.facets.getEngine().process().getProcessById(param.getProcessId()));
        }
        if (param.getOrderId() != null) {
            Order order = this.facets.getEngine().query().getOrder(param.getOrderId());
            param.setOrder(order);
            if (order != null) {
                param.InitDataFromMap(order.getVariableMap());
            }
        }
        if (param.getTaskId() != null) {
            param.setTask(this.facets.getEngine().query().getTask(param.getTaskId()));
        }
    }

    private String doApplyTask(String businessType, Integer businessId) {
        switch (businessType) {
            case "shieldRequirement": {
                return this.shieldRequirementService.getBusinessPath(businessId, false);
            }
        }
        return "/commons/404";
    }

    private String doApproveTask(String businessType, Integer businessId) {
        switch (businessType) {
            case "shieldRequirement": {
                return this.shieldRequirementService.getBusinessPath(businessId, true);
            }
            case "pdmonitor-check": {
                return this.pdMonitorService.getBusinessPathCheck(businessId, true);
            }
            case "trainPlans": {
                return this.trainplanService.getBusinessPath(businessId, true);
            }
            case "trainSummarizes": {
                return this.trainsummarizeService.getBusinessPath(businessId, true);
            }
            case "trainEvaluations": {
                return this.trainEvaluationService.getBusinessPath(businessId, true);
            }
            case "emeDrills": {
                return this.emeDrillService.getBusinessPath(businessId, true);
            }
            case "emeMaterialrents": {
                return this.emeMaterialrentService.getBusinessPath(businessId, true);
            }
            case "emeAccidentInfos": {
                return this.emeAccidentInfoService.getBusinessPath(businessId, true);
            }
            case "suspectedDieaser": {
                return this.phcSuspectedOccupationalDiseasersService.getBusinessPath(businessId, true);
            }
        }
        return "/commons/404";
    }

    private String doInformTask(String businessType, Integer businessId) {
        switch (businessType) {
            case "shieldRequirement": {
                return "/commons/404";
            }
            case "emeDrills": {
                return this.emeDrillService.getInformPath(businessId);
            }
        }
        return "/commons/404";
    }

    private String doFeedbackTask(String businessType, Integer businessId) {
        switch (businessType) {
            case "shieldRequirement": {
                return "/commons/404";
            }
            case "pdmonitor": {
                return this.pdMonitorService.getInformPath(businessId);
            }
        }
        return "/commons/404";
    }

    public String doTask(String businessType, Integer businessId, String taskName) {
        if ("inform".equals(taskName)) {
            return this.doInformTask(businessType, businessId);
        }
        if ("read".equals(taskName)) {
            return this.doFeedbackTask(businessType, businessId);
        }
        if ("apply".equals(taskName)) {
            return this.doApplyTask(businessType, businessId);
        }
        if ("approve".equals(taskName)) {
            return this.doApproveTask(businessType, businessId);
        }
        return "/commons/404";
    }

    public String doReformTask(String businessIdList, String taskName) {
        if ("inform".equals(taskName)) {
            return this.ReformPhaseService.getInformPath(businessIdList);
        }
        if ("read".equals(taskName)) {
            return this.ReformPhaseService.getInformPath(businessIdList);
        }
        if ("apply".equals(taskName)) {
            return this.ReformPhaseService.getBusinessPath(businessIdList, 0);
        }
        if ("approve".equals(taskName)) {
            return this.ReformPhaseService.getBusinessPath(businessIdList, 1);
        }
        return this.ReformPhaseService.getBusinessPath(businessIdList, 2);
    }

    public Boolean isInChecking(Byte modularId, Byte stage, Integer solutionId) {
        WfModularExample example = new WfModularExample();
        WfModularExample.Criteria criteria = example.createCriteria();
        criteria.andModularIdEqualTo(modularId);
        criteria.andPhaseEqualTo((int)stage);
        criteria.andSolutionIdEqualTo(solutionId);
        criteria.andApproveResultEqualTo(ApproveResult.notApprove.getValue());
        List<WfModular> wfModularList = this.wfModularMapper.selectByExample(example);
        return !wfModularList.isEmpty();
    }

    public Boolean isCheckPassed(Byte modularId, Byte stage, Integer solutionId) {
        WfModularExample example = new WfModularExample();
        WfModularExample.Criteria criteria = example.createCriteria();
        criteria.andModularIdEqualTo(modularId);
        criteria.andPhaseEqualTo((int)stage);
        criteria.andSolutionIdEqualTo(solutionId);
        criteria.andApproveResultEqualTo(ApproveResult.approvePass.getValue());
        List<WfModular> wfModularList = this.wfModularMapper.selectByExample(example);
        return !wfModularList.isEmpty();
    }

    public void updateWfModularResult(WfModular record) {
        WfModularExample example = new WfModularExample();
        WfModularExample.Criteria criteria = example.createCriteria();
        criteria.andWorkflowIdEqualTo(record.getWorkflowId());
        criteria.andModularIdEqualTo(record.getModularId());
        criteria.andSolutionIdEqualTo(record.getSolutionId());
        criteria.andApproveResultEqualTo(ApproveResult.notApprove.getValue());
        WfModular wfModular = new WfModular();
        wfModular.setApproveResult(record.getApproveResult());
        wfModular.setApproveNum(record.getApproveNum());
        wfModular.setOpinion(record.getOpinion());
        EntityUtil.getInstance().setCreateAndUpdateInfo(wfModular);
        this.wfModularMapper.updateByExampleSelective(wfModular, example);
    }

    public WfModular saveWfModularInfo(WfModular record) {
        EntityUtil.getInstance().setCreateAndUpdateInfo(record);
        this.wfModularMapper.insert(record);
        return record;
    }

    public Integer getWfModularMaxApproveNum(Integer solutionId, Byte modularId, Integer phase) {
        WfModularExample example = new WfModularExample();
        example.createCriteria().andSolutionIdEqualTo(solutionId).andModularIdEqualTo(modularId).andPhaseEqualTo(phase).andApproveNumEqualToMax();
        List<WfModular> list = this.wfModularMapper.selectByExample(example);
        int maxNum = 0;
        for (WfModular wfModular : list) {
            if (wfModular.getApproveNum() == null) continue;
            int n = maxNum = maxNum > wfModular.getApproveNum() ? maxNum : wfModular.getApproveNum();
        }
        return maxNum + 1;
    }

    public List<WfModular> selectWfModularByModularIdAndSolutionIdAndStageId(Byte modularId, Integer solutionId, Integer phase) {
        WfModularExample example = new WfModularExample();
        WfModularExample.Criteria criteria = example.createCriteria();
        criteria.andModularIdEqualTo(modularId);
        criteria.andSolutionIdEqualTo(solutionId);
        criteria.andPhaseEqualTo(phase);
        List<WfModular> wfModularList = this.wfModularMapper.selectByExample(example);
        return wfModularList;
    }

    public WfModular selectWfModularByOrderId(Integer orderId) {
        WfModularExample example = new WfModularExample();
        WfModularExample.Criteria criteria = example.createCriteria();
        criteria.andWorkflowIdEqualTo(orderId);
        List<WfModular> wfModularList = this.wfModularMapper.selectByExample(example);
        return wfModularList.size() > 0 ? wfModularList.get(0) : null;
    }
}

