/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.warnmark;

import cn.smarthse.core.annotation.SYSLOG;
import cn.smarthse.core.dao.warnmark.WmMaintenanceMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.model.warnmark.WmMaintenance;
import cn.smarthse.core.model.warnmark.WmMaintenanceExample;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@SYSLOG(desc="\u8b66\u793a\u6807\u8bc6\u767b\u8bb0\u8868")
@Service
public class WmMaintenanceService {
    @Autowired
    WmMaintenanceMapper mapper;

    public List<WmMaintenance> getAll(Integer cid) {
        WmMaintenanceExample e = new WmMaintenanceExample();
        e.createCriteria().andCidEqualTo(cid).andIsvalidEqualTo(Constant.ACTIVE_YES);
        return this.mapper.selectByExample(e);
    }

    public WmMaintenance selectByPrimaryKey(Integer id) {
        return this.mapper.selectByPrimaryKey(id);
    }

    @Transactional
    public int create(WmMaintenance record) {
        record.setIsvalid(Constant.ACTIVE_YES);
        int count = this.mapper.insertSelective(record);
        return count;
    }

    @Transactional
    public int update(WmMaintenance record) {
        int count = this.mapper.updateByPrimaryKeySelective(record);
        return count;
    }

    @Transactional
    public int delete(Integer id) {
        WmMaintenance record = this.mapper.selectByPrimaryKey(id);
        record.setIsvalid(Constant.ACTIVE_NO);
        int count = this.mapper.updateByPrimaryKey(record);
        return count;
    }

    public List<WmMaintenance> search(Integer cid, Integer managerId, String mainDate1, String mainDate2) {
        WmMaintenance e = new WmMaintenance();
        e.setCid(cid);
        e.setMainManger(managerId);
        e.setMainDate1(mainDate1);
        e.setMainDate2(mainDate2);
        return this.mapper.selectParameter(e);
    }
}

