/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.train;

import cn.smarthse.core.dao.train.TrainsummarizeMapper;
import cn.smarthse.core.framework.common.util.StringUtils;
import cn.smarthse.core.framework.enums.ApproveResult;
import cn.smarthse.core.framework.enums.Modulars;
import cn.smarthse.core.model.flow.WfModular;
import cn.smarthse.core.model.train.TrainPaperFile;
import cn.smarthse.core.model.train.Trainsummarize;
import cn.smarthse.core.model.vo.WorkFlowParam;
import cn.smarthse.core.service.train.TrainPaperFileService;
import cn.smarthse.core.service.workflow.GeneralWorkFlowService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrainsummarizeService {
    @Autowired
    TrainsummarizeMapper mapper;
    @Autowired
    TrainPaperFileService fileService;
    @Autowired
    GeneralWorkFlowService workflowService;

    public List<Trainsummarize> list(Trainsummarize info) {
        return this.mapper.list(info);
    }

    public Trainsummarize get(Integer id) {
        Trainsummarize info = this.mapper.selectByPrimaryKey(id);
        info.setFiles(this.fileService.selectByPid(id));
        return info;
    }

    public int update(Trainsummarize info) {
        this.mapper.updateByPrimaryKeySelective(info);
        this.updateFiles(info.getId(), info.getFiles());
        return 1;
    }

    public int insert(Trainsummarize info) {
        this.mapper.insert(info);
        this.updateFiles(info.getId(), info.getFiles());
        return 1;
    }

    public int delete(Integer id) {
        this.fileService.deleteByPid(id);
        return this.mapper.deleteByPrimaryKey(id);
    }

    private void updateFiles(Integer pid, List<TrainPaperFile> files) {
        this.fileService.deleteByPid(pid);
        ArrayList<TrainPaperFile> addFiles = new ArrayList<TrainPaperFile>();
        if (files == null) {
            return;
        }
        for (TrainPaperFile paper : files) {
            if (!StringUtils.isNotEmpty(paper.getFileurl())) continue;
            paper.setPid(pid);
            addFiles.add(paper);
        }
        this.fileService.addBatch(addFiles);
    }

    public void end(String[] ids) {
        this.mapper.end(ids);
    }

    public void workflow(WorkFlowParam param, Integer orderId) {
        if (param.getEnd().booleanValue() && param.getApproved().booleanValue()) {
            String[] ids = new String[]{String.valueOf(param.getBusinessId())};
            this.end(ids);
        }
        if (param.getEnd().booleanValue()) {
            param.getApproved().booleanValue();
        }
    }

    public String getBusinessPath(Integer businessId, Boolean isApprove) {
        int approve = isApprove != false ? 1 : 0;
        try {
            return "forward:/trainSummarizes/info?approve=" + approve + "&id=" + businessId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "/commons/404";
        }
    }

    public String goNextState(Integer id) {
        Trainsummarize record = this.get(id);
        String url = "redirect:info?id=" + id;
        this.setNoApprove(id, Integer.parseInt(record.getPhase()), Integer.parseInt(record.getStatus()));
        String[] ids = new String[]{String.valueOf(id)};
        this.end(ids);
        return url;
    }

    private void setNoApprove(Integer id, int phase, int status) {
        WfModular wfModular = new WfModular();
        wfModular.setModularId(Modulars.TrainSummarize.getValue());
        wfModular.setPhase(phase);
        wfModular.setSolutionId(id);
        wfModular.setStatus(status);
        wfModular.setWorkflowId(null);
        wfModular.setApproveResult(ApproveResult.approvePass.getValue());
        wfModular.setApproveNum(this.workflowService.getWfModularMaxApproveNum(wfModular.getSolutionId(), wfModular.getModularId(), wfModular.getPhase()));
        this.workflowService.saveWfModularInfo(wfModular);
    }
}

