/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.train;

import cn.smarthse.core.dao.train.TrainplanMapper;
import cn.smarthse.core.framework.common.util.StringUtils;
import cn.smarthse.core.framework.enums.ApproveResult;
import cn.smarthse.core.framework.enums.Modulars;
import cn.smarthse.core.framework.enums.TrainPlanEnums;
import cn.smarthse.core.model.flow.WfModular;
import cn.smarthse.core.model.train.TrainPaperFile;
import cn.smarthse.core.model.train.Trainattend;
import cn.smarthse.core.model.train.Traindoc;
import cn.smarthse.core.model.train.Trainplan;
import cn.smarthse.core.model.train.TrainplanExample;
import cn.smarthse.core.model.train.TrainplanWithBLOBs;
import cn.smarthse.core.model.vo.WorkFlowParam;
import cn.smarthse.core.service.train.TrainPaperFileService;
import cn.smarthse.core.service.train.TrainPaperService;
import cn.smarthse.core.service.train.TrainResultService;
import cn.smarthse.core.service.train.TrainattendService;
import cn.smarthse.core.service.train.TraindocService;
import cn.smarthse.core.service.workflow.GeneralWorkFlowService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrainPlanService {
    @Autowired
    TrainplanMapper mapper;
    @Autowired
    TraindocService traindocService;
    @Autowired
    TrainattendService trainattendService;
    @Autowired
    TrainPaperService paperService;
    @Autowired
    TrainResultService trainResultService;
    @Autowired
    TrainPaperFileService fileService;
    @Autowired
    GeneralWorkFlowService workflowService;

    public List<Trainplan> list(Trainplan plan) {
        return this.mapper.list(plan);
    }

    public void insert(TrainplanWithBLOBs plan) {
        plan.setNo(String.valueOf(new Date().getTime()));
        this.mapper.insert(plan);
        this.updateTrainDocs(plan.getId(), plan.getDocs());
        this.updateTrainAttends(plan.getId(), plan.getAttends());
    }

    public void update(TrainplanWithBLOBs plan) {
        this.mapper.updateByPrimaryKeyWithBLOBs(plan);
        this.updateTrainDocs(plan.getId(), plan.getDocs());
        this.updateTrainAttends(plan.getId(), plan.getAttends());
        this.paperService.updatePaper(plan.getPaper());
    }

    public void delete(String id) {
        this.mapper.deleteByPrimaryKey(Integer.parseInt(id));
        this.traindocService.deleteByTid(Integer.parseInt(id));
        this.trainattendService.deleteByTid(Integer.parseInt(id));
        this.paperService.deleteByPid(Integer.parseInt(id));
    }

    public TrainplanWithBLOBs get(Integer id) {
        TrainplanWithBLOBs info = this.mapper.selectByPrimaryKey(id);
        info.setDocs(this.traindocService.selectByTid(id));
        info.setAttends(this.trainattendService.listByTid(id));
        info.setPaper(this.paperService.getByPid(id));
        info.setResults(this.trainResultService.selectByTid(id));
        TrainPaperFile file = new TrainPaperFile();
        file.setPid(id);
        file.setType(4);
        info.setOtherfiles(this.fileService.selectByInfo(file));
        return info;
    }

    private void updateTrainDocs(Integer tid, List<Traindoc> docs) {
        this.traindocService.deleteByTid(tid);
        if (docs == null || docs.size() == 0) {
            return;
        }
        ArrayList<Traindoc> addDocs = new ArrayList<Traindoc>();
        for (Traindoc doc : docs) {
            if (!StringUtils.isNotEmpty(doc.getType())) continue;
            doc.setTid(tid);
            addDocs.add(doc);
        }
        this.traindocService.addBatch(addDocs);
    }

    private void updateTrainAttends(Integer tid, List<Trainattend> attends) {
        this.trainattendService.deleteByTid(tid);
        if (attends == null || attends.size() == 0) {
            return;
        }
        ArrayList<Trainattend> addAttends = new ArrayList<Trainattend>();
        for (Trainattend attend : attends) {
            if (!StringUtils.isNotEmpty(attend.getUname())) continue;
            attend.setTid(tid);
            addAttends.add(attend);
        }
        this.trainattendService.addBatch(addAttends);
    }

    public void updateSelective(TrainplanWithBLOBs info) {
        this.mapper.updateByPrimaryKeySelective(info);
    }

    public void score(TrainplanWithBLOBs info) {
        this.mapper.score(info);
    }

    public void finish(TrainplanWithBLOBs info) {
        this.mapper.finish(info);
        TrainPaperFile file = new TrainPaperFile();
        file.setPid(info.getId());
        file.setType(4);
        this.updatePapers(file, info.getOtherfiles());
    }

    private void updatePapers(TrainPaperFile file, List<TrainPaperFile> files) {
        this.fileService.deleteByInfo(file);
        if (files == null || files.size() == 0) {
            return;
        }
        ArrayList<TrainPaperFile> addPapers = new ArrayList<TrainPaperFile>();
        for (TrainPaperFile paper : files) {
            if (!StringUtils.isNotEmpty(paper.getFileurl())) continue;
            paper.setPid(file.getPid());
            addPapers.add(paper);
        }
        this.fileService.addBatch(addPapers);
    }

    public void updateState(List<Integer> idList, byte status) {
        if (idList == null || idList.size() == 0) {
            return;
        }
        TrainplanExample example = new TrainplanExample();
        TrainplanExample.Criteria criteria = example.createCriteria();
        criteria.andIdIn((List)idList);
        TrainplanWithBLOBs plan = new TrainplanWithBLOBs();
        plan.setStatus(status);
        plan.setUpdatetime(new Date());
        this.mapper.updateStatus(plan, example);
    }

    public void updateState(Integer id, byte status) {
        TrainplanExample example = new TrainplanExample();
        TrainplanExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        TrainplanWithBLOBs plan = new TrainplanWithBLOBs();
        plan.setStatus(status);
        plan.setUpdatetime(new Date());
        this.mapper.updateStatus(plan, example);
    }

    public String getBusinessPath(Integer businessId, Boolean isApprove) {
        TrainplanWithBLOBs record = this.get(businessId);
        Byte phase = record.getStatus();
        TrainPlanEnums enums = TrainPlanEnums.getTrainPlanEnumsByValue(phase);
        int approve = isApprove != false ? 1 : 0;
        try {
            return "forward:/trainPlans/" + enums.getCode() + "?approve=" + approve + "&id=" + businessId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "/commons/404";
        }
    }

    public void workflow(WorkFlowParam param, Integer orderId) {
        TrainplanWithBLOBs record = this.get(param.getBusinessId());
        Byte status = record.getStatus();
        if (param.getEnd().booleanValue() && param.getApproved().booleanValue()) {
            if (record.getStatus() == 1) {
                status = 3;
            } else if (record.getStatus() == 3) {
                status = 5;
            } else if (record.getStatus() == 5) {
                status = 7;
            } else if (record.getStatus() == 7) {
                status = 9;
            }
            ArrayList<Integer> ids = new ArrayList<Integer>();
            ids.add(param.getBusinessId());
            this.updateState(ids, (byte)status);
        }
        if (param.getEnd().booleanValue()) {
            param.getApproved().booleanValue();
        }
    }

    public String goNextState(Integer id) {
        TrainplanWithBLOBs record = this.get(id);
        String url = "";
        switch (record.getStatus()) {
            case 1: {
                record.setStatus((byte)3);
                break;
            }
            case 3: {
                record.setStatus((byte)5);
                break;
            }
            case 5: {
                record.setStatus((byte)7);
                break;
            }
            case 7: {
                record.setStatus((byte)9);
                break;
            }
            default: {
                url = "/commons/404";
            }
        }
        TrainPlanEnums enums = TrainPlanEnums.getTrainPlanEnumsByValue(record.getStatus());
        url = "redirect:" + enums.getCode() + "?id=" + id;
        this.setNoApprove(id, record.getStatus(), record.getStatus());
        this.updateState(id, (byte)record.getStatus());
        return url;
    }

    private void setNoApprove(Integer id, Byte phase, Byte status) {
        WfModular wfModular = new WfModular();
        wfModular.setModularId(Modulars.TrainPlan.getValue());
        wfModular.setPhase((int)phase);
        wfModular.setSolutionId(id);
        wfModular.setStatus((int)status);
        wfModular.setWorkflowId(null);
        wfModular.setApproveResult(ApproveResult.approvePass.getValue());
        wfModular.setApproveNum(this.workflowService.getWfModularMaxApproveNum(wfModular.getSolutionId(), wfModular.getModularId(), wfModular.getPhase()));
        this.workflowService.saveWfModularInfo(wfModular);
    }
}

