/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.train;

import cn.smarthse.core.dao.train.TrainpapersMapper;
import cn.smarthse.core.framework.common.util.StringUtils;
import cn.smarthse.core.model.train.TrainPaperFile;
import cn.smarthse.core.model.train.Trainpapers;
import cn.smarthse.core.service.train.TrainPaperFileService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrainPaperService {
    @Autowired
    TrainpapersMapper mapper;
    @Autowired
    TrainPaperFileService fileService;

    public Trainpapers getByPid(Integer pid) {
        Trainpapers paper = this.mapper.getByPid(pid);
        if (paper == null) {
            return paper;
        }
        List<TrainPaperFile> paperFiles = this.fileService.selectByPid(paper.getId());
        paper.setSignfiles(this.getFilesByType(1, paperFiles));
        paper.setMedias(this.getFilesByType(2, paperFiles));
        paper.setOtherfiles(this.getFilesByType(3, paperFiles));
        return paper;
    }

    public int updatePaper(Trainpapers paper) {
        if (paper == null) {
            return 0;
        }
        if (paper.getId() == null) {
            this.mapper.insert(paper);
        } else {
            this.mapper.updateByPrimaryKeyWithBLOBs(paper);
        }
        List<TrainPaperFile> paperFiles = this.getAllFiles(paper);
        this.updatePapers(paper.getId(), paperFiles);
        return 1;
    }

    public int insert(Trainpapers paper) {
        if (paper == null) {
            return 0;
        }
        this.mapper.insert(paper);
        List<TrainPaperFile> paperFiles = this.getAllFiles(paper);
        this.updatePapers(paper.getId(), paperFiles);
        return 1;
    }

    public int deleteByPid(Integer pid) {
        this.mapper.deleteByPid(pid);
        return 1;
    }

    private List<TrainPaperFile> getAllFiles(Trainpapers paper) {
        ArrayList<TrainPaperFile> allPapers = new ArrayList<TrainPaperFile>();
        if (paper == null) {
            return allPapers;
        }
        if (paper.getSignfiles() != null && paper.getSignfiles().size() > 0) {
            allPapers.addAll(paper.getSignfiles());
        }
        if (paper.getMedias() != null && paper.getMedias().size() > 0) {
            allPapers.addAll(paper.getMedias());
        }
        if (paper.getOtherfiles() != null && paper.getOtherfiles().size() > 0) {
            allPapers.addAll(paper.getOtherfiles());
        }
        return allPapers;
    }

    private void updatePapers(Integer pid, List<TrainPaperFile> files) {
        this.fileService.deleteByPid(pid);
        if (files == null || files.size() == 0) {
            return;
        }
        ArrayList<TrainPaperFile> addPapers = new ArrayList<TrainPaperFile>();
        for (TrainPaperFile paper : files) {
            if (!StringUtils.isNotEmpty(paper.getFileurl())) continue;
            paper.setPid(pid);
            addPapers.add(paper);
        }
        this.fileService.addBatch(addPapers);
    }

    private List<TrainPaperFile> getFilesByType(Integer type, List<TrainPaperFile> files) {
        ArrayList<TrainPaperFile> papers = new ArrayList<TrainPaperFile>();
        for (TrainPaperFile paper : files) {
            if (type != paper.getType()) continue;
            papers.add(paper);
        }
        return papers;
    }
}

