/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.train;

import cn.smarthse.core.dao.train.TrainevaluationMapper;
import cn.smarthse.core.framework.enums.ApproveResult;
import cn.smarthse.core.framework.enums.Modulars;
import cn.smarthse.core.model.flow.WfModular;
import cn.smarthse.core.model.train.Trainevaluation;
import cn.smarthse.core.model.train.TrainevaluationExample;
import cn.smarthse.core.model.vo.WorkFlowParam;
import cn.smarthse.core.service.train.TrainEvaluationRangeService;
import cn.smarthse.core.service.workflow.GeneralWorkFlowService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrainEvaluationService {
    @Autowired
    TrainevaluationMapper mapper;
    @Autowired
    TrainEvaluationRangeService rangeService;
    @Autowired
    GeneralWorkFlowService workflowService;

    public List<Trainevaluation> list(Trainevaluation info) {
        TrainevaluationExample example = new TrainevaluationExample();
        TrainevaluationExample.Criteria criteria = example.createCriteria();
        if (info.getStatus() != null) {
            criteria.andStatusEqualTo(info.getStatus());
        }
        return this.mapper.selectByExample(example);
    }

    public void insert(Trainevaluation info) {
        this.mapper.insert(info);
        this.updateChildren(info);
    }

    public void update(Trainevaluation info) {
        this.mapper.updateByPrimaryKey(info);
        this.updateChildren(info);
    }

    public void updateChildren(Trainevaluation info) {
        this.rangeService.deleteByPid(info.getId());
        this.rangeService.addBatch(info.getRanges(), info.getId());
    }

    public void end(List<Integer> ids) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        TrainevaluationExample example = new TrainevaluationExample();
        TrainevaluationExample.Criteria criteria = example.createCriteria();
        criteria.andIdIn((List)ids);
        Trainevaluation data = new Trainevaluation();
        data.setStatus((byte)1);
        data.setUpdatetime(new Date());
        this.mapper.updateByExampleSelective(data, example);
    }

    public void end(Integer id) {
        TrainevaluationExample example = new TrainevaluationExample();
        TrainevaluationExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        Trainevaluation data = new Trainevaluation();
        data.setStatus((byte)1);
        data.setUpdatetime(new Date());
        this.mapper.updateByExampleSelective(data, example);
    }

    public void workflow(WorkFlowParam param, Integer orderId) {
        if (param.getEnd().booleanValue() && param.getApproved().booleanValue()) {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            ids.add(param.getBusinessId());
            this.end(ids);
        }
        if (param.getEnd().booleanValue()) {
            param.getApproved().booleanValue();
        }
    }

    public String getBusinessPath(Integer businessId, Boolean isApprove) {
        int approve = isApprove != false ? 1 : 0;
        try {
            return "forward:/trainEvaluations/info?approve=" + approve + "&id=" + businessId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "/commons/404";
        }
    }

    public Trainevaluation get(Integer id) {
        Trainevaluation data = this.mapper.selectByPrimaryKey(id);
        return data;
    }

    public void goNextState(Integer id) {
        Trainevaluation record = this.get(id);
        this.setNoApprove(id, record.getPhase().byteValue(), record.getStatus().byteValue());
        this.end(id);
    }

    private void setNoApprove(Integer id, int phase, int status) {
        WfModular wfModular = new WfModular();
        wfModular.setModularId(Modulars.TrainEvaluation.getValue());
        wfModular.setPhase(phase);
        wfModular.setSolutionId(id);
        wfModular.setStatus(status);
        wfModular.setWorkflowId(null);
        wfModular.setApproveResult(ApproveResult.approvePass.getValue());
        wfModular.setApproveNum(this.workflowService.getWfModularMaxApproveNum(wfModular.getSolutionId(), wfModular.getModularId(), wfModular.getPhase()));
        this.workflowService.saveWfModularInfo(wfModular);
    }
}

