/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.sys;

import cn.smarthse.core.dao.sys.SysRemindMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.model.sys.SysPushmessage;
import cn.smarthse.core.model.sys.SysRemind;
import cn.smarthse.core.model.sys.SysRemindExample;
import cn.smarthse.core.service.SysPushmessageService;
import cn.smarthse.core.util.DateUtil;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class SysRemindService {
    @Autowired
    SysRemindMapper sysRemindMapper;
    @Autowired
    SysPushmessageService sysPushmessageService;

    public SysRemind addSysRemind(SysRemind record) {
        this.sysRemindMapper.insertSelective(record);
        return record;
    }

    public SysRemind getSysRemindById(int id) {
        return this.sysRemindMapper.selectByPrimaryKey(id);
    }

    public int updateSysRemind(SysRemind record) {
        return this.sysRemindMapper.updateByPrimaryKey(record);
    }

    public int deleteSysRemindByID(int id) {
        return this.sysRemindMapper.deleteByPrimaryKey(id);
    }

    public List<SysRemind> getSysRemindListByExample(SysRemindExample example) {
        return this.sysRemindMapper.selectByExample(example);
    }

    public List<SysRemind> getNoRemindListByJob() {
        SysRemindExample example = new SysRemindExample();
        example.createCriteria().andIsremindEqualTo((byte)0).andIsactiveEqualTo((byte)1).andReminddatetimeBetween(DateUtil.addMinutes((Date)new Date(), (int)-1), DateUtil.addMinutes((Date)new Date(), (int)1));
        example.setOrderByClause(" reminddatetime asc");
        return this.sysRemindMapper.selectByExample(example);
    }

    @Transactional
    public int processRemind(SysRemind n) {
        n.setIsremind((byte)1);
        this.sysRemindMapper.updateByPrimaryKey(n);
        if (n.getCid() == null || n.getCid() == 0 || StringUtils.isEmpty((String)n.getTitle()) || n.getRemindstaffid() == null || n.getRemindstaffid() == 0) {
            return 0;
        }
        SysPushmessage pushmessage = new SysPushmessage();
        pushmessage.setCid(n.getCid());
        pushmessage.setIsactive(Constant.ACTIVE_YES);
        pushmessage.setTitle(n.getTitle());
        pushmessage.setMessageno(n.getBusinessno());
        pushmessage.setProcessname(n.getBusinessname());
        pushmessage.setMessagetype(2);
        pushmessage.setProcessurl(n.getRemindurl());
        pushmessage.setSenderdatetime(new Date());
        pushmessage.setSenderuserid(n.getCreateuserid());
        pushmessage.setTostaffids(String.valueOf(n.getRemindstaffid()));
        this.sysPushmessageService.addSysPushmessage(pushmessage);
        return 1;
    }
}

