/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.sys;

import cn.smarthse.core.dao.sys.SysAreaMapper;
import cn.smarthse.core.dao.sys.SysDistrict2Mapper;
import cn.smarthse.core.model.sys.SysArea;
import cn.smarthse.core.model.sys.SysAreaExample;
import cn.smarthse.core.model.sys.SysDistrict2;
import cn.smarthse.core.model.sys.SysDistrict2Example;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class DistrictService {
    @Autowired
    SysDistrict2Mapper sysDistrict2Mapper;
    @Autowired
    SysAreaMapper sysAreaMapper;

    public SysDistrict2 addSysDistrict2(SysDistrict2 record) {
        this.sysDistrict2Mapper.insertSelective(record);
        return record;
    }

    public SysDistrict2 getSysDistrict2ById(Long id) {
        return this.sysDistrict2Mapper.selectByPrimaryKey(id);
    }

    public int updateSysDistrict2(SysDistrict2 record) {
        return this.sysDistrict2Mapper.updateByPrimaryKeySelective(record);
    }

    public List<SysDistrict2> getSysDistrict2ListByExample(SysDistrict2Example example) {
        return this.sysDistrict2Mapper.selectByExample(example);
    }

    @Cacheable(value={"default"}, key="'district-provincelist'")
    public List<SysDistrict2> getAllProvince() {
        SysDistrict2Example e = new SysDistrict2Example();
        SysDistrict2Example.Criteria c = e.createCriteria();
        c.andStatusEqualTo(1);
        c.andParentIdEqualTo(0L);
        c.andLevelEqualTo(1);
        return this.sysDistrict2Mapper.selectByExample(e);
    }

    @Cacheable(value={"default"}, key="'district-citylist-p' + #provinceId ")
    public List<SysDistrict2> getCityList(Long provinceId) {
        SysDistrict2Example e = new SysDistrict2Example();
        SysDistrict2Example.Criteria c = e.createCriteria();
        c.andStatusEqualTo(1);
        c.andLevelEqualTo(2);
        c.andParentIdEqualTo(provinceId);
        return this.sysDistrict2Mapper.selectByExample(e);
    }

    @Cacheable(value={"default"}, key="'district-arealist-c' + #cityId ")
    public List<SysDistrict2> getAreaList(Long cityId) {
        SysDistrict2Example e = new SysDistrict2Example();
        SysDistrict2Example.Criteria c = e.createCriteria();
        c.andStatusEqualTo(1);
        c.andParentIdEqualTo(cityId);
        c.andLevelEqualTo(3);
        return this.sysDistrict2Mapper.selectByExample(e);
    }

    @Cacheable(value={"default"}, key="'district-streetlist-a' + #areaId ")
    public List<SysDistrict2> getStreetList(Long areaId) {
        SysDistrict2Example e = new SysDistrict2Example();
        SysDistrict2Example.Criteria c = e.createCriteria();
        c.andStatusEqualTo(1);
        c.andParentIdEqualTo(areaId);
        c.andLevelEqualTo(4);
        return this.sysDistrict2Mapper.selectByExample(e);
    }

    public SysArea addSysArea(SysArea record) {
        this.sysAreaMapper.insertSelective(record);
        return record;
    }

    public SysArea getSysAreaById(Long id) {
        return this.sysAreaMapper.selectByPrimaryKey(id);
    }

    public int updateSysArea(SysArea record) {
        return this.sysAreaMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteSysAreaByID(Long id) {
        return this.sysAreaMapper.deleteByPrimaryKey(id);
    }

    public List<SysArea> getSysAreaListByExample(SysAreaExample example) {
        return this.sysAreaMapper.selectByExample(example);
    }
}

