/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.sheild;

import cn.smarthse.core.dao.shield.ShieldfetchrecordMapper;
import cn.smarthse.core.dao.shield.ShieldsendMapper;
import cn.smarthse.core.framework.common.util.StringUtils;
import cn.smarthse.core.model.shield.Shieldfetchrecord;
import cn.smarthse.core.model.shield.ShieldfetchrecordExample;
import cn.smarthse.core.model.shield.Shieldsend;
import cn.smarthse.core.model.shield.ShieldsendExample;
import cn.smarthse.core.service.sheild.ShieldfetchdetailService;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShieldsendSevice {
    @Autowired
    ShieldsendMapper mapper;
    @Autowired
    ShieldfetchdetailService detailService;
    @Autowired
    ShieldfetchrecordMapper recordMapper;

    public List<Shieldsend> selectBySend(Shieldsend record, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        return this.mapper.selectBySend(record);
    }

    public List<Shieldsend> selectBySend(Shieldsend record) {
        return this.mapper.selectBySend(record);
    }

    public void delete(Integer id) {
        this.mapper.deleteByPrimaryKey(id);
    }

    public void insert(Shieldsend data) {
        this.mapper.insert(data);
    }

    public void update(Shieldsend data) {
        this.mapper.updateByPrimaryKey(data);
    }

    public Shieldsend selectInfoById(Integer id) {
        Shieldsend send = this.mapper.selectById(id);
        Shieldfetchrecord record = new Shieldfetchrecord();
        record.setSendid(id);
        send.setRecords(this.recordMapper.selectListByInfo(record));
        return send;
    }

    public void updateRecords(String recordids, Integer sendid) {
        if (StringUtils.isEmpty((String)recordids)) {
            return;
        }
        ShieldfetchrecordExample example = new ShieldfetchrecordExample();
        ShieldfetchrecordExample.Criteria criteria = example.createCriteria();
        List<Integer> ids = StringUtils.parseToIntegerList(recordids);
        criteria.andIdIn((List)ids);
        Shieldfetchrecord record = new Shieldfetchrecord();
        record.setSendid(sendid);
        this.recordMapper.updateByExampleSelective(record, example);
    }

    public void insertOrUpdateRecord(Shieldfetchrecord record) {
        if (record.getId() != null) {
            this.recordMapper.updateByPrimaryKey(record);
        } else {
            this.recordMapper.insert(record);
        }
        this.detailService.updateDetails(record.getDetails(), record.getId());
    }

    public Shieldfetchrecord getFetchRecordById(Integer id) {
        Shieldfetchrecord query = new Shieldfetchrecord();
        query.setId(id);
        List<Shieldfetchrecord> records = this.recordMapper.selectListByInfo(query);
        Shieldfetchrecord record = null;
        record = records != null && records.size() > 0 ? records.get(0) : new Shieldfetchrecord();
        return record;
    }

    public void deleteDetails(Integer recordid) {
        this.recordMapper.deleteByPrimaryKey(recordid);
        this.detailService.deleteDetailsByRecordId(recordid);
    }

    public void delete(List<Integer> idList) {
        if (idList == null || idList.size() == 0) {
            return;
        }
        ShieldsendExample example = new ShieldsendExample();
        example.createCriteria().andIdIn((List)idList);
        this.mapper.deleteByExample(example);
    }
}

