/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.sheild;

import cn.smarthse.core.dao.shield.ShieldrequirementdetailMapper;
import cn.smarthse.core.framework.common.util.StringUtils;
import cn.smarthse.core.model.shield.ShieldSpecRelation;
import cn.smarthse.core.model.shield.ShieldrequirementWithBLOBs;
import cn.smarthse.core.model.shield.Shieldrequirementdetail;
import cn.smarthse.core.model.shield.Shieldsend;
import cn.smarthse.core.service.sheild.ShieldRequirementService;
import cn.smarthse.core.service.sheild.ShieldsendSevice;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShieldrequirementdetailService {
    @Autowired
    ShieldrequirementdetailMapper mapper;
    @Autowired
    ShieldsendSevice shieldsendService;
    @Autowired
    ShieldRequirementService requireServce;

    public List<Shieldrequirementdetail> selectByInfo(Shieldrequirementdetail record) {
        return this.mapper.selectByInfo(record);
    }

    public int updateDetail(Integer pid, List<Shieldrequirementdetail> details) {
        this.mapper.deleteByPid(pid);
        if (details == null || details.size() == 0) {
            return 0;
        }
        return this.mapper.insertDetails(details);
    }

    public int updateDetailById(Shieldrequirementdetail detail, String records) {
        if (detail.getId() == null) {
            this.mapper.insert(detail);
            this.addSendInfo(detail);
        } else {
            this.mapper.updateDetailById(detail);
        }
        this.updateRelations(detail.getId(), records);
        return 1;
    }

    private List<ShieldSpecRelation> updateRelations(Integer recordId, String records) {
        String[] recordArray;
        ArrayList<ShieldSpecRelation> relations = new ArrayList<ShieldSpecRelation>();
        this.mapper.deleteRelations(recordId);
        if (!StringUtils.isNotEmpty(records)) {
            return relations;
        }
        String[] stringArray = recordArray = records.split(",");
        int n = recordArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] recordInfo;
            String record = stringArray[n2];
            if (StringUtils.isNotEmpty(record) && (recordInfo = record.split("_")).length >= 2) {
                ShieldSpecRelation relation = new ShieldSpecRelation();
                relation.setRecordid(recordId);
                String[] shieldAndSpec = recordInfo[0].split(":");
                if (shieldAndSpec.length >= 2) {
                    relation.setSpecid(Integer.parseInt(shieldAndSpec[1]));
                    relation.setShieldtype(shieldAndSpec[0]);
                    relation.setAmount(Integer.parseInt(recordInfo[1]));
                    relations.add(relation);
                }
            }
            ++n2;
        }
        if (relations.size() > 0) {
            this.mapper.insertDetailRelations(relations);
        }
        return relations;
    }

    private void addSendInfo(Shieldrequirementdetail requireDetail) {
        ShieldrequirementWithBLOBs require = this.requireServce.selectByPrimaryKey(requireDetail.getSurveyid());
        Shieldsend send = new Shieldsend();
        send.setReqid(requireDetail.getId());
        send.setWorkname(require.getWorkname());
        send.setSendno(require.getBatchno());
        send.setStatus(0);
        this.shieldsendService.insert(send);
    }

    public int deleteDetailById(Integer id) {
        return this.mapper.deleteByPrimaryKey(id);
    }

    public Shieldrequirementdetail getDetailById(Integer id) {
        if (id == null) {
            return new Shieldrequirementdetail();
        }
        return this.mapper.selectByPrimaryKey(id);
    }

    public List<ShieldSpecRelation> selectShieldSpecRelation(Integer recordid) {
        return this.mapper.selectShieldSpecRelation(recordid);
    }

    public List<Shieldrequirementdetail> selectShields(Shieldrequirementdetail detail) {
        return this.mapper.selectShields(detail);
    }

    public List<Shieldrequirementdetail> countDetails(Integer surveyId) {
        return this.mapper.countDetails(surveyId);
    }
}

