/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.sheild;

import cn.smarthse.core.dao.shield.ShieldpurchaseMapper;
import cn.smarthse.core.dao.shield.ShieldpurchasedetailMapper;
import cn.smarthse.core.model.shield.Shieldpurchase;
import cn.smarthse.core.model.shield.Shieldpurchasedetail;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShieldpurchaseService {
    @Autowired
    ShieldpurchaseMapper mapper;
    @Autowired
    ShieldpurchasedetailMapper detailMapper;

    public List<Shieldpurchase> selectByPurchase(Shieldpurchase param, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        return this.mapper.selectByPurchase(param);
    }

    public Shieldpurchase selectDetailById(Integer id) {
        Shieldpurchase result = null;
        Shieldpurchase param = new Shieldpurchase();
        param.setId(id);
        List<Shieldpurchase> purchases = this.mapper.selectByPurchase(param);
        if (purchases != null && purchases.size() > 0) {
            result = purchases.get(0);
            Shieldpurchasedetail detail = new Shieldpurchasedetail();
            detail.setBuyid(id);
            result.setDetails(this.mapper.selectDetailsByPid(detail));
        } else {
            result = new Shieldpurchase();
        }
        return result;
    }

    public int update(Shieldpurchase purchase) {
        this.mapper.updateByPrimaryKey(purchase);
        this.updateDetails(purchase);
        return 1;
    }

    public int insert(Shieldpurchase purchase) {
        purchase.setUpdatetime(new Date());
        this.mapper.insert(purchase);
        this.updateDetails(purchase);
        return 1;
    }

    private void updateDetails(Shieldpurchase purchase) {
        Integer buyid = purchase.getId();
        Shieldpurchasedetail detail = new Shieldpurchasedetail();
        detail.setBuyid(buyid);
        this.mapper.deleteDetails(detail);
        List<Shieldpurchasedetail> details = purchase.getDetails();
        if (details == null || details.size() == 0) {
            return;
        }
        ArrayList<Shieldpurchasedetail> insertDetails = new ArrayList<Shieldpurchasedetail>();
        for (Shieldpurchasedetail sd : details) {
            if (sd.getShieldid() == null) continue;
            sd.setBuyid(buyid);
            insertDetails.add(sd);
        }
        if (insertDetails.size() > 0) {
            this.mapper.insertDetailBach(insertDetails);
        }
    }

    public int delete(Integer id) {
        return this.mapper.deleteByPrimaryKey(id);
    }

    public int deleteDetailById(Integer id) {
        Shieldpurchasedetail detail = new Shieldpurchasedetail();
        detail.setId(id);
        return this.mapper.deleteDetails(detail);
    }

    public List<Shieldpurchase> selectByPurchase(Shieldpurchase purchase) {
        return this.mapper.selectByPurchase(purchase);
    }
}

