/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.sheild;

import cn.smarthse.core.dao.shield.ShieldSpecMapper;
import cn.smarthse.core.model.shield.ShieldSpec;
import cn.smarthse.core.model.shield.ShieldSpecRelation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShieldSpecService {
    @Autowired
    ShieldSpecMapper mapper;

    public List<ShieldSpec> list(ShieldSpec spec) {
        return this.mapper.list(spec);
    }

    public List<ShieldSpec> listSpec(ShieldSpec spec) {
        return this.mapper.listSpec(spec);
    }

    public Map<String, List<ShieldSpec>> findMap(ShieldSpec spec) {
        HashMap<String, List<ShieldSpec>> map = new HashMap<String, List<ShieldSpec>>();
        List<ShieldSpec> list = this.mapper.listSpec(spec);
        for (ShieldSpec e : list) {
            String type = e.getType();
            List<ShieldSpec> hasList = map.get(type) == null ? new ArrayList() : (List)map.get(type);
            hasList.add(e);
            map.put(type, hasList);
        }
        return map;
    }

    public Map<String, List<ShieldSpec>> findMapByRelation(ShieldSpecRelation relation) {
        HashMap<String, List<ShieldSpec>> map = new HashMap<String, List<ShieldSpec>>();
        List<ShieldSpec> list = this.mapper.findListByRelation(relation);
        for (ShieldSpec e : list) {
            String type = e.getType();
            List<ShieldSpec> hasList = map.get(type) == null ? new ArrayList() : (List)map.get(type);
            hasList.add(e);
            map.put(type, hasList);
        }
        return map;
    }

    public List<ShieldSpec> findListByRelation(ShieldSpecRelation relation) {
        return this.mapper.findListByRelation(relation);
    }
}

