/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.sheild;

import cn.smarthse.core.dao.shield.ShieldrequirementMapper;
import cn.smarthse.core.framework.common.util.StringUtils;
import cn.smarthse.core.framework.enums.ApproveResult;
import cn.smarthse.core.framework.enums.Modulars;
import cn.smarthse.core.model.flow.WfModular;
import cn.smarthse.core.model.shield.Shieldrequirement;
import cn.smarthse.core.model.shield.ShieldrequirementExample;
import cn.smarthse.core.model.shield.ShieldrequirementWithBLOBs;
import cn.smarthse.core.model.shield.Shieldrequirementdetail;
import cn.smarthse.core.model.vo.WorkFlowParam;
import cn.smarthse.core.service.sheild.ShieldrequirementdetailService;
import cn.smarthse.core.service.workflow.GeneralWorkFlowService;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShieldRequirementService {
    @Autowired
    ShieldrequirementMapper mapper;
    @Autowired
    ShieldrequirementdetailService detailService;
    @Autowired
    GeneralWorkFlowService workflowService;

    public List<Shieldrequirement> selectByEquipment(Shieldrequirement query, int pageNum, int pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        ShieldrequirementExample example = new ShieldrequirementExample();
        ShieldrequirementExample.Criteria criteria = example.createCriteria();
        if (query.getStatus() == null) {
            criteria.andStatusEqualTo(Byte.parseByte("0"));
        } else {
            criteria.andStatusEqualTo(query.getStatus());
        }
        return this.mapper.selectByExample(example);
    }

    public ShieldrequirementWithBLOBs selectByPrimaryKey(Integer id) {
        return this.mapper.selectByPrimaryKey(id);
    }

    public int insert(ShieldrequirementWithBLOBs record) {
        record.setPhase((byte)1);
        record.setStatus(Byte.valueOf("0"));
        record.setIsvalid(Byte.valueOf("1"));
        return this.mapper.insert(record);
    }

    public int update(ShieldrequirementWithBLOBs record) {
        return this.mapper.updateByPrimaryKeyWithBLOBs(record);
    }

    public void workflow(WorkFlowParam param, Integer orderId) {
        ShieldrequirementWithBLOBs record = this.selectByPrimaryKey(param.getBusinessId());
        record.setWorkflowid(orderId);
        if (param.getEnd().booleanValue() && param.getApproved().booleanValue()) {
            switch (record.getPhase()) {
                case 1: {
                    record.setPhase((byte)2);
                    break;
                }
                case 2: {
                    record.setPhase((byte)3);
                    break;
                }
                case 3: {
                    record.setPhase((byte)4);
                    record.setStatus((byte)1);
                    break;
                }
            }
        }
        this.updatePhase(record);
    }

    public int updatePhase(Shieldrequirement record) {
        return this.mapper.updatePhase(record);
    }

    public ShieldrequirementWithBLOBs selectDetailById(Integer id) {
        ShieldrequirementWithBLOBs data = this.mapper.selectDetailById(id);
        return data;
    }

    public List<ShieldrequirementWithBLOBs> selectList(Shieldrequirement query) {
        return this.mapper.selectList(query);
    }

    public int updateDetail(ShieldrequirementWithBLOBs require, String joiner) {
        String[] deptIdAndStaffIds;
        this.mapper.updateByPrimaryKeySelective(require);
        if (!StringUtils.isNotEmpty(joiner)) {
            return 0;
        }
        ArrayList<Shieldrequirementdetail> details = new ArrayList<Shieldrequirementdetail>();
        String[] stringArray = deptIdAndStaffIds = joiner.split(",");
        int n = deptIdAndStaffIds.length;
        int n2 = 0;
        while (n2 < n) {
            String deptIdAndStaffId = stringArray[n2];
            if (StringUtils.isNotEmpty(joiner) && deptIdAndStaffId.indexOf("_") >= 0) {
                String[] ids = deptIdAndStaffId.split("_");
                Shieldrequirementdetail detail = new Shieldrequirementdetail();
                detail.setSurveyid(require.getId());
                detail.setDeptid(Integer.parseInt(ids[0]));
                detail.setManager(Integer.parseInt(ids[1]));
                details.add(detail);
            }
            ++n2;
        }
        return this.detailService.updateDetail(require.getId(), details);
    }

    public String getBusinessPath(Integer businessId, Boolean isApprove) {
        ShieldrequirementWithBLOBs requirement = this.selectByPrimaryKey(businessId);
        switch (requirement.getPhase()) {
            case 1: {
                if (isApprove.booleanValue()) {
                    return "forward:/device/shieldRequirements/info?approve=1&id=" + businessId;
                }
                return "forward:/device/shieldRequirements/info?approve=0&id=" + businessId;
            }
            case 2: {
                if (isApprove.booleanValue()) {
                    return "forward:/device/shieldRequirements/start?approve=1&id=" + businessId;
                }
                return "forward:/device/shieldRequirements/start?approve=0&id=" + businessId;
            }
            case 3: {
                if (isApprove.booleanValue()) {
                    return "forward:/device/shieldRequirements/count?approve=1&id=" + businessId;
                }
                return "forward:/device/shieldRequirements/count?approve=0&id=" + businessId;
            }
            case 4: {
                return "forward:/device/shieldRequirements/countInfo?id=" + businessId;
            }
        }
        return "/commons/404";
    }

    public String goNextState(Integer id) {
        ShieldrequirementWithBLOBs requirement = this.selectByPrimaryKey(id);
        String url = "";
        switch (requirement.getPhase()) {
            case 1: {
                requirement.setPhase((byte)2);
                url = "redirect:/device/shieldRequirements/start?id=" + id;
                break;
            }
            case 2: {
                requirement.setPhase((byte)3);
                url = "redirect:/device/shieldRequirements/count?id=" + id;
                break;
            }
            case 3: {
                requirement.setPhase((byte)4);
                requirement.setStatus((byte)1);
                url = "redirect:/device/shieldRequirements/countInfo?&id=" + id;
                break;
            }
            default: {
                url = "/commons/404";
            }
        }
        this.setNoApprove(id, requirement.getPhase(), requirement.getStatus());
        this.updatePhase(requirement);
        return url;
    }

    public void updateState(List<Integer> ids, byte state) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        ShieldrequirementExample example = new ShieldrequirementExample();
        ShieldrequirementExample.Criteria criteria = example.createCriteria();
        criteria.andIdIn((List)ids);
        ShieldrequirementWithBLOBs record = new ShieldrequirementWithBLOBs();
        record.setStatus(state);
        this.mapper.updateByExampleSelective(record, example);
    }

    private void setNoApprove(Integer id, Byte phase, Byte status) {
        WfModular wfModular = new WfModular();
        wfModular.setModularId(Modulars.shieldRequirement.getValue());
        wfModular.setPhase((int)phase);
        wfModular.setSolutionId(id);
        wfModular.setStatus((int)status);
        wfModular.setWorkflowId(null);
        wfModular.setApproveResult(ApproveResult.approvePass.getValue());
        wfModular.setApproveNum(this.workflowService.getWfModularMaxApproveNum(wfModular.getSolutionId(), wfModular.getModularId(), wfModular.getPhase()));
        this.workflowService.saveWfModularInfo(wfModular);
    }

    public void delete(List<Integer> idList) {
        if (idList == null || idList.size() == 0) {
            return;
        }
        ShieldrequirementExample example = new ShieldrequirementExample();
        example.createCriteria().andIdIn((List)idList);
        this.mapper.deleteByExample(example);
    }
}

