/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.sheild;

import cn.smarthse.core.dao.shield.ShieldequipmentMapper;
import cn.smarthse.core.framework.common.util.StringUtils;
import cn.smarthse.core.model.shield.Shieldequipment;
import cn.smarthse.core.model.shield.ShieldequipmentExample;
import com.github.pagehelper.PageHelper;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShieldEquipmentService {
    @Autowired
    ShieldequipmentMapper shieldequipmentMapper;

    public List<Shieldequipment> selectByExample(ShieldequipmentExample example) {
        return this.shieldequipmentMapper.selectByExample(example);
    }

    public List<Shieldequipment> selectByEquipment(Shieldequipment equipment, int pageNum, int pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        ShieldequipmentExample example = new ShieldequipmentExample();
        ShieldequipmentExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isNull(equipment.getShieldno())) {
            criteria.andShieldnoLike("%" + equipment.getShieldno() + "%");
        }
        if (StringUtils.isNull(equipment.getDescription())) {
            criteria.andDescriptionLike("%" + equipment.getDescription() + "%");
        }
        return this.shieldequipmentMapper.selectByExample(example);
    }

    public int updateEquipment(Shieldequipment equipment) {
        if (equipment.getId() != null) {
            return this.shieldequipmentMapper.updateByPrimaryKey(equipment);
        }
        equipment.setShieldno(String.valueOf(new Date().getTime()));
        return this.shieldequipmentMapper.insert(equipment);
    }

    public Shieldequipment selectByPrimaryKey(Integer id) {
        return this.shieldequipmentMapper.selectByPrimaryKey(id);
    }

    public int del(Integer id) {
        return this.shieldequipmentMapper.deleteByPrimaryKey(id);
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < 1000) {
            UUID uid = UUID.randomUUID();
            System.out.println(uid + "   " + uid.toString());
            ++i;
        }
    }

    public Shieldequipment selectDetailByPrimaryKey(Integer id) {
        return this.shieldequipmentMapper.selectDetailByPrimaryKey(id);
    }
}

