/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.sheild;

import cn.smarthse.core.dao.shield.EquipworkroleMapper;
import cn.smarthse.core.dao.shield.EquipworkroleheaderMapper;
import cn.smarthse.core.framework.common.util.StringUtils;
import cn.smarthse.core.model.shield.EquipWorkRoleGroup;
import cn.smarthse.core.model.shield.EquipWorkRoleQueryParams;
import cn.smarthse.core.model.shield.Equipworkrole;
import cn.smarthse.core.model.shield.EquipworkroleExample;
import cn.smarthse.core.model.shield.EquipworkroleVO;
import cn.smarthse.core.model.shield.Equipworkroleheader;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EquipWorkRoleService {
    @Autowired
    EquipworkroleMapper equipworkroleMapper;
    @Autowired
    EquipworkroleheaderMapper headerMapper;

    public int countByExample(EquipworkroleExample example) {
        return this.equipworkroleMapper.countByExample(example);
    }

    public int deleteByPrimaryKey(Integer id) {
        return this.equipworkroleMapper.deleteByPrimaryKey(id);
    }

    public int insert(Equipworkrole record) {
        return this.equipworkroleMapper.insert(record);
    }

    public List<Equipworkrole> selectByExample(EquipworkroleExample example) {
        return this.equipworkroleMapper.selectByExample(example);
    }

    public Equipworkrole selectByPrimaryKey(Integer id) {
        return this.equipworkroleMapper.selectByPrimaryKey(id);
    }

    public int updateByPrimaryKey(Equipworkrole record) {
        return this.equipworkroleMapper.updateByPrimaryKey(record);
    }

    public List<EquipworkroleVO> pageEquipWorkRole(EquipWorkRoleQueryParams params) {
        return this.equipworkroleMapper.pageEquipWorkRole(params);
    }

    public List<EquipworkroleVO> listAll(EquipWorkRoleQueryParams params) {
        return this.equipworkroleMapper.listAll(params);
    }

    public Integer countEquipWorkRole(EquipWorkRoleQueryParams params) {
        return this.equipworkroleMapper.countEquipWorkRole(params);
    }

    public EquipworkroleVO selectById(Integer id) {
        return this.equipworkroleMapper.selectById(id);
    }

    public int create(EquipWorkRoleGroup group, String workId) {
        if (!StringUtils.isNotEmpty(workId)) {
            return 0;
        }
        this.equipworkroleMapper.deleteByWorkId(workId);
        List<EquipworkroleVO> vos = group.getList();
        ArrayList<EquipworkroleVO> params = new ArrayList<EquipworkroleVO>();
        for (EquipworkroleVO vo : vos) {
            if (!StringUtils.isNotEmpty(vo.getShieldType())) continue;
            vo.setWorkId(group.getWorkId());
            vo.setCustomCycle(vo.getCount() + vo.getCountUnit() + "/" + vo.getCycle() + vo.getCycleUnit());
            params.add(vo);
        }
        if (params == null || params.size() == 0) {
            return 0;
        }
        return this.equipworkroleMapper.insertBatch(params);
    }

    public int create(EquipWorkRoleGroup group) {
        if (!StringUtils.isNotEmpty(group.getWorkId())) {
            return 0;
        }
        this.equipworkroleMapper.deleteByWorkId(group.getWorkId());
        List<EquipworkroleVO> vos = group.getList();
        ArrayList<EquipworkroleVO> params = new ArrayList<EquipworkroleVO>();
        for (EquipworkroleVO vo : vos) {
            if (!StringUtils.isNotEmpty(vo.getShieldType())) continue;
            vo.setWorkId(group.getWorkId());
            vo.setCustomCycle(vo.getCount() + vo.getCountUnit() + "/" + vo.getCycle() + vo.getCycleUnit());
            params.add(vo);
        }
        if (params == null || params.size() == 0) {
            return 0;
        }
        return this.equipworkroleMapper.insertBatch(params);
    }

    public int insertOrUpdate(Equipworkroleheader header) {
        if (header.getId() != null) {
            this.headerMapper.updateByPrimaryKey(header);
        } else {
            this.headerMapper.insert(header);
        }
        this.equipworkroleMapper.deleteByHeaderId(header.getId());
        List<EquipworkroleVO> vos = header.getList();
        ArrayList<EquipworkroleVO> params = new ArrayList<EquipworkroleVO>();
        for (EquipworkroleVO vo : vos) {
            if (!StringUtils.isNotEmpty(vo.getShieldType())) continue;
            vo.setWorkId(String.valueOf(header.getWorkid()));
            vo.setHeaderid(header.getId());
            vo.setCustomCycle(vo.getCount() == null ? "" : (vo.getCount() + vo.getCountUnit() + "/" + vo.getCycle() == null ? "" : vo.getCycle() + vo.getCycleUnit()));
            params.add(vo);
        }
        if (params == null || params.size() == 0) {
            return 0;
        }
        return this.equipworkroleMapper.insertBatch(params);
    }

    public List<EquipworkroleVO> selectByWorkId(Integer workId) {
        return this.equipworkroleMapper.selectByWorkId(workId);
    }

    public int deleteByWorkId(String workId) {
        return this.equipworkroleMapper.deleteByWorkId(workId);
    }

    public List<Equipworkroleheader> listDetails(EquipWorkRoleQueryParams params) {
        return this.headerMapper.listDetails(params);
    }

    public void deleteByHeaderId(Integer id) {
        this.equipworkroleMapper.deleteByHeaderId(id);
        this.headerMapper.deleteByPrimaryKey(id);
    }

    public Equipworkroleheader getDetail(Integer id) {
        return this.headerMapper.getDetail(id);
    }
}

