/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.security;

import cn.smarthse.core.dao.basic.StaffMapper;
import cn.smarthse.core.dao.basic.UserMapper;
import cn.smarthse.core.dao.security.SecUserroleMapper;
import cn.smarthse.core.dao.sys.SyslogMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.framework.common.util.ehcache.EHCacheUtil;
import cn.smarthse.core.framework.utils.Digests;
import cn.smarthse.core.framework.utils.EncodeUtils;
import cn.smarthse.core.model.basic.Staff;
import cn.smarthse.core.model.basic.User;
import cn.smarthse.core.model.basic.UserExample;
import cn.smarthse.core.model.security.SecPermission;
import cn.smarthse.core.model.security.SecRole;
import cn.smarthse.core.model.security.SecUserrole;
import cn.smarthse.core.model.security.SecUserroleExample;
import cn.smarthse.core.model.sys.Syslog;
import cn.smarthse.core.model.sys.SyslogExample;
import cn.smarthse.core.model.vo.QueryLogParam;
import cn.smarthse.core.service.basic.staff.StaffService;
import cn.smarthse.core.service.security.RoleManager;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserManager {
    public static final String HASH_ALGORITHM = "SHA-1";
    public static final int HASH_INTERATIONS = 1024;
    private static final int SALT_SIZE = 8;
    @Autowired
    private SyslogMapper SyslogMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private StaffMapper staffMapper;
    @Autowired
    private StaffService StaffService;
    @Autowired
    private SecUserroleMapper secUserroleMapper;
    @Autowired
    private RoleManager RoleManager;

    public void initCompanyInfo(Integer cid) {
        List<Map<String, String>> list = this.staffMapper.selectUserAll(cid);
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (Map<String, String> m : list) {
            map.put((Integer)((Object)m.get("id")), String.valueOf(m.get("orgname")) + "/" + m.get("realname"));
        }
        List<Map<Integer, String>> list2 = this.staffMapper.selectStaffAll(cid);
        HashMap<Integer, String> map2 = new HashMap<Integer, String>();
        for (Map<Integer, String> m : list2) {
            map2.put((Integer)((Object)m.get("id")), String.valueOf(m.get("orgname")) + "/" + m.get("realname"));
        }
        List<Map<Integer, String>> list3 = this.staffMapper.selectOrgAll(cid);
        HashMap<Integer, String> map3 = new HashMap<Integer, String>();
        for (Map<Integer, String> m : list3) {
            map3.put((Integer)((Object)m.get("id")), m.get("orgname"));
        }
        EHCacheUtil.initCacheManager();
        EHCacheUtil.put("userNameMap", map);
        EHCacheUtil.put("staffNameMap", map2);
        EHCacheUtil.put("orgNameMap", map3);
    }

    public User getUserById(Integer id) {
        return this.userMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"default"}, key="'User-byname-' + #name")
    public User getByName(String name) {
        UserExample e = new UserExample();
        e.createCriteria().andUsernameEqualTo(name);
        List<User> list = this.userMapper.selectByExample(e);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @CacheEvict(value={"default"}, key="'User-byname-' + #name")
    public void clearUserByNameCache(String name) {
    }

    public List<SecRole> getRoleList(Integer id) {
        ArrayList<SecRole> roleList = new ArrayList<SecRole>();
        SecUserroleExample e = new SecUserroleExample();
        e.createCriteria().andUidEqualTo(id).andIsactiveEqualTo(Constant.ACTIVE_YES);
        List<SecUserrole> list = this.secUserroleMapper.selectByExample(e);
        for (SecUserrole userrole : list) {
            SecRole role = this.RoleManager.getById(userrole.getRid());
            roleList.add(role);
        }
        return roleList;
    }

    public List<User> getAll(Integer cid, Integer pageNumber, Integer pageSize) {
        PageHelper.startPage((int)pageNumber, (int)pageSize);
        return this.queryUser(cid, null);
    }

    public List<User> queryUser(Integer cid, String name, Integer pageNumber, Integer pageSize) {
        PageHelper.startPage((int)pageNumber, (int)pageSize);
        return this.queryUser(cid, name);
    }

    public List<Syslog> queryLog(QueryLogParam param, Integer pageNumber, Integer pageSize) {
        PageHelper.startPage((int)pageNumber, (int)pageSize);
        SyslogExample e = new SyslogExample();
        SyslogExample.Criteria c = e.createCriteria();
        if (param.getCid() != null) {
            c.andCidEqualTo(param.getCid());
        }
        if (param.getUid() != null) {
            c.andUidEqualTo(param.getUid());
        }
        if (param.getUpdateBegin() != null) {
            c.andCreatetimeGreaterThanOrEqualTo(param.getUpdateBegin());
        }
        if (param.getUpdateEnd() != null) {
            c.andCreatetimeLessThanOrEqualTo(param.getUpdateEnd());
        }
        if (param.getType() != null) {
            c.andTypeEqualTo(param.getType());
        }
        return this.SyslogMapper.selectByExample(e);
    }

    public List<User> queryUser(Integer cid, String name) {
        UserExample e = new UserExample();
        UserExample.Criteria c = e.createCriteria();
        c.andCidEqualTo(cid);
        if (StringUtils.isNotEmpty((String)name)) {
            c.andFullnameLike("%" + name + "%");
        }
        List<User> list = this.userMapper.selectByExample(e);
        return list;
    }

    public int delete(Integer id) {
        User record = this.userMapper.selectByPrimaryKey(id);
        record.setIsvalid(Constant.ACTIVE_NO);
        return this.userMapper.updateByPrimaryKeySelective(record);
    }

    public void update(User entity) {
        this.userMapper.updateByPrimaryKey(entity);
    }

    public User findUserByName(String username) {
        UserExample e = new UserExample();
        e.or().andUsernameEqualTo(username);
        List<User> list = this.userMapper.selectByExample(e);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public List<String> getPermissionName(Integer userId) {
        ArrayList<String> result = new ArrayList<String>();
        List<SecRole> roleList = this.getRoleList(userId);
        for (SecRole role : roleList) {
            List<SecPermission> pList = this.RoleManager.getRolePermission(role.getId());
            for (SecPermission p : pList) {
                result.add(p.getCode());
            }
        }
        result.addAll(this.userMapper.getAuthoritiesName(userId));
        return result;
    }

    public List<String> getRolesName(Integer userId) {
        return this.userMapper.getRolesName(userId);
    }

    private void entryptPassword(User user) {
        byte[] salt = Digests.generateSalt(8);
        user.setSalt(EncodeUtils.hexEncode(salt));
        byte[] hashPassword = Digests.sha1(user.getPlainpassword().getBytes(), salt, 1024);
        user.setPassword(EncodeUtils.hexEncode(hashPassword));
    }

    @Transactional
    public int create(User user, Integer staffId, Integer[] roleList) {
        int count = 0;
        this.entryptPassword(user);
        user.setRegistertime(new Date());
        count += this.userMapper.insertSelective(user);
        Staff staff = new Staff();
        staff.setId(staffId);
        staff.setUid(user.getId());
        this.StaffService.updateSimple(staff);
        if (roleList == null || roleList.length == 0) {
            return count;
        }
        Integer[] integerArray = roleList;
        int n = roleList.length;
        int n2 = 0;
        while (n2 < n) {
            Integer index = integerArray[n2];
            SecUserrole newrecord = new SecUserrole();
            newrecord.setUid(user.getId());
            newrecord.setIsactive(Constant.ACTIVE_YES);
            newrecord.setRid(index);
            newrecord.setCreatetime(new Date());
            count += this.secUserroleMapper.insertSelective(newrecord);
            ++n2;
        }
        return count;
    }

    @Transactional
    public int update(User user, Integer staffId, Integer[] roleList) {
        if (StringUtils.isNotEmpty((String)user.getPlainpassword())) {
            this.entryptPassword(user);
        } else {
            user.setPlainpassword(null);
        }
        int count = 0;
        count += this.userMapper.updateByPrimaryKeySelective(user);
        if (staffId != null) {
            Staff staff = new Staff();
            staff.setId(staffId);
            staff.setUid(user.getId());
            this.StaffService.updateSimple(staff);
        }
        if (roleList == null || roleList.length == 0) {
            return count;
        }
        SecUserroleExample e = new SecUserroleExample();
        e.createCriteria().andUidEqualTo(user.getId()).andIsactiveEqualTo(Constant.ACTIVE_YES);
        SecUserrole record = new SecUserrole();
        record.setIsactive(Constant.ACTIVE_NO);
        record.setUpdatetime(new Date());
        count += this.secUserroleMapper.updateByExampleSelective(record, e);
        Integer[] integerArray = roleList;
        int n = roleList.length;
        int n2 = 0;
        while (n2 < n) {
            Integer index = integerArray[n2];
            SecUserrole newrecord = new SecUserrole();
            newrecord.setUid(user.getId());
            newrecord.setIsactive(Constant.ACTIVE_YES);
            newrecord.setRid(index);
            newrecord.setCreatetime(new Date());
            count += this.secUserroleMapper.insertSelective(newrecord);
            ++n2;
        }
        return count;
    }

    @Transactional
    public int deleteAll(Integer cid) {
        UserExample e = new UserExample();
        e.createCriteria().andCidEqualTo(cid).andIsvalidEqualTo(Constant.ACTIVE_YES);
        List<User> list = this.userMapper.selectByExample(e);
        for (User a : list) {
            this.clearUserByNameCache(a.getUsername());
        }
        User record = new User();
        record.setCid(0);
        return this.userMapper.updateByExampleSelective(record, e);
    }
}

