/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.security;

import cn.smarthse.core.dao.security.SecPermissionMapper;
import cn.smarthse.core.dao.security.SecRoleMapper;
import cn.smarthse.core.dao.security.SecRolepermissionMapper;
import cn.smarthse.core.dao.security.SecUserroleMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.model.security.SecPermission;
import cn.smarthse.core.model.security.SecRole;
import cn.smarthse.core.model.security.SecRoleExample;
import cn.smarthse.core.model.security.SecRolepermission;
import cn.smarthse.core.model.security.SecRolepermissionExample;
import cn.smarthse.core.model.security.SecUserrole;
import cn.smarthse.core.model.security.SecUserroleExample;
import com.github.pagehelper.PageHelper;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleManager {
    @Autowired
    private SecRoleMapper secRoleMapper;
    @Autowired
    private SecRolepermissionMapper secRolepermissionMapper;
    @Autowired
    private SecPermissionMapper secPermissionMapper;
    @Autowired
    SecUserroleMapper secUserRoleMapper;

    public SecRole getById(Integer id) {
        return this.secRoleMapper.selectByPrimaryKey(id);
    }

    public List<SecPermission> getRolePermission(Integer id) {
        return this.secPermissionMapper.selectByRoleId(id);
    }

    public List<SecRole> getAll(Integer cid) {
        return this.getAll(cid, null, null);
    }

    public List<SecRole> getAll(Integer cid, Integer pageNumber, Integer pageSize) {
        if (pageNumber != null) {
            PageHelper.startPage((int)pageNumber, (int)pageSize);
        }
        SecRoleExample e = new SecRoleExample();
        e.createCriteria().andCidEqualTo(cid).andIsactiveEqualTo(Constant.ACTIVE_YES);
        SecRoleExample.Criteria c = e.createCriteria();
        c.andCidIsNull().andIsactiveEqualTo(Constant.ACTIVE_YES);
        e.or(c);
        List<SecRole> list = this.secRoleMapper.selectByExample(e);
        return list;
    }

    @Transactional
    public int create(SecRole role, List<String> PermissionList) {
        int count = 0;
        role.setCreatetime(new Date());
        count += this.secRoleMapper.insertSelective(role);
        if (PermissionList == null || PermissionList.size() == 0) {
            return count;
        }
        for (String index : PermissionList) {
            SecRolepermission newrecord = new SecRolepermission();
            newrecord.setRid(role.getId());
            newrecord.setIsactive(Constant.ACTIVE_YES);
            newrecord.setPermissioncode(index);
            newrecord.setUpdatetime(new Date());
            count += this.secRolepermissionMapper.insertSelective(newrecord);
        }
        return count;
    }

    @Transactional
    public int update(SecRole role, List<String> PermissionList) {
        int count = 0;
        count = role.getId() == null ? (count += this.secRoleMapper.insertSelective(role)) : (count += this.secRoleMapper.updateByPrimaryKeySelective(role));
        if (PermissionList == null || PermissionList.size() == 0) {
            return count;
        }
        SecRolepermissionExample e = new SecRolepermissionExample();
        e.createCriteria().andRidEqualTo(role.getId()).andIsactiveEqualTo(Constant.ACTIVE_YES);
        SecRolepermission record = new SecRolepermission();
        record.setIsactive(Constant.ACTIVE_NO);
        record.setUpdatetime(new Date());
        count += this.secRolepermissionMapper.updateByExampleSelective(record, e);
        for (String index : PermissionList) {
            SecRolepermission newrecord = new SecRolepermission();
            newrecord.setRid(role.getId());
            newrecord.setIsactive(Constant.ACTIVE_YES);
            newrecord.setPermissioncode(index);
            newrecord.setUpdatetime(new Date());
            count += this.secRolepermissionMapper.insertSelective(newrecord);
        }
        return count;
    }

    public int delete(Integer id) {
        SecRole record = this.secRoleMapper.selectByPrimaryKey(id);
        record.setIsactive(Constant.ACTIVE_NO);
        record.setDeletetime(new Date());
        return this.secRoleMapper.updateByPrimaryKeySelective(record);
    }

    public SecUserrole addSecUserRole(SecUserrole record) {
        this.secUserRoleMapper.insertSelective(record);
        return record;
    }

    public SecUserrole getSecUserroleById(int id) {
        return this.secUserRoleMapper.selectByPrimaryKey(id);
    }

    public int updateSecUserRole(SecUserrole record) {
        return this.secUserRoleMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteSecUserRole(SecUserrole record) {
        return this.secUserRoleMapper.deleteByPrimaryKey(record.getId());
    }

    public List<SecUserrole> getSecUserRoleListByExample(SecUserroleExample example) {
        return this.secUserRoleMapper.selectByExample(example);
    }
}

