/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.security;

import cn.smarthse.core.dao.security.SecResourceMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.model.security.SecResource;
import cn.smarthse.core.model.security.SecResourceExample;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResourceManager {
    @Autowired
    private SecResourceMapper secResourceMapper;

    public SecResource getByCode(String code) {
        return this.secResourceMapper.selectByPrimaryKey(code);
    }

    public List<SecResource> getAll() {
        return this.getAll(null, null);
    }

    public List<SecResource> getAll(Integer pageNumber, Integer pageSize) {
        if (pageNumber != null) {
            PageHelper.startPage((int)pageNumber, (int)pageSize);
        }
        SecResourceExample e = new SecResourceExample();
        e.createCriteria().andIsactiveEqualTo(Constant.ACTIVE_YES);
        List<SecResource> list = this.secResourceMapper.selectByExample(e);
        return list;
    }

    public List<SecResource> getChildList(String code) {
        SecResourceExample e = new SecResourceExample();
        SecResourceExample.Criteria c = e.createCriteria();
        c.andIsactiveEqualTo(Constant.ACTIVE_YES);
        if (StringUtils.isNotEmpty((String)code)) {
            c.andPcodeEqualTo(code);
        }
        List<SecResource> list = this.secResourceMapper.selectByExample(e);
        list.add(this.secResourceMapper.selectByPrimaryKey(code));
        return list;
    }

    public int create(SecResource r) {
        return this.secResourceMapper.insertSelective(r);
    }

    public int update(SecResource r) {
        return this.secResourceMapper.updateByPrimaryKeySelective(r);
    }

    public int delete(String code) {
        SecResource record = this.secResourceMapper.selectByPrimaryKey(code);
        record.setIsactive(Constant.ACTIVE_NO);
        return this.secResourceMapper.updateByPrimaryKeySelective(record);
    }
}

