/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.sceneInspection.impl;

import cn.smarthse.core.dao.sceneInspection.dao.OccupationHealthInspectionCollaboratorDao;
import cn.smarthse.core.dao.sceneInspection.dao.OccupationHealthInspectionCurrentRangeDao;
import cn.smarthse.core.dao.sceneInspection.dao.OccupationHealthInspectionCurrentTableDao;
import cn.smarthse.core.dao.sceneInspection.dao.OccupationHealthInspectionDao;
import cn.smarthse.core.dao.sceneInspection.dao.OccupationHealthInspectionOtherAttachmentDao;
import cn.smarthse.core.dao.sceneInspection.dao.OccupationHealthInspectionPaperManagerDao;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionCurrentTableItemMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionEmergencyMaterialTableMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionEquipentTableMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionReformItemMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionReformItemTableMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionTemplateTableItemMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionTemplateTableMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionWarningSignsTableMapper;
import cn.smarthse.core.framework.enums.InspectionTableSystemType;
import cn.smarthse.core.framework.enums.RecordState;
import cn.smarthse.core.framework.utils.excel.imports.InspectionTableItemEntity;
import cn.smarthse.core.framework.utils.excel.imports.InspectionTableItemExcel;
import cn.smarthse.core.model.basic.OccupationalRiskFactors;
import cn.smarthse.core.model.device.Device;
import cn.smarthse.core.model.emergency.material.EmeMaterial;
import cn.smarthse.core.model.reform.RefReformitem;
import cn.smarthse.core.model.reform.RefReformitemWithBLOBs;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionCurrentTable;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionCurrentTableItem;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionCurrentTableItemExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionEmergencyMaterialTable;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionEmergencyMaterialTableExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionEquipentTable;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionEquipentTableExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionReformItemTable;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionReformItemTableExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionTemplateTable;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionTemplateTableExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionTemplateTableItem;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionTemplateTableItemExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionWarningSignsTable;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionWarningSignsTableExample;
import cn.smarthse.core.model.sys.Sysparam;
import cn.smarthse.core.model.warnmark.WmBase;
import cn.smarthse.core.model.warnmark.WmBaseExample;
import cn.smarthse.core.service.basic.OccupationalRiskFactorsService;
import cn.smarthse.core.service.basic.SysParamService;
import cn.smarthse.core.service.device.DeviceService;
import cn.smarthse.core.service.emergency.material.EmeMaterialService;
import cn.smarthse.core.service.reform.ReformItemService;
import cn.smarthse.core.service.reform.ReformSolutionService;
import cn.smarthse.core.service.sceneInspection.OccHealthInspectionTableService;
import cn.smarthse.core.service.warnmark.WarnMarkService;
import cn.smarthse.core.util.EntityUtil;
import cn.smarthse.core.util.LoginUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class OccupationHealthInspectionTableService
implements OccHealthInspectionTableService {
    @Resource(name="OccupationHealthInspectionCollaboratorDaoImpl")
    private OccupationHealthInspectionCollaboratorDao collaboratorDao;
    @Resource(name="OccupationHealthInspectionCurrentRangeDaoImpl")
    private OccupationHealthInspectionCurrentRangeDao rangeDao;
    @Resource(name="OccupationHealthInspectionCurrentTableDaoImpl")
    private OccupationHealthInspectionCurrentTableDao currentTableDao;
    @Resource(name="OccupationHealthInspectionOtherAttachmentDaoImpl")
    private OccupationHealthInspectionOtherAttachmentDao otherAttachmentDao;
    @Autowired
    private OccupationHealthInspectionTemplateTableMapper templateTabeMapper;
    @Autowired
    private OccupationHealthInspectionTemplateTableItemMapper templateTableItemMapper;
    @Autowired
    private OccupationHealthInspectionCurrentTableItemMapper currentTableItemMapper;
    @Resource(name="OccupationHealthInspectionPaperManagerDaoImpl")
    private OccupationHealthInspectionPaperManagerDao paperManagerDao;
    @Resource(name="OccupationHealthInspectionDaoImpl")
    private OccupationHealthInspectionDao inspectionDao;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private OccupationHealthInspectionEquipentTableMapper equipmentTableMapper;
    @Autowired
    private OccupationHealthInspectionEmergencyMaterialTableMapper materialTableMapper;
    @Autowired
    private OccupationHealthInspectionWarningSignsTableMapper warningSignsTableMapper;
    @Autowired
    private EmeMaterialService emeMaterialService;
    @Autowired
    private WarnMarkService warnMarkService;
    @Autowired
    private OccupationalRiskFactorsService ORFService;
    @Autowired
    private SysParamService sysParamService;
    @Autowired
    private ReformItemService reformItemService;
    @Autowired
    private ReformSolutionService reformSolutionService;
    @Autowired
    private OccupationHealthInspectionReformItemTableMapper reformItemTableMapper;
    @Autowired
    private OccupationHealthInspectionReformItemMapper reformItemMapper;

    @Override
    public List<OccupationHealthInspectionTemplateTable> getInspectionTemplateTableListByCompanyId(Integer companyId, String searchParam) {
        OccupationHealthInspectionTemplateTableExample example = new OccupationHealthInspectionTemplateTableExample();
        OccupationHealthInspectionTemplateTableExample.Criteria criteria = example.createCriteria();
        criteria.andCompanyIdEqualTo(companyId);
        OccupationHealthInspectionTemplateTableExample.Criteria criteria2 = example.or();
        criteria2.andCompanyIdIsNull();
        if (StringUtils.isNotEmpty((String)searchParam)) {
            criteria.andTableNameLike("%" + searchParam + "%");
            criteria2.andTableNameLike("%" + searchParam + "%");
        }
        return this.templateTabeMapper.selectByExample(example);
    }

    @Override
    @Transactional(readOnly=false)
    public OccupationHealthInspectionTemplateTable saveInspectionTemplateTable(OccupationHealthInspectionTemplateTable table) {
        EntityUtil.getInstance().setCreateAndUpdateInfo(table);
        if (table.getId() == null) {
            table.setCompanyId(LoginUtil.getInstance().getLoginStaffInfo().getCid());
            this.templateTabeMapper.insert(table);
        } else {
            this.templateTabeMapper.updateByPrimaryKeySelective(table);
        }
        return table;
    }

    @Override
    public OccupationHealthInspectionTemplateTable getInspectionTemplateTableById(Integer id) {
        if (id == null) {
            return null;
        }
        return this.templateTabeMapper.selectByPrimaryKey(id);
    }

    @Override
    @Transactional(readOnly=false)
    public void addInspectionTempalteTableItemsFromLocal(Integer tableId, Integer[] items) {
        if (this.templateTabeMapper.selectByPrimaryKey(tableId) == null) {
            return;
        }
        Integer[] integerArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Integer item = integerArray[n2];
            OccupationHealthInspectionTemplateTableItem templateItem = this.templateTableItemMapper.selectByPrimaryKey(item);
            if (templateItem != null && !templateItem.getTableId().equals(tableId)) {
                OccupationHealthInspectionTemplateTableItem tableItem = new OccupationHealthInspectionTemplateTableItem();
                tableItem.setTableId(tableId);
                tableItem.setContentItem(templateItem.getContentItem());
                tableItem.setAccordingAs(templateItem.getAccordingAs());
                tableItem.setRecordState(RecordState.valid.getValue());
                EntityUtil.getInstance().setCreateAndUpdateInfo(tableItem);
                this.templateTableItemMapper.insert(tableItem);
            }
            ++n2;
        }
    }

    @Override
    public List<OccupationHealthInspectionTemplateTableItem> getInspectionTemplateTableItemByTableId(Integer tableId) {
        if (tableId == null) {
            return null;
        }
        OccupationHealthInspectionTemplateTableItemExample example = new OccupationHealthInspectionTemplateTableItemExample();
        example.createCriteria().andTableIdEqualTo(tableId).andRecordStateEqualTo(RecordState.valid.getValue());
        return this.templateTableItemMapper.selectByExample(example);
    }

    @Override
    @Transactional(readOnly=false)
    public List<InspectionTableItemEntity> importInspectionItem(String filePath, Integer tableId) {
        List<InspectionTableItemEntity> itemList = InspectionTableItemExcel.getInstance().getInspectionItemEntityList(filePath);
        for (InspectionTableItemEntity entity : itemList) {
            OccupationHealthInspectionTemplateTableItem item = new OccupationHealthInspectionTemplateTableItem();
            item.setAccordingAs(entity.getAccordingAs());
            item.setContentItem(entity.getContentItem());
            item.setTableId(tableId);
            EntityUtil.getInstance().setCreateAndUpdateInfo(item);
            this.templateTableItemMapper.insert(item);
        }
        return itemList;
    }

    @Override
    @Transactional(readOnly=false)
    public void deleteInspectionItem(Integer itemId) {
        OccupationHealthInspectionTemplateTableItem item = new OccupationHealthInspectionTemplateTableItem();
        item.setId(itemId);
        item.setRecordState(RecordState.invalid.getValue());
        EntityUtil.getInstance().setCreateAndUpdateInfo(item);
        this.templateTableItemMapper.updateByPrimaryKeySelective(item);
    }

    @Override
    public List<OccupationHealthInspectionEmergencyMaterialTable> getEmeMaterialTableListByTableId(Integer tableId, Boolean isTemplateTableItems) {
        if (isTemplateTableItems == null || isTemplateTableItems.booleanValue()) {
            List<EmeMaterial> emeMaterialList = this.emeMaterialService.getListByCompanyId(LoginUtil.getInstance().getLoginStaffCompanyId());
            ArrayList<OccupationHealthInspectionEmergencyMaterialTable> list = new ArrayList<OccupationHealthInspectionEmergencyMaterialTable>();
            for (EmeMaterial emeMaterial : emeMaterialList) {
                OccupationHealthInspectionEmergencyMaterialTable table = this.getMaterialTableFromEmeMaterial(emeMaterial, tableId);
                if (table == null) continue;
                list.add(table);
            }
            return list;
        }
        OccupationHealthInspectionEmergencyMaterialTableExample example = new OccupationHealthInspectionEmergencyMaterialTableExample();
        example.createCriteria().andTableIdEqualTo(tableId).andRecordStateEqualTo(RecordState.valid.getValue());
        List<OccupationHealthInspectionEmergencyMaterialTable> list = this.materialTableMapper.selectByExample(example);
        return list;
    }

    @Override
    public List<OccupationHealthInspectionEquipentTable> getInspectionEquipmentTableListByTableId(Integer tableId, Boolean isTemplateTableItems) {
        if (isTemplateTableItems == null || isTemplateTableItems.booleanValue()) {
            List<Device> deviceList = this.deviceService.getDeviceListByCompanyId(LoginUtil.getInstance().getLoginStaffCompanyId());
            ArrayList<OccupationHealthInspectionEquipentTable> list = new ArrayList<OccupationHealthInspectionEquipentTable>();
            for (Device device : deviceList) {
                OccupationHealthInspectionEquipentTable table = this.getEquipmentTableInfoFromDevice(device, tableId);
                if (table == null) continue;
                list.add(table);
            }
            return list;
        }
        OccupationHealthInspectionEquipentTableExample example = new OccupationHealthInspectionEquipentTableExample();
        example.createCriteria().andTableIdEqualTo(tableId).andRecordStateEqualTo(RecordState.valid.getValue());
        return this.equipmentTableMapper.selectByExample(example);
    }

    @Override
    public List<OccupationHealthInspectionWarningSignsTable> getWarningSignsTableListByTableId(Integer tableId, Boolean isTemplateTableItems) {
        if (isTemplateTableItems == null || isTemplateTableItems.booleanValue()) {
            WmBaseExample example = new WmBaseExample();
            example.createCriteria().andCidEqualTo(LoginUtil.getInstance().getLoginStaffCompanyId());
            List<WmBase> wmBaseList = this.warnMarkService.getWmbaseListByExample(example);
            ArrayList<OccupationHealthInspectionWarningSignsTable> list = new ArrayList<OccupationHealthInspectionWarningSignsTable>();
            for (WmBase wmBase : wmBaseList) {
                OccupationHealthInspectionWarningSignsTable table = this.getWarningSingsTableFromWmBase(wmBase, tableId);
                if (table == null) continue;
                list.add(table);
            }
            return list;
        }
        OccupationHealthInspectionWarningSignsTableExample example = new OccupationHealthInspectionWarningSignsTableExample();
        example.createCriteria().andTableIdEqualTo(tableId).andRecordStateEqualTo(RecordState.valid.getValue());
        return this.warningSignsTableMapper.selectByExample(example);
    }

    @Override
    public OccupationHealthInspectionCurrentTable getInspectionCurrentTableById(Integer id) {
        if (id == null) {
            return null;
        }
        return this.currentTableDao.selectByPrimaryKey(id);
    }

    @Override
    public List<OccupationHealthInspectionCurrentTableItem> getCurrentTableItemListByTableId(Integer tableId) {
        OccupationHealthInspectionCurrentTableItemExample example = new OccupationHealthInspectionCurrentTableItemExample();
        example.createCriteria().andTableIdEqualTo(tableId).andRecordStateEqualTo(RecordState.valid.getValue());
        return this.currentTableItemMapper.selectByExample(example);
    }

    @Override
    public List<OccupationHealthInspectionTemplateTableItem> getTemplateTableItemList(Integer tableId, String searchKey, Integer ... notTableIds) {
        OccupationHealthInspectionTemplateTableItemExample example = new OccupationHealthInspectionTemplateTableItemExample();
        OccupationHealthInspectionTemplateTableItemExample.Criteria criteria = example.createCriteria();
        OccupationHealthInspectionTemplateTableItemExample.Criteria criteria1 = example.createCriteria();
        if (tableId != null) {
            criteria.andTableIdEqualTo(tableId).andRecordStateEqualTo(RecordState.valid.getValue());
            criteria1.andTableIdEqualTo(tableId).andRecordStateEqualTo(RecordState.valid.getValue());
        } else {
            criteria.andRecordStateEqualTo(RecordState.valid.getValue());
            criteria1.andRecordStateEqualTo(RecordState.valid.getValue());
        }
        Integer[] integerArray = notTableIds;
        int n = notTableIds.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            criteria.andTableIdNotEqualTo(id);
            criteria1.andTableIdNotEqualTo(id);
            ++n2;
        }
        if (StringUtils.isNotBlank((String)searchKey)) {
            criteria.andContentItemLike("%" + searchKey + "%");
            criteria1.andAccordingAsLike("%" + searchKey + "%");
            example.or(criteria1);
        }
        List<OccupationHealthInspectionTemplateTableItem> list = this.templateTableItemMapper.selectByExample(example);
        return list;
    }

    @Override
    public void cloneItemsFromTemplateToCurrentTableByTableList(List<OccupationHealthInspectionCurrentTable> inspectionContents, Byte stageId) {
        if (inspectionContents == null || stageId == null) {
            return;
        }
        for (OccupationHealthInspectionCurrentTable table : inspectionContents) {
            if (table.getTableNativeCode() == null) continue;
            if (table.getTableNativeCode().equals(InspectionTableSystemType.custom.getValue())) {
                OccupationHealthInspectionTemplateTable templateTable = this.templateTabeMapper.selectByPrimaryKey(table.getInspectionTableId());
                for (OccupationHealthInspectionTemplateTableItem item : templateTable.getItems()) {
                    OccupationHealthInspectionCurrentTableItem currentItem = new OccupationHealthInspectionCurrentTableItem();
                    currentItem.setAccordingAs(item.getAccordingAs());
                    currentItem.setContentItem(item.getContentItem());
                    currentItem.setTableId(table.getId());
                    EntityUtil.getInstance().setCreateAndUpdateInfo(currentItem);
                    this.currentTableItemMapper.insert(currentItem);
                }
                continue;
            }
            if (table.getTableNativeCode().equals(InspectionTableSystemType.emergencyMaterial.getValue())) {
                List<EmeMaterial> emeMaterialList = this.emeMaterialService.getListByCompanyId(LoginUtil.getInstance().getLoginStaffCompanyId());
                for (EmeMaterial emeMaterial : emeMaterialList) {
                    OccupationHealthInspectionEmergencyMaterialTable materialTable = this.getMaterialTableFromEmeMaterial(emeMaterial, table.getId());
                    if (materialTable == null) continue;
                    this.materialTableMapper.insert(materialTable);
                }
                continue;
            }
            if (table.getTableNativeCode().equals(InspectionTableSystemType.equipment.getValue())) {
                List<Device> deviceList = this.deviceService.getDeviceListByCompanyId(LoginUtil.getInstance().getLoginStaffCompanyId());
                for (Device device : deviceList) {
                    OccupationHealthInspectionEquipentTable equipmentTable = this.getEquipmentTableInfoFromDevice(device, table.getId());
                    if (equipmentTable == null) continue;
                    this.equipmentTableMapper.insert(equipmentTable);
                }
                continue;
            }
            if (table.getTableNativeCode().equals(InspectionTableSystemType.warningSigns.getValue())) {
                WmBaseExample example = new WmBaseExample();
                example.createCriteria().andCidEqualTo(LoginUtil.getInstance().getLoginStaffCompanyId());
                List<WmBase> wmBaseList = this.warnMarkService.getWmbaseListByExample(example);
                for (WmBase wmBase : wmBaseList) {
                    OccupationHealthInspectionWarningSignsTable warningSignsTable = this.getWarningSingsTableFromWmBase(wmBase, table.getId());
                    if (warningSignsTable == null) continue;
                    this.warningSignsTableMapper.insert(warningSignsTable);
                }
                continue;
            }
            if (!table.getTableNativeCode().equals(InspectionTableSystemType.reformItem.getValue())) continue;
            Integer companyId = LoginUtil.getInstance().getLoginStaffCompanyId();
            if (companyId == null) {
                return;
            }
            List<RefReformitem> list = this.reformItemService.getItemList(companyId, 2);
            for (RefReformitem reformItem : list) {
                OccupationHealthInspectionReformItemTable reformItemTable = this.getReformItemTableFromRefReformitem(reformItem, table.getId());
                if (reformItemTable == null) continue;
                this.reformItemTableMapper.insert(reformItemTable);
            }
        }
    }

    @Override
    public void cloneItemsFromTemplateToCurrentTable(Integer inspectionId, Byte stageId) {
        List<OccupationHealthInspectionCurrentTable> inspectionContents = this.currentTableDao.selectByInspectionIdAndStageId(inspectionId, stageId, true);
        this.cloneItemsFromTemplateToCurrentTableByTableList(inspectionContents, stageId);
    }

    private OccupationHealthInspectionReformItemTable getReformItemTableFromRefReformitem(RefReformitem reformItem, Integer inspecitonTableId) {
        if (reformItem == null) {
            return null;
        }
        OccupationHealthInspectionReformItemTable reformItemTable = new OccupationHealthInspectionReformItemTable();
        reformItemTable.setTableId(inspecitonTableId);
        reformItemTable.setReformItemId(reformItem.getId());
        EntityUtil.getInstance().setCreateAndUpdateInfo(reformItemTable);
        return reformItemTable;
    }

    private OccupationHealthInspectionWarningSignsTable getWarningSingsTableFromWmBase(WmBase wmBase, Integer inspecitonTableId) {
        OccupationalRiskFactors orf;
        Integer harmid;
        if (wmBase == null) {
            return null;
        }
        OccupationHealthInspectionWarningSignsTable wsTable = new OccupationHealthInspectionWarningSignsTable();
        wsTable.setAreaId(wmBase.getAreaid());
        Integer n = harmid = wmBase.getHarms() == null ? null : wmBase.getHarms().get(0).getHarmid();
        if (harmid != null && (orf = this.ORFService.getById(harmid)) != null) {
            wsTable.setInformProject(orf.getNameCh());
        }
        wsTable.setSpecificLocation(wmBase.getPositionaddr());
        wsTable.setTableId(inspecitonTableId);
        Sysparam sysparam = wmBase.getSigntype() == null ? null : this.sysParamService.getSysparamById(wmBase.getSigntype());
        wsTable.setWarningSignsType(sysparam == null ? "\u672a\u77e5\u79cd\u7c7b" : sysparam.getParamvalue());
        wsTable.setWarningSingsSn(wmBase.getSigncode());
        EntityUtil.getInstance().setCreateAndUpdateInfo(wsTable);
        return wsTable;
    }

    private OccupationHealthInspectionEmergencyMaterialTable getMaterialTableFromEmeMaterial(EmeMaterial emeMaterial, Integer inspecitonTalbeId) {
        if (emeMaterial == null) {
            return null;
        }
        OccupationHealthInspectionEmergencyMaterialTable materialTable = new OccupationHealthInspectionEmergencyMaterialTable();
        materialTable.setMaterialModel(emeMaterial.getModel());
        materialTable.setMaterialName(emeMaterial.getMname());
        materialTable.setMaterialNumber(emeMaterial.getQuantity());
        materialTable.setMaterialPlace(emeMaterial.getMarea());
        materialTable.setMaterialSn(emeMaterial.getMno());
        materialTable.setTableId(inspecitonTalbeId);
        EntityUtil.getInstance().setCreateAndUpdateInfo(materialTable);
        return materialTable;
    }

    private OccupationHealthInspectionEquipentTable getEquipmentTableInfoFromDevice(Device device, Integer inspectionTableId) {
        if (device == null) {
            return null;
        }
        OccupationHealthInspectionEquipentTable equipmentTable = new OccupationHealthInspectionEquipentTable();
        equipmentTable.setTableId(inspectionTableId);
        equipmentTable.setEquipmentlName(device.getDevicename());
        equipmentTable.setEquipmentModel(device.getDevicemodel());
        equipmentTable.setEquipmentNumber(device.getDeviceamount());
        equipmentTable.setEquipmentPlace(device.getInstallposition());
        equipmentTable.setEquipmentSn(device.getDeviceno());
        EntityUtil.getInstance().setCreateAndUpdateInfo(equipmentTable);
        return equipmentTable;
    }

    @Override
    public List<RefReformitem> getReformItemList() {
        Integer companyId = LoginUtil.getInstance().getLoginStaffCompanyId();
        if (companyId == null) {
            return null;
        }
        List<RefReformitem> list = this.reformItemService.getItemList(companyId, 2);
        for (RefReformitem reformItem : list) {
            reformItem.setSolution(this.reformSolutionService.getSolution(reformItem.getId()));
        }
        return list;
    }

    @Override
    public List<RefReformitem> getReformItemListByTableId(Integer tableId) {
        if (tableId == null) {
            return null;
        }
        OccupationHealthInspectionReformItemTableExample example = new OccupationHealthInspectionReformItemTableExample();
        example.createCriteria().andTableIdEqualTo(tableId).andRecordStateEqualTo(RecordState.valid.getValue());
        List<OccupationHealthInspectionReformItemTable> occReformItemList = this.reformItemTableMapper.selectByExample(example);
        ArrayList<RefReformitem> list = new ArrayList<RefReformitem>();
        for (OccupationHealthInspectionReformItemTable item : occReformItemList) {
            RefReformitemWithBLOBs refItem = this.reformItemService.getItem(item.getReformItemId());
            refItem.setSolution(this.reformSolutionService.getSolution(refItem.getId()));
            list.add(refItem);
        }
        return list;
    }

    @Override
    public void deleteItemsByTable(OccupationHealthInspectionCurrentTable table) {
        if (table == null || table.getId() == null || table.getTableNativeCode() == null) {
            return;
        }
        if (table.getTableNativeCode().equals(InspectionTableSystemType.custom.getValue())) {
            OccupationHealthInspectionCurrentTableItem record = new OccupationHealthInspectionCurrentTableItem();
            record.setRecordState(RecordState.invalid.getValue());
            EntityUtil.getInstance().setCreateAndUpdateInfo(record);
            OccupationHealthInspectionCurrentTableItemExample example = new OccupationHealthInspectionCurrentTableItemExample();
            example.createCriteria().andTableIdEqualTo(table.getId()).andRecordStateEqualTo(RecordState.valid.getValue());
            this.currentTableItemMapper.updateByExampleSelective(record, example);
        } else if (table.getTableNativeCode().equals(InspectionTableSystemType.emergencyMaterial.getValue())) {
            OccupationHealthInspectionEmergencyMaterialTable record = new OccupationHealthInspectionEmergencyMaterialTable();
            record.setRecordState(RecordState.invalid.getValue());
            EntityUtil.getInstance().setCreateAndUpdateInfo(record);
            OccupationHealthInspectionEmergencyMaterialTableExample example = new OccupationHealthInspectionEmergencyMaterialTableExample();
            example.createCriteria().andTableIdEqualTo(table.getId()).andRecordStateEqualTo(RecordState.valid.getValue());
            this.materialTableMapper.updateByExampleSelective(record, example);
        } else if (table.getTableNativeCode().equals(InspectionTableSystemType.equipment.getValue())) {
            OccupationHealthInspectionEquipentTable record = new OccupationHealthInspectionEquipentTable();
            record.setRecordState(RecordState.invalid.getValue());
            EntityUtil.getInstance().setCreateAndUpdateInfo(record);
            OccupationHealthInspectionEquipentTableExample example = new OccupationHealthInspectionEquipentTableExample();
            example.createCriteria().andTableIdEqualTo(table.getId()).andRecordStateEqualTo(RecordState.valid.getValue());
            this.equipmentTableMapper.updateByExampleSelective(record, example);
        } else if (table.getTableNativeCode().equals(InspectionTableSystemType.warningSigns.getValue())) {
            OccupationHealthInspectionWarningSignsTable record = new OccupationHealthInspectionWarningSignsTable();
            record.setRecordState(RecordState.invalid.getValue());
            EntityUtil.getInstance().setCreateAndUpdateInfo(record);
            OccupationHealthInspectionWarningSignsTableExample example = new OccupationHealthInspectionWarningSignsTableExample();
            example.createCriteria().andTableIdEqualTo(table.getId()).andRecordStateEqualTo(RecordState.valid.getValue());
            this.warningSignsTableMapper.updateByExampleSelective(record, example);
        } else if (table.getTableNativeCode().equals(InspectionTableSystemType.reformItem.getValue())) {
            OccupationHealthInspectionReformItemTable record = new OccupationHealthInspectionReformItemTable();
            record.setRecordState(RecordState.invalid.getValue());
            EntityUtil.getInstance().setCreateAndUpdateInfo(record);
            OccupationHealthInspectionReformItemTableExample example = new OccupationHealthInspectionReformItemTableExample();
            example.createCriteria().andTableIdEqualTo(table.getId()).andRecordStateEqualTo(RecordState.valid.getValue());
            this.reformItemTableMapper.updateByExampleSelective(record, example);
        }
    }
}

