/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.sceneInspection.impl;

import cn.smarthse.core.dao.sceneInspection.dao.OccupationHealthInspectionCollaboratorDao;
import cn.smarthse.core.dao.sceneInspection.dao.OccupationHealthInspectionCurrentRangeDao;
import cn.smarthse.core.dao.sceneInspection.dao.OccupationHealthInspectionCurrentTableDao;
import cn.smarthse.core.dao.sceneInspection.dao.OccupationHealthInspectionDao;
import cn.smarthse.core.dao.sceneInspection.dao.OccupationHealthInspectionOtherAttachmentDao;
import cn.smarthse.core.dao.sceneInspection.dao.OccupationHealthInspectionPaperManagerDao;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionCurrentTableItemMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionEmergencyMaterialTableMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionEquipentTableMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionInformFeedbackMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionMakeUpMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionReformItemMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionReformItemTableMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionSummaryMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionTableItemResultMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionTableItemResultReformMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionTableItemResultSpecialMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionTemplateItemMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionTemplateTableMapper;
import cn.smarthse.core.dao.sceneInspection.mapper.OccupationHealthInspectionWarningSignsTableMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.framework.common.util.StringUtils;
import cn.smarthse.core.framework.enums.ApproveResult;
import cn.smarthse.core.framework.enums.FeedbackType;
import cn.smarthse.core.framework.enums.InspectionRecordStaffType;
import cn.smarthse.core.framework.enums.InspectionTableSystemType;
import cn.smarthse.core.framework.enums.Modulars;
import cn.smarthse.core.framework.enums.OccupationHealthInspectionType;
import cn.smarthse.core.framework.enums.OccupationHealthStageRelation;
import cn.smarthse.core.framework.enums.RecordState;
import cn.smarthse.core.framework.enums.RecordType;
import cn.smarthse.core.framework.enums.ReformFileType;
import cn.smarthse.core.model.basic.Area;
import cn.smarthse.core.model.basic.File;
import cn.smarthse.core.model.basic.Staff;
import cn.smarthse.core.model.flow.WfModular;
import cn.smarthse.core.model.reform.RefReformfile;
import cn.smarthse.core.model.reform.RefReformitemWithBLOBs;
import cn.smarthse.core.model.reform.RefReformphase;
import cn.smarthse.core.model.reform.RefReformregularcheck;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspection;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionCollaborator;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionCurrentRange;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionCurrentTable;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionCurrentTableItem;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionCurrentTableItemExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionEmergencyMaterialTable;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionEmergencyMaterialTableExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionEquipentTable;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionEquipentTableExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionInformFeedback;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionInformFeedbackExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionMakeUp;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionMakeUpExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionOtherAttachment;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionPaperManager;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionPaperManagerExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionReformItem;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionReformItemExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionReformItemTable;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionReformItemTableExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionSummary;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionSummaryExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionTableItemResult;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionTableItemResultExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionTableItemResultReform;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionTableItemResultReformExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionTableItemResultSpecial;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionTableItemResultSpecialExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionTemplateItem;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionTemplateItemExample;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionTemplateTable;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionWarningSignsTable;
import cn.smarthse.core.model.sceneInspection.OccupationHealthInspectionWarningSignsTableExample;
import cn.smarthse.core.model.vo.InspectionSearchEntity;
import cn.smarthse.core.model.vo.WorkFlowParam;
import cn.smarthse.core.service.FileService;
import cn.smarthse.core.service.basic.AreaService;
import cn.smarthse.core.service.basic.staff.StaffService;
import cn.smarthse.core.service.reform.ReformItemService;
import cn.smarthse.core.service.reform.ReformPhaseService;
import cn.smarthse.core.service.reform.ReformService;
import cn.smarthse.core.service.sceneInspection.OccHealthInspectionService;
import cn.smarthse.core.service.sceneInspection.OccHealthInspectionTableService;
import cn.smarthse.core.service.workflow.GeneralWorkFlowService;
import cn.smarthse.core.service.workflow.IWorkflowService;
import cn.smarthse.core.service.workflow.ModularsWorkflowService;
import cn.smarthse.core.service.workflow.SnakerEngineFacets;
import cn.smarthse.core.util.EntityUtil;
import cn.smarthse.core.util.LoginUtil;
import cn.smarthse.core.util.PageAttribute;
import cn.smarthse.core.util.PageUtil;
import cn.smarthse.core.util.sceneInspection.OccupationHealthInspectionUtil;
import cn.smarthse.core.util.sceneInspection.impl.InspectionAdditionsArea;
import cn.smarthse.core.util.sceneInspection.impl.InspectionAdditionsCollaborator;
import cn.smarthse.core.util.sceneInspection.impl.InspectionAdditionsContent;
import cn.smarthse.core.util.sceneInspection.impl.InspectionAdditionsOtherAttachment;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class OccupationHealthInspectionService
implements OccHealthInspectionService,
IWorkflowService {
    @Resource(name="OccupationHealthInspectionCollaboratorDaoImpl")
    private OccupationHealthInspectionCollaboratorDao collaboratorDao;
    @Resource(name="OccupationHealthInspectionCurrentRangeDaoImpl")
    private OccupationHealthInspectionCurrentRangeDao rangeDao;
    @Resource(name="OccupationHealthInspectionCurrentTableDaoImpl")
    private OccupationHealthInspectionCurrentTableDao currentTableDao;
    @Resource(name="OccupationHealthInspectionOtherAttachmentDaoImpl")
    private OccupationHealthInspectionOtherAttachmentDao otherAttachmentDao;
    @Autowired
    private OccupationHealthInspectionInformFeedbackMapper feedbackMapper;
    @Autowired
    private StaffService staffService;
    @Autowired
    private AreaService AreaService;
    @Autowired
    private SnakerEngineFacets facets;
    @Autowired
    private OccupationHealthInspectionTemplateTableMapper templateTabeMapper;
    @Autowired
    private OccupationHealthInspectionTemplateItemMapper templateItemMapper;
    @Autowired
    private OccupationHealthInspectionCurrentTableItemMapper currentTableItemMapper;
    @Autowired
    private GeneralWorkFlowService workflowService;
    @Resource(name="OccupationHealthInspectionPaperManagerDaoImpl")
    private OccupationHealthInspectionPaperManagerDao paperManagerDao;
    @Resource(name="OccupationHealthInspectionDaoImpl")
    private OccupationHealthInspectionDao inspectionDao;
    @Autowired
    private OccupationHealthInspectionReformItemMapper reformItemMapper;
    @Autowired
    private FileService fileService;
    @Autowired
    private OccupationHealthInspectionSummaryMapper summaryMapper;
    @Autowired
    private OccupationHealthInspectionTableItemResultMapper resultMapper;
    @Autowired
    private OccupationHealthInspectionEquipentTableMapper equipmentTableMapper;
    @Autowired
    private OccupationHealthInspectionEmergencyMaterialTableMapper materialTableMapper;
    @Autowired
    private OccupationHealthInspectionWarningSignsTableMapper warningSignsTableMapper;
    @Autowired
    private OccupationHealthInspectionReformItemTableMapper reformItemTableMapper;
    @Autowired
    private OccupationHealthInspectionTableItemResultSpecialMapper resultSpecialMapper;
    @Autowired
    private ReformItemService reformItemService;
    @Autowired
    private ReformPhaseService reformPhaseService;
    @Autowired
    private ReformService reformService;
    @Autowired
    private OccupationHealthInspectionTableItemResultReformMapper resultReformMapper;
    @Autowired
    private OccHealthInspectionTableService inspectionTableService;
    @Autowired
    private ModularsWorkflowService modularWordflowService;
    @Autowired
    private OccupationHealthInspectionMakeUpMapper makeupMapper;

    @Override
    public List<OccupationHealthInspection> selectOccupationHealthInspectionListByCompanyId(Integer companyId) {
        return this.inspectionDao.selectOccupationHealthInspectionListByCompanyId(companyId);
    }

    private void setDailyScenePlanInfo(OccupationHealthInspection occ) {
        if (occ == null) {
            return;
        }
        if (OccupationHealthInspectionType.dailyScene.getValue().equals(occ.getInspectionTypeInitiate()) && OccupationHealthStageRelation.initiate.getStage().getValue().equals(occ.getInspectionStageId())) {
            if (occ.getInspectionTypeInitiate() != null) {
                occ.setInspectionType(occ.getInspectionTypeInitiate());
            }
            if (occ.getInspectionActualTime() != null) {
                occ.setInspectionPlanTime(occ.getInspectionActualTime());
            }
            if (occ.getInspectionManagerIdInitiate() != null) {
                occ.setInspectionManagerId(occ.getInspectionManagerIdInitiate());
            }
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void saveOccupationHealthInspectionMakeupInfo(OccupationHealthInspection occ) {
        if (occ == null) {
            return;
        }
        String orgAndName = this.staffService.getStaffNameOrgByStaffId(occ.getInspectionManagerId());
        if (StringUtils.isNotEmpty(orgAndName)) {
            occ.setInspectionManagerName(orgAndName);
        }
        OccupationHealthInspection oldOcc = null;
        if (occ.getId() == null || occ.getId() < 1) {
            occ.setInspectionStageId(OccupationHealthStageRelation.file.getStage().getValue());
            this.inspectionDao.insert(occ);
            occ.setInspectionStageId(OccupationHealthStageRelation.initiate.getStage().getValue());
            for (OccupationHealthInspectionCollaborator collaborator : occ.getCollaboratorList()) {
                this.saveInspectionCollaborator(collaborator, occ);
            }
            for (OccupationHealthInspectionCurrentRange range : occ.getAreaList()) {
                this.saveCurrentRange(range, occ);
            }
            for (OccupationHealthInspectionCurrentTable content : occ.getContentList()) {
                this.saveInspectionContent(content, occ);
                this.addContentItems(oldOcc, occ, OccupationHealthStageRelation.initiate.getStage().getValue());
            }
            for (OccupationHealthInspectionOtherAttachment otherAttachment : occ.getOtherAttachmentList()) {
                this.saveOtherAttachment(otherAttachment, occ);
            }
        } else {
            this.inspectionDao.updateByPrimaryKeySelective(occ, occ.getId());
            oldOcc = this.selectOccupationHealthInspectionByPrimaryKey(occ.getId(), OccupationHealthStageRelation.initiate.getStage().getValue(), null);
            Byte stageId = occ.getInspectionStageId();
            occ.setInspectionStageId(OccupationHealthStageRelation.initiate.getStage().getValue());
            this.checkCollaborator(oldOcc, occ);
            this.checkArea(oldOcc, occ);
            this.deleteContentItems(oldOcc, occ);
            this.checkInspectionContent(oldOcc, occ);
            this.addContentItems(oldOcc, occ, OccupationHealthStageRelation.initiate.getStage().getValue());
            this.checkOtherAttachment(oldOcc, occ);
            occ.setInspectionStageId(stageId);
        }
        this.checkPaperManager(oldOcc, occ);
        this.saveMakeupExtendInfo(occ.getMakeup(), occ.getId());
        if (occ.getSummary() != null) {
            if (occ.getSummary().getId() == null) {
                occ.getSummary().setInspectionId(occ.getId());
                occ.getSummary().setInspectionResultSn(OccupationHealthInspectionUtil.getInstance().getSummarySnManager(null));
                occ.getSummary().setRecordStaffType(InspectionRecordStaffType.manager.getValue());
            }
            this.saveSummaryInfo(occ.getSummary());
        }
    }

    private void deleteContentItems(OccupationHealthInspection oldOcc, OccupationHealthInspection occ) {
        List<Object> oldContentList = oldOcc == null ? new ArrayList() : oldOcc.getContentList();
        InspectionAdditionsContent additions = InspectionAdditionsContent.getInstance();
        additions.removeOtherByStageIdFromList(occ.getInspectionStageId(), oldContentList);
        int oldContentSize = oldContentList.size();
        int i = 0;
        while (i < oldContentSize) {
            boolean isNeedDelete = true;
            for (OccupationHealthInspectionCurrentTable content : occ.getContentList()) {
                if (content.getInspectionTableId() == null || content.getInspectionTableId() == 0 || !content.getInspectionTableId().equals(((OccupationHealthInspectionCurrentTable)oldContentList.get(i)).getInspectionTableId()) || !((OccupationHealthInspectionCurrentTable)oldContentList.get(i)).getStageId().equals(occ.getInspectionStageId())) continue;
                isNeedDelete = false;
                break;
            }
            if (isNeedDelete) {
                this.inspectionTableService.deleteItemsByTable((OccupationHealthInspectionCurrentTable)oldContentList.get(i));
            }
            ++i;
        }
    }

    private void addContentItems(OccupationHealthInspection oldOcc, OccupationHealthInspection occ, Byte stageId) {
        List<Object> oldContentList = oldOcc == null ? new ArrayList() : oldOcc.getContentList();
        ArrayList<OccupationHealthInspectionCurrentTable> inspectionContents = new ArrayList<OccupationHealthInspectionCurrentTable>();
        for (OccupationHealthInspectionCurrentTable content : occ.getContentList()) {
            if (content.getInspectionTableId() == null || content.getInspectionTableId() == 0) continue;
            boolean has = false;
            for (OccupationHealthInspectionCurrentTable occupationHealthInspectionCurrentTable : oldContentList) {
                if (!content.getInspectionTableId().equals(occupationHealthInspectionCurrentTable.getInspectionTableId()) || !occupationHealthInspectionCurrentTable.getStageId().equals(occ.getInspectionStageId())) continue;
                has = true;
                break;
            }
            if (has) continue;
            inspectionContents.add(content);
        }
        this.inspectionTableService.cloneItemsFromTemplateToCurrentTableByTableList(inspectionContents, stageId);
    }

    @Override
    @Transactional(readOnly=false)
    public OccupationHealthInspection saveOccupationHealthInspectionPlan(OccupationHealthInspection occ) {
        if (occ == null) {
            return new OccupationHealthInspection();
        }
        this.setDailyScenePlanInfo(occ);
        String orgAndName = this.staffService.getStaffNameOrgByStaffId(occ.getInspectionManagerId());
        if (StringUtils.isNotEmpty(orgAndName)) {
            occ.setInspectionManagerName(orgAndName);
        }
        if (occ.getId() == null || occ.getId() < 1) {
            this.inspectionDao.insert(occ);
            for (OccupationHealthInspectionCollaborator collaborator : occ.getCollaboratorList()) {
                this.saveInspectionCollaborator(collaborator, occ);
            }
            for (OccupationHealthInspectionCurrentRange range : occ.getAreaList()) {
                this.saveCurrentRange(range, occ);
            }
            for (OccupationHealthInspectionCurrentTable content : occ.getContentList()) {
                this.saveInspectionContent(content, occ);
            }
            for (OccupationHealthInspectionOtherAttachment otherAttachment : occ.getOtherAttachmentList()) {
                this.saveOtherAttachment(otherAttachment, occ);
            }
        } else {
            OccupationHealthInspection oldOcc = this.selectOccupationHealthInspectionByPrimaryKey(occ.getId(), null, null);
            this.checkCollaborator(oldOcc, occ);
            this.checkArea(oldOcc, occ);
            this.checkInspectionContent(oldOcc, occ);
            this.checkOtherAttachment(oldOcc, occ);
            this.inspectionDao.updateByPrimaryKeySelective(occ, occ.getId());
        }
        return occ;
    }

    private void saveMakeupExtendInfo(OccupationHealthInspectionMakeUp makeup, Integer inspectionId) {
        if (inspectionId == null || makeup == null) {
            return;
        }
        makeup.setInspecitonid(inspectionId);
        EntityUtil.getInstance().setCreateAndUpdateInfo(makeup);
        if (makeup.getId() == null) {
            this.makeupMapper.insertSelective(makeup);
        } else {
            this.makeupMapper.updateByPrimaryKeySelectiveAlwaysIds(makeup);
        }
    }

    private void checkOtherAttachment(OccupationHealthInspection oldOcc, OccupationHealthInspection occ) {
        List<Object> oldOtherAttachmentList = oldOcc == null ? new ArrayList() : oldOcc.getOtherAttachmentList();
        InspectionAdditionsOtherAttachment additions = InspectionAdditionsOtherAttachment.getInstance();
        additions.removeOtherByStageIdFromList(occ.getInspectionStageId(), oldOtherAttachmentList);
        int oldOtherAttachmentSize = oldOtherAttachmentList.size();
        int i = 0;
        while (i < oldOtherAttachmentSize) {
            boolean isNeedDelete = true;
            for (OccupationHealthInspectionOtherAttachment otherAttachment : occ.getOtherAttachmentList()) {
                if (otherAttachment.getFileId() == null || otherAttachment.getFileId() == 0 || !otherAttachment.getFileId().equals(((OccupationHealthInspectionOtherAttachment)oldOtherAttachmentList.get(i)).getFileId()) || !((OccupationHealthInspectionOtherAttachment)oldOtherAttachmentList.get(i)).getInspectionStageId().equals(occ.getInspectionStageId())) continue;
                isNeedDelete = false;
                break;
            }
            if (isNeedDelete) {
                this.otherAttachmentDao.deleteByPrimaryKey(((OccupationHealthInspectionOtherAttachment)oldOtherAttachmentList.get(i)).getId());
                oldOtherAttachmentList.remove(i);
                --oldOtherAttachmentSize;
                --i;
            }
            ++i;
        }
        for (OccupationHealthInspectionOtherAttachment otherAttachment : occ.getOtherAttachmentList()) {
            if (otherAttachment.getFileId() == null || otherAttachment.getFileId() == 0) continue;
            boolean has = false;
            for (OccupationHealthInspectionOtherAttachment occupationHealthInspectionOtherAttachment : oldOtherAttachmentList) {
                if (!otherAttachment.getFileId().equals(occupationHealthInspectionOtherAttachment.getFileId()) || !occupationHealthInspectionOtherAttachment.getInspectionStageId().equals(occ.getInspectionStageId())) continue;
                has = true;
                break;
            }
            if (has) continue;
            this.saveOtherAttachment(otherAttachment, occ);
        }
    }

    private void saveOtherAttachment(OccupationHealthInspectionOtherAttachment otherAttachment, OccupationHealthInspection occ) {
        otherAttachment.setInspectionId(occ.getId());
        otherAttachment.setInspectionStageId(occ.getInspectionStageId());
        this.otherAttachmentDao.insert(otherAttachment);
    }

    private void checkInspectionContent(OccupationHealthInspection oldOcc, OccupationHealthInspection occ) {
        List<Object> oldContentList = oldOcc == null ? new ArrayList() : oldOcc.getContentList();
        InspectionAdditionsContent additions = InspectionAdditionsContent.getInstance();
        additions.removeOtherByStageIdFromList(occ.getInspectionStageId(), oldContentList);
        int oldContentSize = oldContentList.size();
        int i = 0;
        while (i < oldContentSize) {
            boolean isNeedDelete = true;
            for (OccupationHealthInspectionCurrentTable content : occ.getContentList()) {
                if (content.getInspectionTableId() == null || content.getInspectionTableId() == 0 || !content.getInspectionTableId().equals(((OccupationHealthInspectionCurrentTable)oldContentList.get(i)).getInspectionTableId()) || !((OccupationHealthInspectionCurrentTable)oldContentList.get(i)).getStageId().equals(occ.getInspectionStageId())) continue;
                isNeedDelete = false;
                break;
            }
            if (isNeedDelete) {
                this.currentTableDao.deleteByPrimaryKey(((OccupationHealthInspectionCurrentTable)oldContentList.get(i)).getId());
                oldContentList.remove(i);
                --oldContentSize;
                --i;
            }
            ++i;
        }
        for (OccupationHealthInspectionCurrentTable content : occ.getContentList()) {
            if (content.getInspectionTableId() == null || content.getInspectionTableId() == 0) continue;
            boolean has = false;
            for (OccupationHealthInspectionCurrentTable occupationHealthInspectionCurrentTable : oldContentList) {
                if (!content.getInspectionTableId().equals(occupationHealthInspectionCurrentTable.getInspectionTableId()) || !occupationHealthInspectionCurrentTable.getStageId().equals(occ.getInspectionStageId())) continue;
                has = true;
                break;
            }
            if (has) continue;
            this.saveInspectionContent(content, occ);
        }
    }

    private void saveInspectionContent(OccupationHealthInspectionCurrentTable content, OccupationHealthInspection occ) {
        OccupationHealthInspectionTemplateTable table = this.templateTabeMapper.selectByPrimaryKey(content.getInspectionTableId());
        if (table == null) {
            return;
        }
        content.setInspectionId(occ.getId());
        content.setStageId(occ.getInspectionStageId());
        content.setApprovalDatetime(table.getApprovalDatetime());
        content.setApprove(table.getApprove());
        content.setChecker(table.getChecker());
        content.setFeature(table.getFeature());
        content.setTableName(table.getTableName());
        content.setTableType(table.getTableType());
        content.setVersion(table.getVersion());
        content.setWriter(table.getWriter());
        this.currentTableDao.insert(content);
    }

    private void checkArea(OccupationHealthInspection oldOcc, OccupationHealthInspection occ) {
        List<Object> oldAreaList = oldOcc == null ? new ArrayList() : oldOcc.getAreaList();
        InspectionAdditionsArea additions = InspectionAdditionsArea.getInstance();
        additions.removeOtherByStageIdFromList(occ.getInspectionStageId(), oldAreaList);
        int oldAreaSize = oldAreaList.size();
        int i = 0;
        while (i < oldAreaSize) {
            boolean isNeedDelete = true;
            for (OccupationHealthInspectionCurrentRange area : occ.getAreaList()) {
                if (area.getRangeId() == null || area.getRangeId() == 0 || !area.getRangeId().equals(((OccupationHealthInspectionCurrentRange)oldAreaList.get(i)).getRangeId()) || !((OccupationHealthInspectionCurrentRange)oldAreaList.get(i)).getStageId().equals(occ.getInspectionStageId())) continue;
                isNeedDelete = false;
                break;
            }
            if (isNeedDelete) {
                this.rangeDao.deleteByPrimaryKey(((OccupationHealthInspectionCurrentRange)oldAreaList.get(i)).getId());
                oldAreaList.remove(i);
                --oldAreaSize;
                --i;
            }
            ++i;
        }
        for (OccupationHealthInspectionCurrentRange area : occ.getAreaList()) {
            if (area.getRangeId() == null || area.getRangeId() == 0) continue;
            boolean has = false;
            for (OccupationHealthInspectionCurrentRange occupationHealthInspectionCurrentRange : oldAreaList) {
                if (!area.getRangeId().equals(occupationHealthInspectionCurrentRange.getRangeId()) || !occupationHealthInspectionCurrentRange.getStageId().equals(occ.getInspectionStageId())) continue;
                has = true;
                break;
            }
            if (has) continue;
            this.saveCurrentRange(area, occ);
        }
    }

    private void saveCurrentRange(OccupationHealthInspectionCurrentRange range, OccupationHealthInspection occ) {
        range.setInspectionId(occ.getId());
        range.setStageId(occ.getInspectionStageId());
        this.rangeDao.insert(range);
    }

    private void checkCollaborator(OccupationHealthInspection oldOcc, OccupationHealthInspection occ) {
        List<Object> oldCollaboratorList = oldOcc == null ? new ArrayList() : oldOcc.getCollaboratorList();
        InspectionAdditionsCollaborator additions = InspectionAdditionsCollaborator.getInstance();
        additions.removeOtherByStageIdFromList(occ.getInspectionStageId(), oldCollaboratorList);
        int oldCollaboratorSize = oldCollaboratorList.size();
        int i = 0;
        while (i < oldCollaboratorSize) {
            boolean isNeedDelete = true;
            for (OccupationHealthInspectionCollaborator collaborator : occ.getCollaboratorList()) {
                if (collaborator.getStaffId() == null || collaborator.getStaffId() == null || !collaborator.getStaffId().equals(((OccupationHealthInspectionCollaborator)oldCollaboratorList.get(i)).getStaffId()) || !((OccupationHealthInspectionCollaborator)oldCollaboratorList.get(i)).getStageId().equals(occ.getInspectionStageId())) continue;
                isNeedDelete = false;
                break;
            }
            if (isNeedDelete) {
                this.collaboratorDao.deleteByPrimaryKey(((OccupationHealthInspectionCollaborator)oldCollaboratorList.get(i)).getId());
                oldCollaboratorList.remove(i);
                --oldCollaboratorSize;
                --i;
            }
            ++i;
        }
        for (OccupationHealthInspectionCollaborator collaborator : occ.getCollaboratorList()) {
            if (collaborator.getStaffId() == null || collaborator.getStaffId() == null) continue;
            boolean has = false;
            for (OccupationHealthInspectionCollaborator occupationHealthInspectionCollaborator : oldCollaboratorList) {
                if (!collaborator.getStaffId().equals(occupationHealthInspectionCollaborator.getStaffId()) || !occupationHealthInspectionCollaborator.getStageId().equals(occ.getInspectionStageId())) continue;
                has = true;
                break;
            }
            if (has) continue;
            this.saveInspectionCollaborator(collaborator, occ);
        }
    }

    private void checkPaperManager(OccupationHealthInspection oldOcc, OccupationHealthInspection occ) {
        List<Object> oldPaperManagerList = oldOcc == null ? new ArrayList() : oldOcc.getPaperManagers();
        int oldPaperManagerSize = oldPaperManagerList.size();
        int i = 0;
        while (i < oldPaperManagerSize) {
            boolean isNeedDelete = true;
            for (OccupationHealthInspectionPaperManager paperManager : occ.getPaperManagers()) {
                if (paperManager.getStaffId() == null || paperManager.getStaffId() == null || paperManager.getStaffId() != ((OccupationHealthInspectionPaperManager)oldPaperManagerList.get(i)).getStaffId()) continue;
                isNeedDelete = false;
                break;
            }
            if (isNeedDelete) {
                this.paperManagerDao.deleteByPrimaryKey(((OccupationHealthInspectionPaperManager)oldPaperManagerList.get(i)).getId());
                oldPaperManagerList.remove(i);
                --oldPaperManagerSize;
                --i;
            }
            ++i;
        }
        for (OccupationHealthInspectionPaperManager paperManager : occ.getPaperManagers()) {
            if (paperManager.getStaffId() == null || paperManager.getStaffId() == null) continue;
            boolean has = false;
            for (OccupationHealthInspectionPaperManager occupationHealthInspectionPaperManager : oldPaperManagerList) {
                if (!paperManager.getStaffId().equals(occupationHealthInspectionPaperManager.getStaffId())) continue;
                has = true;
                break;
            }
            if (has) continue;
            paperManager.setInspectionId(occ.getId());
            this.paperManagerDao.insert(paperManager);
        }
    }

    private void saveInspectionCollaborator(OccupationHealthInspectionCollaborator collaborator, OccupationHealthInspection occ) {
        collaborator.setInspectionId(occ.getId());
        collaborator.setStageId(occ.getInspectionStageId());
        this.collaboratorDao.insert(collaborator);
    }

    private void setInspectionSummary(Boolean isApproveSummary, OccupationHealthInspection occ) {
        if (isApproveSummary.booleanValue()) {
            OccupationHealthInspectionSummary summary = this.getSummaryByInspectionIdAndRecordStaffId(occ.getId(), occ.getInspectionManagerIdInitiate());
            if (summary == null) {
                return;
            }
            summary.setResultRecordUser(occ.getInspectionManagerInitiate());
            occ.setSummary(summary);
        } else {
            Staff staff = LoginUtil.getInstance().getLoginStaffInfo();
            if (staff != null) {
                OccupationHealthInspectionSummary summary = this.getSummaryByInspectionIdAndRecordStaffId(occ.getId(), staff.getId());
                if (summary == null) {
                    summary = new OccupationHealthInspectionSummary();
                    if (staff.getId().equals(occ.getInspectionManagerId())) {
                        summary.setInspectionResultSn(OccupationHealthInspectionUtil.getInstance().getSummarySnManager(occ.getInspectionTypeInitiate()));
                        summary.setRecordStaffType(InspectionRecordStaffType.manager.getValue());
                    } else {
                        summary.setInspectionResultSn(OccupationHealthInspectionUtil.getInstance().getSummarySnCollaborator(occ.getInspectionTypeInitiate()));
                        summary.setRecordStaffType(InspectionRecordStaffType.collaborator.getValue());
                    }
                    summary.setInspectionResultRedordUser(staff.getId());
                    summary.setInspectionId(occ.getId());
                }
                occ.setSummary(summary);
            }
        }
    }

    private void getInitiateSn(OccupationHealthInspection occ) {
        if (StringUtils.isEmpty((String)occ.getInformSn())) {
            occ.setInformSn(OccupationHealthInspectionUtil.getInstance().getInformSn());
        }
    }

    private void setOccupationHealthInspectionPlanInfo(OccupationHealthInspection occ) {
        occ.setAreaList(this.rangeDao.selectByInspectionIdAndStageId(occ.getId(), occ.getInfoStage()));
        occ.setCollaboratorList(this.collaboratorDao.selectByInspectionIdAndStageId(occ.getId(), occ.getInfoStage()));
        occ.setOtherAttachmentList(this.otherAttachmentDao.selectByInspectionIdAndStageId(occ.getId(), occ.getInfoStage()));
        occ.setContentList(this.currentTableDao.selectByInspectionIdAndStageId(occ.getId(), occ.getInfoStage(), false));
    }

    @Override
    public List<OccupationHealthInspectionCurrentTable> getInspectionContentForSummary(Integer inspectionId) {
        if (inspectionId == null) {
            return null;
        }
        return this.currentTableDao.selectByInspectionIdAndStageId(inspectionId, OccupationHealthStageRelation.initiate.getStage().getValue(), false);
    }

    private void getOccupationHealthInspectionInitiateInfo(OccupationHealthInspection occ, Byte infoStage) {
        this.getInspectionAreaCollaboratorAndSoOn(occ, infoStage);
        this.getInitiateSn(occ);
    }

    private void getInspectionAreaCollaboratorAndSoOn(OccupationHealthInspection occ, Byte infoStage) {
        occ.setAreaList(this.rangeDao.selectByInspectionIdAndStageId(occ.getId(), infoStage));
        occ.setCollaboratorList(this.collaboratorDao.selectByInspectionIdAndStageId(occ.getId(), infoStage));
        occ.setOtherAttachmentList(this.otherAttachmentDao.selectByInspectionIdAndStageId(occ.getId(), infoStage));
        occ.setContentList(this.currentTableDao.selectByInspectionIdAndStageId(occ.getId(), infoStage, false));
    }

    private void getOccupationHealthInspectionSummaryInfo(OccupationHealthInspection occ, Byte infoStage, boolean isApprove) {
        this.getInspectionAreaCollaboratorAndSoOn(occ, infoStage);
        this.setInspectionSummary(isApprove, occ);
    }

    private void getOccupationHealthInspectionFileInfo(OccupationHealthInspection occ) {
        OccupationHealthInspectionPaperManagerExample example = new OccupationHealthInspectionPaperManagerExample();
        example.createCriteria().andInspectionIdEqualTo(occ.getId()).andRecordStateGreaterThan(RecordState.invalid.getValue());
        occ.setPaperManagers(this.paperManagerDao.selectByExample(example));
    }

    @Override
    public OccupationHealthInspection selectOccupationHealthInspectionByPrimaryKey(Integer id, Byte stageId, Boolean isApprove) {
        if (id == null) {
            return null;
        }
        OccupationHealthInspection occ = this.inspectionDao.selectByPrimaryKey(id);
        if (occ == null) {
            return null;
        }
        if (stageId == null) {
            stageId = occ.getInspectionStageId();
        }
        this.getOccupationHealthInspectionInfoStage(occ, stageId);
        if (RecordType.makeup.getValue().equals(occ.getRecordType())) {
            this.setMakeupContent(occ);
        } else {
            this.setOrdinaryContent(occ, isApprove, stageId);
        }
        return occ;
    }

    private void setOrdinaryContent(OccupationHealthInspection occ, Boolean isApprove, Byte stageId) {
        if (OccupationHealthStageRelation.plan.getStage().getValue().equals(stageId)) {
            this.setOccupationHealthInspectionPlanInfo(occ);
        } else if (OccupationHealthStageRelation.initiate.getStage().getValue().equals(stageId)) {
            this.getOccupationHealthInspectionInitiateInfo(occ, occ.getInfoStage());
        } else if (OccupationHealthStageRelation.implement.getStage().getValue().equals(stageId)) {
            this.getOccupationHealthInspectionInitiateInfo(occ, occ.getInfoStage());
        } else if (OccupationHealthStageRelation.summary.getStage().getValue().equals(stageId)) {
            isApprove = isApprove == null ? false : isApprove;
            this.getOccupationHealthInspectionSummaryInfo(occ, occ.getInfoStage(), isApprove);
        } else if (OccupationHealthStageRelation.file.getStage().getValue().equals(stageId)) {
            this.getOccupationHealthInspectionFileInfo(occ);
        }
        if (occ.getInspectionStageId().compareTo(OccupationHealthStageRelation.plan.getStage().getValue()) > 0) {
            occ.setFeedbackList(this.getFeedbackList(occ.getId(), OccupationHealthStageRelation.initiate.getStage().getValue(), null));
        }
    }

    private void setMakeupContent(OccupationHealthInspection occ) {
        this.getOccupationHealthInspectionInitiateInfo(occ, OccupationHealthStageRelation.initiate.getStage().getValue());
        this.getOccupationHealthInspectionSummaryInfo(occ, OccupationHealthStageRelation.initiate.getStage().getValue(), true);
        this.getOccupationHealthInspectionFileInfo(occ);
        this.getMakeupExtendInfo(occ);
    }

    private void getMakeupExtendInfo(OccupationHealthInspection occ) {
        if (occ == null || occ.getId() == null) {
            return;
        }
        OccupationHealthInspectionMakeUpExample example = new OccupationHealthInspectionMakeUpExample();
        example.createCriteria().andRecordStateEqualTo(RecordState.valid.getValue()).andInspecitonidEqualTo(occ.getId());
        List<OccupationHealthInspectionMakeUp> list = this.makeupMapper.selectByExample(example);
        if (list.size() > 0) {
            occ.setMakeup(list.get(0));
        }
    }

    private void setMaterialReformItem(OccupationHealthInspectionEmergencyMaterialTable item, Integer recordStaffId, Integer tableId) {
        OccupationHealthInspectionReformItemExample example = new OccupationHealthInspectionReformItemExample();
        example.createCriteria().andCreateByEqualTo(recordStaffId).andInspectionTableTypeEqualTo(InspectionTableSystemType.emergencyMaterial.getValue()).andInspectionTableIdEqualTo(tableId).andInspectionItemIdEqualTo(item.getId()).andRecordStateGreaterThan(RecordState.invalid.getValue());
        item.setRefItemList(this.reformItemMapper.selectByExample(example));
        for (OccupationHealthInspectionReformItem reformItem : item.getRefItemList()) {
            this.setReformItemExtnedInfo(reformItem);
        }
    }

    private void setWarningSignReformItem(OccupationHealthInspectionWarningSignsTable item, Integer recordStaffId, Integer tableId) {
        OccupationHealthInspectionReformItemExample example = new OccupationHealthInspectionReformItemExample();
        example.createCriteria().andCreateByEqualTo(recordStaffId).andInspectionTableTypeEqualTo(InspectionTableSystemType.warningSigns.getValue()).andInspectionTableIdEqualTo(tableId).andInspectionItemIdEqualTo(item.getId()).andRecordStateGreaterThan(RecordState.invalid.getValue());
        item.setRefItemList(this.reformItemMapper.selectByExample(example));
        for (OccupationHealthInspectionReformItem reformItem : item.getRefItemList()) {
            this.setReformItemExtnedInfo(reformItem);
        }
    }

    private void setCustomTableReformItem(OccupationHealthInspectionCurrentTableItem item, Integer recordStaffId, Integer tableId) {
        OccupationHealthInspectionReformItemExample example = new OccupationHealthInspectionReformItemExample();
        example.createCriteria().andCreateByEqualTo(recordStaffId).andInspectionTableTypeEqualTo(InspectionTableSystemType.custom.getValue()).andInspectionTableIdEqualTo(tableId).andInspectionItemIdEqualTo(item.getId()).andRecordStateGreaterThan(RecordState.invalid.getValue());
        item.setRefItemList(this.reformItemMapper.selectByExample(example));
        for (OccupationHealthInspectionReformItem reformItem : item.getRefItemList()) {
            this.setReformItemExtnedInfo(reformItem);
        }
    }

    private void setEquipmentTableReformItem(OccupationHealthInspectionEquipentTable item, Integer recordStaffId, Integer tableId) {
        OccupationHealthInspectionReformItemExample example = new OccupationHealthInspectionReformItemExample();
        example.createCriteria().andCreateByEqualTo(recordStaffId).andInspectionTableTypeEqualTo(InspectionTableSystemType.equipment.getValue()).andInspectionTableIdEqualTo(tableId).andInspectionItemIdEqualTo(item.getId()).andRecordStateGreaterThan(RecordState.invalid.getValue());
        item.setRefItemList(this.reformItemMapper.selectByExample(example));
        for (OccupationHealthInspectionReformItem reformItem : item.getRefItemList()) {
            this.setReformItemExtnedInfo(reformItem);
        }
    }

    private void getOccupationHealthInspectionInfoStage(OccupationHealthInspection occ, Byte stageId) {
        if (stageId.equals(OccupationHealthStageRelation.initiate.getStage().getValue())) {
            occ.setInfoStage(this.getInitiateInfoStage(occ));
        } else if (stageId.equals(OccupationHealthStageRelation.file.getStage().getValue())) {
            occ.setInfoStage(stageId);
        } else if (stageId.equals(OccupationHealthStageRelation.initiate.getStage().getValue()) || stageId.equals(OccupationHealthStageRelation.implement.getStage().getValue()) || stageId.equals(OccupationHealthStageRelation.summary.getStage().getValue())) {
            occ.setInfoStage(OccupationHealthStageRelation.initiate.getStage().getValue());
        } else {
            occ.setInfoStage(stageId);
        }
    }

    private Byte getInitiateInfoStage(OccupationHealthInspection occ) {
        boolean hasInitiateInfo;
        boolean bl = hasInitiateInfo = StringUtils.isNotEmpty(occ.getInformSn());
        if (hasInitiateInfo) {
            return OccupationHealthStageRelation.initiate.getStage().getValue();
        }
        return OccupationHealthStageRelation.plan.getStage().getValue();
    }

    @Override
    @Transactional(readOnly=false)
    public int updateByPrimaryKeySelective(OccupationHealthInspection record) {
        return this.inspectionDao.updateByPrimaryKeySelective(record, record.getId());
    }

    @Override
    @Transactional(readOnly=false)
    public OccupationHealthInspection saveOccupationHealthInspectionInitiate(OccupationHealthInspection occ) {
        this.saveOccupationHealthInspectionPlan(occ);
        return occ;
    }

    private void deleteInform(Integer inspectionId, Byte stageId) {
        if (inspectionId == null || stageId == null) {
            return;
        }
        OccupationHealthInspectionInformFeedbackExample example = new OccupationHealthInspectionInformFeedbackExample();
        OccupationHealthInspectionInformFeedbackExample.Criteria criteria = example.createCriteria();
        criteria.andInspectionIdEqualTo(inspectionId);
        criteria.andStageIdEqualTo(stageId);
        criteria.andRecordStateEqualTo(RecordState.valid.getValue());
        OccupationHealthInspectionInformFeedback oldFeedback = new OccupationHealthInspectionInformFeedback();
        oldFeedback.setRecordState(RecordState.invalid.getValue());
        EntityUtil.getInstance().setCreateAndUpdateInfo(oldFeedback);
        this.feedbackMapper.updateByExampleSelective(oldFeedback, example);
    }

    @Override
    @Transactional(readOnly=false)
    public void InitiateFeedback(WorkFlowParam param, OccupationHealthInspectionInformFeedback feedback) {
        Map<String, Object> paramMap = param.getparamMap();
        Staff staff = this.staffService.selectByUserId(Integer.valueOf(param.getReceiver()));
        if (staff != null) {
            OccupationHealthInspectionInformFeedbackExample example = new OccupationHealthInspectionInformFeedbackExample();
            OccupationHealthInspectionInformFeedbackExample.Criteria criteria = example.createCriteria();
            criteria.andInspectionIdEqualTo(param.getBusinessId());
            criteria.andWorkflowIdEqualTo(param.getOrderId());
            criteria.andFeedbackUserIdEqualTo(staff.getId());
            criteria.andStageIdEqualTo(Byte.valueOf(param.getBusinessPhase()));
            feedback.setFeedbackTime(new Date());
            this.feedbackMapper.updateByExampleSelective(feedback, example);
        }
        this.facets.execute(param.getTaskId(), "" + LoginUtil.getInstance().getLoginStaffInfo().getId(), paramMap);
    }

    @Override
    public Boolean isInformed(Integer inspectionId, Byte stageId) {
        if (inspectionId == null || stageId == null) {
            return false;
        }
        OccupationHealthInspectionInformFeedbackExample example = new OccupationHealthInspectionInformFeedbackExample();
        OccupationHealthInspectionInformFeedbackExample.Criteria criteria = example.createCriteria();
        criteria.andInspectionIdEqualTo(inspectionId);
        criteria.andStageIdEqualTo(stageId);
        criteria.andRecordStateEqualTo(RecordState.valid.getValue());
        List<OccupationHealthInspectionInformFeedback> feedbackList = this.feedbackMapper.selectByExample(example);
        return feedbackList != null && feedbackList.size() >= 1;
    }

    @Override
    public List<OccupationHealthInspectionTemplateItem> getTemplateItemListlocalByCompanyId(Integer companyId) {
        if (companyId == null) {
            return null;
        }
        OccupationHealthInspectionTemplateItemExample example = new OccupationHealthInspectionTemplateItemExample();
        OccupationHealthInspectionTemplateItemExample.Criteria criteria = example.createCriteria();
        criteria.andCompanyIdEqualTo(companyId);
        return this.templateItemMapper.selectByExample(example);
    }

    @Override
    @Transactional(readOnly=false)
    public void goNextStage(Integer inspectionId) {
        OccupationHealthInspection occ = this.selectOccupationHealthInspectionByPrimaryKey(inspectionId, null, null);
        if (occ == null) {
            return;
        }
        this.updateStage(inspectionId, occ.getInspectionStageId(), false, null, false);
        this.setNoApprove(inspectionId, occ.getInspectionStageId());
    }

    @Transactional(readOnly=false)
    private void updateModularForApprove(WorkFlowParam param, Integer orderId) {
        Byte modelId = Modulars.occupationHealthInspection.getValue();
        WfModular wfModular = new WfModular();
        wfModular.setModularId(modelId);
        wfModular.setPhase(Integer.valueOf(param.getBusinessPhase()));
        wfModular.setSolutionId(param.getBusinessId());
        wfModular.setStatus(Integer.valueOf(param.getBusinessStatus()));
        boolean isDeleteInfo = param.isApplyBranch();
        Boolean isNeedApprove = param.getNeedapprove();
        if (isNeedApprove == null || param.getOrderId() != null || param.getTaskId() != null) {
            isNeedApprove = true;
        }
        OccupationHealthInspectionUtil.getInstance().getClass();
        if (isNeedApprove.booleanValue()) {
            if (param.isApplyBranch()) {
                wfModular.setWorkflowId(orderId);
                wfModular.setApproveResult(ApproveResult.notApprove.getValue());
                wfModular.setApproveNum(this.workflowService.getWfModularMaxApproveNum(wfModular.getSolutionId(), wfModular.getModularId(), wfModular.getPhase()));
                this.workflowService.saveWfModularInfo(wfModular);
            } else {
                wfModular.setWorkflowId(orderId);
                wfModular.setApproveResult(param.getApproved() != false ? ApproveResult.approvePass.getValue() : ApproveResult.approveFail.getValue());
                wfModular.setOpinion(param.getRemark());
                this.workflowService.updateWfModularResult(wfModular);
            }
        } else if (param.getOrderId() == null && param.getTaskId() == null) {
            wfModular.setWorkflowId(orderId);
            wfModular.setApproveResult(ApproveResult.approvePass.getValue());
            wfModular.setApproveNum(this.workflowService.getWfModularMaxApproveNum(wfModular.getSolutionId(), wfModular.getModularId(), wfModular.getPhase()));
            this.workflowService.saveWfModularInfo(wfModular);
        }
        this.updateStage(wfModular.getSolutionId(), wfModular.getPhase().byteValue(), isNeedApprove, wfModular.getApproveResult(), isDeleteInfo);
    }

    private void setNoApprove(Integer inspectioId, Byte stageId) {
        WfModular wfModular = new WfModular();
        wfModular.setModularId(Modulars.occupationHealthInspection.getValue());
        wfModular.setPhase((int)stageId);
        wfModular.setSolutionId(inspectioId);
        wfModular.setStatus(null);
        wfModular.setWorkflowId(null);
        wfModular.setApproveResult(ApproveResult.approvePass.getValue());
        wfModular.setApproveNum(this.workflowService.getWfModularMaxApproveNum(wfModular.getSolutionId(), wfModular.getModularId(), wfModular.getPhase()));
        this.workflowService.saveWfModularInfo(wfModular);
    }

    private void updateStage(Integer inspectioId, Byte stageId, boolean isNeedApprove, Byte approveResult, boolean isDeleteInfo) {
        OccupationHealthInspection occ;
        if (isDeleteInfo) {
            this.deleteInform(inspectioId, stageId);
        }
        OccupationHealthInspectionUtil.getInstance().getClass();
        if (isNeedApprove) {
            if (ApproveResult.approvePass.getValue() != approveResult) {
                return;
            }
            if (OccupationHealthStageRelation.initiate.getStage().getValue().equals(stageId)) {
                return;
            }
            if (OccupationHealthStageRelation.plan.getStage().getValue().equals(stageId)) {
                this.inspectionTableService.cloneItemsFromTemplateToCurrentTable(inspectioId, OccupationHealthStageRelation.plan.getStage().getValue());
            } else if (OccupationHealthStageRelation.summary.getStage().getValue().equals(stageId)) {
                occ = this.selectOccupationHealthInspectionByPrimaryKey(inspectioId, null, null);
                this.setReformModularRefItem(inspectioId, occ.getInspectionType());
                if (OccupationHealthInspectionType.dailyScene.getValue().equals(occ.getInspectionTypeInitiate())) {
                    this.setReformInspectionRegularChckInfo(occ.getId(), occ.getInspectionManagerIdInitiate());
                }
            } else if (OccupationHealthStageRelation.file.getStage().getValue().equals(stageId)) {
                occ = this.selectOccupationHealthInspectionByPrimaryKey(inspectioId, null, null);
                if (RecordType.makeup.getValue().equals(occ.getRecordType())) {
                    this.setReformModularRefItem(inspectioId, occ.getInspectionType());
                    this.setInspectionImmutable(occ.getId());
                    this.completeWorkFlow(RecordState.immutable.getValue(), occ.getInspectionStageId(), occ.getId());
                }
            }
        } else if (OccupationHealthStageRelation.initiate.getStage().getValue().equals(stageId)) {
            this.inspectionTableService.cloneItemsFromTemplateToCurrentTable(inspectioId, OccupationHealthStageRelation.initiate.getStage().getValue());
        } else if (OccupationHealthStageRelation.plan.getStage().getValue().equals(stageId)) {
            this.inspectionTableService.cloneItemsFromTemplateToCurrentTable(inspectioId, OccupationHealthStageRelation.plan.getStage().getValue());
        } else if (OccupationHealthStageRelation.summary.getStage().getValue().equals(stageId)) {
            occ = this.selectOccupationHealthInspectionByPrimaryKey(inspectioId, null, null);
            this.setReformModularRefItem(inspectioId, occ.getInspectionType());
            if (OccupationHealthInspectionType.dailyScene.getValue().equals(occ.getInspectionTypeInitiate())) {
                this.setReformInspectionRegularChckInfo(occ.getId(), occ.getInspectionManagerIdInitiate());
            }
        } else if (OccupationHealthStageRelation.file.getStage().getValue().equals(stageId)) {
            occ = this.selectOccupationHealthInspectionByPrimaryKey(inspectioId, null, null);
            if (RecordType.makeup.getValue().equals(occ.getRecordType())) {
                this.setReformModularRefItem(inspectioId, occ.getInspectionType());
                this.setInspectionImmutable(occ.getId());
                this.completeWorkFlow(RecordState.immutable.getValue(), occ.getInspectionStageId(), occ.getId());
            }
        }
        Byte nextPhase = this.getNextPhase(Modulars.occupationHealthInspection.getValue(), stageId, isNeedApprove);
        if (nextPhase != null) {
            OccupationHealthInspection inspection = new OccupationHealthInspection();
            inspection.setId(inspectioId);
            inspection.setInspectionStageId(nextPhase.equals(OccupationHealthStageRelation.implement.getStage().getValue()) ? OccupationHealthStageRelation.summary.getStage().getValue() : nextPhase);
            this.updateByPrimaryKeySelective(inspection);
        }
    }

    private void setInspectionImmutable(Integer inspectionId) {
        OccupationHealthInspection occ = new OccupationHealthInspection();
        occ.setRecordState(RecordState.immutable.getValue());
        occ.setId(inspectionId);
        EntityUtil.getInstance().setCreateAndUpdateInfo(occ);
        this.inspectionDao.updateByPrimaryKeySelective(occ, occ.getId());
    }

    private void setReformInspectionRegularChckInfo(Integer inspectionId, Integer recoredStaffId) {
        List<OccupationHealthInspectionCurrentTable> tableList = this.getInspectionContentForSummary(inspectionId);
        for (OccupationHealthInspectionCurrentTable table : tableList) {
            if (!InspectionTableSystemType.reformItem.getValue().equals(table.getTableNativeCode())) continue;
            List<OccupationHealthInspectionReformItemTable> reformItemTableList = this.getInspectionReformItemsList(recoredStaffId, table.getId());
            for (OccupationHealthInspectionReformItemTable reformItemTable : reformItemTableList) {
                RefReformregularcheck record = new RefReformregularcheck();
                record.setChecker(recoredStaffId);
                if (reformItemTable.getReformItem() != null) {
                    record.setDesc(reformItemTable.getReformItem().getDescription());
                }
                record.setIsvalid(Constant.ACTIVE_YES);
                record.setItemid(reformItemTable.getReformItemId());
                record.setUpdatetime(new Date());
                OccupationHealthInspectionTableItemResult result = reformItemTable.getInspectionResult();
                if (result != null) {
                    OccupationHealthInspectionTableItemResultReform resultReform = result.getReformSpecial();
                    if (resultReform != null) {
                        record.setFinisheddesc(reformItemTable.getInspectionResult().getReformSpecial().getFinishedExplain());
                        record.setUnfinisheddesc(reformItemTable.getInspectionResult().getReformSpecial().getUnfinishedExplain());
                    }
                    record.setRegister(reformItemTable.getInspectionResult().getCreateBy());
                }
                this.reformItemService.insertRegularCheck(record);
            }
        }
    }

    private void setReformModularRefItem(Integer inspectionId, Byte inspectionType) {
        if (inspectionId == null) {
            return;
        }
        List<OccupationHealthInspectionSummary> summaryList = this.getInspectionSummaryByStaffType(inspectionId, InspectionRecordStaffType.manager);
        if (summaryList == null || summaryList.size() == 0) {
            return;
        }
        List<WfModular> wfmodularList = this.workflowService.selectWfModularByModularIdAndSolutionIdAndStageId(Modulars.occupationHealthInspection.getValue(), inspectionId, (int)OccupationHealthStageRelation.summary.getStage().getValue());
        WfModular wfModular = null;
        int num = 0;
        for (WfModular wm : wfmodularList) {
            if (!wm.getApproveResult().equals(ApproveResult.approvePass.getValue()) || wm.getApproveNum() <= num) continue;
            wfModular = wm;
        }
        String resultSource = "\u73b0\u573a\u68c0\u67e5";
        byte reformImageType = ReformFileType.reformImage.getValue();
        byte reformAudioType = ReformFileType.reformImage.getValue();
        byte reformVideoType = ReformFileType.reformImage.getValue();
        if (OccupationHealthInspectionType.dailyScene.getValue().equals(inspectionType)) {
            resultSource = "\u65e5\u5e38\u68c0\u67e5";
            reformImageType = ReformFileType.dailySceneReformImage.getValue();
            reformAudioType = ReformFileType.dailySceneReformAudio.getValue();
            reformVideoType = ReformFileType.dailySceneReformVideo.getValue();
        }
        for (OccupationHealthInspectionSummary summary : summaryList) {
            for (OccupationHealthInspectionTableItemResult result : summary.getResultList()) {
                for (OccupationHealthInspectionReformItem reformItem : result.getRefItemList()) {
                    RefReformitemWithBLOBs record = new RefReformitemWithBLOBs();
                    record.setCid(LoginUtil.getInstance().getLoginStaffCompanyId());
                    record.setResultsource(resultSource);
                    record.setResultid(summary.getId());
                    record.setItemno(reformItem.getReformSn());
                    record.setReason(reformItem.getReason());
                    record.setDescription(reformItem.getReformItemDescribe());
                    record.setConsequence(reformItem.getAftermath());
                    record.setFinder(reformItem.getDiscoverer());
                    record.setFindtime(reformItem.getInspectionDate());
                    record.setRegister(reformItem.getCreateBy());
                    record.setRegtime(reformItem.getCreateDate());
                    if (wfModular != null) {
                        record.setApprover(wfModular.getUpdateBy());
                        record.setApprovetime(wfModular.getUpdateDate());
                    }
                    record.setItemposition(reformItem.getReformPlaces());
                    record.setItemtype((int)reformItem.getReformType());
                    record.setItemlevel((int)reformItem.getReformLevel());
                    record.setManager(reformItem.getReformManagerId());
                    record.setAttenders(reformItem.getReformCollaboratorId());
                    record.setItemstatus(1);
                    this.reformItemService.createItem(record);
                    this.insertBeforeReformFile(reformItem.getBeforeReformImage(), reformImageType, record.getId());
                    this.insertBeforeReformFile(reformItem.getBeforeReformAudio(), reformAudioType, record.getId());
                    this.insertBeforeReformFile(reformItem.getBeforeReformVideo(), reformVideoType, record.getId());
                    RefReformphase reformPhase = new RefReformphase();
                    reformPhase.setCid(record.getCid());
                    reformPhase.setItemid(record.getId());
                    reformPhase.setInformtime(new Date());
                    reformPhase.setInformno(OccupationHealthInspectionUtil.getInstance().getReformInformSn());
                    reformPhase.setRequiredtime(reformItem.getReformFinishDate());
                    this.reformPhaseService.create(reformPhase);
                }
            }
        }
    }

    private void insertBeforeReformFile(String fileStr, byte fileType, int reformItemId) {
        String[] fileArray;
        if (StringUtils.isEmpty((String)fileStr)) {
            return;
        }
        String[] stringArray = fileArray = fileStr.split(",");
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (StringUtils.isNumber(id)) {
                RefReformfile reformFile = new RefReformfile();
                reformFile.setItemid(reformItemId);
                reformFile.setFiletype(fileType);
                reformFile.setFile(Integer.valueOf(id));
                reformFile.setIsvalid(Constant.ACTIVE_YES);
                this.reformService.updateFile(reformFile);
            }
            ++n2;
        }
    }

    private List<OccupationHealthInspectionSummary> getInspectionSummaryByStaffType(Integer inspectionId, InspectionRecordStaffType recordStffType) {
        if (inspectionId == null) {
            return null;
        }
        OccupationHealthInspectionSummaryExample example = new OccupationHealthInspectionSummaryExample();
        OccupationHealthInspectionSummaryExample.Criteria criteria = example.createCriteria();
        criteria.andInspectionIdEqualTo(inspectionId);
        if (recordStffType != null) {
            criteria.andRecordStaffTypeEqualTo(recordStffType.getValue());
        }
        criteria.andRecordStateEqualTo(RecordState.valid.getValue());
        List<OccupationHealthInspectionSummary> list = this.summaryMapper.selectByExample(example);
        for (OccupationHealthInspectionSummary summary : list) {
            this.setSummaryResultListInfo(summary, true);
        }
        return list;
    }

    private Byte getNextPhase(Byte modularId, Byte stageId, boolean isApprove) {
        if (modularId.equals(Modulars.occupationHealthInspection.getValue())) {
            if (stageId == null || isApprove && stageId.byteValue() == OccupationHealthStageRelation.initiate.getStage().getValue().byteValue()) {
                return null;
            }
            OccupationHealthStageRelation[] occupationHealthStageRelationArray = OccupationHealthStageRelation.values();
            int n = occupationHealthStageRelationArray.length;
            int n2 = 0;
            while (n2 < n) {
                OccupationHealthStageRelation stage = occupationHealthStageRelationArray[n2];
                if (stage.getStage().getValue().equals(stageId)) {
                    if (stage.getNextStage() == null) {
                        return null;
                    }
                    return stage.getNextStage().getValue();
                }
                ++n2;
            }
        }
        return null;
    }

    private void saveSummaryInfo(OccupationHealthInspectionSummary summary) {
        if (summary == null) {
            return;
        }
        EntityUtil.getInstance().setCreateAndUpdateInfo(summary);
        if (summary.getId() == null) {
            this.summaryMapper.insert(summary);
        } else {
            this.summaryMapper.updateByPrimaryKeySelective(summary);
        }
    }

    private void saveSummaryResultInfo(List<OccupationHealthInspectionTableItemResult> list, Integer summaryId) {
        if (summaryId == null) {
            return;
        }
        for (OccupationHealthInspectionTableItemResult result : list) {
            result.setSummaryId(summaryId);
            EntityUtil.getInstance().setCreateAndUpdateInfo(result);
            if (result.getId() == null) {
                this.resultMapper.insertSelective(result);
            } else {
                this.resultMapper.updateByPrimaryKeySelective(result);
            }
            if (result.getResultSpecial() != null && result.getResultSpecial().isNotEmpty()) {
                if (result.getResultSpecial().getId() != null && result.getResultSpecial().getId() > 0) {
                    EntityUtil.getInstance().setCreateAndUpdateInfo(result.getResultSpecial());
                    this.resultSpecialMapper.updateByPrimaryKeySelective(result.getResultSpecial());
                } else if (result.getResultSpecial().isNotEmpty()) {
                    result.getResultSpecial().setResultId(result.getId());
                    EntityUtil.getInstance().setCreateAndUpdateInfo(result.getResultSpecial());
                    this.resultSpecialMapper.insert(result.getResultSpecial());
                }
            }
            if (result.getReformSpecial() == null) continue;
            if (result.getReformSpecial().getId() != null && result.getReformSpecial().getId() > 0) {
                EntityUtil.getInstance().setCreateAndUpdateInfo(result.getReformSpecial());
                result.getReformSpecial().setResultId(result.getId());
                this.resultReformMapper.updateByPrimaryKeySelective(result.getReformSpecial());
                continue;
            }
            EntityUtil.getInstance().setCreateAndUpdateInfo(result.getReformSpecial());
            result.getReformSpecial().setResultId(result.getId());
            this.resultReformMapper.insert(result.getReformSpecial());
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void saveInspectionSummary(OccupationHealthInspection occ) {
        if (occ == null) {
            return;
        }
        this.saveSummaryInfo(occ.getSummary());
        this.saveSummaryResultInfo(occ.getSummary().getResultList(), occ.getSummary().getId());
    }

    private void completeWorkFlow(Byte recrodState, Byte inspectionStageId, Integer inspectionId) {
        if (!RecordState.immutable.getValue().equals(recrodState) || inspectionStageId == null || inspectionId == null) {
            return;
        }
        Integer companyId = LoginUtil.getInstance().getLoginStaffCompanyId();
        Integer loginStaffId = LoginUtil.getInstance().getLoginStaffId();
        String applyer = loginStaffId == null ? "" : "" + loginStaffId;
        WorkFlowParam param = new WorkFlowParam();
        param.setApplyer(applyer);
        param.setStage(OccupationHealthStageRelation.getStage(inspectionStageId).getName());
        param.setBusinessPhase("" + inspectionStageId);
        param.setBusinessId(inspectionId);
        param.setBusinessType(Modulars.occupationHealthInspection.getCode());
        this.modularWordflowService.completeWorkflow(companyId, param);
    }

    @Override
    @Transactional(readOnly=false)
    public void saveInspectionFileInfo(OccupationHealthInspection occ) {
        OccupationHealthInspection oldOcc = this.selectOccupationHealthInspectionByPrimaryKey(occ.getId(), null, null);
        this.checkPaperManager(oldOcc, occ);
        OccupationHealthInspection occFileInfo = new OccupationHealthInspection();
        occFileInfo.setId(occ.getId());
        occFileInfo.setInspectionPaperStorePlace(occ.getInspectionPaperStorePlace());
        occFileInfo.setInspectionPaperMark(occ.getInspectionPaperMark());
        occFileInfo.setRecordState(occ.getRecordState());
        this.inspectionDao.updateByPrimaryKeySelective(occFileInfo, occFileInfo.getId());
        this.completeWorkFlow(occ.getRecordState(), oldOcc.getInspectionStageId(), oldOcc.getId());
    }

    @Override
    @Transactional(readOnly=false)
    public void deleteInspections(List<Integer> ids) {
        for (Integer id : ids) {
            this.inspectionDao.deleteByPrimaryKey(id);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void saveInspectionReformItem(OccupationHealthInspectionReformItem reformItem) {
        for (Area area : reformItem.getReformPlacesArea()) {
            if (area.getId() == null || area.getId() <= 0) continue;
            reformItem.setReformPlaces(String.valueOf(reformItem.getReformPlaces() == null ? "," : reformItem.getReformPlaces()) + area.getId() + ",");
        }
        for (Integer staff : reformItem.getReformCollaborators()) {
            if (staff == null || staff <= 0 || reformItem.getReformCollaboratorId() != null && reformItem.getReformCollaboratorId().indexOf("," + staff + ",") > -1) continue;
            reformItem.setReformCollaboratorId(String.valueOf(reformItem.getReformCollaboratorId() == null ? "," + staff + "," : reformItem.getReformCollaboratorId()) + staff + ",");
        }
        for (File file : reformItem.getBeforeReformImageFile()) {
            if (file.getId() == null || file.getId() <= 0) continue;
            reformItem.setBeforeReformImage(String.valueOf(reformItem.getBeforeReformImage() == null ? "," : reformItem.getBeforeReformImage()) + file.getId() + ",");
        }
        for (File file : reformItem.getBeforeReformAudioFile()) {
            if (file.getId() == null || file.getId() <= 0) continue;
            reformItem.setBeforeReformAudio(String.valueOf(reformItem.getBeforeReformAudio() == null ? "," : reformItem.getBeforeReformAudio()) + file.getId() + ",");
        }
        for (File file : reformItem.getBeforeReformVideoFile()) {
            if (file.getId() == null || file.getId() <= 0) continue;
            reformItem.setBeforeReformVideo(String.valueOf(reformItem.getBeforeReformVideo() == null ? "," : reformItem.getBeforeReformVideo()) + file.getId() + ",");
        }
        EntityUtil.getInstance().setCreateAndUpdateInfo(reformItem);
        if (reformItem.getId() != null) {
            this.reformItemMapper.updateByPrimaryKeySelective(reformItem);
        } else {
            this.reformItemMapper.insert(reformItem);
        }
    }

    private void setReformItemExtnedInfo(OccupationHealthInspectionReformItem refItem) {
        String[] videos;
        String[] audios;
        String[] images;
        String[] reformCollaborator;
        int n;
        String[] places;
        if (refItem == null) {
            return;
        }
        String[] stringArray = places = StringUtils.isEmpty((String)refItem.getReformPlaces()) ? null : refItem.getReformPlaces().split(",");
        if (places != null) {
            String[] stringArray2 = places;
            n = places.length;
            int n2 = 0;
            while (n2 < n) {
                String areaId = stringArray2[n2];
                if (StringUtils.isNumber(areaId)) {
                    refItem.getReformPlacesArea().add(this.AreaService.getArea(Integer.valueOf(areaId)));
                }
                ++n2;
            }
        }
        String[] stringArray3 = reformCollaborator = StringUtils.isEmpty((String)refItem.getReformCollaboratorId()) ? null : refItem.getReformCollaboratorId().split(",");
        if (reformCollaborator != null) {
            String[] stringArray4 = reformCollaborator;
            int n3 = reformCollaborator.length;
            n = 0;
            while (n < n3) {
                String collaboratorId = stringArray4[n];
                if (StringUtils.isNumber(collaboratorId)) {
                    refItem.getReformCollaborators().add(Integer.valueOf(collaboratorId));
                }
                ++n;
            }
        }
        String[] stringArray5 = images = StringUtils.isEmpty((String)refItem.getBeforeReformImage()) ? null : refItem.getBeforeReformImage().split(",");
        if (images != null) {
            String[] stringArray6 = images;
            int n4 = images.length;
            int n5 = 0;
            while (n5 < n4) {
                String image = stringArray6[n5];
                if (StringUtils.isNumber(image)) {
                    refItem.getBeforeReformImageFile().add(this.fileService.getById(Integer.valueOf(image)));
                }
                ++n5;
            }
        }
        String[] stringArray7 = audios = StringUtils.isEmpty((String)refItem.getBeforeReformAudio()) ? null : refItem.getBeforeReformAudio().split(",");
        if (audios != null) {
            String[] stringArray8 = audios;
            int n6 = audios.length;
            int n7 = 0;
            while (n7 < n6) {
                String audio = stringArray8[n7];
                if (StringUtils.isNumber(audio)) {
                    refItem.getBeforeReformAudioFile().add(this.fileService.getById(Integer.valueOf(audio)));
                }
                ++n7;
            }
        }
        String[] stringArray9 = videos = StringUtils.isEmpty((String)refItem.getBeforeReformVideo()) ? null : refItem.getBeforeReformVideo().split(",");
        if (videos != null) {
            String[] stringArray10 = videos;
            int n8 = videos.length;
            int n9 = 0;
            while (n9 < n8) {
                String video = stringArray10[n9];
                if (StringUtils.isNumber(video)) {
                    refItem.getBeforeReformVideoFile().add(this.fileService.getById(Integer.valueOf(video)));
                }
                ++n9;
            }
        }
    }

    @Override
    public OccupationHealthInspectionReformItem getReformItemById(Integer id) {
        OccupationHealthInspectionReformItem refItem = this.reformItemMapper.selectByPrimaryKey(id);
        this.setReformItemExtnedInfo(refItem);
        return refItem;
    }

    private OccupationHealthInspectionSummary getSummaryByInspectionIdAndRecordStaffId(Integer inspecitonId, Integer staffId) {
        OccupationHealthInspectionSummaryExample example = new OccupationHealthInspectionSummaryExample();
        OccupationHealthInspectionSummaryExample.Criteria criteria = example.createCriteria();
        criteria.andInspectionIdEqualTo(inspecitonId);
        if (staffId != null) {
            criteria.andCreateByEqualTo(staffId);
        }
        criteria.andRecordStateEqualTo(RecordState.valid.getValue());
        List<OccupationHealthInspectionSummary> summaryList = this.summaryMapper.selectByExample(example);
        OccupationHealthInspectionSummary summary = summaryList.size() > 0 ? summaryList.get(0) : null;
        return summary;
    }

    private void setSummaryResultListInfo(OccupationHealthInspectionSummary summary, boolean needSetReformItem) {
        if (summary == null) {
            return;
        }
        OccupationHealthInspectionTableItemResultExample resultExample = new OccupationHealthInspectionTableItemResultExample();
        resultExample.createCriteria().andSummaryIdEqualTo(summary.getId()).andRecordStateEqualTo(RecordState.valid.getValue());
        summary.setResultList(this.resultMapper.selectByExample(resultExample));
        if (summary.getResultList() != null) {
            for (OccupationHealthInspectionTableItemResult result : summary.getResultList()) {
                this.setResultSpecialInfo(result);
                if (!needSetReformItem) continue;
                this.setReformItemListForResult(result, summary.getCreateBy());
            }
        }
    }

    private void setReformItemListForResult(OccupationHealthInspectionTableItemResult result, Integer reformItemRecordStaffId) {
        OccupationHealthInspectionReformItemExample example = new OccupationHealthInspectionReformItemExample();
        OccupationHealthInspectionReformItemExample.Criteria criteria = example.createCriteria();
        criteria.andInspectionTableIdEqualTo(result.getTableId());
        criteria.andInspectionItemIdEqualTo(result.getItemId());
        criteria.andCreateByEqualTo(reformItemRecordStaffId);
        criteria.andRecordStateEqualTo(RecordState.valid.getValue());
        result.setRefItemList(this.reformItemMapper.selectByExample(example));
    }

    private void setResultSpecialInfo(OccupationHealthInspectionTableItemResult result) {
        if (result == null) {
            return;
        }
        OccupationHealthInspectionTableItemResultSpecialExample specialExample = new OccupationHealthInspectionTableItemResultSpecialExample();
        specialExample.createCriteria().andResultIdEqualTo(result.getId()).andRecordStateEqualTo(RecordState.valid.getValue());
        List<OccupationHealthInspectionTableItemResultSpecial> specailList = this.resultSpecialMapper.selectByExample(specialExample);
        result.setResultSpecial(specailList == null || specailList.size() < 1 ? null : specailList.get(0));
        this.setResultSpecialFileList(result.getResultSpecial());
    }

    private void setReformSpecialInfo(OccupationHealthInspectionTableItemResult result) {
        OccupationHealthInspectionTableItemResultReform reformSpecial;
        if (result == null) {
            return;
        }
        OccupationHealthInspectionTableItemResultReformExample specialExample = new OccupationHealthInspectionTableItemResultReformExample();
        specialExample.createCriteria().andResultIdEqualTo(result.getId()).andRecordStateEqualTo(RecordState.valid.getValue());
        List<OccupationHealthInspectionTableItemResultReform> specailList = this.resultReformMapper.selectByExample(specialExample);
        OccupationHealthInspectionTableItemResultReform occupationHealthInspectionTableItemResultReform = reformSpecial = specailList == null || specailList.size() < 1 ? null : specailList.get(0);
        if (reformSpecial != null) {
            List<File> videoFiles;
            List<File> audioFiles;
            List<File> imageFiles = this.getFileByIds(reformSpecial.getImageFileIds());
            if (imageFiles != null) {
                reformSpecial.setImageFiles(imageFiles);
            }
            if ((audioFiles = this.getFileByIds(reformSpecial.getAudioFileIds())) != null) {
                reformSpecial.setAudioFiles(audioFiles);
            }
            if ((videoFiles = this.getFileByIds(reformSpecial.getVideoFileIds())) != null) {
                reformSpecial.setVideoFiles(videoFiles);
            }
        }
        result.setReformSpecial(reformSpecial);
    }

    private void setResultSpecialFileList(OccupationHealthInspectionTableItemResultSpecial special) {
        if (special == null || StringUtils.isEmpty((String)special.getFiles())) {
            return;
        }
        List<File> files = this.getFileByIds(special.getFiles());
        if (files != null) {
            special.setFileList(files);
        }
    }

    private List<File> getFileByIds(String ids) {
        String[] fileIds;
        if (StringUtils.isEmpty((String)ids)) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        String[] stringArray = fileIds = ids.split(",");
        int n = fileIds.length;
        int n2 = 0;
        while (n2 < n) {
            File file;
            String id = stringArray[n2];
            if (StringUtils.isNumber(id) && (file = this.fileService.getById(Integer.valueOf(id))) != null) {
                files.add(file);
            }
            ++n2;
        }
        return files;
    }

    private List<OccupationHealthInspectionReformItem> getRefItemListByInspectionTableIdAndInspectionItemIdAndRecordStaffId(Integer inspecitonTableId, Integer inspectionItemId, Integer recordStaffId) {
        OccupationHealthInspectionReformItemExample example = new OccupationHealthInspectionReformItemExample();
        example.createCriteria().andCreateByEqualTo(recordStaffId).andInspectionTableIdEqualTo(inspecitonTableId).andInspectionItemIdEqualTo(inspectionItemId);
        return this.reformItemMapper.selectByExample(example);
    }

    @Override
    public List<OccupationHealthInspectionTableItemResult> getInsepctionItemResultList(Integer tableId, Integer itemId, List<Integer> recordStaffIdList) {
        OccupationHealthInspectionTableItemResultExample example = new OccupationHealthInspectionTableItemResultExample();
        example.createCriteria().andTableIdEqualTo(tableId).andItemIdEqualTo(itemId).andCreateByIn((List)recordStaffIdList);
        List<OccupationHealthInspectionTableItemResult> resultList = this.resultMapper.selectByExample(example);
        for (OccupationHealthInspectionTableItemResult result : resultList) {
            result.setRefItemList(this.getRefItemListByInspectionTableIdAndInspectionItemIdAndRecordStaffId(tableId, itemId, result.getCreateBy()));
        }
        return resultList;
    }

    @Override
    public List<OccupationHealthInspectionInformFeedback> getFeedbackList(Integer inspectionId, Byte stageId, FeedbackType feedbackType) {
        if (inspectionId == null || stageId == null) {
            return null;
        }
        OccupationHealthInspectionInformFeedbackExample example = new OccupationHealthInspectionInformFeedbackExample();
        OccupationHealthInspectionInformFeedbackExample.Criteria criteria = example.createCriteria();
        criteria.andInspectionIdEqualTo(inspectionId).andStageIdEqualTo(stageId).andRecordStateEqualTo(RecordState.valid.getValue());
        if (feedbackType != null) {
            Boolean feedback = FeedbackType.getValue(feedbackType.ordinal());
            if (feedback == null) {
                criteria.andIsAgreeIsNull();
            } else {
                criteria.andIsAgreeEqualTo(feedback);
            }
        }
        List<OccupationHealthInspectionInformFeedback> list = this.feedbackMapper.selectByExample(example);
        return list;
    }

    @Override
    public Byte getInspectionType(OccupationHealthInspection occ, Byte stageId) {
        if (occ == null) {
            return null;
        }
        if (stageId == null) {
            stageId = occ.getInspectionStageId();
        }
        if (stageId == null) {
            return occ.getInspectionType();
        }
        if (stageId.compareTo(OccupationHealthStageRelation.initiate.getStage().getValue()) >= 0) {
            return occ.getInspectionTypeInitiate();
        }
        return occ.getInspectionType();
    }

    @Override
    public PageInfo<OccupationHealthInspectionEquipentTable> getInspectionEquipmentItems(Integer summaryRecordStaff, Integer tableId, Integer pageNum, Integer pageSize) {
        if (tableId == null) {
            return null;
        }
        OccupationHealthInspectionEquipentTableExample example = new OccupationHealthInspectionEquipentTableExample();
        example.createCriteria().andTableIdEqualTo(tableId).andRecordStateEqualTo(RecordState.valid.getValue());
        PageAttribute attribute = PageUtil.getInstance().setPageInfo(pageNum, pageSize);
        PageHelper.startPage((int)attribute.getPageNum(), (int)attribute.getPageSize());
        List<OccupationHealthInspectionEquipentTable> list = this.equipmentTableMapper.selectByExample(example);
        PageInfo page = new PageInfo(list);
        for (OccupationHealthInspectionEquipentTable equipment : page.getList()) {
            this.setEquipmentItemInspectionResult(equipment, summaryRecordStaff);
            this.setEquipmentTableReformItem(equipment, summaryRecordStaff, tableId);
        }
        return page;
    }

    @Override
    public PageInfo<OccupationHealthInspectionCurrentTableItem> getInspectionCustomerItems(Integer summaryRecordStaff, Integer tableId, Integer pageNum, Integer pageSize) {
        if (tableId == null) {
            return null;
        }
        OccupationHealthInspectionCurrentTableItemExample example = new OccupationHealthInspectionCurrentTableItemExample();
        example.createCriteria().andTableIdEqualTo(tableId).andRecordStateEqualTo(RecordState.valid.getValue());
        PageAttribute attribute = PageUtil.getInstance().setPageInfo(pageNum, pageSize);
        PageHelper.startPage((int)attribute.getPageNum(), (int)attribute.getPageSize());
        List<OccupationHealthInspectionCurrentTableItem> list = this.currentTableItemMapper.selectByExample(example);
        PageInfo page = new PageInfo(list);
        for (OccupationHealthInspectionCurrentTableItem customTableItem : page.getList()) {
            this.setCustomItemInspectionResult(customTableItem, summaryRecordStaff);
            this.setCustomTableReformItem(customTableItem, summaryRecordStaff, tableId);
        }
        return page;
    }

    private void setMaterialInspectionResult(OccupationHealthInspectionEmergencyMaterialTable material, Integer summaryRecordStaff) {
        if (summaryRecordStaff == null) {
            return;
        }
        OccupationHealthInspectionTableItemResultExample example = new OccupationHealthInspectionTableItemResultExample();
        example.createCriteria().andTableIdEqualTo(material.getTableId()).andItemIdEqualTo(material.getId()).andCreateByEqualTo(summaryRecordStaff).andRecordStateEqualTo(RecordState.valid.getValue());
        List<OccupationHealthInspectionTableItemResult> list = this.resultMapper.selectByExample(example);
        material.setInspectionResult(list.size() > 0 ? list.get(0) : null);
        this.setResultSpecialInfo(material.getInspectionResult());
    }

    private void setCustomItemInspectionResult(OccupationHealthInspectionCurrentTableItem customTableItem, Integer summaryRecordStaff) {
        if (summaryRecordStaff == null) {
            return;
        }
        OccupationHealthInspectionTableItemResultExample example = new OccupationHealthInspectionTableItemResultExample();
        example.createCriteria().andTableIdEqualTo(customTableItem.getTableId()).andItemIdEqualTo(customTableItem.getId()).andCreateByEqualTo(summaryRecordStaff).andRecordStateEqualTo(RecordState.valid.getValue());
        List<OccupationHealthInspectionTableItemResult> list = this.resultMapper.selectByExample(example);
        customTableItem.setInspectionResult(list.size() > 0 ? list.get(0) : null);
        this.setResultSpecialInfo(customTableItem.getInspectionResult());
    }

    private void setEquipmentItemInspectionResult(OccupationHealthInspectionEquipentTable equipment, Integer summaryRecordStaff) {
        if (summaryRecordStaff == null) {
            return;
        }
        OccupationHealthInspectionTableItemResultExample example = new OccupationHealthInspectionTableItemResultExample();
        example.createCriteria().andTableIdEqualTo(equipment.getTableId()).andItemIdEqualTo(equipment.getId()).andCreateByEqualTo(summaryRecordStaff).andRecordStateEqualTo(RecordState.valid.getValue());
        List<OccupationHealthInspectionTableItemResult> list = this.resultMapper.selectByExample(example);
        equipment.setInspectionResult(list.size() > 0 ? list.get(0) : null);
        this.setResultSpecialInfo(equipment.getInspectionResult());
    }

    private void setWarningSignItemInspectionResult(OccupationHealthInspectionWarningSignsTable warningSign, Integer summaryRecordStaff) {
        if (summaryRecordStaff == null) {
            return;
        }
        OccupationHealthInspectionTableItemResultExample example = new OccupationHealthInspectionTableItemResultExample();
        example.createCriteria().andTableIdEqualTo(warningSign.getTableId()).andItemIdEqualTo(warningSign.getId()).andCreateByEqualTo(summaryRecordStaff).andRecordStateEqualTo(RecordState.valid.getValue());
        List<OccupationHealthInspectionTableItemResult> list = this.resultMapper.selectByExample(example);
        warningSign.setInspectionResult(list.size() > 0 ? list.get(0) : null);
        this.setResultSpecialInfo(warningSign.getInspectionResult());
    }

    private void setReformItemTableInspectionResult(OccupationHealthInspectionReformItemTable reformItemTable, Integer summaryRecordStaff) {
        if (summaryRecordStaff == null) {
            return;
        }
        OccupationHealthInspectionTableItemResultExample example = new OccupationHealthInspectionTableItemResultExample();
        example.createCriteria().andTableIdEqualTo(reformItemTable.getTableId()).andItemIdEqualTo(reformItemTable.getId()).andCreateByEqualTo(summaryRecordStaff).andRecordStateEqualTo(RecordState.valid.getValue());
        List<OccupationHealthInspectionTableItemResult> list = this.resultMapper.selectByExample(example);
        reformItemTable.setInspectionResult(list.size() > 0 ? list.get(0) : null);
        this.setReformSpecialInfo(reformItemTable.getInspectionResult());
    }

    @Override
    public PageInfo<OccupationHealthInspectionEmergencyMaterialTable> getInspectionMaterialItems(Integer summaryRecordStaff, Integer tableId, Integer pageNum, Integer pageSize) {
        if (tableId == null) {
            return null;
        }
        OccupationHealthInspectionEmergencyMaterialTableExample example = new OccupationHealthInspectionEmergencyMaterialTableExample();
        example.createCriteria().andTableIdEqualTo(tableId).andRecordStateEqualTo(RecordState.valid.getValue());
        PageAttribute attribute = PageUtil.getInstance().setPageInfo(pageNum, pageSize);
        PageHelper.startPage((int)attribute.getPageNum(), (int)attribute.getPageSize());
        List<OccupationHealthInspectionEmergencyMaterialTable> list = this.materialTableMapper.selectByExample(example);
        PageInfo page = new PageInfo(list);
        for (OccupationHealthInspectionEmergencyMaterialTable material : page.getList()) {
            this.setMaterialInspectionResult(material, summaryRecordStaff);
            this.setMaterialReformItem(material, summaryRecordStaff, tableId);
        }
        return page;
    }

    @Override
    public PageInfo<OccupationHealthInspectionWarningSignsTable> getInspectionWarningSignItems(Integer summaryRecordStaff, Integer tableId, Integer pageNum, Integer pageSize) {
        if (tableId == null) {
            return null;
        }
        OccupationHealthInspectionWarningSignsTableExample example = new OccupationHealthInspectionWarningSignsTableExample();
        example.createCriteria().andTableIdEqualTo(tableId).andRecordStateEqualTo(RecordState.valid.getValue());
        PageAttribute attribute = PageUtil.getInstance().setPageInfo(pageNum, pageSize);
        PageHelper.startPage((int)attribute.getPageNum(), (int)attribute.getPageSize());
        List<OccupationHealthInspectionWarningSignsTable> list = this.warningSignsTableMapper.selectByExample(example);
        PageInfo page = new PageInfo(list);
        for (OccupationHealthInspectionWarningSignsTable warningSign : page.getList()) {
            this.setWarningSignItemInspectionResult(warningSign, summaryRecordStaff);
            this.setWarningSignReformItem(warningSign, summaryRecordStaff, tableId);
        }
        return page;
    }

    private List<OccupationHealthInspectionReformItemTable> getInspectionReformItemsList(Integer summaryRecordStaff, Integer tableId) {
        if (tableId == null) {
            return null;
        }
        OccupationHealthInspectionReformItemTableExample example = new OccupationHealthInspectionReformItemTableExample();
        example.createCriteria().andTableIdEqualTo(tableId).andRecordStateEqualTo(RecordState.valid.getValue());
        List<OccupationHealthInspectionReformItemTable> list = this.reformItemTableMapper.selectByExample(example);
        for (OccupationHealthInspectionReformItemTable reformItemTable : list) {
            this.setReformItemTableInspectionResult(reformItemTable, summaryRecordStaff);
            reformItemTable.setReformItem(this.reformItemService.getItem(reformItemTable.getReformItemId()));
        }
        return list;
    }

    private void setReformItemTableExtendsInfo(OccupationHealthInspectionReformItemTable reformItemTable) {
        RefReformitemWithBLOBs reformItem = this.reformItemService.getItem(reformItemTable.getReformItemId());
        reformItemTable.setReformItem(reformItem);
    }

    @Override
    public PageInfo<OccupationHealthInspectionReformItemTable> getInspectionReformItems(Integer summaryRecordStaff, Integer tableId, Integer pageNum, Integer pageSize) {
        if (tableId == null) {
            return null;
        }
        OccupationHealthInspectionReformItemTableExample example = new OccupationHealthInspectionReformItemTableExample();
        example.createCriteria().andTableIdEqualTo(tableId).andRecordStateEqualTo(RecordState.valid.getValue());
        PageAttribute attribute = PageUtil.getInstance().setPageInfo(pageNum, pageSize);
        PageHelper.startPage((int)attribute.getPageNum(), (int)attribute.getPageSize());
        List<OccupationHealthInspectionReformItemTable> list = this.reformItemTableMapper.selectByExample(example);
        PageInfo page = new PageInfo(list);
        for (OccupationHealthInspectionReformItemTable reformItemTable : page.getList()) {
            this.setReformItemTableExtendsInfo(reformItemTable);
            this.setReformItemTableInspectionResult(reformItemTable, summaryRecordStaff);
        }
        return page;
    }

    @Override
    public OccupationHealthInspectionTableItemResultReform getInspectionResultReformItemFiles(Integer resultId) {
        File file;
        String id;
        int n;
        int n2;
        String[] stringArray;
        String[] ids;
        if (resultId == null) {
            return null;
        }
        OccupationHealthInspectionTableItemResultReform result = this.resultReformMapper.selectByPrimaryKey(resultId);
        if (StringUtils.isNotEmpty(result.getImageFileIds())) {
            stringArray = ids = result.getImageFileIds().split(",");
            n2 = ids.length;
            n = 0;
            while (n < n2) {
                id = stringArray[n];
                if (StringUtils.isNumber(id) && (file = this.fileService.getById(Integer.valueOf(id))) != null) {
                    result.getImageFiles().add(file);
                }
                ++n;
            }
        }
        if (StringUtils.isNotEmpty(result.getAudioFileIds())) {
            stringArray = ids = result.getAudioFileIds().split(",");
            n2 = ids.length;
            n = 0;
            while (n < n2) {
                id = stringArray[n];
                if (StringUtils.isNumber(id) && (file = this.fileService.getById(Integer.valueOf(id))) != null) {
                    result.getAudioFiles().add(file);
                }
                ++n;
            }
        }
        if (StringUtils.isNotEmpty(result.getVideoFileIds())) {
            stringArray = ids = result.getVideoFileIds().split(",");
            n2 = ids.length;
            n = 0;
            while (n < n2) {
                id = stringArray[n];
                if (StringUtils.isNumber(id) && (file = this.fileService.getById(Integer.valueOf(id))) != null) {
                    result.getVideoFiles().add(file);
                }
                ++n;
            }
        }
        return result;
    }

    @Override
    public List<OccupationHealthInspection> getInspectionUnfinishedList(Integer companyId) {
        if (companyId == null) {
            return null;
        }
        return this.inspectionDao.getInspectionUnfinishedList(companyId);
    }

    @Override
    public PageInfo<OccupationHealthInspection> getInspectionfinishedList(Integer companyId, InspectionSearchEntity search, Integer pageNum, Integer pageSize) {
        if (companyId == null) {
            return null;
        }
        return this.inspectionDao.getInspectionfinishedList(companyId, search, pageNum, pageSize);
    }

    @Override
    @Transactional(readOnly=false)
    public int terminationInspection(List<Integer> inspecitonIds, String terminationReason) {
        Integer companyId = LoginUtil.getInstance().getLoginStaffCompanyId();
        Integer loginStaffId = LoginUtil.getInstance().getLoginStaffId();
        String applyer = loginStaffId == null ? "" : "" + loginStaffId;
        for (Integer id : inspecitonIds) {
            OccupationHealthInspection occ = this.selectOccupationHealthInspectionByPrimaryKey(id, null, null);
            if (occ == null) {
                inspecitonIds.remove(id);
                continue;
            }
            WorkFlowParam param = new WorkFlowParam();
            param.setApplyer(applyer);
            param.setStage(OccupationHealthStageRelation.getStage(occ.getInspectionStageId()).getName());
            param.setBusinessPhase("" + occ.getInspectionStageId());
            param.setBusinessId(occ.getId());
            param.setBusinessType(Modulars.occupationHealthInspection.getCode());
            this.modularWordflowService.terminateWorkflow(companyId, param);
        }
        return this.inspectionDao.terminationInspection(inspecitonIds, terminationReason);
    }

    @Override
    @Transactional(readOnly=false)
    public void workflow(WorkFlowParam param, Integer orderId) {
        this.updateModularForApprove(param, orderId);
    }

    @Override
    public String doTask(Integer businessId, String taskName) {
        OccupationHealthInspection occ = this.selectOccupationHealthInspectionByPrimaryKey((int)businessId, null, null);
        if (occ == null) {
            return "/commons/404";
        }
        Byte inspectionType = this.getInspectionType(occ, null);
        Byte stageId = occ.getInspectionStageId();
        return OccupationHealthInspectionUtil.getInstance().occupationHealthInspectionBuisnessPath(occ.getId(), stageId, taskName, inspectionType);
    }

    @Override
    public String doApproveTask(Integer businessId) {
        return null;
    }

    @Override
    public int terminateTask(Integer businessId) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ids.add(businessId);
        return this.terminationInspection(ids, null);
    }

    @Override
    public String addWorkUrl() {
        return null;
    }

    @Override
    public String workflowInform(WorkFlowParam param, Integer orderId) {
        OccupationHealthInspection occ;
        String[] recover = param.getReceiver().split(",");
        this.deleteInform(param.getBusinessId(), Byte.valueOf(param.getBusinessPhase()));
        if (recover != null) {
            String[] stringArray = recover;
            int n = recover.length;
            int n2 = 0;
            while (n2 < n) {
                Staff staff;
                String rec = stringArray[n2];
                if (StringUtils.isNumber(rec) && (staff = this.staffService.get(Integer.valueOf(rec))) != null) {
                    OccupationHealthInspectionInformFeedback feedback = new OccupationHealthInspectionInformFeedback();
                    feedback.setFeedbackUserId(staff.getId());
                    feedback.setInspectionId(param.getBusinessId());
                    feedback.setWorkflowId(orderId);
                    feedback.setStageId(Byte.valueOf(param.getBusinessPhase()));
                    EntityUtil.getInstance().setCreateAndUpdateInfo(feedback);
                    this.feedbackMapper.insert(feedback);
                }
                ++n2;
            }
        }
        if (!param.getNeedInform().booleanValue()) {
            occ = new OccupationHealthInspection();
            occ.setInformTime(new Date());
            occ.setId(param.getBusinessId());
            occ.setInspectionStageId(this.getNextPhase(Modulars.occupationHealthInspection.getValue(), Byte.valueOf(param.getBusinessPhase()), false));
            this.inspectionDao.updateByPrimaryKeySelective(occ, occ.getId());
            this.inspectionTableService.cloneItemsFromTemplateToCurrentTable(occ.getId(), OccupationHealthStageRelation.initiate.getStage().getValue());
        } else {
            occ = new OccupationHealthInspection();
            occ.setInformTime(new Date());
            occ.setId(param.getBusinessId());
            this.inspectionDao.updateByPrimaryKeySelective(occ, occ.getId());
        }
        Byte inspectionType = this.getInspectionType(occ, null);
        return OccupationHealthInspectionUtil.getInstance().occupationHealthInspectionBuisnessPath(occ.getId(), occ.getInspectionStageId(), "inform", inspectionType);
    }
}

