/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.core.service.reform;

import cn.smarthse.core.dao.reform.RefEmergencyrescueplanMapper;
import cn.smarthse.core.dao.reform.RefReformsolutionMapper;
import cn.smarthse.core.dao.reform.RefSolutiondetailsMapper;
import cn.smarthse.core.dao.reform.RefSolutionmaterialMapper;
import cn.smarthse.core.framework.common.Constant;
import cn.smarthse.core.framework.common.generator.SerialTool;
import cn.smarthse.core.model.common.ResponseData;
import cn.smarthse.core.model.reform.RefEmergencyrescueplan;
import cn.smarthse.core.model.reform.RefEmergencyrescueplanExample;
import cn.smarthse.core.model.reform.RefReformitemWithBLOBs;
import cn.smarthse.core.model.reform.RefReformsolutionWithBLOBs;
import cn.smarthse.core.model.reform.RefSolutiondetails;
import cn.smarthse.core.model.reform.RefSolutionmaterial;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReformSolutionService {
    @Autowired
    private RefReformsolutionMapper RefReformsolutionMapper;
    @Autowired
    private RefSolutiondetailsMapper RefSolutiondetailsMapper;
    @Autowired
    private RefEmergencyrescueplanMapper RefEmergencyrescueplanMapper;
    @Autowired
    private RefSolutionmaterialMapper RefSolutionmaterialMapper;

    public int createSolution(RefReformsolutionWithBLOBs record) {
        record.setIsvalid(Constant.ACTIVE_YES);
        record.setSolutionno(SerialTool.generatorNo("Solution"));
        this.RefReformsolutionMapper.insertSelective(record);
        return record.getId();
    }

    public int deleteSolution(Integer id) {
        RefReformsolutionWithBLOBs a = new RefReformsolutionWithBLOBs();
        a.setId(id);
        a.setIsvalid(Constant.ACTIVE_NO);
        return this.RefReformsolutionMapper.updateByPrimaryKeySelective(a);
    }

    public int updateSolution(RefReformsolutionWithBLOBs record) {
        if (record.getId() == null) {
            return this.createSolution(record);
        }
        return this.RefReformsolutionMapper.updateByPrimaryKeySelective(record);
    }

    public RefReformsolutionWithBLOBs getSolution(int itemid) {
        return this.RefReformsolutionMapper.selectSolutionByItemId(itemid);
    }

    @Transactional
    public int updateSolutionDetail(RefReformitemWithBLOBs record) {
        RefReformsolutionWithBLOBs solution = record.getSolution();
        if (solution.getId() == null) {
            solution.setCid(record.getCid());
            solution.setItemid(record.getId());
            solution.setSolutionno(SerialTool.generatorNo("Solution"));
            solution.setSolutiontype(record.getItemlevel().byteValue());
            solution.setCreatetime(new Date());
            solution.setIsvalid(Constant.ACTIVE_YES);
            this.RefReformsolutionMapper.insertSelective(solution);
        }
        RefSolutiondetails detail = solution.getDetail();
        detail.setSolutionid(solution.getId());
        detail.setIsvalid(Constant.ACTIVE_YES);
        detail.setUpdatetime(new Date());
        if (detail.getId() == null) {
            return this.RefSolutiondetailsMapper.insertSelective(detail);
        }
        return this.RefSolutiondetailsMapper.updateByPrimaryKeySelective(detail);
    }

    @Transactional
    public int deleteSolutionDetail(List<Integer> idList) {
        int count = 0;
        for (Integer id : idList) {
            RefSolutiondetails record = new RefSolutiondetails();
            record.setId(id);
            record.setIsvalid(Constant.ACTIVE_NO);
            record.setUpdatetime(new Date());
            count += this.RefSolutiondetailsMapper.updateByPrimaryKeySelective(record);
        }
        return count;
    }

    @Transactional
    public int updateSolutionPlan(Integer methodId, List<Integer> planList) {
        int count = 0;
        for (Integer planid : planList) {
            RefEmergencyrescueplan plan = new RefEmergencyrescueplan();
            plan.setMethodid(methodId);
            plan.setInfoid(planid);
            plan.setIsvalid(Constant.ACTIVE_YES);
            count += this.RefEmergencyrescueplanMapper.insertSelective(plan);
        }
        return count;
    }

    public int deleteSolutionPlan(Integer id) {
        RefEmergencyrescueplan record = new RefEmergencyrescueplan();
        record.setId(id);
        record.setIsvalid(Constant.ACTIVE_NO);
        record.setUpdatetime(new Date());
        return this.RefEmergencyrescueplanMapper.updateByPrimaryKeySelective(record);
    }

    public int deleteSolutionPlan(Integer methodid, Integer infoid) {
        RefEmergencyrescueplan record = new RefEmergencyrescueplan();
        record.setIsvalid(Constant.ACTIVE_NO);
        record.setUpdatetime(new Date());
        RefEmergencyrescueplanExample e = new RefEmergencyrescueplanExample();
        e.createCriteria().andMethodidEqualTo(methodid).andInfoidEqualTo(infoid);
        return this.RefEmergencyrescueplanMapper.updateByExampleSelective(record, e);
    }

    public int updateSolutionMaterial(RefSolutionmaterial m) {
        m.setIsvalid(Constant.ACTIVE_YES);
        m.setUpdatetime(new Date());
        if (m.getId() == null) {
            return this.RefSolutionmaterialMapper.insertSelective(m);
        }
        return this.RefSolutionmaterialMapper.updateByPrimaryKeySelective(m);
    }

    public int deleteSolutionMaterial(Integer id) {
        RefSolutionmaterial record = new RefSolutionmaterial();
        record.setId(id);
        record.setIsvalid(Constant.ACTIVE_NO);
        record.setUpdatetime(new Date());
        return this.RefSolutionmaterialMapper.updateByPrimaryKeySelective(record);
    }

    public RefSolutionmaterial getSolutionMaterial(Integer id) {
        return this.RefSolutionmaterialMapper.selectByPrimaryKey(id);
    }

    public ResponseData<List<RefSolutionmaterial>> getMaterialFromExcel(String fileName) throws Exception {
        ResponseData<List<RefSolutionmaterial>> data = new ResponseData<List<RefSolutionmaterial>>();
        HSSFWorkbook wb = new HSSFWorkbook((InputStream)new FileInputStream(fileName));
        HSSFSheet sheet = wb.getSheetAt(0);
        ArrayList<RefSolutionmaterial> list = new ArrayList<RefSolutionmaterial>();
        int rowIndex = 0;
        Iterator iter = sheet.rowIterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (++rowIndex == 1 || row.getCell(1) == null || row.getCell(1).getCellType() == 3) continue;
            RefSolutionmaterial m = new RefSolutionmaterial();
            int cellCount = 3;
            int colIndex = 0;
            int i = 0;
            while (i < cellCount) {
                Cell cell = row.getCell(i);
                ++colIndex;
                if (cell != null && cell.getCellType() != 3) {
                    switch (i) {
                        case 0: {
                            try {
                                m.setMaterialname(cell.getStringCellValue().trim());
                                break;
                            }
                            catch (Exception e) {
                                data.setCode(-1);
                                data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u6240\u9700\u7269\u8d44\u540d\u79f0\u683c\u5f0f\u4e0d\u5bf9");
                                return data;
                            }
                        }
                        case 1: {
                            try {
                                m.setSpecification(cell.getStringCellValue().trim());
                                break;
                            }
                            catch (Exception e) {
                                data.setCode(-1);
                                data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u89c4\u683c\u683c\u5f0f\u4e0d\u5bf9");
                                return data;
                            }
                        }
                        case 2: {
                            try {
                                m.setCount((int)cell.getNumericCellValue());
                                break;
                            }
                            catch (Exception e) {
                                data.setCode(-1);
                                data.setContent("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u6570\u91cf\u683c\u5f0f\u4e0d\u5bf9");
                                return data;
                            }
                        }
                    }
                }
                ++i;
            }
            list.add(m);
        }
        wb.close();
        data.setResult(list);
        return data;
    }

    public int importMaterial(Integer methodid, List<RefSolutionmaterial> list) {
        int count = 0;
        for (RefSolutionmaterial m : list) {
            m.setMethodid(methodid);
            count += this.updateSolutionMaterial(m);
        }
        return count;
    }

    private String getExcelColName(int index) {
        if (index <= 26) {
            return String.valueOf((char)(65 + index - 1));
        }
        int a = index / 26;
        int b = index % 26;
        return String.valueOf(String.valueOf((char)(65 + a - 1))) + String.valueOf((char)(65 + b - 1));
    }
}

